#!/bin/sh

# check for command line parameters
if [ $# -ne 4 ]; then
  echo "Usage: $0 <office_inst_path> <singleproductname> <productversion> <language>"
  exit 1
fi

# check if original CDE dtappintegrate is available
if [ ! -x "/usr/dt/bin/dtappintegrate" ]; then
  echo "/usr/dt/bin/dtappintegrate not found or not executable"
  exit 1
fi
 
# cleanup the directory structure to work in
rm -rf "$1/dt" 2>/dev/null

# create the directory structure for /usr/dt/bin/dtappintegrate
ICON_DEST="$1/dt/appconfig/icons/C" 
TYPES_DEST="$1/dt/appconfig/types"

# create <progpath>/dt/appconfig/icons/C directory
if [ ! -d $ICON_DEST ]; then
  mkdir -m 0777 -p $ICON_DEST;
fi

# create <progpath>/dt/appconfig/types directory
if [ ! -d $TYPES_DEST ]; then
  mkdir -m 0777 -p $TYPES_DEST;
fi

# for all files in <progpath>/share/cde/icons create a link with a product
# prefix in $ICON_DEST.
for SOURCE in `ls "$1/share/cde/icons"`; do
  ICON=`echo $SOURCE | sed "s/.xpm/.pm/"`
  ln "$1/share/cde/icons/$SOURCE" "$ICON_DEST/$2_$3_$ICON"
done

# to include english files for C locale, create symbolic link in source tree
ln -s "$1/share/cde/types/en" "$1/share/cde/types/C" 2>/dev/null

# for every file and supported locale create a link with a product prefix
# (if no file type) in $TYPES_DEST
for LOCALE in C `ls -1 "$1/share/cde/types" | grep $4`; do
  if [ -d "$1/share/cde/types/$LOCALE" ]; then
    mkdir -m 0777 "$TYPES_DEST/$LOCALE"

    # link language specific types files
    ln "$1/share/cde/types/$LOCALE/group.fp" $TYPES_DEST/$LOCALE/$2_$3_group.fp
    ln "$1/share/cde/types/$LOCALE/group.dt" $TYPES_DEST/$LOCALE/$2_$3_group.dt

    for SOURCE in writer calc draw impress; do
      if [ -f "$1/share/cde/types/$LOCALE/$SOURCE.fp" ]; then
        ln "$1/share/cde/types/$LOCALE/$SOURCE.fp" $TYPES_DEST/$LOCALE/$2_$3_$SOURCE.fp
        ln "$1/share/cde/types/$LOCALE/$SOURCE.dt" $TYPES_DEST/$LOCALE/$2_$3_$SOURCE.dt
        ln "$1/share/cde/types/$LOCALE/vnd.stardivision.$SOURCE.dt" $TYPES_DEST/$LOCALE/
        ln "$1/share/cde/types/$LOCALE/vnd.sun.xml.$SOURCE.dt" $TYPES_DEST/$LOCALE/

        if [ "$SOURCE" = "writer" ]; then
          ln "$1/share/cde/types/$LOCALE/vnd.stardivision.writer-global.dt" $TYPES_DEST/$LOCALE/
          ln "$1/share/cde/types/$LOCALE/vnd.sun.xml.writer.global.dt" $TYPES_DEST/$LOCALE/
          ln "$1/share/cde/types/$LOCALE/vnd.stardivision.math.dt" $TYPES_DEST/$LOCALE/
          ln "$1/share/cde/types/$LOCALE/vnd.sun.xml.math.dt" $TYPES_DEST/$LOCALE/
          ln "$1/share/cde/types/$LOCALE/ms-word.dt" $TYPES_DEST/$LOCALE/
          ln "$1/share/cde/types/$LOCALE/richtext.dt" $TYPES_DEST/$LOCALE/
          
        elif [ "$SOURCE" = "calc" ]; then
          ln "$1/share/cde/types/$LOCALE/vnd.stardivision.chart.dt" $TYPES_DEST/$LOCALE/
          ln "$1/share/cde/types/$LOCALE/ms-excel.dt" $TYPES_DEST/$LOCALE/

        elif [ "$SOURCE" = "impress" ]; then
          ln "$1/share/cde/types/$LOCALE/ms-powerpoint.dt" $TYPES_DEST/$LOCALE/
        fi
      fi
    done
  fi
done

# create links fo locales not directly supported
if [ "$4" = "en" ]; then
  ln -s "en" "$TYPES_DEST/en_AU"
  ln -s "en" "$TYPES_DEST/en_AU.ISO8859-1"
  ln -s "en" "$TYPES_DEST/en_CA"
  ln -s "en" "$TYPES_DEST/en_CA.ISO8859-1"
  ln -s "en" "$TYPES_DEST/en_GB"
  ln -s "en" "$TYPES_DEST/en_GB.ISO8859-1"
  ln -s "en" "$TYPES_DEST/en_GB.ISO8859-15"
  ln -s "en" "$TYPES_DEST/en_IE"
  ln -s "en" "$TYPES_DEST/en_IE.ISO8859-1"
  ln -s "en" "$TYPES_DEST/en_IE.ISO8859-15"
  ln -s "en" "$TYPES_DEST/en_NZ"
  ln -s "en" "$TYPES_DEST/en_NZ.ISO8859-1"
  ln -s "en" "$TYPES_DEST/en_US"
  ln -s "en" "$TYPES_DEST/en_US.ISO8859-1"
  ln -s "en" "$TYPES_DEST/en_US.ISO8859-15"
  ln -s "en.UTF-8" "$TYPES_DEST/en_US.UTF-8"
elif [ "$4" = "pt" ]; then
  ln -s "pt" "$TYPES_DEST/pt.ISO8859-15"
  ln -s "pt" "$TYPES_DEST/pt_BR.ISO8859-1"
  ln -s "pt" "$TYPES_DEST/pt_PT"
  ln -s "pt" "$TYPES_DEST/pt_PT.ISO8859-1"
  ln -s "pt" "$TYPES_DEST/pt_PT.ISO8859-15"
elif [ "$4" = "ru" ]; then
  ln -s "ru" "$TYPES_DEST/ru_RU"
  ln -s "ru.ANSI-1251" "$TYPES_DEST/ru.ansi1251"
  ln -s "ru.ANSI-1251" "$TYPES_DEST/ru.ansi-1251"
  ln -s "ru.ANSI-1251" "$TYPES_DEST/ru_RU.ANSI1251"
  ln -s "ru.ISO8859-5" "$TYPES_DEST/ru_RU.ISO8859-5"
  ln -s "ru.KOI8-R" "$TYPES_DEST/ru.koi8-r"
  ln -s "ru.KOI8-R" "$TYPES_DEST/ru_RU.KOI8-R"
elif [ "$4" = "gr" ]; then
  ln -s "gr" "$TYPES_DEST/sun_eu_greek"
elif [ "$4" = "nl" ]; then
  ln -s "nl" "$TYPES_DEST/nl.ISO8859-15"
  ln -s "nl" "$TYPES_DEST/nl_BE"
  ln -s "nl" "$TYPES_DEST/nl_BE.ISO8859-1"
  ln -s "nl" "$TYPES_DEST/nl_BE.ISO8859-15"
  ln -s "nl" "$TYPES_DEST/nl_NL"
  ln -s "nl" "$TYPES_DEST/nl_NL.ISO8859-1"
  ln -s "nl" "$TYPES_DEST/nl_NL.ISO8859-15"
elif [ "$4" = "fr" ]; then
  ln -s "fr" "$TYPES_DEST/fr.ISO8859-15"
  ln -s "fr" "$TYPES_DEST/fr_BE"
  ln -s "fr" "$TYPES_DEST/fr_BE.ISO8859-1"
  ln -s "fr" "$TYPES_DEST/fr_BE.ISO8859-15"
  ln -s "fr" "$TYPES_DEST/fr_CA"
  ln -s "fr" "$TYPES_DEST/fr_CA.ISO8859-1"
  ln -s "fr" "$TYPES_DEST/fr_CH"
  ln -s "fr" "$TYPES_DEST/fr_CH.ISO8859-1"
  ln -s "fr" "$TYPES_DEST/fr_FR"
  ln -s "fr" "$TYPES_DEST/fr_FR.ISO8859-1"
  ln -s "fr" "$TYPES_DEST/fr_FR.ISO8859-15"
  ln -s "fr.UTF-8" "$TYPES_DEST/fr_FR.UTF-8"
elif [ "$4" = "es" ]; then
  ln -s "es" "$TYPES_DEST/es.ISO8859-15"
  ln -s "es" "$TYPES_DEST/es_AR"
  ln -s "es" "$TYPES_DEST/es_AR.ISO8859-1"
  ln -s "es" "$TYPES_DEST/es_BO"
  ln -s "es" "$TYPES_DEST/es_BO.ISO8859-1"
  ln -s "es" "$TYPES_DEST/es_CL"
  ln -s "es" "$TYPES_DEST/es_CL.ISO8859-1"
  ln -s "es" "$TYPES_DEST/es_CO"
  ln -s "es" "$TYPES_DEST/es_CO.ISO8859-1"
  ln -s "es" "$TYPES_DEST/es_CR"
  ln -s "es" "$TYPES_DEST/es_CR.ISO8859-1"
  ln -s "es" "$TYPES_DEST/es_EC"
  ln -s "es" "$TYPES_DEST/es_EC.ISO8859-1"
  ln -s "es" "$TYPES_DEST/es_ES"
  ln -s "es" "$TYPES_DEST/es_ES.ISO8859-1"
  ln -s "es" "$TYPES_DEST/es_ES.ISO8859-15"
  ln -s "es.UTF-8" "$TYPES_DEST/es_ES.UTF-8"
  ln -s "es" "$TYPES_DEST/es_GT"
  ln -s "es" "$TYPES_DEST/es_GT.ISO8859-1"
  ln -s "es" "$TYPES_DEST/es_MX"
  ln -s "es" "$TYPES_DEST/es_MX.ISO8859-1"
  ln -s "es" "$TYPES_DEST/es_NI"
  ln -s "es" "$TYPES_DEST/es_NI.ISO8859-1"
  ln -s "es" "$TYPES_DEST/es_PA"
  ln -s "es" "$TYPES_DEST/es_PA.ISO8859-1"
  ln -s "es" "$TYPES_DEST/es_PE"
  ln -s "es" "$TYPES_DEST/es_PE.ISO8859-1"
  ln -s "es" "$TYPES_DEST/es_PY"
  ln -s "es" "$TYPES_DEST/es_PY.ISO8859-1"
  ln -s "es" "$TYPES_DEST/es_SV"
  ln -s "es" "$TYPES_DEST/es_SV.ISO8859-1"
  ln -s "es" "$TYPES_DEST/es_UY"
  ln -s "es" "$TYPES_DEST/es_UY.ISO8859-1"
  ln -s "es" "$TYPES_DEST/es_VE"
  ln -s "es" "$TYPES_DEST/es_VE.ISO8859-1"
elif [ "$4" = "fi" ]; then
  ln -s "fi" "$TYPES_DEST/fi.ISO8859-15"
  ln -s "fi" "$TYPES_DEST/fi_FI"
  ln -s "fi" "$TYPES_DEST/fi_FI.ISO8859-1"
  ln -s "fi" "$TYPES_DEST/fi_FI.ISO8859-15"
elif [ "$4" = "ca" ]; then
  ln -s "ca" "$TYPES_DEST/ca.ISO8859-15"
  ln -s "ca" "$TYPES_DEST/ca_ES"
  ln -s "ca" "$TYPES_DEST/ca_ES.ISO8859-1"
  ln -s "ca" "$TYPES_DEST/ca_ES.ISO8859-15"
elif [ "$4" = "it" ]; then
  ln -s "it" "$TYPES_DEST/it.ISO8859-15"
  ln -s "it" "$TYPES_DEST/it_IT"
  ln -s "it" "$TYPES_DEST/it_IT.ISO8859-1"
  ln -s "it" "$TYPES_DEST/it_IT.ISO8859-15"
  ln -s "it.UTF-8" "$TYPES_DEST/it_IT.UTF-8"
elif [ "$4" = "da" ]; then
  ln -s "da" "$TYPES_DEST/da.ISO8859-15"
  ln -s "da" "$TYPES_DEST/da_DK"
  ln -s "da" "$TYPES_DEST/da_DK.ISO8859-1"
  ln -s "da" "$TYPES_DEST/da_DK.ISO8859-15"
elif [ "$4" = "sv" ]; then
  ln -s "sv" "$TYPES_DEST/sv.ISO8859-15"
  ln -s "sv" "$TYPES_DEST/sv_SE"
  ln -s "sv" "$TYPES_DEST/sv_SE.ISO8859-1"
  ln -s "sv" "$TYPES_DEST/sv_SE.ISO8859-15"
  ln -s "sv.UTF-8" "$TYPES_DEST/sv_SE.UTF-8"
elif [ "$4" = "pl" ]; then
  ln -s "pl" "$TYPES_DEST/pl_PL"
  ln -s "pl" "$TYPES_DEST/pl_PL.ISO8859-2"
elif [ "$4" = "de" ]; then
  ln -s "de" "$TYPES_DEST/de.ISO8859-15"
  ln -s "de" "$TYPES_DEST/de_AT"
  ln -s "de" "$TYPES_DEST/de_AT.ISO8859-1"
  ln -s "de" "$TYPES_DEST/de_AT.ISO8859-15"
  ln -s "de" "$TYPES_DEST/de_CH"
  ln -s "de" "$TYPES_DEST/de_CH.ISO8859-1"
  ln -s "de" "$TYPES_DEST/de_DE"
  ln -s "de" "$TYPES_DEST/de_DE.ISO8859-1"
  ln -s "de" "$TYPES_DEST/de_DE.ISO8859-15"
  ln -s "de.UTF-8" "$TYPES_DEST/de_DE.UTF-8"
elif [ "$4" = "ja" ]; then
  ln -s "ja" "$TYPES_DEST/japanese"
  ln -s "ja_JP.EUCJP" "$TYPES_DEST/ja_JP.eucJP"
  ln -s "ja_JP.EUCJP" "$TYPES_DEST/ja_JP.EUC"
elif [ "$4" = "ko" ]; then
  ln -s "ko" "$TYPES_DEST/korean"
elif [ "$4" = "zh_CN" ]; then
  ln -s "zh_CN.EUC" "$TYPES_DEST/zh"
  ln -s "zh_CN.GBK" "$TYPES_DEST/zh.GBK"
  ln -s "zh_CN.UTF-8" "$TYPES_DEST/zh.UTF-8"
  ln -s "zh_CN.EUC" "$TYPES_DEST/chinese"
elif [ "$4" = "zh_TW" ]; then
  ln -s "zh_TW.EUC" "$TYPES_DEST/zh_TW"
  ln -s "zh_TW.EUC" "$TYPES_DEST/tchinese"
elif [ "$4" = "tr" ]; then
  ln -s "tr" "$TYPES_DEST/tr_TR"
  ln -s "tr" "$TYPES_DEST/tr_TR.ISO8859-9"
fi

# for we do not ask the user if he wishes to integrate globally, 
# no error message should be printed
/usr/dt/bin/dtappintegrate -s $1 
#2>/dev/null
RETVAL=$?

# create result file to signal successful integration
if [ $RETVAL -eq 0 ]; then 
  touch "$1/share/cde/dtappintegrate.success"
else  
  # create result file to signal missing root permissions
  if [ $RETVAL -eq 3 ]; then
    touch "$1/share/cde/dtappintegrate.noroot"
  fi

  # remove the integration tree to signal failed integration
  rm -rf "$1/dt"
fi

