/*************************************************************************
 *
 *  $RCSfile: fattr.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: nf $ $Date: 2001/05/02 11:03:42 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#if SUPD==358
#include <tlintl.hxx>
#endif

#if defined(DEBUG) && defined (MH)
#define TEST 1 => Scheiss define ist das!
#endif

#include <time.h>
#ifndef MAC
#if !defined( UNX ) && !defined( BLC )
#include <sys/utime.h>
#else
#include <utime.h>
#endif
#include <sys/types.h>
#include <sys/stat.h>
#else
#include <utime.h>
#include <types.h>
#include <stat.h>
#define _GEN_HXX
#endif
#include <stdio.h>
#include <errno.h>

#if defined( UNX ) || defined( MAC )
#define _unlink unlink
#include <unistd.h>
#endif

#define private public
#include "stream.hxx"
#include "debug.hxx"

#if defined( UNX ) || defined( BLC ) || defined ( MAC )
#define _stat stat
#define _utime utime
#define _utimbuf utimbuf
#endif

#ifdef MAC
#define S_IREAD 0
#define S_IWRITE 0
#endif

#ifdef ICC
#define _stat stat
#define _utimbuf utimbuf
#endif

#include "fattr.hxx"

#if ( defined (ICC) && !defined (AIX) ) || defined (BLC) || defined (UNX) || defined (WTC) || defined (MAC)
#define _S_IFDIR 	S_IFDIR
#define _S_IREAD 	S_IREAD
#define _S_IWRITE	S_IWRITE
#define _S_IEXEC	S_IEXEC
#endif

#ifdef DOS
#include <io.h>	// wg. chmod
#endif
#ifdef WIN
#include <io.h>	// wg. chmod
#endif

struct FileAttribute_Impl
{
	Date			aDateCreated;
	Time			aTimeCreated;
	Date			aDateModified;
	Time			aTimeModified;
	Date			aDateAccessed;
	Time			aTimeAccessed;
	ULONG			nAttr;
};

FileAttribute::FileAttribute()	:
#ifdef UNX
	FileStat( DirEntry("/dev/null") )
#elif MAC
	FileStat()
#else
	FileStat( DirEntry("NUL") )
#endif
{
#if !defined( DOS ) && !defined( MAC )
	tzset();
#endif

	pImpl = new FileAttribute_Impl;
	pImpl->aDateCreated = Date();
	pImpl->aDateModified = Date();
	pImpl->aDateAccessed = Date();
	pImpl->aTimeCreated = Time();
	pImpl->aTimeModified = Time();
	pImpl->aTimeAccessed = Time();
	pImpl->nAttr = 777;

}

FileAttribute::FileAttribute( const DirEntry& rDirEntry ) :
	FileStat( rDirEntry )
{
	theEntry = rDirEntry;
	ByteString aFilename( rDirEntry.GetFull(), gsl_getSystemTextEncoding());
	USHORT nLen = aFilename.Len();
	pFileName = new char[nLen+1];
	(void) strcpy ( pFileName, aFilename.GetBuffer() );

#if !defined( DOS ) && !defined( MAC )
	tzset();
#endif

	pImpl = GetAttributes();
}

DirEntry FileAttribute::GetDirEntry()
{
	return theEntry;
}

void FileAttribute::SetName( const DirEntry& rDirEntry )
{
	theEntry = rDirEntry;
	ByteString aFilename( rDirEntry.GetFull(), gsl_getSystemTextEncoding());
	USHORT nLen = aFilename.Len();
	pFileName = new char[nLen+1];
	(void) strcpy ( pFileName, aFilename.GetBuffer() );

	SetAttributes( pImpl );
}

FileAttribute::FileAttribute( const FileAttribute &rFattr )
{
	// nur die Attribute !!
	//
	// theEntry = rFattr.theEntry;
	//pFileName = new char[strlen( rFattr.pFileName ) +1];
	//(void) strcpy ( pFileName, rFattr.pFileName );

#if !defined( DOS ) && !defined( MAC )
	tzset();
#endif

	pImpl = new FileAttribute_Impl;
	pImpl->aDateCreated = rFattr.pImpl->aDateCreated;
	pImpl->aDateModified = rFattr.pImpl->aDateModified;
	pImpl->aDateAccessed = rFattr.pImpl->aDateAccessed;
	pImpl->aTimeCreated = rFattr.pImpl->aTimeCreated;
	pImpl->aTimeModified = rFattr.pImpl->aTimeModified;
	pImpl->aTimeAccessed = rFattr.pImpl->aTimeAccessed;
	pImpl->nAttr = rFattr.pImpl->nAttr;

	//SetAttributes( pImpl );
}

FileAttribute::~FileAttribute()
{
}

ULONG  FileAttribute::GetFlags()
{
	return pImpl->nAttr;
}

FileAttribute_Impl* FileAttribute::GetAttributes()
{
	FileAttribute_Impl* pData = new FileAttribute_Impl;
	pData->aDateCreated = DateCreated();
	pData->aDateModified = DateModified();
	pData->aDateAccessed = DateAccessed();
	pData->aTimeCreated = TimeCreated();
	pData->aTimeModified = TimeModified();
	pData->aTimeAccessed = TimeAccessed();

	struct _stat buf;
	int result;

	result = _stat( pFileName, &buf );

	pData->nAttr = 0L;

	if ( !result )
	{
#ifdef DEBUG
		fprintf( stderr, "GetAttr : %s %x \n", pFileName, buf.st_mode );
#endif
		pData->nAttr = buf.st_mode;
	}

	return pData;
}

void FileAttribute::SetAttributes( FileAttribute_Impl* )
{
	//if ( IsKind( FSYS_KIND_DIR ) )
	//{
		ULONG nOldAttr = pImpl->nAttr;

		//fuer Touchen, den Schreibschutz runternehmen
#if defined( UNX )
		Attrib( 777 );
#else
		Attrib( FA_WRITE );
#endif

		Touch( pImpl->aDateModified, pImpl->aTimeModified,
				pImpl->aDateAccessed, pImpl->aTimeAccessed );

		// Die FileAttribute wieder herstellen
			Attrib( nOldAttr );
	//}

}

/*
 *
 * File auf das aktuelle Datum touchen !
 *
 */

BOOL FileAttribute::Touch()
{
	if (_utime( pFileName, NULL ) == -1)
	{
		//Error();
		fprintf( stderr, "Touch failed\n" );
		return FALSE;
	}
	else
		return TRUE;
}

BOOL FileAttribute::Delete()
{
#if defined( UNX )
	Attrib( 777 );
#else
	Attrib(  FA_WRITE );
#endif
#ifdef DEBUG
	fprintf( stderr, "Unlinking %s\n", pFileName );
#endif
	if (_unlink( pFileName ) == -1)
	{
		//Error();
		fprintf( stderr, "Delete of %s failed\n", pFileName );
		return FALSE;
	}
	else
		return TRUE;
}

/*
 *
 * File auf Referenzfile touchen
 *
 */

BOOL FileAttribute::Touch( String aRefFile )
{
	DirEntry aEntry( aRefFile );
	if ( !aEntry.Exists() )
		return FALSE;

	FileStat aFileStat( aEntry );
	Date aModDate = aFileStat.DateModified();
	Time aModTime = aFileStat.TimeModified();
	Date aAccDate = aFileStat.DateAccessed();
	Time aAccTime = aFileStat.TimeAccessed();

	return Touch( aModDate, aModTime, aAccDate, aAccTime );
}

/*
 *
 * File auf Modifaction und Access Datum touchen
 *
 */

BOOL FileAttribute::Touch( Date &rModDate, Time &rModTime )
{
	struct tm *my_modtime = new tm;
	my_modtime->tm_sec = rModTime.GetSec();
	my_modtime->tm_min = rModTime.GetMin();
	my_modtime->tm_hour = rModTime.GetHour();

	my_modtime->tm_mday = rModDate.GetDay();
	my_modtime->tm_mon = rModDate.GetMonth()-1;
	my_modtime->tm_year = rModDate.GetYear() -1900;

	my_modtime->tm_isdst = -1;

	time_t new_modtime = mktime( my_modtime );

	_utimbuf *new_utime = new _utimbuf;
	new_utime->actime = 0L;
	new_utime->modtime = new_modtime;

	if (_utime( pFileName, new_utime ) == -1)
	{
		//Error();
		//	fprintf( stderr, "%s: Touching DateTime failed\n", pFileName );
	}

	return TRUE;
}
/*
 *
 * File auf Modifaction und Access Datum touchen
 *
 */

BOOL FileAttribute::Touch( Date &rModDate, Time &rModTime,
							Date &rAccDate, Time &rAccTime )
{
	struct tm *my_modtime = new tm;
	my_modtime->tm_sec = rModTime.GetSec();
	my_modtime->tm_min = rModTime.GetMin();
	my_modtime->tm_hour = rModTime.GetHour();

	my_modtime->tm_mday = rModDate.GetDay();
	my_modtime->tm_mon = rModDate.GetMonth()-1;
	my_modtime->tm_year = rModDate.GetYear() -1900;

	my_modtime->tm_isdst = -1;

	time_t new_modtime = mktime( my_modtime );

	struct tm *my_acctime = new tm;
	my_acctime->tm_sec = rAccTime.GetSec();
	my_acctime->tm_min = rAccTime.GetMin();
	my_acctime->tm_hour = rAccTime.GetHour();

	my_acctime->tm_mday = rAccDate.GetDay();
	my_acctime->tm_mon = rAccDate.GetMonth()-1;
	my_acctime->tm_year = rAccDate.GetYear() -1900;

	my_acctime->tm_isdst = 0;

	time_t new_acctime = mktime( my_acctime );

	_utimbuf *new_utime = new _utimbuf;
	new_utime->actime = new_acctime;
	new_utime->modtime = new_modtime;

	if (_utime( pFileName, new_utime ) == -1)
	{
		Error();
//		fprintf( stderr, "%s: Touching DateTime failed\n", pFileName );
	}

	return TRUE;
}

/*
 *
 * Schreib/Lese Rechte setzen
 *
 */

BOOL FileAttribute::Attrib( ULONG nAttr )
{
#ifdef DEBUG
	fprintf( stderr, "Attrib : %s %x \n", pFileName, nAttr );
#endif

#ifndef MAC
	if ( chmod ( pFileName, nAttr ) == -1 )
	{
		//Error();
		return FALSE;
	}
	else
#endif
		return TRUE;
}

void FileAttribute::Error()
{
#ifdef DEBUG
	printf( "DEBUG : errno : %d\n", errno );
#endif
	switch ( errno )
	{
		case EACCES :
			ErrorHandler::HandleError( FSYS_ERR_ACCESSDENIED );
			break;
		case ENOENT :
			ErrorHandler::HandleError( FSYS_ERR_NOTAFILE );
			break;
		case ENOSPC :
			ErrorHandler::HandleError( FSYS_ERR_VOLUMEFULL );
			break;
		case EINVAL :
			ErrorHandler::HandleError( FSYS_ERR_INVALIDCHAR );
			break;
		default:
			ErrorHandler::HandleError( FSYS_ERR_UNKNOWN );
	}
}

void FileAttribute::LowerName()
{
	FileAttribute_Impl* pOldAttribs = GetAttributes();

	Attrib( FA_WRITE );
	DirEntry(pFileName).MoveTo(DirEntry("xxxxxxxxxxxx"));
	DirEntry("xxxxxxxxxxxx").MoveTo(DirEntry(pFileName));

	Attrib(pOldAttribs->nAttr);
}

void FileAttribute::LowerName(char* pName)
{
	FileAttribute_Impl* pOldAttribs = GetAttributes();

	Attrib( FA_WRITE );
	DirEntry(pFileName).MoveTo(DirEntry("xxxxxxxxxxxx"));
	DirEntry("xxxxxxxxxxxx").MoveTo(DirEntry(pName));

	Attrib(pOldAttribs->nAttr);
}

/********************************************************************/

/*
 * FileCloner
 *
 */

BOOL FileCloner::Progress()
{
	if ( GetBytesCopied() == 0 )
		Begin();
	if ( GetBytesCopied() == GetBytesTotal() )
		End();
	if ( (nProgress % 10 ) == 0 )
#ifdef DEBUG
			fprintf(stderr, ".");
#endif
	nProgress++;
	return TRUE;
}

void FileCloner::Begin()
{
	nProgress = 0;
}

void FileCloner::End()
{
}

#ifndef _STREAM_HXX
#ifdef UNX
#define private public
#endif
#include "stream.hxx"
#endif

struct FileCloner_Impl
{
	FSysAction		nActions;		// was zu tun ist (Copy/Move/recur)
    Link            aErrorLink;		// bei Fehlern zu rufen
	ErrCode			eErr;           // aktueller Fehlercode im Error-Handler
	const DirEntry*	pErrSource;		// fuer Error-Handler falls Source-Fehler
	const DirEntry*	pErrTarget;		// fuer Error-Handler falls Target-Fehler

					FileCloner_Impl()
					:	nActions( 0 ), eErr( 0 ),
						pErrSource( 0 ), pErrTarget( 0 )
					{}
					FileCloner_Impl( const FileCloner_Impl &rOrig )
					:	nActions( rOrig.nActions ), eErr( 0 ),
						pErrSource( 0 ), pErrTarget( 0 )
					{}

	FileCloner_Impl& operator=( const FileCloner_Impl &rOrig )
					{
						nActions = rOrig.nActions;
						eErr = 0; pErrSource = 0; pErrTarget = 0;
						return *this;
					}
};

FileCloner::FileCloner():
    nBlockSize( 4096 ),
    nBytesTotal( 0 ),
	nBytesCopied( 0 ),
	bUpdateCopy( FALSE ),
	bCopied( FALSE ),
	bDiffCopy( FALSE )//,
	//pImp( new FileCloner_Impl )
{
	pImp = new FileCloner_Impl;
}

FileCloner::FileCloner( const DirEntry &rSource, const DirEntry &rTarget ):
    aSource( rSource ),
    aTarget( rTarget ),
    nBlockSize( 4096 ),
    nBytesTotal( 0 ),
	nBytesCopied( 0 ),
	bUpdateCopy( FALSE ),
	bCopied( FALSE ),
	bDiffCopy( FALSE )//,
	//pImp( new FileCloner_Impl )
{
	pImp = new FileCloner_Impl;
}

FileCloner::FileCloner( const FileCloner &rCloner ):
    aSource( rCloner.aSource ),
    aTarget( rCloner.aTarget ),
    nBlockSize( 4096 ),
    nBytesTotal( 0 ),
    nBytesCopied( 0 ),
	aProgressLink( rCloner.aProgressLink ),
	bDiffCopy( FALSE ),
	bCopied( FALSE ),
	bUpdateCopy( FALSE )//,
	//pImp( new FileCloner_Impl )
{
	pImp = new FileCloner_Impl;
}


FileCloner::~FileCloner()
{
	delete pImp;
}


FileCloner& FileCloner::operator = ( const FileCloner &rCloner )
{
    aSource = rCloner.aSource;
    aTarget = rCloner.aTarget;
    nBytesTotal = rCloner.nBytesTotal;
    nBytesCopied = rCloner.nBytesCopied;
    nBytesCopied = rCloner.nBytesCopied;
    nBlockSize = rCloner.nBlockSize;
    aProgressLink = rCloner.aProgressLink;
	*pImp = *(rCloner.pImp);
    return *this;
}

/*
BOOL FileCopier::Progress()
{
    if ( !aProgressLink )
        return TRUE;
    else
        return aProgressLink.Call( this );
}
*/

//---------------------------------------------------------------------------

ErrCode FileCloner::Error( ErrCode eErr,
						   const DirEntry *pSource, const DirEntry *pTarget )
{
	// kein Fehler oder kein ErrorHandler?
	if ( !eErr || !pImp->aErrorLink )
		// => Error beibehalten
		return eErr;

	// sonst gesetzten ErrorHandler fragen
	pImp->pErrSource = pSource;
	pImp->pErrTarget = pTarget;
	pImp->eErr = eErr;
	ErrCode eRet = (ErrCode) pImp->aErrorLink.Call( this );
	pImp->pErrSource = 0;
	pImp->pErrTarget = 0;
	return eRet;
}

//---------------------------------------------------------------------------

const DirEntry*	FileCloner::GetErrorSource() const
{
	return pImp->pErrSource;
}

//---------------------------------------------------------------------------

const DirEntry*	FileCloner::GetErrorTarget() const
{
	return pImp->pErrTarget;
}

//---------------------------------------------------------------------------

ErrCode	FileCloner::GetError() const
{
	return pImp->eErr;
}

//---------------------------------------------------------------------------

void FileCloner::SetErrorHdl( const Link &rLink )
{
	pImp->aErrorLink = rLink;
}

//---------------------------------------------------------------------------

const Link& FileCloner::GetErrorHdl() const
{
	return pImp->aErrorLink ;
}


FSysError FileCloner::DoCopy_Impl( const DirEntry &rSource, const DirEntry &rTarget, BOOL bTop )
{
	FSysError eRet = FSYS_ERR_OK;

	// source is directory?
	FileStat aSourceFileStat( rSource );
	if ( aSourceFileStat.IsKind(FSYS_KIND_DIR) )
	{
		// recursive copy
		eRet = Error( rTarget.MakeDir() ? FSYS_ERR_OK : FSYS_ERR_UNKNOWN,
					  0, &rTarget );
		Dir aSourceDir( rSource, FSYS_KIND_DIR|FSYS_KIND_FILE );
		for ( USHORT n = 0; eRet == FSYS_ERR_OK && n < aSourceDir.Count(); ++n )
		{
			const DirEntry &rSubSource = aSourceDir[n];
			DirEntryFlag eFlag = rSubSource.GetFlag();
			if ( eFlag != FSYS_FLAG_CURRENT && eFlag != FSYS_FLAG_PARENT )
			{
				DirEntry aSubTarget( rTarget + DirEntry(rSubSource.GetName()) );
				eRet = DoCopy_Impl( rSubSource, aSubTarget, FALSE );
			}
		}

	}
	else if ( aSourceFileStat.IsKind(FSYS_KIND_WILD) )
	{
		FileStat aTargetFileStat( rTarget );
		if ( aTargetFileStat.IsKind( FSYS_KIND_WILD ) )
		{
			WildCard aWldCrd( rSource.GetName() );
			Dir aWldDir( rSource );
#if !defined( DOS ) && !defined( OS2 ) && !defined( WNT )
			for ( ULONG i=0; i<= aWldDir.Count(); i++ )
			{
				String aFileName = aWldDir[i].GetName();

				DirEntry aWldSource( rSource.GetPath());
				aWldSource += DirEntry( aFileName );

				DirEntry aWldTarget( rTarget.GetDevice());
				aWldTarget += rTarget.GetPath();
				aWldTarget += DirEntry( aFileName );

				eRet = DoCopy_Impl( aWldSource, aWldTarget, FALSE );
			}
#endif
		}
	}
	else if ( aSourceFileStat.IsKind(FSYS_KIND_FILE) )
	{
		if ( bUpdateCopy )
		{
			FileStat aSource( rSource ); FileStat aDest( rTarget );

			DateTime aSourceDateTime( aSource.DateModified(),
										aSource.TimeModified() );
			DateTime aDestDateTime( aDest.DateModified(),
										aDest.TimeModified() );

			// SourceDatei auf 2 Sekunden adjustieren
			ULONG nSeconds = aSourceDateTime.GetSec();
			if ( nSeconds % 2 == 1 )
				aSourceDateTime.SetSec( --nSeconds );

			// Dateien sind gleich
			if ( aSourceDateTime <= aDestDateTime && !bDiffCopy )
			{
				DBG_ASSERT( FALSE, "Dateien sind gleich" );
				return eRet = FSYS_ERR_OK;
			}

		}
		if ( rTarget.Exists() )
		{
			FileAttribute aTmpDel( rTarget );
			if ( !aTmpDel.Delete())
				return FSYS_ERR_ACCESSDENIED;
		}
		// copy file
	    nBytesCopied = 0;
		nBytesTotal = FileStat( rSource ).GetSize();

		String aFileName( GUI2FSYS( rSource.GetFull()));
	    SvFileStream aSource( aFileName,
				  STREAM_READ|STREAM_NOCREATE|STREAM_SHARE_DENYNONE );

	    if ( !aSource.GetError() )
	    {
#ifdef UNX
			struct stat buf;
			if ( fstat( aSource.GetFileHandle(), &buf ) == -1 )
			{
				//fprintf(stderr, "fstat failed\n");
				return FSYS_ERR_ACCESSDENIED;
			}
#endif
#ifdef UNX
//roge Ohne STREAM_SHARE_DENYWRITE. Sonst geht nix mehr.
			SvFileStream aTarget( GUI2FSYS( rTarget.GetFull() ),
	                              STREAM_WRITE|STREAM_TRUNC);
#else
			SvFileStream aTarget( GUI2FSYS( rTarget.GetFull() ),
	                              STREAM_WRITE|STREAM_TRUNC|STREAM_SHARE_DENYWRITE);
#endif
	        if ( !aTarget.GetError() )
	        {
//roge patch Unter Linux fuehrte das Folgende
//zu return FSYS_ERR_ACCESSDENIED. buf.st_mode kommt von
// fstat auf das SourceFile (s.o.), auch hat dieser
//Parameter eigentlich nicht viel mit dem
//Eingabeparameter fuer fchmod zu tun?

				/*
#ifdef UNX

#ifdef AIX
				if ( fchmod( (char*)(int)aTarget.GetFileHandle(), buf.st_mode ) == -1)
#else
	            if ( fchmod( aTarget.GetFileHandle(), buf.st_mode ) == -1)
#endif
					return FSYS_ERR_ACCESSDENIED;
#endif
				*/

	            size_t nAllocSize = 0, nSize = 0;
	            char *pBuf = 0;
	            while ( Progress() && nSize == nAllocSize && eRet == FSYS_ERR_OK )
	            {
	                // adjust the block-size
	                if ( nBlockSize > nAllocSize )
	                {
	                    delete pBuf;
	                    nAllocSize = nBlockSize;
	                    pBuf = new char[nAllocSize];
	                }

	                // copy one block
	                nSize = aSource.Read( pBuf, nBlockSize );
	                if ( nSize != aTarget.Write( pBuf, nSize ) )
					{
						eRet = aTarget.GetError();
	                    Error( FSYS_ERR_VOLUMEFULL, 0, &rTarget );
						//ErrorHandler::HandleError( eRet );
					}

	                // adjust counters
	                nBytesCopied += nSize;
	                if ( nBytesCopied > nBytesTotal )
	                    nBytesTotal = nBytesCopied;
	            }
	            delete pBuf;
	        }
	        else
			{
	            eRet = Error( aTarget.GetError(), 0, &rTarget );
				ErrorHandler::HandleError( eRet );
			}
	    }
	    else
		{
	        eRet = Error( rSource.GetError(), &rSource, 0 );
			ErrorHandler::HandleError( eRet );
		}

		if ( FSYS_ERR_OK == eRet )
		{
			bCopied = TRUE;
			FileAttribute aSourceFileAttr( rSource );
			FileAttribute aDestFileAttr = aSourceFileAttr;
			aDestFileAttr.SetName( rTarget );
		}
	}

	// bei Move ggf. das File/Dir loeschen
#if SUPD > 355
	if ( FSYS_ERR_OK == eRet && ( pImp->nActions  & FSYS_ACTION_MOVE ) )
	{
		eRet = Error( rSource.Kill(), &rSource, 0 );
		if ( eRet && rSource.Exists() )
			// loeschen ging nicht => dann die Kopie wieder loeschen
			rTarget.Kill( pImp->nActions );
	}
#else
	DBG_ASSERT( FALSE, "Feature not implemented");
#endif
    return eRet;
}

FSysError FileCloner::Execute( FSysAction nActions )
{
	DirEntry aAbsSource = DirEntry( aSource);
	DirEntry aAbsTarget = DirEntry( aTarget );
	pImp->nActions = nActions;

	// check if both pathes are accessible and source and target are different
	if ( !aAbsTarget.ToAbs() || !aAbsSource.ToAbs() ||
	     aAbsTarget == aAbsSource )
	    return FSYS_ERR_ACCESSDENIED;

#if SUPD > 355
	// check if copy would be endless recursive into itself
	if ( FSYS_ACTION_RECURSIVE == ( nActions & FSYS_ACTION_RECURSIVE ) &&
		 aAbsSource.Contains( aAbsTarget ) )
		return ERRCODE_IO_RECURSIVE;
#endif

	// target is directory?
	if ( FileStat( aAbsTarget ).IsKind(FSYS_KIND_DIR) )
		// append name of source
		aAbsTarget += aSource.GetName();

	// recursive copy
	return DoCopy_Impl( aAbsSource, aAbsTarget, TRUE );
}

BOOL FileCloner::Compare()
{
	DirEntry aAbsSource = DirEntry( aSource);
	DirEntry aAbsTarget = DirEntry( aTarget );

	// check if both pathes are accessible and source and target are different
	if ( !aAbsTarget.ToAbs() || !aAbsSource.ToAbs() ||
	     aAbsTarget == aAbsSource )
	    return FALSE;

	// target is directory?
	if ( FileStat( aAbsTarget ).IsKind(FSYS_KIND_DIR) )
		// append name of source
		aAbsTarget += aSource.GetName();

	// recursive compare
	return DoCompare_Impl( aAbsSource, aAbsTarget );
}


BOOL FileCloner::DoCompare_Impl( const DirEntry &rSource,
										const DirEntry &rTarget )
{
	BOOL eRet = TRUE;

	// source is directory?
	FileStat aSourceFileStat( rSource );
	if ( aSourceFileStat.IsKind(FSYS_KIND_DIR) )
	{
		// recursive compare
		eRet = Error( rTarget.MakeDir() ? FSYS_ERR_OK : FSYS_ERR_UNKNOWN,
					  0, &rTarget );
		Dir aSourceDir( rSource, FSYS_KIND_DIR|FSYS_KIND_FILE );
		for ( USHORT n = 0; eRet == FSYS_ERR_OK && n < aSourceDir.Count(); ++n )
		{
			const DirEntry &rSubSource = aSourceDir[n];
			DirEntryFlag eFlag = rSubSource.GetFlag();
			if ( eFlag != FSYS_FLAG_CURRENT && eFlag != FSYS_FLAG_PARENT )
			{
				DirEntry aSubTarget( rTarget + DirEntry(rSubSource.GetName()) );
				eRet = DoCompare_Impl( rSubSource, aSubTarget );
			}
		}

	}
	else if ( aSourceFileStat.IsKind(FSYS_KIND_WILD) )
	{
		FileStat aTargetFileStat( rTarget );
		if ( aTargetFileStat.IsKind( FSYS_KIND_WILD ) )
		{
			WildCard aWldCrd( rSource.GetName() );
			Dir aWldDir( rSource );
			for ( ULONG i=0; i<= aWldDir.Count(); i++ )
			{
#if !defined( DOS ) && !defined( OS2 ) && !defined( WNT )
				String aFileName = aWldDir[i].GetName();
				String aSourceFileName( rSource.GetPath().GetFull());
				aSourceFileName += String((char)92, gsl_getSystemTextEncoding());
				aSourceFileName += aFileName;
				DirEntry aWldSource( aSourceFileName );
				String aTargetFileName( rTarget.GetDevice().GetFull());
				aTargetFileName += String((char)92, gsl_getSystemTextEncoding());
				aTargetFileName += rTarget.GetPath().GetFull();
				aTargetFileName += String((char)92, gsl_getSystemTextEncoding());
				aTargetFileName += aFileName;
				DirEntry aWldTarget( aTargetFileName );
				eRet = DoCompare_Impl( aWldSource, aWldTarget );
#endif
			}
		}

	}
	else if ( aSourceFileStat.IsKind(FSYS_KIND_FILE) )
	{
		// copy file
	    nBytesCopied = 0;
		nBytesTotal = FileStat( rSource ).GetSize();

		String aFileName( GUI2FSYS( rSource.GetFull()));
	    SvFileStream aSource( aFileName,
						  STREAM_READ|STREAM_NOCREATE|STREAM_SHARE_DENYNONE );

	    if ( !aSource.GetError() )
	    {
#ifdef UNX
			struct stat buf;
			if ( fstat( aSource.GetFileHandle(), &buf ) == -1 )
				return FSYS_ERR_ACCESSDENIED;
#endif
			SvFileStream aTarget( GUI2FSYS( rTarget.GetFull() ),
						  STREAM_READ|STREAM_NOCREATE|STREAM_SHARE_DENYNONE );
	        if ( !aTarget.GetError() )
	        {
#ifdef UNX
	            if ( fchmod( aTarget.GetFileHandle(), buf.st_mode ) == -1)
					return FSYS_ERR_ACCESSDENIED;
#endif
	            size_t nAllocSize = 0, nSize = 0;
	            char *pBuf = 0;
				char *pTargetBuf = 0;
	            while ( Progress() && nSize == nAllocSize )
	            {
	                // adjust the block-size
	                if ( nBlockSize > nAllocSize )
	                {
	                    delete pBuf;
	                    delete pTargetBuf;
	                    nAllocSize = nBlockSize;
	                    pBuf = new char[nAllocSize];
	                    pTargetBuf = new char[nAllocSize];
	                }

	                // copy one block
	                nSize = aSource.Read( pBuf, nBlockSize );
					// hier weitermachen !!!!!!!!!!!!!!!!!!
					//
					aTarget.Read( pTargetBuf, nBlockSize );

					int nResult = memcmp( pBuf, pTargetBuf, nBlockSize );

					if ( nResult != 0 )
					{
						DBG_ASSERT( FALSE, "Dateien sind unterschiedlich" );
						return FALSE;
					}
	                // adjust counters
	                nBytesCopied += nSize;
	                if ( nBytesCopied > nBytesTotal )
	                    nBytesTotal = nBytesCopied;
	            }
	            delete pBuf;
	            delete pTargetBuf;
	        }
	        else
	            eRet = Error( aTarget.GetError(), 0, &rTarget );
	    }
	    else
	        eRet = Error( rSource.GetError(), &rSource, 0 );

	}

    return eRet;
}
/********************************************************************/

#ifdef TESTxxxx
int __cdecl main( int argc, char **argv )
{
	BS_ErrorHandler *pErr = new BS_ErrorHandler;

	ErrorHandler::HandleError( FSYS_ERR_UNKNOWN );

	BOOL bRet;
	DirEntry aTestFile( "test.txt" );
	DirEntry aTargetFile( "c:\\test.tar" );

	//aFile.Attrib( FA_WRITE );
	//aFile.Attrib( FA_HIDDEN );
	//Date aDate;
	//Time aTime;

	//aDate.SetYear( 1976 );
	//aDate.SetMonth( 7 );

	//aTime.SetHour( 3 );

	//aFile.Touch( aDate, aTime );
	//aFile.Attrib( FA_RDONLY );

	FileCloner aFileCloner( aTestFile, aTargetFile );

	bRet = aFileCloner.Compare();
	if ( !bRet )
		printf( "Die Dateien sind unterschiedlich\n" );

	aFileCloner.Execute();

	bRet = aFileCloner.Compare();
	if ( !bRet )
		printf( "Die Dateien sind unterschiedlich\n" );

	/*FileAttribute aFile( aTestFile );
	FileAttribute aSecAttr = aFile;
	aSecAttr.SetName( aTargetFile );*/

	return 0;
}
#endif
