/*************************************************************************
 *
 *  $RCSfile: minormk.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: nf $ $Date: 2000/09/26 06:13:02 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include "minormk.hxx"
#include "appdef.hxx"
#include "fsys.hxx"

//
// class MinorMk
//

/*****************************************************************************/
MinorMk::MinorMk( const ByteString &rMinor,	const ByteString &rEnvironment )
/*****************************************************************************/
				: bExists( FALSE )
{
	ByteString sDelimiter( DirEntry::GetAccessDelimiter(), RTL_TEXTENCODING_ASCII_US );


	ByteString sSolver( GetEnv( "SOLARVERSION" ));
	BOOL bNewEnv = TRUE;
	if ( !sSolver.Len()) {
		sSolver = GetEnv( "SOLARVER" );
		bNewEnv = FALSE;
	}
	ByteString sUPD( GetEnv( "UPD" ));

	ByteString sMinorMk( sSolver );
	sMinorMk += sDelimiter;
	if ( !bNewEnv ) {
		sMinorMk += sUPD;
		sMinorMk += sDelimiter;
	}

	if ( rEnvironment.Len()) {
		sMinorMk += rEnvironment;
		sMinorMk += sDelimiter;
		sMinorMk += "inc";
		if( rMinor.Len()) {
			sMinorMk += ".";
			sMinorMk += rMinor;
		}
		sMinorMk += sDelimiter;
	}

	sMinorMk += sUPD;
	sMinorMk += "minor.mk";

	String sFile( sMinorMk, RTL_TEXTENCODING_ASCII_US );
	if ( DirEntry( sFile ).Exists()) {
		bExists = TRUE;
		SvFileStream aStream( sFile, STREAM_STD_READ );
		while ( !aStream.IsOpen())
			aStream.Open( sFile, STREAM_STD_READ );

		ByteString sLine;
		while ( !aStream.IsEof()) {
			aStream.ReadLine( sLine );

			if ( sLine.GetToken( 0, '=' ) == "RSCVERSION" )
				sRSCVERSION = sLine.GetToken( 1, '=' );
			else if ( sLine.GetToken( 0, '=' ) == "RSCREVISION" )
				sRSCREVISION = sLine.GetToken( 1, '=' );
			else if ( sLine.GetToken( 0, '=' ) == "BUILD" )
				sBUILD = sLine.GetToken( 1, '=' );
			else if ( sLine.GetToken( 0, '=' ) == "LAST_MINOR" )
				sLAST_MINOR = sLine.GetToken( 1, '=' );
		}
		aStream.Close();

		sRSCVERSION.EraseTrailingChars();
		sRSCREVISION.EraseTrailingChars();
		sBUILD.EraseTrailingChars();
		sLAST_MINOR.EraseTrailingChars();
	}
}

/*****************************************************************************/
MinorMk::~MinorMk()
/*****************************************************************************/
{
}

/*****************************************************************************/
BOOL MinorMk::PatchFlat( const String &rNewMinor, const String &rNewBuildNr )
/*****************************************************************************/
{
	return FALSE;
}

/*****************************************************************************/
BOOL MinorMk::CreateFlatIfNotExists()
/*****************************************************************************/
{
	return FALSE;
}

