/*************************************************************************
 *
 *  $RCSfile: updmake.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: nf $ $Date: 2001/02/15 15:20:01 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#include "sstring.hxx"
#include "prj.hxx"
#include "inimgr.hxx"
#include "updmake.hxx"
#include "appdef.hxx"
#include "make_err.hxx"

#include "iparser.hxx"
#include "geninfo.hxx"
#include "shellprp.hxx"
#include <stdlib.h>
#include <stdio.h>

const char PRJ_DIR_NAME[] = "prj";
const char DLIST_NAME[] = "d.lst";


ByteString GetProjectRoot();

const ByteString sSubdir_Prj("prj");
static ByteString aAccessDelimiter = 
	ByteString( DirEntry::GetAccessDelimiter(), gsl_getSystemTextEncoding());


//
// class UPDDependencies
//

/*****************************************************************************/
UPDDependencies::UPDDependencies( ByteString &rDir, ByteString &rLog )
/*****************************************************************************/
				: ByteString( rDir ),
				sLogName( rLog ),
				sDependencies( "" )
{
}

/*****************************************************************************/
void UPDDependencies::AddDepend( ByteString &rDpc )
/*****************************************************************************/
{
	ByteString sDpcs( sDependencies );
	ByteString sDpc( rDpc );

	if ( sDpcs.ToUpperAscii().Search( sDpc.ToUpperAscii()) == STRING_NOTFOUND ) {
		// if this dependencie is not in list add it
		sDependencies += rDpc;
		sDependencies += ( ";" );
	}
}

/*****************************************************************************/
BOOL UPDDependencies::RemoveDepend( ByteString &rDpc )
/*****************************************************************************/
{
	BOOL bReturn = FALSE;

	ByteString sDpc( rDpc );
	sDpc += ByteString( ";" );


	// remove the dependencie
	while( sDependencies.SearchAndReplace( sDpc, "" )
		!= STRING_NOTFOUND ) bReturn = TRUE;

	return bReturn;
}

//
// class UPDDirectory
//

/*****************************************************************************/
UPDDirectory::UPDDirectory( const ByteString &rDir,const ByteString &rCommand )
/*****************************************************************************/
				: ByteString( rDir ),
				sMakeCommand( rCommand )
{
}

/*****************************************************************************/
BOOL UPDDirectory::Build( ByteString &rSwitches )
/*****************************************************************************/
{
	BOOL bReturn = TRUE;

	// create the whole command to build this dir
	ByteString sCommand( sMakeCommand );
	sCommand += ByteString( " " );
	sCommand += rSwitches;

	return bReturn;
}

//
// class UPDMake
//

/*****************************************************************************/
UPDMake::UPDMake( const ByteString &rProject,
				  const ByteString &rWorkStamp,
				  const ByteString &rMakeCommand,
				  const ByteString &rFileName,
				  Star *pStar )
/*****************************************************************************/
				: nErrorCode( MK_NO_ERROR ),
				sFileName( rFileName ),
				sPathAdd( aAccessDelimiter ),
				sMakeCommand( rMakeCommand ),
				sProject(rProject),
				sWorkStamp(rWorkStamp),
				bGetProjectFromCvs(FALSE)
{
	ByteString sSolarList;
	if ( !pStar )
	{ 
		nErrorCode = GetStar( &pStar, rWorkStamp);
		if (nErrorCode != MK_NO_ERROR)
			return;
	}

	Prj* pProject = pStar->GetPrj( rProject );
	if ( !pProject ) {
		nErrorCode = MK_ERROR_NO_PROJECT;
		return;
	}

	// iteration over directories
	DependenciesList aDpcList;
	ByteString sEnvBase( getenv( "INPATH" ));
	if ( !sEnvBase.Len()) {
		nErrorCode = MK_NO_ENVIRONMENT;
		return;
	}

	sEnvBase = sEnvBase.Copy( 0, 3 ).ToUpperAscii();

	for ( ULONG i = 0; i < pProject->Count(); i++ ) {
		CommandData *pData = pProject->GetObject( i );

		USHORT nType = pData->GetOSType();
		USHORT nCmd = pData->GetCommandType();
		ByteString aCmdPara = pData->GetCommandPara();

		if (( nCmd == COMMAND_NMAKE )
		   &&( (( sEnvBase == "WIN" ) && ( nType & OS_WIN16 ))
		   ||(( sEnvBase == "WNT" ) && ( nType & OS_WIN32 ))
		   ||(( sEnvBase == "UNX" ) && ( nType & OS_UNX ))
		   ||(( sEnvBase == "OS2" ) && ( nType & OS_OS2 ))
			||(( sEnvBase == "MAC" ) && ( nType & OS_MAC )) ))
		{
			ByteString sFile( pData->GetPath());
			ByteString sLog( pData->GetLogFile());
			UPDDependencies *pDpc = new UPDDependencies( sFile, sLog );

			SByteStringList* pList = pData->GetDependencies();
			if ( pList )
			{
				for ( ULONG i = 0; i< pList->Count(); i++ )
				{
					ByteString sDependExt = (*pList->GetObject( i )).GetToken( 1, '.' );
					if ( ( sDependExt.ToUpperAscii() == "" )
					   ||(( sEnvBase == "WIN" ) && ( sDependExt == "W" ))
					   ||(( sEnvBase == "WNT" ) && ( sDependExt == "N" ))
					   ||(( sEnvBase == "UNX" ) && ( sDependExt == "U" ))
					   ||(( sEnvBase == "OS2" ) && ( sDependExt == "P" ))
					   ||(( sEnvBase == "MAC" ) && ( sDependExt == "M" )) )
					{
						ByteString sDpc(( *pList->GetObject( i )).GetToken( 0, '.' ));
						pDpc->AddDepend( sDpc );
					}
				}
			}
			aDpcList.Insert( pDpc, LIST_APPEND );
		}
	}

	if ( !aDpcList.Count()) {
		nErrorCode = MK_ERROR_NO_DIRS;
		return;
	}

	// generate directory order
	BOOL bOnceMore = TRUE;
	while ( aDpcList.Count() && bOnceMore ) {
		BOOL bInserted = FALSE;
		for ( ULONG i = 0; !bInserted && i < aDpcList.Count(); i++ ) {
			if ( !aDpcList.GetObject( i )->GetDependCount()) {
				UPDDependencies *pDpc = aDpcList.GetObject( i );
				aDpcList.Remove( i );
				ByteString sDir( *pDpc );
				ByteString sLog( pDpc->GetLogFile());
				delete pDpc;

				for ( ULONG j = 0; j < aDpcList.Count(); j++ ) {
					aDpcList.GetObject( j )->RemoveDepend( sLog );
				}

				UPDDirectory *pDir = new UPDDirectory( sDir, rMakeCommand );
				Insert( pDir, LIST_APPEND );
				bInserted = TRUE;
			}
			if (( i == aDpcList.Count() - 1 ) && ( !bInserted ))
				bOnceMore = FALSE;
		}
	}
	if ( !bOnceMore ) {
		nErrorCode = MK_ERROR_DEPEND;
		return;
	}
}

/*****************************************************************************/
UPDMake::~UPDMake()
/*****************************************************************************/
{
#ifdef GCC
	for ( ULONG i = 0; i < Container::Count(); i++ )
#else
	for ( ULONG i = 0; i < Count(); i++ )
#endif
	{
		delete GetObject( i );
	}
}

/*****************************************************************************/
BOOL UPDMake::WriteScript( ByteString &rSwitches )
/*****************************************************************************/
{
	SvFileStream aScript( String( sFileName, gsl_getSystemTextEncoding()),
		STREAM_STD_WRITE | STREAM_TRUNC );
	if ( aScript.GetError())
		return FALSE;

#if !defined( UNX ) && !defined( MAC )
	aScript.WriteLine( ByteString( "@echo off" ));
	aScript.WriteLine( ByteString( "pushd" ));
#else
	aScript.WriteLine( ByteString( "setenv mk_tmp TRUE" ));
#endif

	WriteScriptInto(aScript,rSwitches);

#if !defined( UNX ) && !defined( MAC )
	aScript.WriteLine( ByteString( "popd" ));
#else
	aScript.WriteLine( ByteString( "unsetenv mk_tmp" ));
#endif

	aScript.Close();
	return TRUE;
}

/*****************************************************************************/
void UPDMake::WriteScriptInto( SvFileStream &o_rBatchFile,
							   const ByteString &i_rSwitches )
/*****************************************************************************/
{
	if (! o_rBatchFile.IsOpen())
		return;

	// Initilalize sPathAdd and sErrorExit:
	String sProjectsParentDir;

	ShellProperties& theShProps = ShellProperties::getShellProperties();

	if (bGetProjectFromCvs)
	{
		DirEntry aAddEntry;
		aAddEntry.ToAbs();
#ifdef MAC
		sProjectsParentDir = aAddEntry[2].GetFull();
#else
		sProjectsParentDir = aAddEntry.GetFull();
#endif
		sPathAdd = ByteString( sProjectsParentDir, gsl_getSystemTextEncoding());
		sPathAdd += theShProps.getDirSeparator();
	}
	else
	{
#ifdef MAC
		DirEntry aAddEntry( String( ":", gsl_getSystemTextEncoding()));
#else
		ByteString sParent("..");
		sParent += theShProps.getDirSeparator();
		sParent += ByteString( ".." );
		DirEntry aAddEntry( String( sParent, gsl_getSystemTextEncoding()));
#endif
		aAddEntry.ToAbs();
#ifdef MAC
		sProjectsParentDir = aAddEntry[2].GetFull();
#else
		sProjectsParentDir = aAddEntry.GetFull();
#endif
		sPathAdd = ByteString( sProjectsParentDir, gsl_getSystemTextEncoding());
		sPathAdd += theShProps.getDirSeparator();
	}
	ByteString sErrorExit = theShProps.getErrorMessageOrExit();

	// Write script lines:
// #if !defined( UNX ) && !defined( MAC )
//	o_rBatchFile.WriteLine( "pushd" );
// #endif
	if (bGetProjectFromCvs)
	{
		ByteString sCdCommand( "cd ");
		sCdCommand += ByteString( sProjectsParentDir, gsl_getSystemTextEncoding());
		o_rBatchFile.WriteLine( sCdCommand );

#ifndef UNX
#ifndef MAC
		ByteString sCvsCommand("_cvs checkout -r");
		sCvsCommand += sWorkStamp;
		sCvsCommand += " ";
		sCvsCommand += sProject;
		sCvsCommand += " >NUL";
#else
#endif
#else
		ByteString sCvsCommand("cvs checkout -r");
		sCvsCommand += sWorkStamp;
		sCvsCommand += " ";
		sCvsCommand += sProject;
		sCvsCommand += " >/dev/null";
#endif
		o_rBatchFile.WriteLine( sCvsCommand );

		ByteString sErrorCvs = theShProps.getErrorMessageOrExit("Cvs checkout failed.");
		o_rBatchFile.WriteLine( sErrorCvs );
	}

	for ( ULONG i = 0; i < Count(); i++ )
	{
		UPDDirectory *pDir = GetObject( i );
		ByteString sDir( *pDir );
		ByteString sCommand1( "cd " );
		sCommand1 += sPathAdd;
		sCommand1 += sDir;
#ifdef UNX
		while( sCommand1.SearchAndReplace( "\\", "/" ) != STRING_NOTFOUND );
#endif
#ifdef MAC
		while( sCommand1.SearchAndReplace( "\\", ":" ) != STRING_NOTFOUND );
#endif
		ByteString sCommand2( sMakeCommand );
		sCommand2 += ByteString( " " );
		sCommand2 += i_rSwitches;

		ByteString sCommand3 = ByteString( "echo " );
		sCommand3 += sCommand1.Copy( 3 );

		o_rBatchFile.WriteLine( sCommand1 );
		o_rBatchFile.WriteLine( sErrorExit );
		o_rBatchFile.WriteLine( sCommand3 );
		o_rBatchFile.WriteLine( sCommand2 );
		o_rBatchFile.WriteLine( sErrorExit );
	}

	// Go to a defined place, some other actions might to be performed on this project.
	//   This place is the prj-directory below the project root.
	DirEntry aTop(sProjectsParentDir);
	aTop += DirEntry( String( sProject, gsl_getSystemTextEncoding()));
	aTop += DirEntry( String( sSubdir_Prj, gsl_getSystemTextEncoding()));
	ByteString sCommandGotoPrj = "cd ";
	sCommandGotoPrj += ByteString( aTop.GetFull(), gsl_getSystemTextEncoding());
	o_rBatchFile.WriteLine( sCommandGotoPrj );
	o_rBatchFile.WriteLine( sErrorExit );

// #if !defined( UNX ) && !defined( MAC )
//	o_rBatchFile.WriteLine( "popd" );
// #endif
}

/*****************************************************************************/
USHORT UPDMake::GetStar( Star **pStar, const ByteString &rVersion, 
	BOOL bRecursive,  GenericInformationList *pStandLst )
/*****************************************************************************/
{
	// check the environment
	ByteString sVersion( rVersion );
	if ( !sVersion.Len())
	{
		return MK_NO_ENVIRONMENT;
	}

	GenericInformationList * dpList;
	IniManager aIniManager;

	if ( pStandLst )
		dpList = pStandLst;
	else {
		// read database
		fprintf( stderr, "\nUpdating configuration ...\n" );
		aIniManager.Update();

		ByteString sVersionList( _DEF_STAND_LIST );
		sVersionList = aIniManager.ToLocal( sVersionList );
		fprintf( stderr, "\nConfiguration file: %s\n", sVersionList.GetBuffer());

		InformationParser aParser;
		dpList = aParser.Execute( String( sVersionList, gsl_getSystemTextEncoding()));

		if ( dpList == 0 )
		{
			return MK_ERROR_READING_VERLST;
		}
	}

	// search for solarlist in datatbase
	ByteString sPath( sVersion );
#ifndef UNX
	sPath += ByteString( "/settings/solarlist" );
#else
	sPath += ByteString( "/settings/unxsolarlist" );
#endif
	ByteString sLocalSolarlistPath = _SOLARLIST;

	GenericInformation *pInfo = dpList->GetInfo( sPath, TRUE );
	if ( pInfo ) {
		ByteString aIniRoot( GetIniRoot());
		DirEntry aIniEntry( String( aIniRoot, RTL_TEXTENCODING_ASCII_US ));
		aIniEntry += DirEntry( String( pInfo->GetValue(), RTL_TEXTENCODING_ASCII_US )).GetBase( PATH_SEPARATOR );
		sLocalSolarlistPath = ByteString( aIniEntry.GetFull(), RTL_TEXTENCODING_ASCII_US );
		sLocalSolarlistPath = aIniManager.ToLocal( sLocalSolarlistPath );
		fprintf( stderr, "Make-initializing file: %s\n", sLocalSolarlistPath.GetBuffer());
	}
	else {
		String sRoot( GetProjectRoot(), RTL_TEXTENCODING_ASCII_US );
		String sPrjDir( String::CreateFromAscii( "prj" ));
		String sSolarList( String::CreateFromAscii( "build.lst" ));

		DirEntry aRoot( sRoot );
		aRoot += DirEntry( sPrjDir );
		aRoot += DirEntry( sSolarList );

		ByteString ssRoot( aRoot.GetFull(), RTL_TEXTENCODING_ASCII_US );
		fprintf( stdout, "Build.lst: %s\n", ssRoot.GetBuffer());

		if ( !aRoot.Exists()) {
			delete dpList;
			return MK_ERROR_READING_VERLST;
		}
		sLocalSolarlistPath = ByteString( aRoot.GetFull(), RTL_TEXTENCODING_ASCII_US );
	}
    delete dpList;

	if ( bRecursive )
		*pStar = new Star( String( sLocalSolarlistPath, RTL_TEXTENCODING_ASCII_US ),
			STAR_MODE_RECURSIVE_PARSE );
	else
		*pStar = new Star( String( sLocalSolarlistPath, RTL_TEXTENCODING_ASCII_US ));

	return MK_NO_ERROR;
}


/****************************************************************************/
ByteString GetProjectRoot()
/****************************************************************************/
{
	BOOL bFound = FALSE;
	DirEntry aCur;
	aCur.ToAbs();
	for ( ; ! bFound && aCur.Level() > 1; aCur.CutName() )
	{
		DirEntry aTest = aCur + DirEntry(PRJ_DIR_NAME) + DirEntry(DLIST_NAME);
		if ( aTest.Exists() )
		{
			return ByteString( aCur.GetFull(), gsl_getSystemTextEncoding());
		}
	}	// end for
	return "";
}



