/*************************************************************************
 *
 *  $RCSfile: inetstrm.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 17:03:02 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _TOOLS_INETSTRM_HXX
#define _TOOLS_INETSTRM_HXX

#ifndef _SAL_TYPES_H_
#include <sal/types.h>
#endif

#ifndef _STRING_HXX
#include <string.hxx>
#endif

class INetMessage;
class INetMIMEMessage;
class INetHTTPMessage;
class SvMemoryStream;
class SvStream;

/*=========================================================================
 *
 * INetStream Interface.
 *
 *=======================================================================*/
enum INetStreamStatus
{
	INETSTREAM_STATUS_LOADED     = -4,
	INETSTREAM_STATUS_WOULDBLOCK = -3,
	INETSTREAM_STATUS_OK         = -2,
	INETSTREAM_STATUS_ERROR      = -1
};

/*
 * INetIStream.
 */
class INetIStream
{
	// Not implemented.
	INetIStream (const INetIStream& rStrm);
	INetIStream& operator= (const INetIStream& rStrm);

protected:
	virtual int GetData (
		sal_Char *pData, ULONG nSize, void *pCtx = NULL) = 0;

public:
	INetIStream (ULONG nIBufferSize = 0);
	virtual ~INetIStream (void);

	int Read (sal_Char *pData, ULONG nSize, void *pCtx = NULL);

	static void Decode64 (SvStream& rIn, SvStream& rOut);
	static void Encode64 (SvStream& rIn, SvStream& rOut);
};

/*
 * INetOStream.
 */
class INetOStream
{
	// Not implemented.
	INetOStream (const INetOStream& rStrm);
	INetOStream& operator= (const INetOStream& rStrm);

protected:
	virtual int PutData (
		const sal_Char *pData, ULONG nSize, void *pCtx = NULL) = 0;

public:
	INetOStream (ULONG nOBufferSize = 0);
	virtual ~INetOStream (void);

	int Write (const sal_Char *pData, ULONG nSize, void *pCtx = NULL);
};

/*
 * INetIOStream.
 */
class INetIOStream : public INetIStream, public INetOStream
{
	// Not implemented.
	INetIOStream (const INetIOStream& rStrm);
	INetIOStream& operator= (const INetIOStream& rStrm);

public:
	INetIOStream (ULONG nIBufferSize = 0, ULONG nOBufferSize = 0);
	virtual ~INetIOStream (void);
};

/*=========================================================================
 *
 * INetMessageStream Interface.
 *
 *=======================================================================*/
enum INetMessageStreamState
{
	INETMSG_EOL_BEGIN,
	INETMSG_EOL_DONE,
	INETMSG_EOL_SCR,
	INETMSG_EOL_FCR,
	INETMSG_EOL_FLF,
	INETMSG_EOL_FSP,
	INETMSG_EOL_FESC
};

/*
 * INetMessageIStream (Message Generator) Interface.
 */
class INetMessageIStream : public INetIStream
{
	INetMessage    *pSourceMsg;
	BOOL            bHeaderGenerated;

	ULONG           nBufSiz;
	sal_Char       *pBuffer;
	sal_Char       *pRead;
	sal_Char       *pWrite;

	SvStream       *pMsgStrm;
	SvMemoryStream *pMsgBuffer;
	sal_Char       *pMsgRead;
	sal_Char       *pMsgWrite;

	virtual int GetData (
		sal_Char *pData, ULONG nSize, void *pCtx = NULL);

	// Not implemented.
	INetMessageIStream (const INetMessageIStream& rStrm);
	INetMessageIStream& operator= (const INetMessageIStream& rStrm);

protected:
	virtual int GetMsgLine (
		sal_Char *pData, ULONG nSize, void *pCtx = NULL);

public:
	INetMessageIStream (ULONG nBufferSize = 2048);
	virtual ~INetMessageIStream (void);

	INetMessage *GetSourceMessage (void) const { return pSourceMsg; }
	void SetSourceMessage (INetMessage *pMsg) { pSourceMsg = pMsg; }

	void GenerateHeader (BOOL bGen = TRUE) { bHeaderGenerated = !bGen; }
	BOOL IsHeaderGenerated (void) const { return bHeaderGenerated; }
};

/*
 * INetMessageOStream (Message Parser) Interface.
 */
class INetMessageOStream : public INetOStream
{
	INetMessage            *pTargetMsg;
	BOOL                    bHeaderParsed;

	INetMessageStreamState  eOState;

	SvMemoryStream         *pMsgBuffer;

	virtual int PutData (
		const sal_Char *pData, ULONG nSize, void *pCtx = NULL);

	// Not implemented.
	INetMessageOStream (const INetMessageOStream& rStrm);
	INetMessageOStream& operator= (const INetMessageOStream& rStrm);

protected:
	virtual int PutMsgLine (
		const sal_Char *pData, ULONG nSize, void *pCtx = NULL);

public:
	INetMessageOStream (void);
	virtual ~INetMessageOStream (void);

	INetMessage *GetTargetMessage (void) const { return pTargetMsg; }
	void SetTargetMessage (INetMessage *pMsg) { pTargetMsg = pMsg; }

	void ParseHeader (BOOL bParse = TRUE) { bHeaderParsed = !bParse; }
	BOOL IsHeaderParsed (void) const { return bHeaderParsed; }
};

/*
 * INetMessageIOStream Interface.
 */
class INetMessageIOStream
	: public INetMessageIStream,
	  public INetMessageOStream
{
	// Not implemented.
	INetMessageIOStream (const INetMessageIOStream& rStrm);
	INetMessageIOStream& operator= (const INetMessageIOStream& rStrm);

public:
	INetMessageIOStream (ULONG nBufferSize = 2048);
	virtual ~INetMessageIOStream (void);
};

/*=========================================================================
 *
 * INetMIMEMessageStream Interface.
 *
 *=======================================================================*/
enum INetMessageEncoding
{
	INETMSG_ENCODING_7BIT,
	INETMSG_ENCODING_8BIT,
	INETMSG_ENCODING_BINARY,
	INETMSG_ENCODING_QUOTED,
	INETMSG_ENCODING_BASE64
};

class INetMIMEMessageStream : public INetMessageIOStream
{
	int                    eState;

	ULONG                  nChildIndex;
	INetMIMEMessageStream *pChildStrm;

	INetMessageEncoding    eEncoding;
	INetMessageIStream    *pEncodeStrm;
	INetMessageOStream    *pDecodeStrm;

	SvMemoryStream        *pMsgBuffer;

	static INetMessageEncoding GetMsgEncoding (
		const String& rContentType);

	// Not implemented.
	INetMIMEMessageStream (const INetMIMEMessageStream& rStrm);
	INetMIMEMessageStream& operator= (const INetMIMEMessageStream& rStrm);

protected:
	virtual int GetMsgLine (
		sal_Char *pData, ULONG nSize, void *pCtx = NULL);
	virtual int PutMsgLine (
		const sal_Char *pData, ULONG nSize, void *pCtx = NULL);

public:
	INetMIMEMessageStream (ULONG nBufferSize = 2048);
	virtual ~INetMIMEMessageStream (void);

	void SetSourceMessage (INetMIMEMessage *pMsg)
	{
		INetMessageIStream::SetSourceMessage ((INetMessage *)pMsg);
	}
	INetMIMEMessage *GetSourceMessage (void) const
	{
		return ((INetMIMEMessage *)INetMessageIStream::GetSourceMessage());
	}

	void SetTargetMessage (INetMIMEMessage *pMsg)
	{
		INetMessageOStream::SetTargetMessage ((INetMessage *)pMsg);
	}
	INetMIMEMessage *GetTargetMessage (void) const
	{
		return ((INetMIMEMessage *)INetMessageOStream::GetTargetMessage());
	}
};

/*=========================================================================
 *
 * INetHTTPMessageStream Interface.
 *
 *=======================================================================*/
class INetHTTPMessageStream : public INetMIMEMessageStream
{
	/** Representation.
	*/
	INetMessageStreamState  m_eState;
	INetMessageOStream     *m_pDecodeStrm;

	/** Not implemented.
	*/
	INetHTTPMessageStream (const INetHTTPMessageStream& rStrm);
	INetHTTPMessageStream& operator= (const INetHTTPMessageStream& rStrm);

protected:
	virtual int GetMsgLine (
		sal_Char *pData, ULONG nSize, void *pCtx = NULL);
	virtual int PutMsgLine (
		const sal_Char *pData, ULONG nSize, void *pCtx = NULL);

public:
	INetHTTPMessageStream (ULONG nBufferSize = 2048);
	virtual ~INetHTTPMessageStream (void);

	void SetSourceMessage (INetHTTPMessage *pMsg)
	{
		INetMessageIStream::SetSourceMessage ((INetMessage *)pMsg);
	}
	INetHTTPMessage *GetSourceMessage (void) const
	{
		return ((INetHTTPMessage *)INetMessageIStream::GetSourceMessage());
	}

	void SetTargetMessage (INetHTTPMessage *pMsg)
	{
		INetMessageOStream::SetTargetMessage ((INetMessage *)pMsg);
	}
	INetHTTPMessage *GetTargetMessage (void) const
	{
		return ((INetHTTPMessage *)INetMessageOStream::GetTargetMessage());
	}
};

#endif /* !_TOOLS_INETSTRM_HXX */

