/*************************************************************************
 *
 *  $RCSfile: persbcst.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 17:03:02 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _R_TOOLS_PERSBCST_HXX
#define _R_TOOLS_PERSBCST_HXX

#include "bcst.hxx"

class GenericInformation;
class GenericInformationList;
class InformationClient;

class PersistentInformationBroadcaster : public InformationBroadcaster
{
private:
	GenericInformationList *mpPersistentData;
	InformationClient *mpIClient;

protected:
	virtual void IMessageArrived( const BroadcastMessage &aMsg );

public:
	/** Wird die Instanz zum empfangen in einer Applikation mit UI verwendet, so mu ein
		FullInformationClient bergeben werden.
		Dieser wird Eigentum des PersistentInformationBroadcaster und wird von diesem
		destruiert.

		!! Siehe auch die Informationen unter InformationBroadcaster !!

		PersistentInformationBroadcaster(
				new CommunicationManagerClientViaSocket( TRUE )
				new FullInformationClient( GetBroadcastHost() )
			);
	 **/
	PersistentInformationBroadcaster( CommunicationManager *pManager = NULL, InformationClient *pIClient = NULL );
	virtual ~PersistentInformationBroadcaster();

	void Reconnect( InformationClient *pIClient = NULL );
	GenericInformation* GetPersistentData( BroadcastCategory nType );

	BOOL MakePersistent( const ByteString &aType );
	BOOL MakePersistent( BroadcastCategory nType );
};

#endif
/*************************************************************************

	  Source Code Control System - Header

	  $Header: /cvs/util/tools/inc/persbcst.hxx,v 1.1.1.1 2000/09/18 17:03:02 hr Exp $

	  Source Code Control System - Update

	  $Log: persbcst.hxx,v $
	  Revision 1.1.1.1  2000/09/18 17:03:02  hr
	  initial import
	
	  Revision 1.3  2000/09/18 10:01:07  willem.vandorp
	  OpenOffice header added.
	
	  Revision 1.2  2000/08/15 06:46:42  nf
	  Moved from r_tools
	
	  Revision 1.3  2000/05/23 15:26:02  gh
	  UNICODE changes

	  Revision 1.2  1999/11/18 16:28:48  nf
	  Fixes fuer Reconnect

	  Revision 1.1  1999/09/09 09:14:47  gh
	  BCST Persistent machen

	  Revision 1.9  1999/08/23 09:06:43  gh
	  new: Name2Id

	  Revision 1.8  1999/08/20 13:56:19  nf
	  neu: meherer Links

	  Revision 1.7  1999/08/19 05:34:06  nf
	  BSCHAT

	  Revision 1.6  1999/08/18 10:02:02  nf
	  Neu: BCST_CAT_BSTRIGGER

	  Revision 1.5  1999/08/18 07:27:27  gh
	  Komfortableres Interface

	  Revision 1.4  1999/08/16 16:32:47  gh
	  Broadcast Message mit ChannelType

	  Revision 1.3  1999/08/16 14:11:41  gh
	  Dokumentation angepasst

	  Revision 1.2  1999/08/16 13:22:15  gh
	  Protokoll auf Verwendung nur einer ID umgestellt

	  Revision 1.1  1999/08/09 15:42:29  gh
	  #67835# Broadcaster clients


*************************************************************************/
