/*************************************************************************
 *
 *  $RCSfile: extattr.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 17:03:05 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#define INCL_DOSFILEMGR
#include <svpm.h>

#include <stdlib.h>
#include <string.h>

#ifndef _EXTENDED_ATTRIBUTES_HXX
#include <ExtAttr.hxx>
#endif

#ifndef _DEBUG_HXX
#include <debug.hxx>
#endif


/*********************
 *
 * Data structures
 *
 *********************
 */

typedef struct {
	unsigned short type;
	unsigned short nLen;
	unsigned char  data[1];
} EAHEADER, *PEAHEADER;


/***************************************************************************************
 *
 * EA - Implementation
 *
 ***************************************************************************************
 */

/*------------------------------------------------------------------------------------
 * remove
 *------------------------------------------------------------------------------------
 */

void EA::remove(const String& file, const String& name)
{
	EAOP2 eaop;
	PM_ULONG ulSize;
	
	// GEA2List not needed
	eaop.fpGEA2List = NULL;

	// allocate and fill FEA2List structure
	ulSize = sizeof(FEA2LIST) + name.Len();
	eaop.fpFEA2List = (PFEA2LIST) new PM_BYTE [ulSize];
	eaop.fpFEA2List->cbList = ulSize;
	eaop.fpFEA2List->list[0].oNextEntryOffset = 0L;	 // no more entries;
	eaop.fpFEA2List->list[0].fEA	 = 0;			 // EA is not critical
	eaop.fpFEA2List->list[0].cbName	 = name.Len();
	eaop.fpFEA2List->list[0].cbValue = 0;

	// set name of EA
	strncpy(eaop.fpFEA2List->list[0].szName, (const char *) name, eaop.fpFEA2List->list[0].cbName);
	eaop.fpFEA2List->list[0].szName[eaop.fpFEA2List->list[0].cbName] = '\0';

	// save buffer to disk
	APIRET rc = DosSetPathInfo((const char *) file, FIL_QUERYEASIZE, (PVOID) &eaop, sizeof(EAOP2), DSPI_WRTTHRU );
	
	// release memory
	delete [] eaop.fpFEA2List;
}

/*------------------------------------------------------------------------------------
 * getFrom
 *------------------------------------------------------------------------------------
 */

void EA::getFrom(const String& file, const String& name)
{
	EAOP2 eaop;

	/*
	 *	allocate only one block of memory and handle the two structures yourself
	 */
	static PM_ULONG nfeaSize = 1024;

	// allocate and fill GEA2List structure
	PM_ULONG ulSize = sizeof(GEA2LIST) + name.Len();

	eaop.fpGEA2List = (PGEA2LIST) new PM_BYTE [ulSize + nfeaSize];
	eaop.fpGEA2List->cbList = ulSize;
	eaop.fpGEA2List->list[0].oNextEntryOffset = 0L;	 // no more entries;
	eaop.fpGEA2List->list[0].cbName	 = name.Len();

	strncpy(eaop.fpGEA2List->list[0].szName, (const char *) name, eaop.fpGEA2List->list[0].cbName);
	eaop.fpGEA2List->list[0].szName[eaop.fpGEA2List->list[0].cbName] = '\0';

	// allocate and fill FEA2List structure
	eaop.fpFEA2List = (PFEA2LIST) ((PBYTE) eaop.fpGEA2List + ulSize);
	eaop.fpFEA2List->cbList = nfeaSize;

	// query EA from file
	APIRET rc = DosQueryPathInfo((const char *) file, FIL_QUERYEASFROMLIST,(PVOID) &eaop, sizeof(EAOP2));

	if(!rc)
	{
		PM_BYTE *pMem = (PM_BYTE *) &eaop.fpFEA2List->list[1] + eaop.fpFEA2List->list[0].cbName;
		PM_BYTE *pEnd = pMem + eaop.fpFEA2List->list[0].cbValue;

		if(eaop.fpFEA2List->list[0].cbValue)
		{
			PM_USHORT *pId	= (PM_USHORT *) pMem;

			if(*pId == attributeId())
			{
				pMem = (PM_BYTE *) (pId + 1);
				readFrom(pMem, pEnd - pMem);
			}
		
			// check default value of multi-value-single-type EA
			else if((*pId == EAT_MVST) && (pId[2] >= 1) && (pId[3] == attributeId()))
			{
				pMem = (PM_BYTE *) (pId + 4);
				readFrom(pMem, pEnd - pMem);
			}
		
			// check for matching types in multi-value-multi-type EA
			else if((*pId == EAT_MVMT) && (pId[2] >= 1))
			{
				// reset memory stream
				pMem  = (PM_BYTE *) (pId + 3);

				// NOTE: this algorithm will fail on attributes that are not length preceeded !!!!
				for(PM_USHORT n = pId[2]; n > 0 && pMem < pEnd; n--)
				{
					pId = (PM_USHORT *) pMem;

					// found type matching EA
					if(*pId == attributeId())
					{
						pMem = (PM_BYTE *) (pId + 1);
						readFrom(pMem, pEnd - pMem);
						break;
					}

					pMem = (PM_BYTE *) (pId + 2) + pId[1];
				}
			}
		}
	}

	// release memory
	delete [] eaop.fpGEA2List;
}

/*------------------------------------------------------------------------------------
 * storeTo
 *------------------------------------------------------------------------------------
 */

void EA::storeTo(const String& file, const String& name)
{
	EAOP2 eaop;
	PM_ULONG  ulSize;
    PM_USHORT nDataSize;

	// GEA2List not needed
	eaop.fpGEA2List = NULL;

	// query size of data
	nDataSize = writeTo(NULL, 0);

	// allocate and fill FEA2List structure
	ulSize = sizeof(FEA2LIST) + name.Len() + nDataSize + sizeof(PM_USHORT);
	eaop.fpFEA2List = (PFEA2LIST) new PM_BYTE [ulSize];
	eaop.fpFEA2List->cbList = ulSize;
	eaop.fpFEA2List->list[0].oNextEntryOffset = 0L;	 // no more entries;
	eaop.fpFEA2List->list[0].fEA	 = 0;			 // EA is not critical
	eaop.fpFEA2List->list[0].cbName	 = name.Len();
	eaop.fpFEA2List->list[0].cbValue = nDataSize + sizeof(PM_USHORT);

	// set name of EA
	strncpy(eaop.fpFEA2List->list[0].szName, (const char *) name, eaop.fpFEA2List->list[0].cbName);
	eaop.fpFEA2List->list[0].szName[eaop.fpFEA2List->list[0].cbName] = '\0';

	// fill in EA data
	PM_USHORT *pId	= (PM_USHORT *) ((PM_BYTE *) &eaop.fpFEA2List->list[1] + eaop.fpFEA2List->list[0].cbName);
	*pId = attributeId();

	writeTo(pId + 1, nDataSize);

	// save buffer to disk
	APIRET rc = DosSetPathInfo((const char *) file, FIL_QUERYEASIZE, (PVOID) &eaop, sizeof(EAOP2), DSPI_WRTTHRU );
	
	// release memory
	delete [] eaop.fpFEA2List;
}

/*------------------------------------------------------------------------------------
 * queryList
 *------------------------------------------------------------------------------------
 */

PM_USHORT EA::queryList(const String& file, NameSet& aNameSet)
{
	PM_ULONG ulEntry =	0;
	PM_ULONG ulCount =	1;
	PM_BYTE	 szBuffer[1024];

	// Due to a bug in OS/2 Warp that causes the stack to be overwritten when
	// DosEnumAttributes() fails with rc == 32 and was called ulCount == -1,
	// query attributes step by step
	while(!DosEnumAttribute(ENUMEA_REFTYPE_PATH, (PVOID) ((const char *) file), ulEntry + 1,
							szBuffer, sizeof(szBuffer), &ulCount, ENUMEA_LEVEL_NO_VALUE)
		 )
	{
		// break if no more items left
		if(ulCount == 0)
			break;

		// add received value to list
		aNameSet[String(((PDENA2) &szBuffer)->szName)] = ((PDENA2) &szBuffer)->fEA;

		// prepare for the next try
		ulEntry += ulCount;
		ulCount = 1;
	}

	return ulEntry;
}

/*------------------------------------------------------------------------------------
 * queryName
 *------------------------------------------------------------------------------------
 */

BOOL EA::queryName(const String& file, const String& name)
{
	PM_ULONG ulEntry =	0;
	PM_ULONG ulCount =	1;
	PM_BYTE	 szBuffer[1024];

	// Due to a bug in OS/2 Warp that causes the stack to be overwritten when
	// DosEnumAttributes() fails with rc == 32 and was called ulCount == -1,
	// query attributes step by step
	while(!DosEnumAttribute(ENUMEA_REFTYPE_PATH, (PVOID) ((const char *) file), ulEntry + 1,
							szBuffer, sizeof(szBuffer), &ulCount, ENUMEA_LEVEL_NO_VALUE)
		 )
	{
		// break if no more items left
		if(ulCount == 0)
			return FALSE;

		// compare names
		if(name.Compare(((PDENA2) &szBuffer)->szName) == COMPARE_EQUAL)
			return TRUE;

		// prepare for the next try
		ulEntry += ulCount;
		ulCount = 1;
	}

	return FALSE;
}

/***************************************************************************************
 *
 * StringEA - Implementation
 *
 ***************************************************************************************
 */

PM_USHORT StringEA::readFrom(PVOID ptr, PM_USHORT nmax)
{
	DBG_ASSERT(ptr, "StringEA::readFrom zero pointer not allowed.\n");

	PM_USHORT * pSize = (PM_USHORT *) ptr;
	PM_USHORT nEASize = sizeof(PM_USHORT) + *pSize;

	// later: throw exception if data corrupted
	if(nEASize <= nmax)
	{
		// delete old buffer and allocate new one
		char * cp = AllocStrBuf(*pSize);

		if(cp)
		{
			// terminating '\0' already set by AllocStrBuf !!
			strncpy(cp, (const char *) (pSize + 1), *pSize);

			return nEASize;
		}
	}

	return 0;
}

PM_USHORT StringEA::writeTo(PVOID ptr, PM_USHORT nmax)
{
	PM_USHORT nEASize = Len() + sizeof(PM_USHORT);

	if(ptr)
	{
		PM_USHORT * pSize = (PM_USHORT *) ptr;

		// check if buffer is big enough to hold the data
		if(nmax >= nEASize)
		{
			// copy data to buffer
			*pSize = Len();
			strncpy((char *) (pSize + 1), GetStr(), *pSize);

			return nEASize;
		}

		// else throw exception later
		return 0;
	}

	// just return buffer size needed
	else
	{
		return nEASize;
	}
}

/***************************************************************************************
 *
 * UrlEA - Implementation
 *
 ***************************************************************************************
 */

PM_USHORT UrlEA::readFrom(PVOID ptr, PM_USHORT nmax)
{
	DBG_ASSERT(ptr, "UrlEA::readFrom zero pointer not allowed.\n");

	// later: throw exception if data corrupted
    if(nmax > 0x30)
    {
        PSZ pUrl = (PSZ) ptr + 0x30;
        PM_USHORT nLen = strlen(pUrl);

		// delete old buffer and allocate new one
		char * cp = AllocStrBuf(nLen);

		if(cp)
		{
			// terminating '\0' already set by AllocStrBuf !!
			strncpy(cp, pUrl, nLen);

			return 0x30 + nLen;
		}
    }

	return 0;
}

PM_USHORT UrlEA::writeTo(PVOID ptr, PM_USHORT nmax)
{
	PM_USHORT nEASize = Len() + sizeof(PM_USHORT);

	if(ptr)
	{
		PM_USHORT * pSize = (PM_USHORT *) ptr;

		// check if buffer is big enough to hold the data
		if(nmax >= nEASize)
		{
			// copy data to buffer
			*pSize = Len();
			strncpy((char *) (pSize + 1), GetStr(), *pSize);

			return nEASize;
		}

		// else throw exception later
		return 0;
	}

	// just return buffer size needed
	else
	{
		return nEASize;
	}
}
