/*************************************************************************
 *
 *  $RCSfile: acceptthread.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: obo $ $Date: 2000/12/05 15:40:33 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _UCB_MAIN_ACCEPTTHREAD_HXX_
#define _UCB_MAIN_ACCEPTTHREAD_HXX_

#ifndef _COM_SUN_STAR_UNO_REFERENCE_HXX_
#include <com/sun/star/uno/Reference.hxx>
#endif
#ifndef _CPPUHELPER_WEAK_HXX_
#include <cppuhelper/weak.hxx>
#endif
#ifndef _RTL_USTRING_HXX_
#include <rtl/ustring.hxx>
#endif
#ifndef _VOS_DIAGNOSE_H_
#include <vos/diagnose.hxx>
#endif
#ifndef _VOS_THREAD_HXX_
#include <vos/thread.hxx>
#endif

namespace com { namespace sun { namespace star {
	namespace bridge
	{
		class XBridgeFactory;
		class XInstanceProvider;
	}
	namespace lang { class XMultiServiceFactory; }
} } }

//============================================================================
namespace ucb_main {

class AcceptThread: public cppu::OWeakObject,
					public vos::OThread
{
public:
	inline
	AcceptThread( 
		com::sun::star::uno::Reference<
		        com::sun::star::lang::XMultiServiceFactory > const &
		    rTheServiceFactory,
		com::sun::star::uno::Reference< 
		        com::sun::star::bridge::XBridgeFactory > const &
		    rTheBridgeFactory,
		com::sun::star::uno::Reference< 
		        com::sun::star::bridge::XInstanceProvider > const &
		    rTheInstanceProvider,
		rtl::OUString const & rTheConnection,
		rtl::OUString const & rTheProtocol);

	//========================================================================
	// both cppu::OWeakObject and vos::OThread have new and delete:

	static inline void * operator new(size_t nSize) throw ()
	{ return OWeakObject::operator new(nSize); }

	static inline void operator delete(void * pMem) throw ()
	{ OWeakObject::operator delete(pMem); }

protected:
	inline
	com::sun::star::uno::Reference<
	        com::sun::star::lang::XMultiServiceFactory >
	    getServiceFactory() const
	{ return m_xServiceFactory; }

	inline
	com::sun::star::uno::Reference<
			com::sun::star::bridge::XBridgeFactory >
		getBridgeFactory() const
	{ return m_xBridgeFactory; }

	inline
	com::sun::star::uno::Reference<
	        com::sun::star::bridge::XInstanceProvider >
	    getInstanceProvider() const
	{ return m_xInstanceProvider; }

	inline rtl::OUString getConnection() const { return m_aConnection; }

	inline rtl::OUString getProtocol() const { return m_aProtocol; }

private:
	com::sun::star::uno::Reference<
	        com::sun::star::lang::XMultiServiceFactory >
	    m_xServiceFactory;
	com::sun::star::uno::Reference<
			com::sun::star::bridge::XBridgeFactory >
		m_xBridgeFactory;
	com::sun::star::uno::Reference<
	        com::sun::star::bridge::XInstanceProvider >
	    m_xInstanceProvider;
	rtl::OUString m_aConnection;
	rtl::OUString m_aProtocol;
};

inline
AcceptThread::AcceptThread( 
	com::sun::star::uno::Reference<
	        com::sun::star::lang::XMultiServiceFactory > const &
	    rTheServiceFactory,
	com::sun::star::uno::Reference< 
	        com::sun::star::bridge::XBridgeFactory > const &
		rTheBridgeFactory,
	com::sun::star::uno::Reference< 
	        com::sun::star::bridge::XInstanceProvider > const &
	    rTheInstanceProvider,
	rtl::OUString const & rTheConnection,
	rtl::OUString const & rTheProtocol):
	m_xServiceFactory(rTheServiceFactory),
	m_xBridgeFactory(rTheBridgeFactory),
	m_xInstanceProvider(rTheInstanceProvider),
	m_aConnection(rTheConnection),
	m_aProtocol(rTheProtocol)
{
	VOS_ENSURE(m_xServiceFactory.is()
			   && m_xBridgeFactory.is()
			   && m_xInstanceProvider.is(),
			   "ucb_main::AcceptThread::AcceptThread(): Null service");
}

}

#endif //  _UCB_MAIN_ACCEPTTHREAD_HXX_
