/*************************************************************************
 *
 *  $RCSfile: ucbdistributor.hxx,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: sb $ $Date: 2001/07/16 09:48:39 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _UCB_MAIN_UCBDISTRIBUTOR_HXX_
#define _UCB_MAIN_UCBDISTRIBUTOR_HXX_

#include <hash_map>
#include <vector>

#ifndef _COM_SUN_STAR_LANG_XEVENTLISTENER_HPP_
#include <com/sun/star/lang/XEventListener.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XSERVICEINFO_HPP_
#include <com/sun/star/lang/XServiceInfo.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XTYPEPROVIDER_HPP_
#include <com/sun/star/lang/XTypeProvider.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_XREMOTECONTENTPROVIDERCONNECTIONCONTROL_HPP_
#include <com/sun/star/ucb/XRemoteContentProviderConnectionControl.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_XREMOTECONTENTPROVIDERDISTRIBUTOR_HPP_
#include <com/sun/star/ucb/XRemoteContentProviderDistributor.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_XREMOTECONTENTPROVIDERDONELISTENER_HPP_
#include <com/sun/star/ucb/XRemoteContentProviderDoneListener.hpp>
#endif
#ifndef _COM_SUN_STAR_UNO_REFERENCE_HXX_
#include <com/sun/star/uno/Reference.hxx>
#endif
#ifndef _CPPUHELPER_WEAK_HXX_
#include <cppuhelper/weak.hxx>
#endif
#ifndef _RTL_REF_HXX_
#include <rtl/ref.hxx>
#endif
#ifndef _SAL_TYPES_H_
#include <sal/types.h>
#endif
#ifndef _VOS_CONDITN_HXX_
#include <vos/conditn.hxx>
#endif
#ifndef _VOS_MUTEX_HXX_
#include <vos/mutex.hxx>
#endif

#ifndef _UCB_MAIN_MACHINE_HXX_
#include "machine.hxx"
#endif

namespace com { namespace sun { namespace star {
	namespace bridge { class XBridge; }
	namespace lang { class XMultiServiceFactory; }
	namespace ucb { class XRemoteContentProviderAcceptor; }
} } }
namespace rtl
{
    class OUString;
    struct OUStringHash;
}

//============================================================================
namespace ucb_main {

class UcbDistributor:
		public cppu::OWeakObject,
		public com::sun::star::lang::XServiceInfo,
		public com::sun::star::lang::XTypeProvider,
		public com::sun::star::ucb::XRemoteContentProviderDistributor,
		public com::sun::star::ucb::XRemoteContentProviderDoneListener,
		public com::sun::star::ucb::XRemoteContentProviderConnectionControl,
		public com::sun::star::lang::XEventListener,
		public Machine
{
public:
    class KeepAliveThread;

	UcbDistributor(
		com::sun::star::uno::Reference<
		        com::sun::star::lang::XMultiServiceFactory > const &
		    rTheFactory,
		MachineControl * pControl);

    virtual UcbDistributor::~UcbDistributor();

	//========================================================================
	// com::sun::star::uno::XInterface:

	virtual com::sun::star::uno::Any SAL_CALL
	queryInterface(com::sun::star::uno::Type const & rType)
		throw (com::sun::star::uno::RuntimeException);

    virtual void SAL_CALL acquire() throw ();

    virtual void SAL_CALL release() throw ();

	//========================================================================
	// com::sun::star::lang::XServiceInfo:

    virtual rtl::OUString SAL_CALL getImplementationName()
		throw (com::sun::star::uno::RuntimeException);

    virtual sal_Bool SAL_CALL supportsService(rtl::OUString const &
											      rServiceName)
		throw (com::sun::star::uno::RuntimeException);

    virtual com::sun::star::uno::Sequence< rtl::OUString > SAL_CALL
	getSupportedServiceNames() throw (com::sun::star::uno::RuntimeException);

	//========================================================================
	// com::sun::star::lang::XTypeProvider:

    virtual
	com::sun::star::uno::Sequence< com::sun::star::uno::Type > SAL_CALL
	getTypes() throw (com::sun::star::uno::RuntimeException);

    virtual com::sun::star::uno::Sequence< sal_Int8 > SAL_CALL
	getImplementationId() throw (com::sun::star::uno::RuntimeException);

	//========================================================================
	// com::sun::star::ucb::XRemoteContentProviderDistributor:

	virtual sal_Bool SAL_CALL
	connectToRemoteAcceptor(rtl::OUString const & rUrl,
							rtl::OUString const & rIdentifier)
		throw (com::sun::star::connection::NoConnectException,
			   com::sun::star::connection::ConnectionSetupException,
			   com::sun::star::lang::IllegalArgumentException,
			   com::sun::star::uno::RuntimeException);

	virtual sal_Bool SAL_CALL
	disconnectFromRemoteAcceptor(rtl::OUString const & rUrl)
		throw (com::sun::star::uno::RuntimeException);

	virtual void SAL_CALL
	disconnectFromAll()
		throw (com::sun::star::uno::RuntimeException);

	//========================================================================
	// com::sun::star::ucb::XRemoteContentProviderDoneListener:

	virtual void SAL_CALL
	doneWithRemoteContentProviders(
		com::sun::star::uno::Reference<
		        com::sun::star::ucb::XRemoteContentProviderAcceptor > const &
		    rAcceptor)
		throw (com::sun::star::uno::RuntimeException);

	//========================================================================
	// com::sun::star::ucb::XRemoteContentProviderConnectionControl:

    virtual void SAL_CALL
    enableConnectionControl(
        com::sun::star::uno::Reference<
                com::sun::star::ucb::XRemoteContentProviderAcceptor > const &
            rAcceptor,
        com::sun::star::uno::Reference<
                com::sun::star::uno::XInterface > const &
            rToken)
        throw (com::sun::star::uno::RuntimeException);

	//========================================================================
	// com::sun::star::lang::XEventListener:

	virtual void SAL_CALL
	disposing(com::sun::star::lang::EventObject const & rSource)
		throw (com::sun::star::uno::RuntimeException);

	//========================================================================
	// ucb_main::Machine:

	virtual void tryStop();

	virtual void doStop(bool bStop);

	//========================================================================
	// Service Implementation:

	static bool
	registerAtServiceFactory(
		com::sun::star::uno::Reference<
		        com::sun::star::lang::XMultiServiceFactory > const &
		    rServiceFactory,
		MachineControl * pControl);

private:
    struct Data
    {
        com::sun::star::uno::Reference< com::sun::star::bridge::XBridge >
            m_xBridge;
        com::sun::star::uno::Reference<
                com::sun::star::ucb::XRemoteContentProviderAcceptor >
            m_xAcceptor;
        com::sun::star::uno::Reference< com::sun::star::uno::XInterface >
            m_xConnectionControlToken;
        rtl::OUString m_aIdentifier;
        rtl::Reference< KeepAliveThread > m_xThread;

        Data(com::sun::star::uno::Reference<
                     com::sun::star::bridge::XBridge > const &
                 rTheBridge,
             com::sun::star::uno::Reference<
                 com::sun::star::ucb::XRemoteContentProviderAcceptor > const &
                 rTheAcceptor,
             rtl::OUString const & rTheIdentifier);

        ~Data();
    };

	enum State
	{
		STATE_IDLE,
		STATE_CONNECTING,
		STATE_TRY_STOP,
		STATE_STOPPED
	};

	typedef std::hash_map< rtl::OUString, Data, rtl::OUStringHash > HashMap;

	typedef std::vector< com::sun::star::uno::Reference<
	                         com::sun::star::bridge::XBridge > >
		BridgeList;

    struct Control
    {
        com::sun::star::uno::Reference<
                com::sun::star::ucb::XRemoteContentProviderAcceptor >
            m_xAcceptor;
        com::sun::star::uno::Reference< com::sun::star::uno::XInterface >
            m_xToken;

        inline
        Control(
            com::sun::star::uno::Reference<
                 com::sun::star::ucb::XRemoteContentProviderAcceptor > const &
                rAcceptor,
            com::sun::star::uno::Reference<
                    com::sun::star::uno::XInterface > const &
                rToken):
            m_xAcceptor(rAcceptor), m_xToken(rToken) {}
    };

    typedef std::vector< Control > ControlList;

	HashMap m_aMap;
	BridgeList m_aDisposed;
    ControlList m_aControls;
	vos::OMutex m_aMapMutex;
	vos::OMutex m_aStateMutex;
	vos::OMutex m_aDelayedMutex;
	vos::OCondition m_aDoStop;
	com::sun::star::uno::Reference<
	        com::sun::star::lang::XMultiServiceFactory >
	    m_xFactory;
	State m_eState;
	bool m_bConnecting;

	bool
	doConnect(rtl::OUString const & rUrl, rtl::OUString const & rIdentifier)
		throw (com::sun::star::connection::NoConnectException,
			   com::sun::star::connection::ConnectionSetupException,
			   com::sun::star::lang::IllegalArgumentException,
			   com::sun::star::uno::RuntimeException);

	void finishDelayed() throw ();

	bool checkTryStop(State eNewState) throw ();
};

}

#endif // _UCB_MAIN_UCBDISTRIBUTOR_HXX_
