/*************************************************************************
 *
 *  $RCSfile: rapofflinestorage.cxx,v $
 *
 *  $Revision: 1.1 $
 *
 *  last change: $Author: sb $ $Date: 2001/06/07 12:58:11 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef INCLUDED_UCB_RAPOFFLINESTORAGE_HXX
#include "rapofflinestorage.hxx"
#endif

#ifndef INCLUDED_UCB_RAPOFFLINESTORAGEERROR_HXX
#include "rapofflinestorageerror.hxx"
#endif
#ifndef INCLUDED_UCB_RAPOFFLINESTORAGEIMPL_HXX
#include "rapofflinestorageimpl.hxx"
#endif
#ifndef INCLUDED_UCB_RAPOFFLINESTORAGENODE_HXX
#include "rapofflinestoragenode.hxx"
#endif

#ifndef _COM_SUN_STAR_BEANS_PROPERTYVALUE_HPP_
#include "com/sun/star/beans/PropertyValue.hpp"
#endif
#ifndef _COM_SUN_STAR_CONTAINER_XHIERARCHICALNAMEACCESS_HPP_
#include "com/sun/star/container/XHierarchicalNameAccess.hpp"
#endif
#ifndef _COM_SUN_STAR_FRAME_XCONFIGMANAGER_HPP_
#include "com/sun/star/frame/XConfigManager.hpp"
#endif
#ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include "com/sun/star/lang/XMultiServiceFactory.hpp"
#endif
#ifndef _COM_SUN_STAR_UNO_ANY_HXX_
#include "com/sun/star/uno/Any.hxx"
#endif
#ifndef _COM_SUN_STAR_UNO_SEQUENCE_HXX_
#include "com/sun/star/uno/Sequence.hxx"
#endif
#ifndef _RTL_USTRING_HXX_
#include "rtl/ustring.hxx"
#endif
#ifndef _SAL_TYPES_H_
#include "sal/types.h"
#endif
#ifndef _STORE_STORE_HXX_
#include "store/store.hxx"
#endif

using namespace com::sun;
using ucprmt::offline::Storage;
using ucprmt::offline::StorageError;
using ucprmt::offline::StorageImpl;
using ucprmt::offline::StorageNodeContainer;

namespace {

rtl::OUString
getStorageFilename(
    star::uno::Reference< star::lang::XMultiServiceFactory > const &
        rServiceFactory)
{
    rtl::OUString aFilename; 
    try
    {
        star::uno::Reference< star::lang::XMultiServiceFactory > xProvider;
        if (rServiceFactory.is())
        {
            star::uno::Sequence< star::uno::Any > aArguments(1);
            aArguments[0]
                <<= star::beans::PropertyValue(
                        rtl::OUString(RTL_CONSTASCII_USTRINGPARAM(
                                          "servertype")),
                        -1,
                        star::uno::makeAny(rtl::OUString(
                                               RTL_CONSTASCII_USTRINGPARAM(
                                                   "plugin"))),
                        star::beans::PropertyState_DIRECT_VALUE);
            xProvider
                = star::uno::Reference< star::lang::XMultiServiceFactory >(
                      rServiceFactory->
                          createInstanceWithArguments(
                              rtl::OUString(
                                  RTL_CONSTASCII_USTRINGPARAM(
                         "com.sun.star.configuration.ConfigurationProvider")),
                              aArguments),
                      star::uno::UNO_QUERY);
        }

        star::uno::Reference< star::container::XHierarchicalNameAccess >
            xAccess;
        if (xProvider.is())
        {
            star::uno::Sequence< star::uno::Any > aArguments(1);
            aArguments[0]
                <<= rtl::OUString(RTL_CONSTASCII_USTRINGPARAM(
                                      "org.openoffice.Office.Common"));
            xAccess
                = star::uno::Reference<
                          star::container::XHierarchicalNameAccess >(
                      xProvider->
                          createInstanceWithArguments(
                              rtl::OUString(
                                  RTL_CONSTASCII_USTRINGPARAM(
                           "com.sun.star.configuration.ConfigurationAccess")),
                              aArguments),
                      star::uno::UNO_QUERY);
        }

        rtl::OUString aValue;
        if (xAccess.is())
            xAccess->getByHierarchicalName(rtl::OUString(
                                               RTL_CONSTASCII_USTRINGPARAM(
                                                   "Path/Current/Storage")))
                >>= aValue;

        star::uno::Reference< star::frame::XConfigManager > xManager;
        if (rServiceFactory.is())
            xManager
                = star::uno::Reference< star::frame::XConfigManager >(
                      rServiceFactory->
                          createInstance(
                              rtl::OUString(
                                  RTL_CONSTASCII_USTRINGPARAM(
                                "com.sun.star.config.SpecialConfigManager"))),
                      star::uno::UNO_QUERY);

        if (xManager.is())
            aFilename = xManager->substituteVariables(aValue);

        if (aFilename.getLength() > 0)
        {
            if (aFilename[aFilename.getLength() - 1] != '/')
                aFilename += rtl::OUString(RTL_CONSTASCII_USTRINGPARAM("/"));
            aFilename
                += rtl::OUString(RTL_CONSTASCII_USTRINGPARAM("rapoffln.stg"));
        }
    }
    catch (star::uno::Exception &)
    {
        //TODO!
        OSL_ASSERT(false);
    }
    return aFilename;
}

}

Storage::~Storage() SAL_THROW(())
{}

Storage::Storage(
    star::uno::Reference< star::lang::XMultiServiceFactory > const &
        rServiceFactory)
    SAL_THROW((StorageError)):
    m_xImpl(new StorageImpl(getStorageFilename(rServiceFactory))),
    m_xNodes(new StorageNodeContainer(m_xImpl))
{
    //TODO! Remove StorageImpl's fillWithDefaults:
    if (m_xImpl->createFile())
    {
        setOffline(true);

        rtl::OUString aPath(RTL_CONSTASCII_USTRINGPARAM("/"));
        rtl::OUString aName;
        store::OStoreStream aStream;
        star::uno::Sequence< rtl::OUString > aChildren;
        sal_uInt32 nDone;

        aChildren.realloc(2);
        aChildren[0] = rtl::OUString(RTL_CONSTASCII_USTRINGPARAM(
                                         "file:///user/work/sub1"));
        aChildren[1] = rtl::OUString(RTL_CONSTASCII_USTRINGPARAM(
                                         "file:///user/work/sub2"));
        m_xNodes->
            insert(
                m_xNodes->
                    create(
                        aChildren,
                        rtl::OUString(),
                        rtl::OUString(
                            RTL_CONSTASCII_USTRINGPARAM(
                               "application/vnd.sun.staroffice.fsys-folder")),
                        rtl::OUString(),
                        star::util::DateTime(0, 0, 0, 12, 23, 3, 2001),
                        true,
                        false,
                        false),
                rtl::OUString(RTL_CONSTASCII_USTRINGPARAM(
                                  "file:///user/work")),
                false);

        aChildren.realloc(1);
        aChildren[0] = rtl::OUString(RTL_CONSTASCII_USTRINGPARAM(
                                         "file:///user/work/sub1/test.txt"));
        m_xNodes->
            insert(
                m_xNodes->
                    create(
                        aChildren,
                        rtl::OUString(RTL_CONSTASCII_USTRINGPARAM(
                                          "file:///user/work")),
                        rtl::OUString(
                            RTL_CONSTASCII_USTRINGPARAM(
                               "application/vnd.sun.staroffice.fsys-folder")),
                        rtl::OUString(RTL_CONSTASCII_USTRINGPARAM("sub1")),
                        star::util::DateTime(0, 0, 0, 12, 23, 3, 2001),
                        true,
                        false,
                        false),
                rtl::OUString(RTL_CONSTASCII_USTRINGPARAM(
                                  "file:///user/work/sub1")),
                false);

        aChildren.realloc(0);
        m_xNodes->
            insert(
                m_xNodes->
                    create(
                        aChildren,
                        rtl::OUString(RTL_CONSTASCII_USTRINGPARAM(
                                          "file:///user/work/sub1")),
                        rtl::OUString(
                            RTL_CONSTASCII_USTRINGPARAM(
                                "application/vnd.sun.staroffice.fsys-file")),
                        rtl::OUString(RTL_CONSTASCII_USTRINGPARAM(
                                          "test.txt")),
                        star::util::DateTime(0, 0, 0, 12, 23, 3, 2001),
                        false,
                        true,
                        false),
                rtl::OUString(RTL_CONSTASCII_USTRINGPARAM(
                                  "file:///user/work/sub1/test.txt")),
                false);
        aName = rtl::OUString(RTL_CONSTASCII_USTRINGPARAM(
                                  "@S:file:///user/work/sub1/test.txt"));
        aStream.create(m_xImpl->getFile(), aPath, aName, store_AccessCreate);
        aStream.
            create(m_xImpl->getFile(), aPath, aName, store_AccessReadWrite);
        aStream.writeAt(0,
                        RTL_CONSTASCII_STRINGPARAM("Just a little test..."),
                        nDone);

        aChildren.realloc(0);
        m_xNodes->
            insert(
                m_xNodes->
                    create(
                        aChildren,
                        rtl::OUString(RTL_CONSTASCII_USTRINGPARAM(
                                          "file:///user/work")),
                        rtl::OUString(
                            RTL_CONSTASCII_USTRINGPARAM(
                               "application/vnd.sun.staroffice.fsys-folder")),
                        rtl::OUString(RTL_CONSTASCII_USTRINGPARAM("sub2")),
                        star::util::DateTime(0, 0, 0, 12, 23, 3, 2001),
                        true,
                        false,
                        false),
                rtl::OUString(RTL_CONSTASCII_USTRINGPARAM(
                                  "file:///user/work/sub2")),
                false);
    }
}

bool Storage::isOffline() SAL_THROW((StorageError))
{
    sal_uInt32 nAttrib = 0;
    storeError eError
        = m_xImpl->
              getFile().
                  attrib(rtl::OUString(RTL_CONSTASCII_USTRINGPARAM("/")),
                         rtl::OUString(RTL_CONSTASCII_USTRINGPARAM("@DATA")),
                         0,
                         0,
                         nAttrib);
    if (eError != store_E_None && eError != store_E_NotExists)
        throw StorageError(eError);
    return (nAttrib & 1) != 0;
}

void Storage::setOffline(bool bOffline) SAL_THROW((StorageError))
{
    rtl::OUString aPath(RTL_CONSTASCII_USTRINGPARAM("/"));
    rtl::OUString aName(RTL_CONSTASCII_USTRINGPARAM("@DATA"));
    for (bool bFirst = true;; bFirst = false)
    {
        storeError eError = m_xImpl->getFile().attrib(aPath,
                                                      aName,
                                                      bOffline ? 0 : 1,
                                                      bOffline ? 1 : 0);
        if (eError == store_E_None)
            break;
        if (eError == store_E_NotExists && bFirst)
            eError = store::OStoreStream().create(m_xImpl->getFile(),
                                                  aPath,
                                                  aName,
                                                  store_AccessCreate);
        if (eError != store_E_None)
            throw StorageError(eError);
    }
}

rtl::Reference< StorageNodeContainer > Storage::getNodes()
{
    return m_xNodes;
}
