/*************************************************************************
 *
 *  $RCSfile: NeonPUTFile.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: kso $ $Date: 2001/06/27 08:57:37 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#ifdef WIN32
#include <io.h>
#endif
#ifdef UNX
#include <unistd.h>
#endif

#ifndef _COM_SUN_STAR_IO_XINPUTSTREAM_HPP_
#include <com/sun/star/io/XInputStream.hpp>
#endif

#ifndef _NEONPUTFILE_HXX_
#include "NeonPUTFile.hxx"
#endif

#define READ_BUFFER_SIZE 8192

using namespace com::sun::star::uno;
using namespace com::sun::star::io;
using namespace webdav_ucp;

// -------------------------------------------------------------------
// Constructor
// -------------------------------------------------------------------
NeonPUTFile::NeonPUTFile( const Reference< XInputStream > & inInputStream )
    throw ( DAVException )
{
	mFileName = rtl::OString( tmpnam( NULL ) );

#ifdef WIN32
	FILE * theFILE = fopen( mFileName.getStr(), "wb" );
#else
	int theFD = open( mFileName.getStr(), O_RDWR | O_CREAT, S_IRUSR );
	if ( theFD == -1 )
        throw DAVException( DAVException::DAV_FILE_OPEN,
                            rtl::OStringToOUString( mFileName,
                                                    RTL_TEXTENCODING_UTF8 ) );

	FILE * theFILE = fdopen( theFD, "w" );
#endif

	if ( theFILE == NULL )
        throw DAVException( DAVException::DAV_FILE_OPEN,
                            rtl::OStringToOUString( mFileName,
                                                    RTL_TEXTENCODING_UTF8 ) );

	Sequence< sal_Int8 > theData( READ_BUFFER_SIZE );
	sal_Int32			 theByteCount = 0;

	//jfl : for empty document, the client provides a null stream
	if (inInputStream.is())
	{
		while ( ( theByteCount =
		      		inInputStream->readBytes(
						theData, READ_BUFFER_SIZE ) ) > 0 )
	    {
			if ( fwrite( theData.getConstArray(), 1, theByteCount, theFILE )
					!= theByteCount )
                throw DAVException( DAVException::DAV_FILE_WRITE,
                                    rtl::OStringToOUString(
                                        mFileName,
                                        RTL_TEXTENCODING_UTF8 ) );
		}
	}
	fclose( theFILE );

	// Neon expects the file to be open
#ifdef WIN32
	if ( ( mFILE = fopen( mFileName.getStr(), "rb" ) ) == NULL )
        throw DAVException( DAVException::DAV_FILE_OPEN,
                            rtl::OStringToOUString( mFileName,
                                                    RTL_TEXTENCODING_UTF8 ) );
#else
	if ( ( mFILE = fopen( mFileName.getStr(), "r" ) ) == NULL )
        throw DAVException( DAVException::DAV_FILE_OPEN,
                            rtl::OStringToOUString( mFileName,
                                                    RTL_TEXTENCODING_UTF8 ) );
#endif
}

// -------------------------------------------------------------------
// Destructor
// -------------------------------------------------------------------
NeonPUTFile::~NeonPUTFile( )
{
    if ( mFILE )
        fclose( mFILE );
}

// -------------------------------------------------------------------
// Remove
// -------------------------------------------------------------------
void NeonPUTFile::Remove( void )
{
	if ( mFILE != NULL )
	{
		fclose( mFILE );
        mFILE = 0;
		remove( mFileName.getStr() );
	}
}
