/*************************************************************************
 *
 *  $RCSfile: accessor.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: np $ $Date: 2002/03/22 12:42:55 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef UDM_ACCESSOR_HXX
#define UDM_ACCESSOR_HXX



// USED SERVICES
	// BASE CLASSES
#include <udm/data.hxx>
	// COMPONENTS
	// PARAMETERS
#include <cosv/template/tplutil.hxx>

namespace udm
{

template <class REALTYPE>
class Accessor : public Data
{
  public:
    typedef Accessor<REALTYPE>  self;
    typedef DYN self * (*connect_method)( REALTYPE & io_data );

    virtual             ~Accessor() {}

    void                assign(
                            const REALTYPE &    i_data );
    REALTYPE            v() const;              // 'v'alue()

    /** @param  i_mode
        0:  Uses the standard implementation.
    */
    static DYN self *   create_(
                            REALTYPE &          io_data,
                            connect_method      i_fMode = 0 );
  private:
    // Interface Data:
    virtual accessor_type
                        inq_Type() const;
    // Locals
    virtual void        do_Assign(
                            const REALTYPE &    i_data ) = 0;
    virtual REALTYPE    inq_V() const = 0;
};





template <class REALTYPE>
inline void
Accessor<REALTYPE>::assign( const REALTYPE & i_data )
    { do_Assign(i_data); }
template <class REALTYPE>
inline REALTYPE
Accessor<REALTYPE>::v() const
    { return inq_V(); }


DYN Accessor< csv::String > *
                    std_create_impl(
                        csv::String &       io_data );
DYN Accessor< intt > *
                    std_create_impl(
                        intt &              io_data );
DYN Accessor< uintt > *
                    std_create_impl(
                        uintt &             io_data );
DYN Accessor< real > *
                    std_create_impl(
                        real &              io_data );
DYN Accessor< bool > *
                    std_create_impl(
                        bool &              io_data );

template <class REALTYPE>
DYN Accessor<REALTYPE> *
Accessor<REALTYPE>::create_( REALTYPE &     io_data,
                                         connect_method i_fMode )
{
    if ( i_fMode == 0 )
        return std_create_impl( io_data );

    return (*i_fMode)( io_data );
}


inline Data::accessor_type
get_accessor_type( const csv::Type2Type<csv::String> & ) { return Data::t_String; }
inline Data::accessor_type
get_accessor_type( const csv::Type2Type<intt> & ) { return Data::t_Integer; }
inline Data::accessor_type
get_accessor_type( const csv::Type2Type<uintt> & ) { return Data::t_UInteger; }
inline Data::accessor_type
get_accessor_type( const csv::Type2Type<real> & ) { return Data::t_Real; }
inline Data::accessor_type
get_accessor_type( const csv::Type2Type<bool> & ) { return Data::t_Bool; }

template <class REALTYPE>
Data::accessor_type
Accessor<REALTYPE>::inq_Type() const
{
 	return get_accessor_type( csv::Type2Type<REALTYPE>() );
}


}   // namespace udm


#endif

