/*************************************************************************
 *
 *  $RCSfile: certctrl.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 17:04:10 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

// include ---------------------------------------------------------------

#include "certctrl.hxx"

#include "certdlg.hrc"
#include "goodies.hrc"

// class CertDetailWindow ------------------------------------------------

CertDetailWindow::CertDetailWindow(	Window* pParent, ResMgr* pResMgr ) :

	Window( pParent, ResId( WIN_SSL_INFCERT, pResMgr ) ),

	m_aIssuedFTI		( this, ResId( FTI_ISSUED ) ),
	m_aIssuedFT			( this, ResId( FT_ISSUED ) ),
	m_aFL1				( this, ResId( FL_1 ) ),
	m_aOwnerFTI			( this, ResId( FTI_OWNER ) ),
	m_aOwnerFT			( this, ResId( FT_OWNER ) ),
	m_aFL2				( this, ResId( FL_2 ) ),
	m_aFingerPrintFTI	( this, ResId( FTI_FINGERPRINT ) ),
	m_aFingerPrintFT	( this, ResId( FT_FINGERPRINT ) ),
	m_aFL3				( this, ResId( FL_3 ) ),
	m_aValidFTI			( this, ResId( FTI_VALID ) ),
	m_aValidFT			( this, ResId( FT_VALID ) )

{
	FreeResource();

	Font aFont( m_aIssuedFTI.GetFont() );
	aFont.SetWeight( WEIGHT_BOLD );
	m_aIssuedFTI.SetFont( aFont );
	m_aOwnerFTI.SetFont( aFont );
	m_aFingerPrintFTI.SetFont( aFont );
	m_aValidFTI.SetFont( aFont );
}

// class CertDetailEdit --------------------------------------------------

CertDetailEdit::CertDetailEdit( Window* pParent, ResMgr* pResMgr ) :

	Window( pParent, ResId( WIN_SSL_INFCERT_EDIT, pResMgr ) ),

	m_aQueryFT	( this, ResId( FT_QUEST ) ),
	m_aYesRB	( this, ResId( RB_YES ) ),
	m_aNoRB		( this, ResId( RB_NO ) )

{
	FreeResource();
	m_aYesRB.Check();
}


