/*************************************************************************
 *
 *  $RCSfile: bitmapex.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: hr $ $Date: 2000/12/07 13:37:15 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SV_BITMAPEX_HXX
#define _SV_BITMAPEX_HXX

#ifndef _SV_BITMAP_HXX
#include <bitmap.hxx>
#endif
#ifndef _SV_ALPHA_HXX
#include <alpha.hxx>
#endif
#ifndef _SV_COLOR_HXX
#include <color.hxx>
#endif

// -------------------
// - TransparentType -
// -------------------

enum TransparentType
{
	TRANSPARENT_NONE, 
	TRANSPARENT_COLOR,
	TRANSPARENT_BITMAP
};

// ------------
// - BitmapEx -
// ------------

class RMBitmapEx;

class BitmapEx
{
	friend class ImpGraphic;

private:

	Bitmap				aBitmap;
	Bitmap				aMask;
	Size				aBitmapSize;
	Color				aTransparentColor;
	TransparentType		eTransparent;
	USHORT				nDummy;
	BOOL				bAlpha;
	BYTE				cDummy;

public:

#ifdef REMOTE_APPSERVER

	void				ImplDrawRemote( OutputDevice* pOut,
										const Point& rSrcPt, const Size& rSrcSz,
										const Point& rDestPt, const Size& rDestSz ) const;
	void				ImplDrawRemoteAlpha( OutputDevice* pOut,
										const Point& rSrcPt, const Size& rSrcSz,
										const Point& rDestPt, const Size& rDestSz ) const;

#endif // REMOTE

#if _SOLAR__PRIVATE

    ImpBitmap*			ImplGetBitmapImpBitmap() const { return aBitmap.ImplGetImpBitmap(); }
    ImpBitmap*			ImplGetMaskImpBitmap() const { return aMask.ImplGetImpBitmap(); }

#endif // PRIVATE

public:

						BitmapEx();
						BitmapEx( const BitmapEx& rBitmapEx );
						BitmapEx( const Bitmap& rBmp );
						BitmapEx( const Bitmap& rBmp, const Bitmap& rMask );
						BitmapEx( const Bitmap& rBmp, const AlphaMask& rAlphaMask );
						BitmapEx( const Bitmap& rBmp, const Color& rTransparentColor );
						~BitmapEx();

	BitmapEx&			operator=( const BitmapEx& rBitmapEx );
	BOOL				operator==( const BitmapEx& rBitmapEx ) const;
	BOOL				operator!=( const BitmapEx& rBitmapEx ) const { return !(*this==rBitmapEx); }
	BOOL				operator!() const { return !aBitmap; }

	BOOL				IsEqual( const BitmapEx& rBmpEx ) const;

	BOOL				IsEmpty() const;
	void				SetEmpty();
	void				Clear();

	void				Draw( OutputDevice* pOutDev, 
							  const Point& rDestPt ) const;
	void				Draw( OutputDevice* pOutDev, 
							  const Point& rDestPt, const Size& rDestSize ) const;
	void				Draw( OutputDevice* pOutDev, 
							  const Point& rDestPt, const Size& rDestSize,
							  const Point& rSrcPtPixel, const Size& rSrcSizePixel ) const;

	BOOL				IsTransparent() const;
	TransparentType		GetTransparentType() const { return eTransparent; }

	Bitmap				GetBitmap( const Color* pTransReplaceColor = NULL ) const;
	Bitmap				GetMask() const;

	BOOL				IsAlpha() const;
	AlphaMask			GetAlpha() const;

    const Size&         GetSizePixel() const { return aBitmapSize; }
	void				SetSizePixel( const Size& rNewSize );

	const Size&			GetPrefSize() const { return aBitmap.GetPrefSize(); }
	void				SetPrefSize( const Size& rPrefSize ) { aBitmap.SetPrefSize( rPrefSize ); }

	const MapMode&		GetPrefMapMode() const { return aBitmap.GetPrefMapMode(); }
	void				SetPrefMapMode( const MapMode& rPrefMapMode ) { aBitmap.SetPrefMapMode( rPrefMapMode ); }

	const Color&		GetTransparentColor() const { return aTransparentColor; }
	void				SetTransparentColor( const Color& rColor ) { aTransparentColor = rColor; }

	USHORT				GetBitCount() const { return aBitmap.GetBitCount(); }
	ULONG				GetSizeBytes() const;
	ULONG				GetChecksum() const;

public:

    BOOL				Convert( BmpConversion eConversion );
	BOOL				ReduceColors( USHORT nNewColorCount, 
									  BmpReduce eReduce = BMP_REDUCE_SIMPLE );
	BOOL				Dither( ULONG nDitherFlags = BMP_DITHER_MATRIX, 
								const BitmapPalette* pDitherPal = NULL );
    BOOL				Crop( const Rectangle& rRectPixel );
    BOOL				Expand( ULONG nDX, ULONG nDY, 
								const Color* pInitColor = NULL, 
								BOOL bExpandTransparent = FALSE );
    BOOL				CopyPixel( const Rectangle& rRectDst,
								   const Rectangle& rRectSrc,
								   const BitmapEx* pBmpExSrc = NULL );
	BOOL				Erase( const Color& rFillColor );
    BOOL				Invert();
    BOOL				Mirror( ULONG nMirrorFlags );
	BOOL				Scale( const Size& rNewSize, ULONG nScaleFlag = BMP_SCALE_FAST );
    BOOL				Scale( const double& rScaleX, const double& rScaleY, ULONG nScaleFlag = BMP_SCALE_FAST );
    BOOL				Rotate( long nAngle10, const Color& rFillColor );
    BOOL				Replace( const Color& rSearchColor, const Color& rReplaceColor, ULONG nTol = 0 );
    BOOL				Replace( const Color* pSearchColors, const Color* pReplaceColors, 
								 ULONG nColorCount, const ULONG* pTols = NULL );
	BOOL				Adjust( short nLuminancePercent = 0,
								short nContrastPercent = 0,
								short nChannelRPercent = 0, 
								short nChannelGPercent = 0, 
								short nChannelBPercent = 0,
								double fGamma = 1.0,
								BOOL bInvert = FALSE );
	BOOL				Filter( BmpFilter eFilter, 
								const BmpFilterParam* pFilterParam = NULL,
								const Link* pProgress = NULL );

public:

	friend SvStream&	operator<<( SvStream& rOStm, const BitmapEx& rBitmapEx );
	friend SvStream&	operator>>( SvStream& rIStm, BitmapEx& rBitmapEx );
};

#endif // _SV_BITMAPEX_HXX
