/*************************************************************************
 *
 *  $RCSfile: button.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: th $ $Date: 2001/07/06 15:54:35 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SV_BUTTON_HXX
#define _SV_BUTTON_HXX

#ifndef _SV_SV_H
#include <sv.h>
#endif
#ifndef _SV_IMAGE_HXX
#include <image.hxx>
#endif
#ifndef _SV_SYMBOL_HXX
#include <symbol.hxx>
#endif
#ifndef _SV_CTRL_HXX
#include <ctrl.hxx>
#endif

class UserDrawEvent;

// ----------
// - Button -
// ----------

class Button : public Control
{
private:
    Link                maClickHdl;

protected:
                        Button( WindowType nType );

public:
                        Button( Window* pParent, WinBits nStyle = 0 );
                        Button( Window* pParent, const ResId& rResId );

    virtual void        Click();

    void                SetClickHdl( const Link& rLink ) { maClickHdl = rLink; }
    const Link&         GetClickHdl() const { return maClickHdl; }

    static XubString    GetStandardText( StandardButtonType eButton );
    static XubString    GetStandardHelpText( StandardButtonType eButton );
};

// --------------------
// - PushButton-Types -
// --------------------

#define PUSHBUTTON_DROPDOWN_TOOLBOX         ((USHORT)0x0001)
#define PUSHBUTTON_DROPDOWN_MENUBUTTON      ((USHORT)0x0002)

// --------------
// - PushButton -
// --------------

class PushButton : public Button
{
protected:
    Rectangle       maFocusRect;
    Image           maImage;
    BitmapEx*       mpBitmapEx;
    void*           mpDummy;
    SymbolType      meSymbol;
    ImageAlign      meImageAlign;
    TriState        meState;
    TriState        meSaveValue;
    USHORT          mnDDStyle;
    USHORT          mnButtonState;
    BOOL            mbPressed;
    BOOL            mbInUserDraw;
    BOOL            mbDummy1;
    BOOL            mbDummy2;
    Link            maToggleHdl;

#if _SOLAR__PRIVATE
#ifdef _SV_BUTTON_CXX
    void            ImplInitData();
    WinBits         ImplInitStyle( const Window* pPrevWindow, WinBits nStyle );
    void            ImplInitSettings( BOOL bFont, BOOL bForeground, BOOL bBackground );
    void            ImplDrawPushButtonContent( OutputDevice* pDev, ULONG nDrawFlags,
                                               const Rectangle& rRect, Rectangle& rTextRect );
    void            ImplDrawPushButton();
    USHORT          ImplGetTextStyle() const;
    BOOL            IsSymbol() const { return ( (meSymbol != SYMBOL_NOSYMBOL) && (meSymbol != SYMBOL_IMAGE) ); }
    BOOL            IsImage() const { return !!maImage; }
#endif

protected:
    void            ImplInit( Window* pParent, WinBits nStyle );

public:
    void            ImplSetDefButton( BOOL bSet );
    static void     ImplDrawPushButtonFrame( Window* pDev, Rectangle& rRect, USHORT nStyle );
    static BOOL     ImplHitTestPushButton( Window* pDev, const Point& rPos, USHORT nStyle );
    BOOL            ImplIsDefButton() const;
#endif

protected:
                    PushButton( WindowType nType );

public:
                    PushButton( Window* pParent, WinBits nStyle = 0 );
                    PushButton( Window* pParent, const ResId& rResId );
                    ~PushButton();

    virtual void    MouseButtonDown( const MouseEvent& rMEvt );
    virtual void    Tracking( const TrackingEvent& rTEvt );
    virtual void    KeyInput( const KeyEvent& rKEvt );
    virtual void    KeyUp( const KeyEvent& rKEvt );
    virtual void    Paint( const Rectangle& rRect );
    virtual void    Draw( OutputDevice* pDev, const Point& rPos, const Size& rSize, ULONG nFlags );
    virtual void    Resize();
    virtual void    GetFocus();
    virtual void    LoseFocus();
    virtual void    StateChanged( StateChangedType nType );
    virtual void    DataChanged( const DataChangedEvent& rDCEvt );
    virtual void    UserDraw( const UserDrawEvent& rUDEvt );

    virtual void    Toggle();

    void            SetImage( const Image& rImage );
    const Image&    GetImage() const { return maImage; }

    void            SetBitmap( const BitmapEx& rBmp );
    BitmapEx        GetBitmap() const;

    void            SetSymbol( SymbolType eSymbol );
    SymbolType      GetSymbol() const { return meSymbol; }

    void            SetImageAlign( ImageAlign eAlign );
    ImageAlign      GetImageAlign() const { return meImageAlign; }

    void            SetDropDown( USHORT nStyle );
    USHORT          GetDropDown() const { return mnDDStyle; }

#ifndef NOOLDSV
    void            SetColor() { SetControlForeground(); }
    void            SetColor( const Color& rColor ) { SetControlForeground( rColor ); }
    Color           GetColor() const { return GetControlForeground(); }
    BOOL            IsColor() const { return IsControlForeground(); }
#endif

    void            SetState( TriState eState );
    TriState        GetState() const { return meState; }

    void            Check( BOOL bCheck = TRUE );
    BOOL            IsChecked() const;

    void            SetPressed( BOOL bPressed );
    BOOL            IsPressed() const { return mbPressed; }

    void            EndSelection();

    void            SaveValue() { meSaveValue = GetState(); }
    TriState        GetSavedValue() const { return meSaveValue; }

    Size            CalcMinimumSize( long nMaxWidth = 0 ) const;

    void            SetToggleHdl( const Link& rLink ) { maToggleHdl = rLink; }
    const Link&     GetToggleHdl() const { return maToggleHdl; }
};

inline void PushButton::Check( BOOL bCheck )
{
    SetState( (bCheck) ? STATE_CHECK : STATE_NOCHECK );
}

inline BOOL PushButton::IsChecked() const
{
    return (GetState() == STATE_CHECK);
}

// ------------
// - OKButton -
// ------------

class OKButton : public PushButton
{
#ifdef _SV_BUTTON_CXX
private:
    void            ImplInit( Window* pParent, WinBits nStyle );
#endif

public:
                    OKButton( Window* pParent, WinBits nStyle = WB_DEFBUTTON );
                    OKButton( Window* pParent, const ResId& rResId );

    virtual void    Click();
};

// ----------------
// - CancelButton -
// ----------------

class CancelButton : public PushButton
{
#ifdef _SV_BUTTON_CXX
private:
    void            ImplInit( Window* pParent, WinBits nStyle );
#endif

public:
                    CancelButton( Window* pParent, WinBits nStyle = 0 );
                    CancelButton( Window* pParent, const ResId& rResId );

    virtual void    Click();
};

// --------------
// - HelpButton -
// --------------

class HelpButton : public PushButton
{
#ifdef _SV_BUTTON_CXX
private:
    void            ImplInit( Window* pParent, WinBits nStyle );
#endif

public:
                    HelpButton( Window* pParent, WinBits nStyle = 0 );
                    HelpButton( Window* pParent, const ResId& rResId );

    virtual void    Click();
};

// ---------------
// - RadioButton -
// ---------------

class RadioButton : public Button
{
private:
    Rectangle       maStateRect;
    Rectangle       maMouseRect;
    Rectangle       maFocusRect;
    Image           maImage;
    USHORT          mnButtonState;
    BOOL            mbChecked;
    BOOL            mbSaveValue;
    BOOL            mbRadioCheck;
    BOOL            mbStateChanged;
    BOOL            mbDummy1;
    BOOL            mbDummy2;
    Link            maToggleHdl;

#if _SOLAR__PRIVATE
#ifdef _SV_BUTTON_CXX
    void            ImplInitData();
    WinBits         ImplInitStyle( const Window* pPrevWindow, WinBits nStyle );
    void            ImplInitSettings( BOOL bFont, BOOL bForeground, BOOL bBackground );
    void            ImplDrawRadioButtonState();
    void            ImplDraw( OutputDevice* pDev, ULONG nDrawFlags,
                              const Point& rPos, const Size& rSize,
                              const Size& rImageSize, long nImageSep,
                              Rectangle& rStateRect,
                              Rectangle& rMouseRect, Rectangle& rFocusRect );
    void            ImplDrawRadioButton();
    void            ImplUncheckAllOther();
#endif

protected:
    void            ImplInit( Window* pParent, WinBits nStyle );
    void            ImplLoadRes( const ResId& rResId );

public:
    void            ImplCallClick( BOOL bGrabFocus = FALSE, USHORT nFocusFlags = 0 );
#endif

public:
                    RadioButton( Window* pParent, WinBits nWinStyle = 0 );
                    RadioButton( Window* pParent, const ResId& rResId );
                    ~RadioButton();

    virtual void    MouseButtonDown( const MouseEvent& rMEvt );
    virtual void    Tracking( const TrackingEvent& rTEvt );
    virtual void    KeyInput( const KeyEvent& rKEvt );
    virtual void    KeyUp( const KeyEvent& rKEvt );
    virtual void    Paint( const Rectangle& rRect );
    virtual void    Draw( OutputDevice* pDev, const Point& rPos, const Size& rSize, ULONG nFlags );
    virtual void    Resize();
    virtual void    GetFocus();
    virtual void    LoseFocus();
    virtual void    StateChanged( StateChangedType nType );
    virtual void    DataChanged( const DataChangedEvent& rDCEvt );

    virtual void    Toggle();

    BOOL            IsStateChanged() const { return mbStateChanged; }

    void            EnableRadioCheck( BOOL bRadioCheck = TRUE ) { mbRadioCheck = bRadioCheck; }
    BOOL            IsRadioCheckEnabled() const { return mbRadioCheck; }

    void            SetImage( const Image& rImage );
    const Image&    GetImage() const { return maImage; }

    void            SetState( BOOL bCheck );
    void            Check( BOOL bCheck = TRUE );
    BOOL            IsChecked() const { return mbChecked; }

    void            SaveValue() { mbSaveValue = IsChecked(); }
    BOOL            GetSavedValue() const { return mbSaveValue; }

    static Image    GetRadioImage( const AllSettings& rSettings, USHORT nFlags );

    Size            CalcMinimumSize( long nMaxWidth = 0 ) const;

    void            SetToggleHdl( const Link& rLink ) { maToggleHdl = rLink; }
    const Link&     GetToggleHdl() const { return maToggleHdl; }
};


// ------------
// - CheckBox -
// ------------

class CheckBox : public Button
{
private:
    Rectangle       maStateRect;
    Rectangle       maMouseRect;
    Rectangle       maFocusRect;
    USHORT          mnButtonState;
    TriState        meState;
    TriState        meSaveValue;
    BOOL            mbTriState;
    Link            maToggleHdl;

#if _SOLAR__PRIVATE
#ifdef _SV_BUTTON_CXX
    void            ImplInitData();
    WinBits         ImplInitStyle( const Window* pPrevWindow, WinBits nStyle );
    void            ImplInitSettings( BOOL bFont, BOOL bForeground, BOOL bBackground );
    void            ImplDrawCheckBoxState();
    void            ImplDraw( OutputDevice* pDev, ULONG nDrawFlags,
                              const Point& rPos, const Size& rSize,
                              const Size& rImageSize, long nImageSep,
                              Rectangle& rStateRect,
                              Rectangle& rMouseRect, Rectangle& rFocusRect );
    void            ImplDrawCheckBox();
#endif

protected:
    void            ImplInit( Window* pParent, WinBits nStyle );
    void            ImplLoadRes( const ResId& rResId );

public:
    void            ImplCheck();
#endif

public:
                    CheckBox( Window* pParent, WinBits nStyle = 0 );
                    CheckBox( Window* pParent, const ResId& rResId );

    virtual void    MouseButtonDown( const MouseEvent& rMEvt );
    virtual void    Tracking( const TrackingEvent& rTEvt );
    virtual void    KeyInput( const KeyEvent& rKEvt );
    virtual void    KeyUp( const KeyEvent& rKEvt );
    virtual void    Paint( const Rectangle& rRect );
    virtual void    Draw( OutputDevice* pDev, const Point& rPos, const Size& rSize, ULONG nFlags );
    virtual void    Resize();
    virtual void    GetFocus();
    virtual void    LoseFocus();
    virtual void    StateChanged( StateChangedType nType );
    virtual void    DataChanged( const DataChangedEvent& rDCEvt );

    virtual void    Toggle();

    void            SetState( TriState eState );
    TriState        GetState() const { return meState; }

    void            Check( BOOL bCheck = TRUE );
    BOOL            IsChecked() const;

    void            EnableTriState( BOOL bTriState = TRUE );
    BOOL            IsTriStateEnabled() const { return mbTriState; }

    void            SaveValue() { meSaveValue = GetState(); }
    TriState        GetSavedValue() const { return meSaveValue; }

    static Image    GetCheckImage( const AllSettings& rSettings, USHORT nFlags );

    Size            CalcMinimumSize( long nMaxWidth = 0 ) const;

    void            SetToggleHdl( const Link& rLink ) { maToggleHdl = rLink; }
    const Link&     GetToggleHdl() const { return maToggleHdl; }
};

inline void CheckBox::Check( BOOL bCheck )
{
    SetState( (bCheck) ? STATE_CHECK : STATE_NOCHECK );
}

inline BOOL CheckBox::IsChecked() const
{
    return (GetState() == STATE_CHECK);
}

// ---------------------------------
// - Control-Layer fuer alten Code -
// ---------------------------------

class ImageButton : public PushButton
{
protected:
                    ImageButton( WindowType nType );

public:
                    ImageButton( Window* pParent, WinBits nStyle = 0 );
                    ImageButton( Window* pParent, const ResId& rResId );
                    ~ImageButton();
};

class ImageRadioButton : public RadioButton
{
public:
                    ImageRadioButton( Window* pParent, WinBits nStyle = 0 );
                    ImageRadioButton( Window* pParent, const ResId& rResId );
                    ~ImageRadioButton();
};

class TriStateBox : public CheckBox
{
public:
            TriStateBox( Window* pParent, WinBits nStyle = 0 );
            TriStateBox( Window* pParent, const ResId& rResId );
            ~TriStateBox();
};

#ifndef NOOLDSV

#define ImageButtonType             SymbolType
#define IMAGEBUTTON_DONTKNOW        SYMBOL_DONTKNOW
#define IMAGEBUTTON_IMAGE           SYMBOL_IMAGE
#define IMAGEBUTTON_ARROW_UP        SYMBOL_ARROW_UP
#define IMAGEBUTTON_ARROW_DOWN      SYMBOL_ARROW_DOWN
#define IMAGEBUTTON_ARROW_LEFT      SYMBOL_ARROW_LEFT
#define IMAGEBUTTON_ARROW_RIGHT     SYMBOL_ARROW_RIGHT
#define IMAGEBUTTON_SPIN_UP         SYMBOL_SPIN_UP
#define IMAGEBUTTON_SPIN_DOWN       SYMBOL_SPIN_DOWN
#define IMAGEBUTTON_SPIN_LEFT       SYMBOL_SPIN_LEFT
#define IMAGEBUTTON_SPIN_RIGHT      SYMBOL_SPIN_RIGHT
#define IMAGEBUTTON_FIRST           SYMBOL_FIRST
#define IMAGEBUTTON_LAST            SYMBOL_LAST
#define IMAGEBUTTON_PREV            SYMBOL_PREV
#define IMAGEBUTTON_NEXT            SYMBOL_NEXT
#define IMAGEBUTTON_PAGEUP          SYMBOL_PAGEUP
#define IMAGEBUTTON_PAGEDOWN        SYMBOL_PAGEDOWN
#define IMAGEBUTTON_PLAY            SYMBOL_PLAY
#define IMAGEBUTTON_REVERSEPLAY     SYMBOL_REVERSEPLAY
#define IMAGEBUTTON_STOP            SYMBOL_STOP
#define IMAGEBUTTON_PAUSE           SYMBOL_PAUSE
#define IMAGEBUTTON_WINDSTART       SYMBOL_WINDSTART
#define IMAGEBUTTON_WINDEND         SYMBOL_WINDEND
#define IMAGEBUTTON_WINDBACKWARD    SYMBOL_WINDBACKWARD
#define IMAGEBUTTON_WINDFORWARD     SYMBOL_WINDFORWARD

#endif

#endif  // _SV_BUTTON_HXX
