/*************************************************************************
 *
 *  $RCSfile: glyphcache.hxx,v $
 *
 *  $Revision: 1.12 $
 *
 *  last change: $Author: hdu $ $Date: 2001/08/02 17:13:42 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SV_GLYPHCACHE_HXX
#define _SV_GLYPHCACHE_HXX

class GlyphCache;
class GlyphMetric;
class GlyphData;
class ServerFont;
class GlyphCachePeer;

#include <tools/gen.hxx>
#include <hash_map>
#include <hash_set>

class PolyPolygon;
struct RawBitmap;
struct ImplFontSelectData;

#include <outfont.hxx>

bool operator==( const ImplFontSelectData& rA, const ImplFontSelectData& rB );

#define SERVERFONT_MAGIC ((void*)0x5EEF0DAC)		/* 5ErvErF0nD_mAgiC */

// =======================================================================

class GlyphCache
{
public:
								GlyphCache( ULONG _nMaxSize = 250000 );
								~GlyphCache();

	static void					EnsureInstance( GlyphCachePeer& rPeer, bool bInitFonts = true );
	static GlyphCache&			GetInstance() { return *pSingleton; }

	void						ClearFontPath();
	void						AddFontPath( const String& rFontPath );
	void						AddFontFile( const rtl::OString& rNormalizedName,
									int nFaceNum, int nFontId, const ImplFontData* );
	long						FetchFontList( ImplDevFontList* ) const;

	void* 						GetFontHandle (int nFontId);
	ServerFont*					CacheFont( const ImplFontSelectData& );
	void						UncacheFont( ServerFont& );

private:
friend ServerFont;
	// used by ServerFont class only
	void						AddedGlyph( ServerFont& rServerFont, GlyphData& rGlyphData );
	void						RemovingGlyph( ServerFont& rSF, GlyphData& rGD, int nGlyphIndex );
	void						UsingGlyph( ServerFont&, GlyphData& rGD );
	void						GrowNotify();

private:
	static GlyphCache*			pSingleton;

	ULONG						CalcByteCount() const;
	void						GarbageCollect();


	struct std::hash<ImplFontSelectData> { size_t operator()( const ImplFontSelectData& ) const;};
	typedef ::std::hash_map<ImplFontSelectData,ServerFont* > FontList;
	FontList					aFontList;

	GlyphCachePeer*				pPeer;

	ULONG						mnMaxSize;		// max overall cache size in bytes
	mutable ULONG				mnBytesUsed;
	mutable long				mnLruIndex;
	ServerFont*					pCurrentGCFont;

	class FreetypeManager*		pFtManager;
};

// =======================================================================

class GlyphMetric
{
public:
	Point					GetOffset() const	{ return maOffset; }
	Point					GetDelta() const	{ return maDelta; }
	Size					GetSize() const		{ return maSize; }
	ULONG					GetCharWidth() const { return mnCharWidth; }

protected:
friend class GlyphData;
	void					SetOffset( int nX, int nY ) { maOffset = Point( nX, nY); }
	void					SetDelta( int nX, int nY )	{ maDelta = Point( nX, nY); }
	void					SetSize( const Size& s )	{ maSize = s; }
	void					SetCharWidth( int nW )		{ mnCharWidth = nW; }

private:
	ULONG					mnCharWidth;
	Point					maDelta;
	Point					maOffset;
	Size					maSize;
};

// -----------------------------------------------------------------------

class GlyphData
{
public:
							GlyphData() : mnExtInfo(0) 	{}

	const GlyphMetric&		GetMetric() const			{ return maMetric; }
	Size					GetSize() const				{ return maMetric.GetSize(); }

	void					SetSize( const Size& s)		{ maMetric.SetSize( s ); }
	void					SetOffset( int nX, int nY )	{ maMetric.SetOffset( nX, nY ); }
	void					SetDelta( int nX, int nY )	{ maMetric.SetDelta( nX, nY ); }
	void					SetCharWidth( int nW )		{ maMetric.SetCharWidth( nW ); }

	void					SetLruValue( int n ) const	{ mnLruValue = n; }
	long					GetLruValue() const 		{ return mnLruValue;}

	void					SetExtended( int nInfo, void* pVoid );
	int						GetExtInfo() 	{ return mnExtInfo; }
	void*					GetExtPointer() { return mpExtData; }

#if _SOLAR__PRIVATE
private:
	GlyphMetric				maMetric;


	// info for GlyphCachePeer
	int						mnExtInfo;
	void*					mpExtData;

	// used by GlyphCache for cache LRU algorithm
	mutable long			mnLruValue;	
#endif // _SOLAR__PRIVATE
};

// =======================================================================

class ServerFont
{
public:
	virtual const ::rtl::OString*	GetFontFileName() const	{ return NULL; }
	virtual int					GetFontFaceNumber() const	{ return 0; }
	virtual int					GetFontId() const			{ return -1; }
	virtual bool				TestFont() const			{ return true; }
	virtual void				SetFontId( int nFontId )	{}
		
	const ImplFontSelectData&	GetFontSelData() const		{ return maFontSelData; }

	virtual void				FetchFontMetric( ImplFontMetricData&, long& rFactor ) const = 0;
	virtual ULONG				GetKernPairs( struct ImplKernPairData** ) const = 0;
    virtual ULONG               GetFontCodeRanges( sal_uInt32* pCodes ) const { return 0; }
	Point						TransformPoint( const Point& ) const;

	virtual int					GetGlyphIndex( sal_Unicode ) const = 0;
	GlyphData&					GetGlyphData( int nGlyphIndex );
	const GlyphMetric&			GetGlyphMetric( int nGlyphIndex )
								{ return GetGlyphData( nGlyphIndex ).GetMetric(); }

	virtual bool				GetGlyphOutline( int nGlyphIndex, PolyPolygon& ) const = 0;
	virtual bool				GetAntialiasAdvice( void ) const = 0;
	virtual bool				GetGlyphBitmap1( int nGlyphIndex, RawBitmap& ) const = 0;
	virtual bool				GetGlyphBitmap8( int nGlyphIndex, RawBitmap& ) const = 0;

	void						SetExtended( int nInfo, void* ppVoid );
	int							GetExtInfo() { return mnExtInfo; }
	void*						GetExtPointer() { return mpExtData; }

#if _SOLAR__PRIVATE
protected:
friend GlyphCache;
								ServerFont( const ImplFontSelectData& );
	virtual						~ServerFont();

	void						AddRef() const		{ ++mnRefCount; }
	long						GetRefCount() const	{ return mnRefCount; }
	long						Release() const;
	ULONG						GetByteCount() const { return mnBytesUsed; }

	virtual void				InitGlyphData( int nGlyphIndex, GlyphData& ) const = 0;
	virtual void				GarbageCollect( long );

private:
	typedef ::std::hash_map<int,GlyphData> GlyphList;
	mutable GlyphList			aGlyphList;

	const ImplFontSelectData	maFontSelData;

	// info for GlyphcachePeer
	int							mnExtInfo;
	void*						mpExtData;

	// used by GlyphCache for cache LRU algorithm
	mutable long				mnRefCount;
	mutable ULONG				mnBytesUsed;

	ServerFont*					pPrevGCFont;
	ServerFont*					pNextGCFont;

protected:
	long						nCos;
	long						nSin;
#endif // _SOLAR__PRIVATE
};

// =======================================================================

class GlyphCachePeer
{
protected:
					GlyphCachePeer() : mnBytesUsed(0) {}
	virtual			~GlyphCachePeer() {}

public:
	ULONG			GetByteCount() const { return mnBytesUsed; }
	virtual void	RemovingFont( ServerFont& ) {}
	virtual void	RemovingGlyph( ServerFont&, GlyphData&, int nGlyphIndex ) {}

protected:
	ULONG			mnBytesUsed;
};

// =======================================================================

class RawBitmap
{
public:
                    RawBitmap();
                    ~RawBitmap();
    bool            Rotate( int nAngle );

public:
	unsigned char*	mpBits;
	ULONG 			mnAllocated;

	ULONG			mnWidth;
	ULONG			mnHeight;

	ULONG			mnScanlineSize;
	ULONG			mnBitCount;

	int 			mnXOffset;
	int 			mnYOffset;
};

// =======================================================================

int SetVerticalFlags( sal_Unicode nChar );

// =======================================================================

inline void GlyphData::SetExtended( int nInfo, void* pVoid )
{
	mnExtInfo = nInfo;
	mpExtData = pVoid;
}

// -----------------------------------------------------------------------

inline void ServerFont::SetExtended( int nInfo, void* pVoid )
{
	mnExtInfo = nInfo;
	mpExtData = pVoid;
}

#endif // _SV_GLYPHCACHE_HXX
