/*************************************************************************
 *
 *  $RCSfile: rmevents.hxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: ssa $ $Date: 2001/11/23 12:16:32 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SV_RMEVENTS_HXX
#define _SV_RMEVENTS_HXX

#include <sal/types.h>
#include <vos/types.hxx>
#include <vos/mutex.hxx>
#include <vos/semaphor.hxx>
#include <vos/conditn.hxx>
#include <vos/timer.hxx>
#include <tools/solar.h>
#include <tools/link.hxx>
#include <tools/string.hxx>

// -------------
// - VclOTimer -
// -------------

class VclOTimer : public vos::OTimer
{
private:
	Link					maTimeoutHdl;
	BOOL					mbSend;

protected:
	virtual void SAL_CALL	onShot();
							DECL_LINK( Timeout, void* );

public:
							VclOTimer();

	void					StartTimer();
	void					StopTimer();
};

// -----------
// - RmEvent -
// -----------

class RmEvent
{
private:

  friend class RmEventSubQueue;

  RmEvent*			mpNext; 	// Verkettung in der MesageQueue

public:

					RmEvent()	{ mpNext = 0; }
};

// --------------
// - ExtRmEvent -
// --------------

class Window;

class ExtRmEvent : public RmEvent
{
private:

	ULONG		mnId;
	void*		mpData;
	BOOL		mbValid;
	Window* 	mpWindow;
	ExtRmEvent* mpNextWindowEvent;	// Verkettung der Events eines Windows

public:
				ExtRmEvent( ULONG nEvtId, Window* pWindow, void* pData = NULL );
				~ExtRmEvent();

	ULONG		GetId() const { return mnId; }
	Window* 	GetWindow() const { return mpWindow; }
	void*		GetData() const { return mpData; }

	void		MarkInvalid() { mbValid = FALSE; }
	BOOL		IsValid() const { return mbValid; }

	ExtRmEvent* GetNextWindowEvent() const { return mpNextWindowEvent; }
	void		SetNextWindowEvent( ExtRmEvent* pEvent ) { mpNextWindowEvent = pEvent; }
};

// ----------
// - Events -
// ----------

struct RmMouseEventData
{
	short	nX;
	short	nY;
	USHORT	nMode;
	USHORT	nCode;
	ULONG	nSysTime;

	RmMouseEventData( short _nX, short _nY, USHORT _nMode, USHORT _nCode, ULONG _nSysTime )
	{
		nX = _nX; nY = _nY; nMode = _nMode; nCode = _nCode; nSysTime = _nSysTime;
	}
};

struct RmKeyEventData
{
	USHORT nChar;
	USHORT nKeyCode;
	USHORT nCount;

	RmKeyEventData( USHORT _nChar, USHORT _nKeyCode, USHORT _nCount )
	{
		nChar = _nChar;
		nKeyCode = _nKeyCode;
		nCount = _nCount;
	}
};

struct RmMouseWheelEventData
{
	long	nX;
	long	nY;
	USHORT	nCode;
	ULONG	nSysTime;
	long	nDelta;
	long	nNotchDelta;
	ULONG	nScrollLines;
	sal_Bool bHorz;

	RmMouseWheelEventData( short _nX, short _nY, USHORT _nCode, ULONG _nSysTime, long _nDelta, long _nNotchDelta, ULONG _nScrollLines, sal_Bool _bHorz )
	{
		nX				= _nX;
		nY				= _nY;
		nCode			= _nCode;
		nSysTime		= _nSysTime;
		nDelta			= _nDelta;
		nNotchDelta 	= _nNotchDelta;
		nScrollLines	=  _nScrollLines;
		bHorz			= _bHorz;
	}
};

struct RmExtTextInputData
{
    XubString aText;
    USHORT* pTextAttr;
    ULONG nCursorPos;
    USHORT nCursorFlags;
    ULONG nSysTime;

    RmExtTextInputData( XubString _aText, USHORT* _pTextAttr, ULONG _nCursorPos, USHORT _nCursorFlags, ULONG _nSysTime )
    {
        aText           = _aText;
        pTextAttr       = _pTextAttr;
        nCursorPos      = _nCursorPos;
        nCursorFlags    = _nCursorFlags;
        nSysTime        = _nSysTime;
    }
    ~RmExtTextInputData()
    {
        delete [] pTextAttr;
    }
};

void ImplPostEvent( ExtRmEvent* pEvent );
void ImplRemoveEvent( ULONG nEventId );
void ImplDispatchEvent( ExtRmEvent* pEvent );

#define RMEVENT_GETFOCUS			1
#define RMEVENT_LOSEFOCUS			2
#define RMEVENT_KEYINPUT			3
#define RMEVENT_KEYUP				4
#define RMEVENT_MOUSEBUTTONDOWN 	5
#define RMEVENT_MOUSEBUTTONUP		6
#define RMEVENT_MOUSEMOVE			7
#define RMEVENT_PAINT				8
#define RMEVENT_RESIZE				9
#define RMEVENT_CLOSE				10
#define RMEVENT_MOUSEWHEEL			11
#define RMEVENT_STARTEXTTEXTINPUT   12
#define RMEVENT_EXTTEXTINPUT        13
#define RMEVENT_ENDEXTTEXTINPUT     14
#define RMEVENT_INPUTCONTEXTCHANGE  15
#define RMEVENT_EXTTEXTINPUTPOS     16
#define RMEVENT_GEOMETRYCHANGE      17
#define RMEVENT_DECORATIONCHANGE    18

// #define RMEVENT_COMMAND
// #define RMEVENT_QUERYDROP
// #define RMEVENT_DROP
#define RMEVENT_USEREVENT			10000

// -------------------
// - RmEventSubQueue -
// -------------------

/*
 RmEventSubQueue
 Used to implement a fast an simple queue for RmEvent-Objects.
 The queue assumes temporary ownership of its RmEvent-Objects.
 It hands back ownership to the user after he called removeHead().
 If the queue is destroyed, it deletes all remaining RmEvents.
*/

class RmEventSubQueue
{
protected:

	RmEvent*	mpHead;
	RmEvent*	mpTail;
	RmEvent*	mpCursor;

public:
				RmEventSubQueue();
				~RmEventSubQueue();

	void		Push( RmEvent* pElement );
	RmEvent*	RemoveHead();
	RmEvent*	Top() const { return mpHead; }
	BOOL		IsEmpty() const { return !mpHead; }

	RmEvent*	GetFirst();
	RmEvent*	GetNext();
	void		RemoveCurrent();
};

// ----------------
// - RmEventQueue -
// ----------------

class RmEventQueue
{
private:

	RmEventSubQueue 	maSubQueue;
	ULONG				mnMouseEvtCount;
	ULONG				mnKeyEvtCount;
	ULONG				mnPaintEvtCount;
	ULONG				mnTimerEvtCount;
	ULONG				mnOtherEvtCount;
	::vos::OMutex		m_Lock;
	::vos::OCondition	m_notEmpty;

	ExtRmEvent*			m_pLastKeyInputEvent;
	USHORT				m_nKeyInputRepeated;
	USHORT				m_nGeneratedEvents;
	ULONG				m_nLastRepeatedInputTime;
	USHORT				m_nMaxGeneratedEvents;

	void				ImplRemoveFromWindow( ExtRmEvent* pEvent );
	void				SetMaxGeneratedRepeats();
public:
						RmEventQueue();
						~RmEventQueue();

	void				AddEvent( ExtRmEvent* pEvent );
	void				RemoveEvent( ExtRmEvent* pEvent );
        void                            RemoveWindowEvents( Window* );

	BOOL				HasEvent();
	BOOL				HasMouseEvent() const { return mnMouseEvtCount > 0UL; }
	BOOL				HasKeyEvent() const { return mnKeyEvtCount > 0UL; }
	BOOL				HasPaintEvent() const { return mnPaintEvtCount > 0UL; }
	BOOL				HasTimerEvent() const { return mnTimerEvtCount > 0UL; }
	BOOL				HasOtherEvent() const { return mnOtherEvtCount > 0UL; }

	RmEvent*			GetNextEvent( BOOL bWaitForEvent );
};

#endif	// _SV_RMEVENTS_HXX
