/*************************************************************************
 *
 *  $RCSfile: salmain.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 17:05:33 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/



#if __profile__

#include "mac_start.h"

#include <profiler.h>

#include "mac_end.h"

#endif



#include <svmac.h>



#define _SV_SALMAIN_CXX



#ifndef _TOOLS_H

#include <tools/tools.h>

#endif

#ifndef _SV_SALDATA_HXX

#include <saldata.hxx>

#endif

#ifndef _SV_SALINST_HXX

#include <salinst.hxx>

#endif

#ifndef _SV_SVAPP_HXX

#include <SVAPP.HXX>

#endif



#include <MEMINIT.hxx>



#include <main.h>



// =======================================================================



static void InitializeApp()

{

	InitGraf((MAC_Ptr) &qd.thePort);

	InitFonts();

	InitWindows();

	InitMenus();

	TEInit();

	InitDialogs(nil);

	InitCursor();



	/* Make sure that the machine has at least 128K ROMs. If it doesn't, exit. */

	SysEnvRec	aMacEnv;



	SysEnvirons( kSysEnvironsVersion, &aMacEnv );



	if ( aMacEnv.machineType < 0 )

	{

		AlertUser( eWrongMachine );

		ExitToShell();

	}



	if ( aMacEnv.systemVersion < 0x0700 )

	{

		AlertUser( eWrongSystem );

		ExitToShell();

	}



	SetEventMask( everyEvent );

}



// -----------------------------------------------------------------------



int main ( int argc, char * argv[] )

{

	// Gibt einem statischen Konstruktor eine Chance die Speicherverwaltung

	// zu einem besseren Zeitpunkt zu initialisieren



	SVMemInit aSVMemInt;



	SalData* pSalData = GetSalData();

	pSalData->mnRefNum = CurResFile();



	InitializeApp();				/* initialize the app environment */

	InitSystem();					/* initialize the SV-Data */



#if __profile__

	ProfilerInit(collectDetailed, microsecondsTimeBase, 10000, 50);

#endif



    // Aufruf von StarView-Main

	SVMain();



#if __profile__

	ProfilerDump("\pStarView.prof");

	ProfilerTerm();

#endif



    return 0;

}

