/*************************************************************************
 *
 *  $RCSfile: salgdi3.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: hdu $ $Date: 2001/07/09 16:06:38 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <string.h>
#include <stdlib.h>
#include <svmac.h>

#define _SV_SALGDI_CXX

#ifndef _DEBUG_HXX
#include <tools/debug.hxx>
#endif
#ifndef _SV_SALDATA_HXX
#include <saldata.hxx>
#endif
#ifndef _SV_SALGDI_HXX
#include <salgdi.hxx>
#endif

#ifndef _SV_OUTFONT_HXX
#include <outfont.hxx>
#endif

#ifndef _MYFONT_HXX
#include <myfont.hxx>
#endif

// =======================================================================

DECLARE_LIST( FontList, ImplFontData* );

// =======================================================================

// -----------------------------------------------------------------------
// last changed:	dv	30.09.97

static FontList* ImplInitFontList()
{
	MenuHandle		hTmpMenu;
	short			nItem;
	Str255			aFontName;
	ImplFontData	*pData, *pCompare;
	FontList		*pList;
	ULONG			nInsertPos;

	pList = new FontList;

	hTmpMenu = NewMenu( 9999, (unsigned char*)"\px" );

	if ( hTmpMenu )
	{
		AppendResMenu( hTmpMenu, 'FONT' );

		for ( nItem = 1; nItem <= CountMItems( hTmpMenu ); nItem++ )
		{
			GetMenuItemText( hTmpMenu, nItem, aFontName );
			pData = new ImplFontData;
			pData->maName = String( (char*)(aFontName+1), aFontName[0] );
			pData->mpSysData = NULL;			// System-Data (only GSL)
// !!! NYI, hier auch schon die anderen Daten fuellen, soweit sinnvoll
//			pData->maStyleName = "";    // StyleName vom Font
//			pData->maScript = "";               // Script (Western, Cyrillic)
			pData->mnWidth = 0; 				// Breite vom Font in Pixeln
			pData->mnHeight = 0;				// Heoehe vom Font in Pixeln
			pData->meFamily = FAMILY_DONTKNOW;	// Family vom Font
			pData->meCharSet = CHARSET_MAC; 	// CharSet vom Font
			pData->mePitch = PITCH_DONTKNOW;	// Pitch vom Font
			pData->meWidthType = WIDTH_NORMAL;	// WidthType vom Font
			pData->meWeight = WEIGHT_NORMAL;	// Weight vom Font
			pData->meItalic = ITALIC_NONE;		// Italic vom Font
			pData->meType = TYPE_DONTKNOW;		// Type vom Font
			pData->mbOrientation = FALSE;		// der Mac kann keine Fonts drehen
			pData->mbDevice = TRUE; 			// immer ein Device-Font
			pData->mnQuality = 0;				// keine Quality Unterscheidung

			nInsertPos = nItem - 1;

			while ( nInsertPos )
			{
				pCompare = pList->GetObject( nInsertPos - 1 );
				if ( pCompare->maName > pData->maName )
					nInsertPos -= 1;
				else
					break;
			}
			pList->Insert( pData, nInsertPos );
		}

		DisposeMenu( hTmpMenu );
	}

	return pList;
}

// =======================================================================
// last changed:	dv	26.09.97

void SalGraphics::SetTextColor( SalColor nSalColor )
{
	MacColor aRGB( SALCOLOR_RED  ( nSalColor ),
				   SALCOLOR_GREEN( nSalColor ),
				   SALCOLOR_BLUE ( nSalColor ) );
	maGraphicsData.maTextColor = aRGB;
	maGraphicsData.meLastDrawMode = DRAW_NONE;
}

// -----------------------------------------------------------------------
// last changed:	hro 15.01.98

USHORT SalGraphics::SetFont( ImplFontSelectData* pFont )
{
	ULONG	nRet;
	short	nFontNum = GetFontNum( pFont, nRet );

	if ( nRet )
		nFontNum = GetAppFont();

	maGraphicsData.meLastDrawMode = DRAW_NONE;

	// set new data
	maGraphicsData.mnFontNum = nFontNum;
	maGraphicsData.meCharSet = pFont->meCharSet;

	maGraphicsData.mnWidth = pFont->mnWidth;
	maGraphicsData.mnHeight = pFont->mnHeight;
	maGraphicsData.mnFontSize = pFont->mnHeight;
	maGraphicsData.mnFontFace = 0;

	if ( pFont->meItalic != ITALIC_NONE)
		maGraphicsData.mnFontFace += italic;

	BOOL bDoBold = TRUE;

	switch ( pFont->meWeight )
	{
		case WEIGHT_THIN:
		case WEIGHT_ULTRALIGHT:
		case WEIGHT_LIGHT:
		case WEIGHT_SEMILIGHT:
			bDoBold = FALSE;
			break;
		case WEIGHT_SEMIBOLD:
		case WEIGHT_BOLD:
		case WEIGHT_ULTRABOLD:
		case WEIGHT_BLACK:
			break;
		case WEIGHT_MEDIUM:
		case WEIGHT_NORMAL:
		default:
			bDoBold = FALSE;
			break;
	}

	if ( bDoBold )
		maGraphicsData.mnFontFace += bold;

	return nRet;
}

// -----------------------------------------------------------------------
// last changed:	hro 15.01.98

long SalGraphics::GetCharWidth( USHORT nChar1, USHORT nChar2, long* pWidthAry )
{
	FMetricRec		aMetric;
	WidthTable		*pTable;
	Fixed			nWidth, nFactor;
	register INT32	i;

	maGraphicsData.CheckDrawMode( DRAW_TEXT );

	FontMetrics( &aMetric );

	// *HRO*
	double stretch;

	if (maGraphicsData.mnWidth)
		stretch = double(maGraphicsData.mnWidth) / double(MyFixedToInt(aMetric.widMax));
	else
		stretch = 1.0;

	if ( nChar2 > (USHORT)0x00FF )
		nChar2 = (USHORT)0x00FF;

	i = (long)nChar2 - (long)nChar1 + 1;

	if ( aMetric.wTabHandle == 0L || nChar1 > nChar2 )
	{	for ( ; i > 0; i--)
		{	*pWidthAry++ = 0;
		}
		return 1;
	}

	// Hier muss noch ein Umrechnungsfaktor ausgerechnet werden
	HLock( aMetric.wTabHandle );
	pTable = (WidthTable *) *( aMetric.wTabHandle );
	Fixed *pWidth = &pTable->tabData[nChar1];

	// Wenn die Ausgabescalierung nicht 1 (16Bit Fixed 1) ist,
	// dann muessen wir die Scalierung noch mal aendern
	if ( pTable->vOutput != 0x0100 )
	{	// scale factor != 1
		nFactor = pTable->vOutput << 8;
		for ( ; i > 0; i-- )
		{
			nWidth = *pWidth++;
			nWidth = FixMul( nWidth, nFactor );
			*pWidthAry = (long)MyFixedToInt( nWidth );

			// *HRO*
			*pWidthAry = long(double(*pWidthAry) * stretch);

			pWidthAry++;
		}
	}
	else
	{	// scale factor == 1
		for ( ; i > 0; i-- )
		{
			nWidth = *pWidth++;
			*pWidthAry = (long)MyFixedToInt( nWidth );

			// *HRO*
			*pWidthAry = long(double(*pWidthAry) * stretch);

			pWidthAry++;
		}
	}

	HUnlock( aMetric.wTabHandle );
	return 1;
}

// -----------------------------------------------------------------------
// last changed:	dv	30.09.97

void SalGraphics::GetFontMetric( ImplFontMetricData* pMetric )
{
	FMetricRec		aMetric;
	memset ( pMetric, 0, sizeof( ImplFontMetricData ) );

	maGraphicsData.CheckDrawMode( DRAW_TEXT );

	FontMetrics( &aMetric );

	// die Fontbreite moeglichst nicht setzen, da sonst die Ausgabe kompliziert
	// wird
	if (maGraphicsData.mnWidth)
		pMetric->mnWidth		= maGraphicsData.mnWidth;
	else
		pMetric->mnWidth		= MyFixedToInt(aMetric.widMax);
	pMetric->mnAscent			= MyFixedToInt( aMetric.ascent ) /*+ MyFixedToInt(aMetric.leading)*/;
	pMetric->mnDescent			= MyFixedToInt( aMetric.descent );


// Das External-Leading vom MAC ignorieren
//	pMetric->mnLeading			= MyFixedToInt( aMetric.leading );


// Jetzt kommt der Hack

	int nPixelHeight = pMetric->mnAscent + pMetric->mnDescent; // Summe aus A + D
	int nPointHeight = maGraphicsData.mnHeight;
	int nDiffHeight = nPixelHeight - nPointHeight;
	int nPoint10 = (nPointHeight * 10 + 50) / 100;

	if ( abs(nDiffHeight) < nPoint10)
	{
// progressiv !!!
		pMetric->mnAscent +=  (nPointHeight * 125 + 500) / 1000;
	}

	pMetric->mnLeading = (pMetric->mnAscent + pMetric->mnDescent) - nPointHeight;

	pMetric->mnSlant			= 0;								// NYI
	pMetric->mnFirstChar		= 0;								// NYI
	pMetric->mnLastChar 		= 0xFF; 							// NYI

	pMetric->maName 			= ImplGetFontName( maGraphicsData.mnFontNum );
	pMetric->maStyleName		= "Normal";                         // NYI
	pMetric->mnOrientation		= 0;
	pMetric->meFamily			= ImplGetFamilyFromID( maGraphicsData.mnFontNum );

	/* Gesetzer Font wird noch ignoriert, muss alles noch geaendert werden von TH
	pMetric->meCharSet			= maGraphicsData.meCharSet; */

	pMetric->meCharSet			= CHARSET_MAC;

	if ( maGraphicsData.mnFontFace & bold )
		pMetric->meWeight		= WEIGHT_BOLD;
	else
		pMetric->meWeight		= WEIGHT_NORMAL;

	if ( maGraphicsData.mnFontFace & italic )
		pMetric->meItalic		= ITALIC_NORMAL;
	else
		pMetric->meItalic		= ITALIC_NONE;

	if ( CharWidth( 'm' ) == CharWidth( 'i' ) )
		pMetric->mePitch		= PITCH_FIXED;
	else
		pMetric->mePitch		= PITCH_VARIABLE;

	if ( RealFont( maGraphicsData.mnFontNum, 25 ) )
		pMetric->meType 		= TYPE_SCALABLE;
	else
		pMetric->meType 		= TYPE_RASTER;

	pMetric->mbDevice			= TRUE;
}

// -----------------------------------------------------------------------

ULONG SalGraphics::GetKernPairs( ULONG nPairs, ImplKernPairData* pKernPairs )
{
	DBG_ERROR( "SalGraphics::GetKernPairs NYI !!!");
	return 0L;
}

// -----------------------------------------------------------------------

ULONG SalGraphics::GetFontCodeRanges( sal_uInt32* pCodePairs ) const
{
	// TODO: try to get the necessary info
	return 0;
}

// -----------------------------------------------------------------------
// last changed:	dv	27.09.97

void SalGraphics::GetDevFontList( ImplDevFontList* pList )
{
	SalData 		*pSalData = GetSalData();
	FontList		*pMacList;
	ImplFontData	*pDevFontData;
	ImplFontData	*pSysFontData;

	if ( ! pSalData->mpFontList )
	{
		pSalData->mpFontList = ImplInitFontList();
	}

	pMacList = pSalData->mpFontList;
	pSysFontData = pMacList->First();

	while ( pSysFontData )
	{
		pDevFontData = new ImplFontData;
		pDevFontData->mpSysData 	= pSysFontData;
		pDevFontData->maName		= pSysFontData->maName;
		pDevFontData->maStyleName	= pSysFontData->maStyleName;
		pDevFontData->maScript		= pSysFontData->maScript;
		pDevFontData->mnWidth		= pSysFontData->mnWidth;
		pDevFontData->mnHeight		= pSysFontData->mnHeight;
		pDevFontData->meFamily		= pSysFontData->meFamily;
		pDevFontData->meCharSet 	= pSysFontData->meCharSet;
		pDevFontData->mePitch		= pSysFontData->mePitch;
		pDevFontData->meWidthType	= pSysFontData->meWidthType;
		pDevFontData->meWeight		= pSysFontData->meWeight;
		pDevFontData->meItalic		= pSysFontData->meItalic;
		pDevFontData->meType		= pSysFontData->meType;
		pDevFontData->mbOrientation = pSysFontData->mbOrientation;
		pDevFontData->mbDevice		= pSysFontData->mbDevice;

		pList->Add( pDevFontData );

		pSysFontData = pMacList->Next();
	}
}

// -----------------------------------------------------------------------
// last changed:	dv	30.09.97

void SalGraphics::DrawText( long nX, long nY, const xub_Unicode* pStr, USHORT nLen )
{
	DBG_ASSERT( nLen && pStr, "DrawText: Nichts da zum ausgeben!" );

	maGraphicsData.CheckDrawMode( DRAW_TEXT );


	FMetricRec		aMetric;
	FontMetrics(&aMetric);
	// *HRO*

	// Startpunkt setzen
	MoveTo ( nX, nY );

	if ( maGraphicsData.mnWidth )		// wenn wir eine Text-Breite haben,
	{									// dann muessen wir den Text mit StdText ausgeben
		MAC_Point	aNumer;
		MAC_Point	aDenom;

		aNumer.v = 1;
		aDenom.v = 1;
		aNumer.h = (short) maGraphicsData.mnWidth;
//		aDenom.h = CharWidth( 'n' );                // 'x' oder 'n' oder ???
		aDenom.h = MyFixedToInt(aMetric.widMax);

		if ( maGraphicsData.mpGrafPort->grafProcs )
		{
			QDTextUPP pTextProc = maGraphicsData.mpGrafPort->grafProcs->textProc;
			CallQDTextProc( pTextProc, nLen, (char *)pStr, aNumer, aDenom );
		}
		else
			StdText( nLen, (char *)pStr, aNumer, aDenom );
	}
	else
	{
		::DrawText( pStr, 0, nLen );
	}
}

// -----------------------------------------------------------------------
// last changed:	hro 15.01.98

void SalGraphics::DrawTextArray( long nX, long nY,
							const xub_Unicode* pStr, USHORT nLen,
							const long* pDXAry )
{
	DBG_ASSERT( nLen && pStr, "DrawText: Nichts da zum ausgeben!" );
	DBG_ASSERT( pDXAry && ( nLen > 1), "DrawText: Keine Positionen da!" );

	//	Wenn wir kein Positionsarray haben, dann geben wir den Text mit DrawText aus.
	if (  !pDXAry || ( nLen == 1 ) )
	{
		DrawText( nX, nY, pStr, nLen );
		return;
	}

	USHORT	i;

	maGraphicsData.CheckDrawMode( DRAW_TEXT );

	FMetricRec		aMetric;
	FontMetrics(&aMetric);
	// *HRO*

	if ( maGraphicsData.mnWidth || maGraphicsData.mbPrinter )
	{	// wenn wir eine Text-Breite haben oder einen Drucker,
		// dann muessen wir den Text mit StdText ausgeben. (Fuer Drucker gilt
		// die FMetricRec nicht (glaube ich)

		QDTextUPP	pTextProc = NULL;
		MAC_Point	aNumer, aDenom;

		aNumer.v = 1;
		aDenom.v = 1;

		// Wenn wir eine Breite fuer den Font haben, dann wird die Ausgabe
		// entsprechend scaliert, ansonsten nehmen wir 1:1

		if ( maGraphicsData.mnWidth )
		{
			aNumer.h = (short) maGraphicsData.mnWidth;
//			aDenom.h = CharWidth( 'n' );                // !!! vielleicht auch x statt n
			aDenom.h = MyFixedToInt(aMetric.widMax);
		}
		else
		{
			aNumer.h = 1;
			aDenom.h = 1;
		}

		// ACHTUNG, ich weiss nicht, ob die Drucker immer einen CGrafPort
		// haben und ob man den Port einfach casten kann.
		if ( maGraphicsData.mpGrafPort->grafProcs )
			pTextProc = maGraphicsData.mpGrafPort->grafProcs->textProc;

		MoveTo ( nX, nY );

		if ( pTextProc )
		{
			CallQDTextProc( pTextProc, 1, pStr++, aNumer, aDenom );
			for ( i = 0; i < nLen - 1; i++ )
			{
				MoveTo ( nX + (short) *( pDXAry + i ), nY );
				CallQDTextProc( pTextProc, 1, pStr++, aNumer, aDenom );
			}
		}
		else
		{
			StdText( 1, pStr++, aNumer, aDenom );
			for ( i = 0; i < nLen - 1; i++ )
			{
				MoveTo ( nX + (short) *( pDXAry + i ), nY );
				StdText( 1, pStr++, aNumer, aDenom );
			}
		}
	}
	else
	{
		FMetricRec	aMetric;
		WidthTable	*pTable;
		short		nNextStart = nX;
		USHORT		nNextCharPos = 0;

		FontMetrics( &aMetric );
		HLock( aMetric.wTabHandle );
		pTable = (WidthTable *) *( aMetric.wTabHandle );

		for ( i = 0; i < nLen; )
		{
			Fixed	nWidth = 0;
			short	nLastWordEnd, nWordEnd, nDiff;
			USHORT	nCharAnz = 0;

			nLastWordEnd = nNextStart;

			do
			{
				if ( i < nLen - 1 )
				{
					nNextStart = nX + (short) *( pDXAry + i );
					nWidth += pTable->tabData[ (unsigned char) pStr[i] ];
					nWordEnd = nLastWordEnd + MyFixedToInt( nWidth );
					nDiff = nNextStart - nWordEnd;
//					if ( nDiff < 0 )				// wenn man +/- 1 Pixel Abweichung erlaubt,
//						nDiff = - nDiff;			// dann wieder einkommentieren
				}
				nCharAnz ++;
				i++;
			} while ( ( i < nLen ) && ( nDiff == 0 ) );

			MoveTo( nLastWordEnd, nY );

			if ( nCharAnz == 1 )
				DrawChar( (short) * ( pStr + nNextCharPos ) );
			else
				::DrawText( pStr + nNextCharPos, 0, nCharAnz );

			nNextCharPos += nCharAnz;
		}
		HUnlock( aMetric.wTabHandle );
	}
}
