/*************************************************************************
 *
 *  $RCSfile: rmwindow.cxx,v $
 *
 *  $Revision: 1.16.2.1 $
 *
 *  last change: $Author: mh $ $Date: 2002/05/24 14:10:49 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <rmwindow.hxx>
#include <rmevents.hxx>
#include <xevthdl.hxx>
#include <svdata.hxx>
#include <rmcache.hxx>
#include <font.hxx>
#include <unotools/atom.hxx>
#include <com/sun/star/portal/client/FontAtomType.hpp>
#include <rtl/ustring.hxx>
#ifndef _ISOLANG_HXX
#include <tools/isolang.hxx>
#endif

#ifndef _RMDRGSRC_HXX_ 
#include <rmdrgsrc.hxx>
#endif

#ifndef _RMDRPTGT_HXX_ 
#include <rmdrptgt.hxx>
#endif

using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::datatransfer::dnd;
using namespace utl;

static ::vcl::InterfacePairCache< ::com::sun::star::portal::client::XRmFrameWindow, ::com::sun::star::portal::client::XRmOutputDevice >* pRemoteWindowCache = NULL;
typedef  ::std::pair< ::com::sun::star::uno::Reference< ::com::sun::star::portal::client::XRmFrameWindow >, ::com::sun::star::uno::Reference< ::com::sun::star::portal::client::XRmOutputDevice > > windowInterfacePair;

void createRemoteWindowCache( const ::com::sun::star::uno::Sequence< ::com::sun::star::uno::Any >& aInterfaceSeq )
{
	if( !pRemoteWindowCache )
	{
		ImplSVData* pSVData = ImplGetSVData();
		pRemoteWindowCache = new ::vcl::InterfacePairCache< ::com::sun::star::portal::client::XRmFrameWindow, ::com::sun::star::portal::client::XRmOutputDevice >(
			pSVData->mxMultiFactory, 
			aInterfaceSeq, 
			::rtl::OUString::createFromAscii( "OfficeWindow.stardiv.de" ), 5, 20 );
	}
}

void eraseRemoteWindowCache()
{
	if( pRemoteWindowCache )
	{
		delete pRemoteWindowCache;
		pRemoteWindowCache = NULL;
	}
}

// -----------------
// - RmFrameWindow -
// -----------------

RmFrameWindow::RmFrameWindow( Window* pServerWindow ) :
	mpEvtHdl( 0 ),
	mePtrStyle( POINTER_ARROW ),
    mbInEvtHandler( false ),
    mbInDragMode ( false )
{
	windowInterfacePair aPair = pRemoteWindowCache->takeInterface();
	mxFrameWindow = aPair.first;
	mxOutputDevice = aPair.second;
	
	mpEvtHdl = (XRmsEventHdl*) new XRmsEventHdl( pServerWindow );
	mxEventHdl = Reference< ::com::sun::star::portal::client::XEventHdl >( mpEvtHdl );

    ImplSVData* pSVData = ImplGetSVData();
	mpAtoms = pSVData->mpAtoms;
}

// -----------------------------------------------------------------------------

RmFrameWindow::~RmFrameWindow()
{
	// jbu  : tell the event handler, that the window is no longer valid.
	Window* pServerWindow = mpEvtHdl->getWindow();
	mpEvtHdl->setWindow(0);
	
	CHECK_FOR_RVPSYNC_NORMAL();
    try
    {
	    mxFrameWindow->ReleaseWindow();
    }
    catch( RuntimeException &e )
    {
        rvpExceptionHandler();
    }
	ImplSVData* pSVData = ImplGetSVData();
	pSVData->mpRmEventQueue->RemoveWindowEvents( pServerWindow );
	if( pRemoteWindowCache )
	{
		windowInterfacePair aPair( mxFrameWindow, mxOutputDevice );
		pRemoteWindowCache->putInterface( aPair );
	}

//#ifdef DEBUG
	mpEvtHdl = NULL;
	mxFrameWindow.clear();
	mxOutputDevice.clear();
	mxEventHdl.clear();
//#endif
}

// -----------------------------------------------------------------------------

void RmFrameWindow::EnableDragMode( BOOL bEnable )
{
    if( mbInDragMode != bEnable )
    {
        mbInDragMode = bEnable;

        if( mxFrameWindow.is() )
        {
    		CHECK_FOR_RVPSYNC_NORMAL();
            
            try
            {
                mxFrameWindow->SetPointer( bEnable ? meDragPtrStyle : mePtrStyle );
            }

            catch( RuntimeException &e )
            {
                rvpExceptionHandler();
            }
        }
    }
}

// -----------------------------------------------------------------------------

ULONG RmFrameWindow::InsertUserEventLink( const Link& rLink )
{
	return maEvents.Insert( new Link( rLink ) );
}

// -----------------------------------------------------------------------------

void RmFrameWindow::Create( ULONG nWinBits, const REF( NMSP_CLIENT::XEventHdl )& rxEventInterface, const ::com::sun::star::uno::Any& aSystemWorkWindowToken, const REF( NMSP_CLIENT::XRmFrameWindow )& xParent )
{
	if( mxFrameWindow.is() )
	{
		CHECK_FOR_RVPSYNC_NORMAL();
        try
        {
		    mxFrameWindow->Create( nWinBits, rxEventInterface, aSystemWorkWindowToken, xParent );
        }
        catch( RuntimeException &e )
        {
            rvpExceptionHandler();
        }
	}
}

// -----------------------------------------------------------------------------

void RmFrameWindow::SetTitle( const OUSTRING& rTitle )
{
	if( mxFrameWindow.is() )
	{
		CHECK_FOR_RVPSYNC_NORMAL();
        try
        {
		    mxFrameWindow->SetTitle( rTitle );
        }
        catch( RuntimeException &e )
        {
            rvpExceptionHandler();
        }
	}
}

// -----------------------------------------------------------------------------

void RmFrameWindow::Show( BOOL bVisible )
{
	if( mxFrameWindow.is() )
	{
		CHECK_FOR_RVPSYNC_NORMAL();
        try
        {
		    mxFrameWindow->Show( bVisible );
        }
        catch( RuntimeException &e )
        {
            rvpExceptionHandler();
        }
	}
}

// -----------------------------------------------------------------------------

void RmFrameWindow::SetPosSize( sal_Int16 nX, sal_Int16 nY, sal_Int16 nWidth, sal_Int16 nHeight, USHORT nFlags )
{
	if( mxFrameWindow.is() )
	{
		CHECK_FOR_RVPSYNC_NORMAL();
        try
        {
		    mxFrameWindow->SetPosSize( nX, nY, nWidth, nHeight, nFlags );
        }
        catch( RuntimeException &e )
        {
            rvpExceptionHandler();
        }
	}
}

// -----------------------------------------------------------------------------

void RmFrameWindow::SetClientSize( sal_Int16 nWidth, sal_Int16 nHeight )
{
	if( mxFrameWindow.is() )
	{
		CHECK_FOR_RVPSYNC_NORMAL();
        try
        {
		    mxFrameWindow->SetClientSize( nWidth, nHeight );
        }
        catch( RuntimeException &e )
        {
            rvpExceptionHandler();
        }
	}
}

// -----------------------------------------------------------------------------

void RmFrameWindow::GetClientSize( sal_Int32& rWidth, sal_Int32& rHeight )
{
	sal_Int16 nWidth = 0, nHeight = 0;
	if( mxFrameWindow.is() )
	{
		CHECK_FOR_RVPSYNC_NORMAL();
        try
        {
		    mxFrameWindow->GetClientSize( nWidth, nHeight );
        }
        catch( RuntimeException &e )
        {
            rvpExceptionHandler();
            nWidth = nHeight = 0;
        }
	}
	rWidth = nWidth;
	rHeight = nHeight;
}

// -----------------------------------------------------------------------------

String RmFrameWindow::GetWindowState()
{
	String aRet;

	if( mxFrameWindow.is() )
	{
		CHECK_FOR_RVPSYNC_NORMAL();
        try
        {
		    aRet = mxFrameWindow->GetWindowState();
        }
        catch( RuntimeException &e )
        {
            rvpExceptionHandler();
            aRet = String();
        }
	}

	return aRet;
}

// -----------------------------------------------------------------------------

void RmFrameWindow::SetWindowState( const String& rState )
{
	if( mxFrameWindow.is() )
	{
		CHECK_FOR_RVPSYNC_NORMAL();
        try
        {
		    mxFrameWindow->SetWindowState( rState );
        }
        catch( RuntimeException &e )
        {
            rvpExceptionHandler();
        }
	}
}

// -----------------------------------------------------------------------------

void RmFrameWindow::GetFontResolution( long& rDPIX, long& rDPIY )
{
	if( mxFrameWindow.is() )
	{
		CHECK_FOR_RVPSYNC_NORMAL();
        try
        {
		    mxFrameWindow->GetFontResolution( rDPIX, rDPIY );
        }
        catch( RuntimeException &e )
        {
            rvpExceptionHandler();
            rDPIX = rDPIY = 0;
        }
	}
}

// -----------------------------------------------------------------------------

::com::sun::star::portal::client::RmFrameResolutions RmFrameWindow::GetFrameResolutions()
{
	if ( mxFrameWindow.is() )
	{
		CHECK_FOR_RVPSYNC_NORMAL();
        try
        {
		    return mxFrameWindow->GetFrameResolutions();
        }
        catch( RuntimeException &e )
        {
            rvpExceptionHandler();
            return ::com::sun::star::portal::client::RmFrameResolutions();
        }
	}
	else return ::com::sun::star::portal::client::RmFrameResolutions();
}

// -----------------------------------------------------------------------------

void RmFrameWindow::ToTop( sal_uInt16 nFlags )
{
	if( mxFrameWindow.is() )
	{
		CHECK_FOR_RVPSYNC_NORMAL();
        try
        {
		    mxFrameWindow->ToTop( nFlags );
        }
        catch( RuntimeException &e )
        {
            rvpExceptionHandler();
        }
	}
}

// -----------------------------------------------------------------------------

void RmFrameWindow::StartPresentation( BOOL bStart, sal_uInt16 nStartFlags )
{
	if( mxFrameWindow.is() )
	{	
		CHECK_FOR_RVPSYNC_NORMAL();
        try
        {
		    mxFrameWindow->StartPresentation( bStart, nStartFlags );
        }
        catch( RuntimeException &e )
        {
            rvpExceptionHandler();
        }
	}
}

// -----------------------------------------------------------------------------

void RmFrameWindow::SetAlwaysOnTop( BOOL bOnTop )
{
	if( mxFrameWindow.is() )
	{
		CHECK_FOR_RVPSYNC_NORMAL();
        try
        {
		    mxFrameWindow->SetAlwaysOnTop( bOnTop );
        }
        catch( RuntimeException &e )
        {
            rvpExceptionHandler();
        }
	}
}

// -----------------------------------------------------------------------------

void RmFrameWindow::ShowFullScreen( BOOL bFullScreen )
{
	if( mxFrameWindow.is() )
	{
		CHECK_FOR_RVPSYNC_NORMAL();
        try
        {
		    mxFrameWindow->ShowFullScreen( bFullScreen );
        }
        catch( RuntimeException &e )
        {
            rvpExceptionHandler();
        }
	}
}

// -----------------------------------------------------------------------------

void RmFrameWindow::CaptureMouse( BOOL bMouse )
{
	if( mxFrameWindow.is() )
	{
		CHECK_FOR_RVPSYNC_NORMAL();
        try
        {
		    mxFrameWindow->CaptureMouse( bMouse );
        }
        catch( RuntimeException &e )
        {
            rvpExceptionHandler();
        }
	}
}

// -----------------------------------------------------------------------------

void RmFrameWindow::SetPointer( PointerStyle ePointerStyle )
{
	if( mxFrameWindow.is() && ePointerStyle != mePtrStyle )
	{
		mePtrStyle = ePointerStyle;

        if( !mbInDragMode )
        {
		    CHECK_FOR_RVPSYNC_NORMAL();
            try
            {
		        mxFrameWindow->SetPointer( ePointerStyle );
            }
            catch( RuntimeException &e )
            {
                rvpExceptionHandler();
            }
        }
	}
}

// -----------------------------------------------------------------------------

void RmFrameWindow::SetDragPointer( PointerStyle ePointerStyle )
{
	if( mxFrameWindow.is() && ePointerStyle != mePtrStyle )
	{
		meDragPtrStyle = ePointerStyle;

        if( mbInDragMode )
        {
		    CHECK_FOR_RVPSYNC_NORMAL();
            try
            {
		        mxFrameWindow->SetPointer( ePointerStyle );
            }

            catch( RuntimeException &e )
            {
                rvpExceptionHandler();
            }
        }
	}
}

// -----------------------------------------------------------------------------

void RmFrameWindow::SetPointerPos( sal_Int16 nX, sal_Int16 nY )
{
	if( mxFrameWindow.is() )
	{
		CHECK_FOR_RVPSYNC_NORMAL();
        try
        {
		    mxFrameWindow->SetPointerPos( nX, nY );
        }
        catch( RuntimeException &e )
        {
            rvpExceptionHandler();
        }
	}
}

// -----------------------------------------------------------------------------

void RmFrameWindow::Beep( SoundType eSoundType )
{
	if( mxFrameWindow.is() )
	{
		CHECK_FOR_RVPSYNC_NORMAL();
        try
        {
		    mxFrameWindow->Beep( eSoundType );
        }
        catch( RuntimeException &e )
        {
            rvpExceptionHandler();
        }
	}
}

// -----------------------------------------------------------------------------

void RmFrameWindow::GetKeyNames( NMSP_CLIENT::KeyNameSequence& rKeyNames )
{
	if( mxFrameWindow.is() )
	{
		CHECK_FOR_RVPSYNC_NORMAL();
        try
        {
		    mxFrameWindow->GetKeyNames( rKeyNames );
        }
        catch( RuntimeException &e )
        {
            rvpExceptionHandler();
            rKeyNames = NMSP_CLIENT::KeyNameSequence();
        }
	}
}

// -----------------------------------------------------------------------------

void RmFrameWindow::Enable( sal_Bool bEnable )
{
	if( mxFrameWindow.is() )
	{
		CHECK_FOR_RVPSYNC_NORMAL();
        try
        {
		    mxFrameWindow->Enable( bEnable );
        }
        catch( RuntimeException &e )
        {
            rvpExceptionHandler();
        }
	}
}

// -----------------------------------------------------------------------------

void RmFrameWindow::SetIcon( sal_Int16 IconID )
{
	if( mxFrameWindow.is() )
	{
		CHECK_FOR_RVPSYNC_NORMAL();
        try
        {
		    mxFrameWindow->SetIcon( IconID );
        }
        catch( RuntimeException &e )
        {
            rvpExceptionHandler();
        }
	}
}

// -----------------------------------------------------------------------------

void RmFrameWindow::SetMinClientSize( sal_Int16 Width, sal_Int16 Height )
{
	if( mxFrameWindow.is() )
	{
		CHECK_FOR_RVPSYNC_NORMAL();
        try
        {
		    mxFrameWindow->SetMinClientSize( Width, Height );
        }
        catch( RuntimeException &e )
        {
            rvpExceptionHandler();
        }
	}
}

// -----------------------------------------------------------------------------

void RmFrameWindow::MouseMoveProcessed()
{
	if( mxFrameWindow.is() )
	{
		mxFrameWindow->MouseMoveProcessed();
	}
}
// -----------------------------------------------------------------------------

void RmFrameWindow::KeyInputProcessed()
{
	if( mxFrameWindow.is() )
	{
		mxFrameWindow->KeyInputProcessed();
	}
}

// -----------------------------------------------------------------------------

void  RmFrameWindow::SetInputContext( const Font& rFont, ULONG rOptions)
{

	if( mxFrameWindow.is() )
	{
		NMSP_CLIENT::IDLFont aIDLFont;
        
		aIDLFont.mnName 		= mpAtoms->getAtom( NMSP_CLIENT::FontAtomType::NAME, rFont.GetName(), sal_True );
    
		aIDLFont.mnStyleName	= mpAtoms->getAtom( NMSP_CLIENT::FontAtomType::STYLE, rFont.GetStyleName(), sal_True );
		aIDLFont.mnWidth		= rFont.GetWidth();
		aIDLFont.mnHeight		= rFont.GetHeight();
		aIDLFont.meFamily		= (UINT16)rFont.GetFamily();
		aIDLFont.meCharSet		= (UINT16)rFont.GetCharSet();
		aIDLFont.meWidthType	= (UINT16)rFont.GetWidthType();
		aIDLFont.meWeight		= (UINT16)rFont.GetWeight();
		aIDLFont.meItalic		= (UINT16)rFont.GetItalic();
		aIDLFont.mePitch		= (UINT16)rFont.GetPitch();
		aIDLFont.mnOrientation	= rFont.GetOrientation();
        aIDLFont.meLanguage         = ConvertLanguageToIsoString( rFont.GetLanguage() );
        aIDLFont.mbVertical         = rFont.IsVertical();
        aIDLFont.mbNonAntialiased   = 0;

		CHECK_FOR_RVPSYNC_NORMAL();
        try
        {
		    mxFrameWindow->SetInputContext( aIDLFont, rOptions );
        }
        catch( RuntimeException &e )
        {
            rvpExceptionHandler();
        }
	}
}

// -----------------------------------------------------------------------------

void  RmFrameWindow::EndExtTextInput( USHORT nFlags )
{
	if( mxFrameWindow.is() )
    {
		CHECK_FOR_RVPSYNC_NORMAL();
        try
        {
		    mxFrameWindow->EndExtTextInput( nFlags );
        }
        catch( RuntimeException &e )
        {
            rvpExceptionHandler();
        }
    }
}

// -----------------------------------------------------------------------------
void  RmFrameWindow::SetCursorRect( const Rectangle* pRect, long nExtTextInputWidth )
{
	if( mxFrameWindow.is() )
    {
        Rectangle rRect;
        if( pRect )
            rRect = *pRect;
        if( rRect == mRmCursorData.mRect && 
            nExtTextInputWidth == mRmCursorData.mnCursorExtWidth )
            return;
//        fprintf(stderr, "SetCursorRect: %d %d %d %d (%d)\n", rRect.Left(), rRect.Top(), rRect.GetWidth(), rRect.GetHeight(), nExtTextInputWidth );
		CHECK_FOR_RVPSYNC_NORMAL();
        try
        {
		    mxFrameWindow->SetCursorRect( rRect.Left(), rRect.Top(), rRect.GetWidth(), rRect.GetHeight(), nExtTextInputWidth );
            mRmCursorData.mRect = rRect;
            mRmCursorData.mnCursorExtWidth = nExtTextInputWidth;
        }
        catch( RuntimeException &e )
        {
            rvpExceptionHandler();
        }
    }
}

// -----------------------------------------------------------------------------

void RmFrameWindow::GetDragSourceDropTarget( Reference< XDragSource >& xDragSource, Reference< XDropTarget >& xDropTarget )
{
    ImplSVData * pSVData = ImplGetSVData();
    
    if( ! pSVData->mxServerDragSource.is() )
    {
    	if( mxFrameWindow.is() )
            mxFrameWindow->GetDragSourceDropTarget( xDragSource, xDropTarget );
            
        if( ! xDragSource.is() )
            pSVData->mxServerDragSource = new RmDragSource();
    }
    
    if( ! xDragSource.is() )
    {
        xDragSource = pSVData->mxServerDragSource;
        xDropTarget = new RmDropTarget();
    }
}

// -----------------------------------------------------------------------------

void RmFrameWindow::GetWorkArea( Rectangle& rRect )
{
    ImplSVData* pSVData = ImplGetSVData();
	if( pSVData->maWorkArea.IsEmpty() )
	{
		if ( pSVData->mxStatus.is() )
		{
			sal_Int16 left, right, top, bottom;
			CHECK_FOR_RVPSYNC_NORMAL();
			try
			{
				pSVData->mxStatus->GetWorkArea( left, right, top, bottom );
				pSVData->maWorkArea = Rectangle( left, top, right, bottom );			
			}
			catch( RuntimeException &e )
			{
				rvpExceptionHandler();
				// provide some useful data
				pSVData->maWorkArea = Rectangle( 0, 0, 800, 600 );
			}
		}
	}
	rRect = pSVData->maWorkArea;
}

// -----------------------------------------------------------------------------
