/*************************************************************************
 *
 *  $RCSfile: kdeint.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: pl $ $Date: 2001/08/20 11:05:09 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#include <sys/types.h>
#include <sys/stat.h>
#include <stdlib.h>
#include <unistd.h>
#include <salunx.h>
#include <X11/Xatom.h>

#include <saldisp.hxx>
#include <salframe.hxx>
#include <kdeint.hxx>
#include <config.hxx>

#include <osl/file.hxx>

#ifndef _STREAM_HXX
#include <tools/stream.hxx>
#endif

#include <tools/fsys.hxx>

#include <tools/urlobj.hxx>

#include <strhelper.hxx>

#define NO_DEFAULT_ICON

using namespace rtl;
using namespace osl;

KDEIntegrator::KDEIntegrator( SalFrame* pFrame ) :
		DtIntegrator( pFrame )
{
	meType = DtKDE;
}

KDEIntegrator::~KDEIntegrator()
{
}

BOOL KDEIntegrator::GetSystemLook( SystemLookInfo& rInfo )
{
	BOOL bRet = FALSE;
    rtl_TextEncoding aEncoding = osl_getThreadTextEncoding();

	String aFile( aHomeDir );
	aFile.AppendAscii("/.kderc");

    if( access( ByteString( aFile, aEncoding ).GetBuffer(), F_OK ) )
    {
        aFile = aHomeDir;
        aFile.AppendAscii("/.kde2/share/config/kdeglobals");
        if( access( ByteString( aFile, aEncoding ).GetBuffer(), F_OK ) )
            return FALSE;
    }

	Config aConfig( aFile );

	ByteString aLine;
	if( aConfig.HasGroup( "WM" ) )
	{
		aConfig.SetGroup( "WM" );
		bRet = TRUE;

		aLine = aConfig.ReadKey( "activeBackground" );
		if( aLine.GetTokenCount( ',' ) >= 3 )
			rInfo.windowActiveStart =
				Color( aLine.GetToken( 0, ',' ).ToInt32(),
					   aLine.GetToken( 1, ',' ).ToInt32(),
				   	   aLine.GetToken( 2, ',' ).ToInt32() );
		aLine = aConfig.ReadKey( "activeBlend" );
		if( aLine.GetTokenCount( ',' ) >= 3 )
			rInfo.windowActiveEnd =
				Color( aLine.GetToken( 0, ',' ).ToInt32(),
					   aLine.GetToken( 1, ',' ).ToInt32(),
				   	   aLine.GetToken( 2, ',' ).ToInt32() );

		aLine = aConfig.ReadKey( "inactiveBackground" );
		if( aLine.GetTokenCount( ',' ) >= 3 )
			rInfo.windowInactiveStart =
				Color( aLine.GetToken( 0, ',' ).ToInt32(),
					   aLine.GetToken( 1, ',' ).ToInt32(),
					   aLine.GetToken( 2, ',' ).ToInt32() );
		aLine = aConfig.ReadKey( "inactiveBlend" );
		if( aLine.GetTokenCount( ',' ) >= 3 )
			rInfo.windowInactiveEnd =
				Color( aLine.GetToken( 0, ',' ).ToInt32(),
					   aLine.GetToken( 1, ',' ).ToInt32(),
					   aLine.GetToken( 2, ',' ).ToInt32() );

		aLine = aConfig.ReadKey( "inactiveForeground" );
		if( aLine.GetTokenCount( ',' ) >= 3 )
			rInfo.inactiveForeground =
				Color( aLine.GetToken( 0, ',' ).ToInt32(),
					   aLine.GetToken( 1, ',' ).ToInt32(),
					   aLine.GetToken( 2, ',' ).ToInt32() );
		aLine = aConfig.ReadKey( "activeForeground" );
		if( aLine.GetTokenCount( ',' ) >= 3 )
			rInfo.activeForeground = Color(
				aLine.GetToken( 0, ',' ).ToInt32(),
				aLine.GetToken( 1, ',' ).ToInt32(),
				aLine.GetToken( 2, ',' ).ToInt32() );

		aLine = aConfig.ReadKey( "titleFont" );
		rInfo.windowFont = String( aLine, gsl_getSystemTextEncoding() );
	}

	if( aConfig.HasGroup( "General" ) )
	{
		aConfig.SetGroup( "General" );
		bRet = TRUE;

		aLine = aConfig.ReadKey( "foreground" );
		if( aLine.GetTokenCount( ',' ) >= 3 )
			rInfo.foreground = Color(
				aLine.GetToken( 0, ',' ).ToInt32(),
				aLine.GetToken( 1, ',' ).ToInt32(),
				aLine.GetToken( 2, ',' ).ToInt32() );
		aLine = aConfig.ReadKey( "background" );
		if( aLine.GetTokenCount( ',' ) >= 3 )
			rInfo.background = Color(
				aLine.GetToken( 0, ',' ).ToInt32(),
				aLine.GetToken( 1, ',' ).ToInt32(),
				aLine.GetToken( 2, ',' ).ToInt32() );

		aLine = aConfig.ReadKey( "selectForeground" );
		if( aLine.GetTokenCount( ',' ) >= 3 )
			rInfo.selectForeground = Color(
				aLine.GetToken( 0, ',' ).ToInt32(),
				aLine.GetToken( 1, ',' ).ToInt32(),
				aLine.GetToken( 2, ',' ).ToInt32() );
		aLine = aConfig.ReadKey( "selectBackground" );
		if( aLine.GetTokenCount( ',' ) >= 3 )
			rInfo.selectBackground = Color(
				aLine.GetToken( 0, ',' ).ToInt32(),
				aLine.GetToken( 1, ',' ).ToInt32(),
				aLine.GetToken( 2, ',' ).ToInt32() );

		aLine = aConfig.ReadKey( "font" );
		rInfo.controlFont = String( aLine, gsl_getSystemTextEncoding() );
	}

	return bRet;
}
