/*************************************************************************
 *
 *  $RCSfile: salpimp1.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 17:05:43 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
extern Pixel XSalBlackPixel( Display * arg1, int arg2 )
{
    if ( IsDisplay( arg1 ) )
        return BlackPixel( arg1, arg2 );
    else
#ifdef PRINTER_IMPLEMENTATION
        return XpBlackPixel( arg1, arg2 );
#else
        return 0;
#endif
}


extern Colormap XSalDefaultColormap( Display * arg1, int arg2 )
{
    if ( IsDisplay( arg1 ) )
        return DefaultColormap( arg1, arg2 );
    else
#ifdef PRINTER_IMPLEMENTATION
        return XpDefaultColormap( arg1, arg2 );
#else
        return 0;
#endif
}


extern int XSalDefaultDepth( Display * arg1, int arg2 )
{
    if ( IsDisplay( arg1 ) )
        return DefaultDepth( arg1, arg2 );
    else
#ifdef PRINTER_IMPLEMENTATION
        return XpDefaultDepth( arg1, arg2 );
#else
        return 0;
#endif
}


extern int XSalDefaultScreen( Display * arg1 )
{
    if ( IsDisplay( arg1 ) )
        return DefaultScreen( arg1 );
    else
#ifdef PRINTER_IMPLEMENTATION
        return XpDefaultScreen( arg1 );
#else
        return 0;
#endif
}


extern Screen* XSalDefaultScreenOfDisplay( Display * arg1 )
{
    return DefaultScreenOfDisplay( arg1 );
}


extern int XSalDisplayHeight( Display * arg1, int arg2 )
{
    if ( IsDisplay( arg1 ) )
        return DisplayHeight( arg1, arg2 );
    else
#ifdef PRINTER_IMPLEMENTATION
        return XpDisplayHeight( arg1, arg2 );
#else
        return 0;
#endif
}


extern int XSalDisplayHeightMM( Display * arg1, int arg2 )
{
    if ( IsDisplay( arg1 ) )
        return DisplayHeightMM( arg1, arg2 );
    else
#ifdef PRINTER_IMPLEMENTATION
        return XpDisplayHeightMM( arg1, arg2 );
#else
        return 0;
#endif
}


extern int XSalDisplayWidth( Display * arg1, int arg2 )
{
    if ( IsDisplay( arg1 ) )
        return DisplayWidth( arg1, arg2 );
    else
#ifdef PRINTER_IMPLEMENTATION
        return XpDisplayWidth( arg1, arg2 );
#else
        return 0;
#endif
}


extern int XSalDisplayWidthMM( Display * arg1, int arg2 )
{
    if ( IsDisplay( arg1 ) )
        return DisplayWidthMM( arg1, arg2 );
    else
#ifdef PRINTER_IMPLEMENTATION
        return XpDisplayWidthMM( arg1, arg2 );
#else
        return 0;
#endif
}


XLIB_Window XSalRootWindow( Display * arg1, int arg2 )
{
    if ( IsDisplay( arg1 ) )
        return RootWindow( arg1, arg2 );
    else
#ifdef PRINTER_IMPLEMENTATION
        return XpRootWindow( arg1, arg2 );
#else
        return 0;
#endif
}


extern Pixel XSalWhitePixel( Display * arg1, int arg2 )
{
    if ( IsDisplay( arg1 ) )
        return WhitePixel( arg1, arg2 );
    else
#ifdef PRINTER_IMPLEMENTATION
        return XpWhitePixel( arg1, arg2 );
#else
        return 0;
#endif
}


extern int XSalAllocColor( Display * arg1, Colormap arg2, XColor * arg3 )
{
    if ( IsDisplay( arg1 ) )
        return XAllocColor( arg1, arg2, arg3 );
    else
#ifdef PRINTER_IMPLEMENTATION
        return XpAllocColor( arg1, arg2, arg3 );
#else
        return 0;
#endif
}


int XSalAllocNamedColor( Display * arg1, Colormap arg2, const char * arg3, XColor * arg4, XColor * arg5 )
{
    if ( IsDisplay( arg1 ) )
        return XAllocNamedColor( arg1, arg2, arg3, arg4, arg5 );
    else
#ifdef PRINTER_IMPLEMENTATION
        return XpAllocNamedColor( arg1, arg2, arg3, arg4, arg5 );
#else
        return 0;
#endif
}


int XSalBell( Display * arg1, int arg2 )
{
    return XBell( arg1, arg2 );
}


int XSalChangeActivePointerGrab( Display * arg1, unsigned int arg2, XLIB_Cursor arg3, long unsigned int arg4 )
{
    return XChangeActivePointerGrab( arg1, arg2, arg3, arg4 );
}


int XSalChangeGC( Display * arg1, GC arg2, long unsigned int arg3, XGCValues * arg4 )
{
    if ( IsDisplay( arg1 ) )
        return XChangeGC( arg1, arg2, arg3, arg4 );
    else
#ifdef PRINTER_IMPLEMENTATION
        return XpChangeGC( arg1, arg2, arg3, arg4 );
#else
        return 0;
#endif
}


int XSalCheckIfEvent( Display * arg1, XEvent * arg2, XSalPeekEventPredicate arg3, char * arg4 )
{
    return XCheckIfEvent( arg1, arg2, arg3, arg4 );
}


int XSalCheckMaskEvent( Display * arg1, long int arg2, XEvent * arg3 )
{
    return XCheckMaskEvent( arg1, arg2, arg3 );
}


int XSalCheckTypedEvent( Display * arg1, int arg2, XEvent * arg3 )
{
    return XCheckTypedEvent( arg1, arg2, arg3 );
}


int XSalCheckWindowEvent( Display * arg1, XLIB_Window arg2, long int arg3, XEvent * arg4 )
{
    return XCheckWindowEvent( arg1, arg2, arg3, arg4 );
}


extern int XSalClipBox( XLIB_Region arg1, XRectangle * arg2 )
{
    return XClipBox( arg1, arg2 );
}


extern int XSalCloseDisplay( Display * arg1 )
{
    return XCloseDisplay( arg1 );
}


extern int XSalCopyArea( Display * arg1, Drawable arg2, Drawable arg3, GC arg4, int arg5, int arg6, unsigned int arg7, unsigned int arg8, int arg9, int arg10 )
{
    if ( IsDisplay( arg1 ) )
        return XCopyArea( arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10 );
    else
#ifdef PRINTER_IMPLEMENTATION
        return XpCopyArea( arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10 );
#else
        return 0;
#endif
}


extern Pixmap XSalCreateBitmapFromData( Display * arg1, Drawable arg2, const char * arg3, unsigned int arg4, unsigned int arg5 )
{
    if ( IsDisplay( arg1 ) )
        return XCreateBitmapFromData( arg1, arg2, arg3, arg4, arg5 );
    else
#ifdef PRINTER_IMPLEMENTATION
        return XpCreateBitmapFromData( arg1, arg2, arg3, arg4, arg5 );
#else
        return 0;
#endif
}


extern Colormap XSalCreateColormap( Display * arg1, XLIB_Window arg2, Visual * arg3, int arg4 )
{
    return XCreateColormap( arg1, arg2, arg3, arg4 );
}


extern XLIB_Cursor XSalCreateFontCursor( Display * arg1, unsigned int arg2 )
{
    return XCreateFontCursor( arg1, arg2 );
}


extern GC XSalCreateGC( Display * arg1, Drawable arg2, long unsigned int arg3, XGCValues * arg4 )
{
    if ( IsDisplay( arg1 ) )
        return XCreateGC( arg1, arg2, arg3, arg4 );
    else
#ifdef PRINTER_IMPLEMENTATION
        return XpCreateGC( arg1, arg2, arg3, arg4 );
#else
        return 0;
#endif
}


extern XImage * XSalCreateImage( Display * arg1, Visual * arg2, unsigned int arg3, int arg4, int arg5, char * arg6, unsigned int arg7, unsigned int arg8, int arg9, int arg10 )
{
    if ( IsDisplay( arg1 ) )
        return XCreateImage( arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10 );
    else
#ifdef PRINTER_IMPLEMENTATION
        return XpCreateImage( arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10 );
#else
        return 0;
#endif
}


extern Pixmap XSalCreatePixmap( Display * arg1, Drawable arg2, unsigned int arg3, unsigned int arg4, unsigned int arg5 )
{
    if ( IsDisplay( arg1 ) )
        return XCreatePixmap( arg1, arg2, arg3, arg4, arg5 );
    else
#ifdef PRINTER_IMPLEMENTATION
        return XpCreatePixmap( arg1, arg2, arg3, arg4, arg5 );
#else
        return 0;
#endif
}


extern XLIB_Cursor XSalCreatePixmapCursor( Display * arg1, Pixmap arg2, Pixmap arg3, XColor * arg4, XColor * arg5, unsigned int arg6, unsigned int arg7 )
{
    return XCreatePixmapCursor( arg1, arg2, arg3, arg4, arg5, arg6, arg7 );
}


extern XLIB_Window XSalCreateWindow( Display * arg1, XLIB_Window arg2, int arg3, int arg4, unsigned int arg5, unsigned int arg6, unsigned int arg7, int arg8, unsigned int arg9, Visual * arg10, long unsigned int arg11, XSetWindowAttributes * arg12 )
{
    return XCreateWindow( arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12 );
}


extern int XSalDefineCursor( Display * arg1, XLIB_Window arg2, XLIB_Cursor arg3 )
{
    return XDefineCursor( arg1, arg2, arg3 );
}


extern void XSalDestroyImage( XImage * arg1 )
{
    XDestroyImage( arg1 );
}


extern int XSalDestroyRegion( XLIB_Region arg1 )
{
    return XDestroyRegion( arg1 );
}


extern int XSalDestroyWindow( Display * arg1, XLIB_Window arg2 )
{
    return XDestroyWindow( arg1, arg2 );
}


extern int XSalDrawImageString( Display * arg1, Drawable arg2, GC arg3, int arg4, int arg5, const char * arg6, int arg7 )
{
    if ( IsDisplay( arg1 ) )
        return XDrawImageString( arg1, arg2, arg3, arg4, arg5, arg6, arg7 );
    else
#ifdef PRINTER_IMPLEMENTATION
        return XpDrawImageString( arg1, arg2, arg3, arg4, arg5, arg6, arg7 );
#else
        return 0;
#endif
}


extern int XSalDrawImageString16( Display * arg1, Drawable arg2, GC arg3, int arg4, int arg5, const XChar2b * arg6, int arg7 )
{
    if ( IsDisplay( arg1 ) )
        return XDrawImageString16( arg1, arg2, arg3, arg4, arg5, arg6, arg7 );
    else
#ifdef PRINTER_IMPLEMENTATION
        return XpDrawImageString16( arg1, arg2, arg3, arg4, arg5, arg6, arg7 );
#else
        return 0;
#endif
}


extern int XSalDrawLine( Display * arg1, Drawable arg2, GC arg3, int arg4, int arg5, int arg6, int arg7 )
{
    if ( IsDisplay( arg1 ) )
        return XDrawLine( arg1, arg2, arg3, arg4, arg5, arg6, arg7 );
    else
#ifdef PRINTER_IMPLEMENTATION
        return XpDrawLine( arg1, arg2, arg3, arg4, arg5, arg6, arg7 );
#else
        return 0;
#endif
}


extern int XSalDrawLines( Display * arg1, Drawable arg2, GC arg3, XPoint * arg4, int arg5, int arg6 )
{
    if ( IsDisplay( arg1 ) )
        return XDrawLines( arg1, arg2, arg3, arg4, arg5, arg6 );
    else
#ifdef PRINTER_IMPLEMENTATION
        return XpDrawLines( arg1, arg2, arg3, arg4, arg5, arg6 );
#else
        return 0;
#endif
}


extern int XSalDrawPoint( Display * arg1, Drawable arg2, GC arg3, int arg4, int arg5 )
{
    if ( IsDisplay( arg1 ) )
        return XDrawPoint( arg1, arg2, arg3, arg4, arg5 );
    else
#ifdef PRINTER_IMPLEMENTATION
        return XpDrawPoint( arg1, arg2, arg3, arg4, arg5 );
#else
        return 0;
#endif
}


extern int XSalDrawRectangle( Display * arg1, Drawable arg2, GC arg3, int arg4, int arg5, unsigned int arg6, unsigned int arg7 )
{
    if ( IsDisplay( arg1 ) )
        return XDrawRectangle( arg1, arg2, arg3, arg4, arg5, arg6, arg7 );
    else
#ifdef PRINTER_IMPLEMENTATION
        return XpDrawRectangle( arg1, arg2, arg3, arg4, arg5, arg6, arg7 );
#else
        return 0;
#endif
}


extern int XSalDrawString( Display * arg1, Drawable arg2, GC arg3, int arg4, int arg5, const char * arg6, int arg7 )
{
    if ( IsDisplay( arg1 ) )
        return XDrawString( arg1, arg2, arg3, arg4, arg5, arg6, arg7 );
    else
#ifdef PRINTER_IMPLEMENTATION
        return XpDrawString( arg1, arg2, arg3, arg4, arg5, arg6, arg7 );
#else
        return 0;
#endif
}


extern int XSalDrawString16( Display * arg1, Drawable arg2, GC arg3, int arg4, int arg5, const XChar2b * arg6, int arg7 )
{
    if ( IsDisplay( arg1 ) )
        return XDrawString16( arg1, arg2, arg3, arg4, arg5, arg6, arg7 );
    else
#ifdef PRINTER_IMPLEMENTATION
        return XpDrawString16( arg1, arg2, arg3, arg4, arg5, arg6, arg7 );
#else
        return 0;
#endif
}


extern int XSalDrawText( Display * arg1, Drawable arg2, GC arg3, int arg4, int arg5, XTextItem * arg6, int arg7 )
{
    if ( IsDisplay( arg1 ) )
        return XDrawText( arg1, arg2, arg3, arg4, arg5, arg6, arg7 );
    else
#ifdef PRINTER_IMPLEMENTATION
        return XpDrawText( arg1, arg2, arg3, arg4, arg5, arg6, arg7 );
#else
        return 0;
#endif
}


extern int XSalEmptyRegion( XLIB_Region arg1 )
{
    return XEmptyRegion( arg1 );
}


extern int XSalEventsQueued( Display * arg1, int arg2 )
{
    return XEventsQueued( arg1, arg2 );
}


extern int XSalFillPolygon( Display * arg1, Drawable arg2, GC arg3, XPoint * arg4, int arg5, int arg6, int arg7 )
{
    if ( IsDisplay( arg1 ) )
        return XFillPolygon( arg1, arg2, arg3, arg4, arg5, arg6, arg7 );
    else
#ifdef PRINTER_IMPLEMENTATION
        return XpFillPolygon( arg1, arg2, arg3, arg4, arg5, arg6, arg7 );
#else
        return 0;
#endif
}


extern int XSalFillRectangle( Display * arg1, Drawable arg2, GC arg3, int arg4, int arg5, unsigned int arg6, unsigned int arg7 )
{
    if ( IsDisplay( arg1 ) )
        return XFillRectangle( arg1, arg2, arg3, arg4, arg5, arg6, arg7 );
    else
#ifdef PRINTER_IMPLEMENTATION
        return XpFillRectangle( arg1, arg2, arg3, arg4, arg5, arg6, arg7 );
#else
        return 0;
#endif
}


extern int XSalFlush( Display * arg1 )
{
    if ( IsDisplay( arg1 ) )
        return XFlush( arg1 );
    else
#ifdef PRINTER_IMPLEMENTATION
        return XpFlush( arg1 );
#else
        return 0;
#endif
}


extern int XSalFree( void * arg1 )
{
    return XFree( arg1 );
}


extern int XSalFreeColormap( Display * arg1, Colormap arg2 )
{
    return XFreeColormap( arg1, arg2 );
}


extern int XSalFreeCursor( Display * arg1, XLIB_Cursor arg2 )
{
    return XFreeCursor( arg1, arg2 );
}


extern int XSalFreeFont( Display * arg1, XFontStruct * arg2 )
{
    if ( IsDisplay( arg1 ) )
        return XFreeFont( arg1, arg2 );
    else
#ifdef PRINTER_IMPLEMENTATION
        return XpFreeFont( arg1, arg2 );
#else
        return 0;
#endif
}


extern int XSalFreeFontInfo( char ** arg1, XFontStruct * arg2, int arg3 )
{
    return XFreeFontInfo( arg1, arg2, arg3 );
}


extern int XSalFreeFontNames( char ** arg1 )
{
    return XFreeFontNames( arg1 );
}


extern int XSalFreeFontPath( char ** arg1 )
{
    return XFreeFontPath( arg1 );
}


extern int XSalFreeGC( Display * arg1, GC arg2 )
{
    if ( IsDisplay( arg1 ) )
        return XFreeGC( arg1, arg2 );
    else
#ifdef PRINTER_IMPLEMENTATION
        return XpFreeGC( arg1, arg2 );
#else
        return 0;
#endif
}


extern int XSalFreeModifiermap( XModifierKeymap * arg1 )
{
    return XFreeModifiermap( arg1 );
}


extern int XSalFreePixmap( Display * arg1, Pixmap arg2 )
{
    if ( IsDisplay( arg1 ) )
        return XFreePixmap( arg1, arg2 );
    else
#ifdef PRINTER_IMPLEMENTATION
        return XpFreePixmap( arg1, arg2 );
#else
        return 0;
#endif
}


extern int XSalGetClassHint( Display * arg1, XLIB_Window arg2, XClassHint * arg3 )
{
    return XGetClassHint( arg1, arg2, arg3 );
}


extern char ** XSalGetFontPath( Display * arg1, int * arg2 )
{
    return XGetFontPath( arg1, arg2 );
}


extern XImage * XSalGetImage( Display * arg1, Drawable arg2, int arg3, int arg4, unsigned int arg5, unsigned int arg6, long unsigned int arg7, int arg8 )
{
    if ( IsDisplay( arg1 ) )
        return XGetImage( arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8 );
    else
#ifdef PRINTER_IMPLEMENTATION
        return XpGetImage( arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8 );
#else
        return 0;
#endif
}


extern XModifierKeymap * XSalGetModifierMapping( Display * arg1 )
{
    return XGetModifierMapping( arg1 );
}


extern Pixel XSalGetPixel( XImage * arg1, int arg2, int arg3 )
{
    return XGetPixel( arg1, arg2, arg3 );
}


extern int XSalGetScreenSaver( Display * arg1, int * arg2, int * arg3, int * arg4, int * arg5 )
{
    return XGetScreenSaver( arg1, arg2, arg3, arg4, arg5 );
}


extern XImage * XSalGetSubImage( Display * arg1, Drawable arg2, int arg3, int arg4, unsigned int arg5, unsigned int arg6, long unsigned int arg7, int arg8, XImage * arg9, int arg10, int arg11 )
{
    if ( IsDisplay( arg1 ) )
        return XGetSubImage( arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11 );
    else
#ifdef PRINTER_IMPLEMENTATION
        return XpGetSubImage( arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11 );
#else
        return 0;
#endif
}


extern XWMHints * XSalGetWMHints( Display * arg1, XLIB_Window arg2 )
{
    return XGetWMHints( arg1, arg2 );
}


extern int XSalGetWMNormalHints( Display * arg1, XLIB_Window arg2, XSizeHints * arg3, long int * arg4 )
{
    return XGetWMNormalHints( arg1, arg2, arg3, arg4 );
}


extern int XSalGetWindowAttributes( Display * arg1, XLIB_Window arg2, XWindowAttributes * arg3 )
{
    return XGetWindowAttributes( arg1, arg2, arg3 );
}


extern int XSalGetWindowProperty( Display * arg1, XLIB_Window arg2, long unsigned int arg3, long int arg4, long int arg5, int arg6, long unsigned int arg7, long unsigned int * arg8, int * arg9, long unsigned int * arg10, long unsigned int * arg11, unsigned char ** arg12 )
{
    return XGetWindowProperty( arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12 );
}


int XSalGrabPointer( Display * arg1, XLIB_Window arg2, int arg3, unsigned int arg4, int arg5, int arg6, XLIB_Window arg7, XLIB_Cursor arg8, long unsigned int arg9 )
{
    return XGrabPointer( arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9 );
}


int XSalIconifyWindow( Display * arg1, XLIB_Window arg2, int arg3 )
{
    return XIconifyWindow( arg1, arg2, arg3 );
}


int XSalIntersectRegion( XLIB_Region arg1, XLIB_Region arg2, XLIB_Region arg3 )
{
    return XIntersectRegion( arg1, arg2, arg3 );
}


KeySym XSalKeycodeToKeysym( Display * arg1, unsigned int arg2, int arg3 )
{
    return XKeycodeToKeysym( arg1, arg2, arg3 );
}


unsigned char XSalKeysymToKeycode( Display * arg1, KeySym arg2 )
{
    return XKeysymToKeycode( arg1, arg2 );
}


char * XSalKeysymToString( KeySym arg1 )
{
    return XKeysymToString( arg1 );
}


extern int * XSalListDepths( Display * arg1, int arg2, int * arg3 )
{
    return XListDepths( arg1, arg2, arg3 );
}


extern char ** XSalListFonts( Display * arg1, const char * arg2, int arg3, int * arg4 )
{
    if ( IsDisplay( arg1 ) )
        return XListFonts( arg1, arg2, arg3, arg4 );
    else
#ifdef PRINTER_IMPLEMENTATION
        return XpListFonts( arg1, arg2, arg3, arg4 );
#else
        return 0;
#endif
}


extern char ** XSalListFontsWithInfo( Display * arg1, const char * arg2, int arg3, int * arg4, XFontStruct ** arg5 )
{
    return XListFontsWithInfo( arg1, arg2, arg3, arg4, arg5 );
}


extern XLIB_Font XSalLoadFont( Display * arg1, const char * arg2 )
{
    if ( IsDisplay( arg1 ) )
        return XLoadFont( arg1, arg2 );
    else
#ifdef PRINTER_IMPLEMENTATION
        return XpLoadFont( arg1, arg2 );
#else
        return 0;
#endif
}


extern XFontStruct * XSalLoadQueryFont( Display * arg1, const char * arg2 )
{
    if ( IsDisplay( arg1 ) )
        return XLoadQueryFont( arg1, arg2 );
    else
#ifdef PRINTER_IMPLEMENTATION
        return XpLoadQueryFont( arg1, arg2 );
#else
        return 0;
#endif
}


extern KeySym XSalLookupKeysym( XKeyEvent * arg1, int arg2 )
{
    return XLookupKeysym( arg1, arg2 );
}


extern int XSalLookupString( XKeyEvent * arg1, char * arg2, int arg3, KeySym * arg4, struct _XComposeStatus * arg5 )
{
    return XLookupString( arg1, arg2, arg3, arg4, arg5 );
}


extern int XSalMapWindow( Display * arg1, XLIB_Window arg2 )
{
    return XMapWindow( arg1, arg2 );
}


extern int XSalMoveWindow( Display * arg1, XLIB_Window arg2, int arg3, int arg4 )
{
    return XMoveWindow( arg1, arg2, arg3, arg4 );
}


extern int XSalNextEvent( Display * arg1, XEvent * arg2 )
{
    return XNextEvent( arg1, arg2 );
}


extern int XSalPeekIfEvent( Display * arg1, XEvent * arg2, XSalPeekEventPredicate arg3, char * arg4 )
{
    return XPeekIfEvent( arg1, arg2, arg3, arg4 );
}


extern int XSalPending( Display * arg1 )
{
    return XPending( arg1 );
}


extern XLIB_Region XSalPolygonRegion( XPoint * arg1, int arg2, int arg3 )
{
    return XPolygonRegion( arg1, arg2, arg3 );
}


extern int XSalPutImage( Display * arg1, Drawable arg2, GC arg3, XImage * arg4, int arg5, int arg6, int arg7, int arg8, unsigned int arg9, unsigned int arg10 )
{
    if ( IsDisplay( arg1 ) )
        return XPutImage( arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10 );
    else
#ifdef PRINTER_IMPLEMENTATION
        return XpPutImage( arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10 );
#else
        return 0;
#endif
}


extern void XSalPutPixel( XImage * arg1, int arg2, int arg3, unsigned long arg4 )
{
    XPutPixel( arg1, arg2, arg3, arg4 );
}


extern int XSalQueryBestStipple( Display * arg1, Drawable arg2, unsigned int arg3, unsigned int arg4, unsigned int * arg5, unsigned int * arg6 )
{
    return XQueryBestStipple( arg1, arg2, arg3, arg4, arg5, arg6 );
}


extern int XSalQueryColor( Display * arg1, Colormap arg2, XColor * arg3 )
{
    if ( IsDisplay( arg1 ) )
        return XQueryColor( arg1, arg2, arg3 );
    else
#ifdef PRINTER_IMPLEMENTATION
        return XpQueryColor( arg1, arg2, arg3 );
#else
        return 0;
#endif
}


extern int XSalQueryColors( Display * arg1, Colormap arg2, XColor * arg3, int arg4 )
{
    if ( IsDisplay( arg1 ) )
        return XQueryColors( arg1, arg2, arg3, arg4 );
    else
#ifdef PRINTER_IMPLEMENTATION
        return XpQueryColors( arg1, arg2, arg3, arg4 );
#else
        return 0;
#endif
}


extern int XSalQueryTree( Display * arg1, XLIB_Window arg2, XLIB_Window * arg3, XLIB_Window * arg4, XLIB_Window ** arg5, unsigned int * arg6 )
{
    return XQueryTree( arg1, arg2, arg3, arg4, arg5, arg6 );
}


extern int XSalRaiseWindow( Display * arg1, XLIB_Window arg2 )
{
    return XRaiseWindow( arg1, arg2 );
}


extern int XSalReconfigureWMWindow( Display * arg1, XLIB_Window arg2, int arg3, unsigned int arg4, XWindowChanges * arg5 )
{
    return XReconfigureWMWindow( arg1, arg2, arg3, arg4, arg5 );
}


extern int XSalRectInRegion( XLIB_Region arg1, int arg2, int arg3, unsigned int arg4, unsigned int arg5 )
{
    return XRectInRegion( arg1, arg2, arg3, arg4, arg5 );
}


extern int XSalRefreshKeyboardMapping( XMappingEvent * arg1 )
{
    return XRefreshKeyboardMapping( arg1 );
}


extern int XSalResetScreenSaver( Display * arg1 )
{
    return XResetScreenSaver( arg1 );
}


extern int XSalSelectInput( Display * arg1, XLIB_Window arg2, long int arg3 )
{
    return XSelectInput( arg1, arg2, arg3 );
}


extern int XSalSendEvent( Display * arg1, XLIB_Window arg2, int arg3, long int arg4, XEvent * arg5 )
{
    return XSendEvent( arg1, arg2, arg3, arg4, arg5 );
}


extern int XSalSetArcMode( Display * arg1, GC arg2, int arg3 )
{
    if ( IsDisplay( arg1 ) )
        return XSetArcMode( arg1, arg2, arg3 );
    else
#ifdef PRINTER_IMPLEMENTATION
        return XpSetArcMode( arg1, arg2, arg3 );
#else
        return 0;
#endif
}


extern int XSalSetBackground( Display * arg1, GC arg2, long unsigned int arg3 )
{
    if ( IsDisplay( arg1 ) )
        return XSetBackground( arg1, arg2, arg3 );
    else
#ifdef PRINTER_IMPLEMENTATION
        return XpSetBackground( arg1, arg2, arg3 );
#else
        return 0;
#endif
}


extern int XSalSetClipMask( Display * arg1, GC arg2, Pixmap arg3 )
{
    if ( IsDisplay( arg1 ) )
        return XSetClipMask( arg1, arg2, arg3 );
    else
#ifdef PRINTER_IMPLEMENTATION
        return XpSetClipMask( arg1, arg2, arg3 );
#else
        return 0;
#endif
}


extern int XSalSetClipOrigin( Display * arg1, GC arg2, int arg3, int arg4 )
{
    if ( IsDisplay( arg1 ) )
        return XSetClipOrigin( arg1, arg2, arg3, arg4 );
    else
#ifdef PRINTER_IMPLEMENTATION
        return XpSetClipOrigin( arg1, arg2, arg3, arg4 );
#else
        return 0;
#endif
}


extern XErrorHandler XSalSetErrorHandler( XErrorHandler arg1 )
{
    return XSetErrorHandler( arg1 );
}


extern int XSalSetFillStyle( Display * arg1, GC arg2, int arg3 )
{
    if ( IsDisplay( arg1 ) )
        return XSetFillStyle( arg1, arg2, arg3 );
    else
#ifdef PRINTER_IMPLEMENTATION
        return XpSetFillStyle( arg1, arg2, arg3 );
#else
        return 0;
#endif
}


extern int XSalSetFont( Display * arg1, GC arg2, XLIB_Font arg3 )
{
    if ( IsDisplay( arg1 ) )
        return XSetFont( arg1, arg2, arg3 );
    else
#ifdef PRINTER_IMPLEMENTATION
        return XpSetFont( arg1, arg2, arg3 );
#else
        return 0;
#endif
}


extern int XSalSetFontPath( Display * arg1, char ** arg2, int arg3 )
{
    return XSetFontPath( arg1, arg2, arg3 );
}


extern int XSalSetForeground( Display * arg1, GC arg2, long unsigned int arg3 )
{
    if ( IsDisplay( arg1 ) )
        return XSetForeground( arg1, arg2, arg3 );
    else
#ifdef PRINTER_IMPLEMENTATION
        return XpSetForeground( arg1, arg2, arg3 );
#else
        return 0;
#endif
}


extern int XSalSetFunction( Display * arg1, GC arg2, int arg3 )
{
    if ( IsDisplay( arg1 ) )
        return XSetFunction( arg1, arg2, arg3 );
    else
#ifdef PRINTER_IMPLEMENTATION
        return XpSetFunction( arg1, arg2, arg3 );
#else
        return 0;
#endif
}


extern XIOErrorHandler XSalSetIOErrorHandler( XIOErrorHandler arg1 )
{
    return XSetIOErrorHandler( arg1 );
}


extern int XSalSetInputFocus( Display * arg1, XLIB_Window arg2, int arg3, long unsigned int arg4 )
{
    return XSetInputFocus( arg1, arg2, arg3, arg4 );
}


extern int XSalSetLineAttributes( Display * arg1, GC arg2, unsigned int arg3, int arg4, int arg5, int arg6 )
{
    if ( IsDisplay( arg1 ) )
        return XSetLineAttributes( arg1, arg2, arg3, arg4, arg5, arg6 );
    else
#ifdef PRINTER_IMPLEMENTATION
        return XpSetLineAttributes( arg1, arg2, arg3, arg4, arg5, arg6 );
#else
        return 0;
#endif
}


extern int XSalSetRegion( Display * arg1, GC arg2, XLIB_Region arg3 )
{
    if ( IsDisplay( arg1 ) )
        return XSetRegion( arg1, arg2, arg3 );
    else
#ifdef PRINTER_IMPLEMENTATION
        return XpSetRegion( arg1, arg2, arg3 );
#else
        return 0;
#endif
}


extern int XSalSetScreenSaver( Display * arg1, int arg2, int arg3, int arg4, int arg5 )
{
    return XSetScreenSaver( arg1, arg2, arg3, arg4, arg5 );
}


extern int XSalSetStipple( Display * arg1, GC arg2, Pixmap arg3 )
{
    if ( IsDisplay( arg1 ) )
        return XSetStipple( arg1, arg2, arg3 );
    else
#ifdef PRINTER_IMPLEMENTATION
        return XpSetStipple( arg1, arg2, arg3 );
#else
        return 0;
#endif
}


extern int XSalSetTSOrigin( Display * arg1, GC arg2, int arg3, int arg4 )
{
    if ( IsDisplay( arg1 ) )
        return XSetTSOrigin( arg1, arg2, arg3, arg4 );
    else
#ifdef PRINTER_IMPLEMENTATION
        return XpSetTSOrigin( arg1, arg2, arg3, arg4 );
#else
        return 0;
#endif
}


extern int XSalSetTile( Display * arg1, GC arg2, Pixmap arg3 )
{
    if ( IsDisplay( arg1 ) )
        return XSetTile( arg1, arg2, arg3 );
    else
#ifdef PRINTER_IMPLEMENTATION
        return XpSetTile( arg1, arg2, arg3 );
#else
        return 0;
#endif
}


extern int XSalSetWMHints( Display * arg1, XLIB_Window arg2, XWMHints * arg3 )
{
    return XSetWMHints( arg1, arg2, arg3 );
}


extern void XSalSetWMIconName( Display * arg1, XLIB_Window arg2, XTextProperty * arg3 )
{
    XSetWMIconName( arg1, arg2, arg3 );
}


extern void XSalSetWMName( Display * arg1, XLIB_Window arg2, XTextProperty * arg3 )
{
    XSetWMName( arg1, arg2, arg3 );
}


extern void XSalSetWMNormalHints( Display * arg1, XLIB_Window arg2, XSizeHints * arg3 )
{
    XSetWMNormalHints( arg1, arg2, arg3 );
}


extern void XSalSetWMProperties( Display * arg1, XLIB_Window arg2, XTextProperty * arg3, XTextProperty * arg4, char ** arg5, int arg6, XSizeHints * arg7, XWMHints * arg8, XClassHint * arg9 )
{
    XSetWMProperties( arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9 );
}


extern int XSalSetWMProtocols( Display * arg1, XLIB_Window arg2, long unsigned int * arg3, int arg4 )
{
    return XSetWMProtocols( arg1, arg2, arg3, arg4 );
}


extern int XSalSetWindowBackgroundPixmap( Display * arg1, XLIB_Window arg2, Pixmap arg3 )
{
    return XSetWindowBackgroundPixmap( arg1, arg2, arg3 );
}


#ifdef _XSHM_H_
extern int XSalShmAttach( Display * arg1, XShmSegmentInfo * arg2 )
{
    return XShmAttach( arg1, arg2 );
}

#endif

#ifdef _XSHM_H_
extern XImage * XSalShmCreateImage( Display * arg1, Visual * arg2, unsigned int arg3, int arg4, char * arg5, XShmSegmentInfo * arg6, unsigned int arg7, unsigned int arg8 )
{
    return XShmCreateImage( arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8 );
}

#endif

#ifdef _XSHM_H_
extern int XSalShmDetach( Display * arg1, XShmSegmentInfo * arg2 )
{
    return XShmDetach( arg1, arg2 );
}

#endif

#ifdef _XSHM_H_
extern "C" int XShmGetEventBase( Display* );
extern int XSalShmGetEventBase( Display * arg1 )
{
    return XShmGetEventBase( arg1 );
}

#endif

#ifdef _XSHM_H_
extern int XSalShmGetImage( Display * arg1, Drawable arg2, XImage * arg3, int arg4, int arg5, long unsigned int arg6 )
{
    return XShmGetImage( arg1, arg2, arg3, arg4, arg5, arg6 );
}

#endif

#ifdef _XSHM_H_
extern int XSalShmPutImage( Display * arg1, Drawable arg2, GC arg3, XImage * arg4, int arg5, int arg6, int arg7, int arg8, unsigned int arg9, unsigned int arg10, int arg11 )
{
    return XShmPutImage( arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11 );
}

#endif

#ifdef _XSHM_H_
extern int XSalShmQueryVersion( Display * arg1, int * arg2, int * arg3, int * arg4 )
{
    return XShmQueryVersion( arg1, arg2, arg3, arg4 );
}

#endif

extern int XSalStringListToTextProperty( char ** arg1, int arg2, XTextProperty * arg3 )
{
    return XStringListToTextProperty( arg1, arg2, arg3 );
}


extern int XSalSubtractRegion( XLIB_Region arg1, XLIB_Region arg2, XLIB_Region arg3 )
{
    return XSubtractRegion( arg1, arg2, arg3 );
}


extern int XSalSync( Display * arg1, int arg2 )
{
    return XSync( arg1, arg2 );
}


extern XSalAfterFunction XSalSynchronize( Display * arg1, int arg2 )
{
    return XSynchronize( arg1, arg2 );
}


extern int XSalTranslateCoordinates( Display * arg1, XLIB_Window arg2, XLIB_Window arg3, int arg4, int arg5, int * arg6, int * arg7, XLIB_Window * arg8 )
{
    return XTranslateCoordinates( arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8 );
}


extern int XSalUngrabKeyboard( Display * arg1, long unsigned int arg2 )
{
    return XUngrabKeyboard( arg1, arg2 );
}


extern int XSalUngrabPointer( Display * arg1, long unsigned int arg2 )
{
    return XUngrabPointer( arg1, arg2 );
}


extern int XSalUnionRectWithRegion( XRectangle * arg1, XLIB_Region arg2, XLIB_Region arg3 )
{
    return XUnionRectWithRegion( arg1, arg2, arg3 );
}


extern int XSalUnionRegion( XLIB_Region arg1, XLIB_Region arg2, XLIB_Region arg3 )
{
    return XUnionRegion( arg1, arg2, arg3 );
}


extern int XSalUnloadFont( Display * arg1, XLIB_Font arg2 )
{
    if ( IsDisplay( arg1 ) )
        return XUnloadFont( arg1, arg2 );
    else
#ifdef PRINTER_IMPLEMENTATION
        return XpUnloadFont( arg1, arg2 );
#else
        return 0;
#endif
}


extern int XSalUnmapWindow( Display * arg1, XLIB_Window arg2 )
{
    return XUnmapWindow( arg1, arg2 );
}


extern int XSalWarpPointer( Display * arg1, XLIB_Window arg2, XLIB_Window arg3, int arg4, int arg5, unsigned int arg6, unsigned int arg7, int arg8, int arg9 )
{
    return XWarpPointer( arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9 );
}


extern int XSalXorRegion( XLIB_Region arg1, XLIB_Region arg2, XLIB_Region arg3 )
{
    return XXorRegion( arg1, arg2, arg3 );
}


extern char * XSalGetAtomName( Display * arg1, long unsigned int arg2 )
{
#   ifdef USE_XMU
	return XmuGetAtomName( arg1, arg2 );
#   else
    return XGetAtomName (arg1, arg2 );
#   endif
}


extern int XSalGetHostname( char * arg1, int arg2 )
{
#   ifdef USE_XMU
    return XmuGetHostname( arg1, arg2 );
#   else
    return gethostname (arg1, arg2 );
#   endif
}


extern void XSalInternStrings( Display * arg1, char ** arg2, unsigned int arg3, long unsigned int * arg4 )
{
#	if defined __SunOS_5_5_1 || defined AIX || defined SCO
	int i;
#	endif
#   ifdef USE_XMU
    XmuInternStrings( arg1, arg2, arg3, arg4 );
#   else
#	if !( defined __SunOS_5_5_1 || defined AIX || defined SCO )
    XInternAtoms( arg1, arg2, arg3, False, arg4 );
#	else
	for( i=0; i<arg3; i++ )
		arg4[i] = XInternAtom( arg1, arg2[i], arg3 );
#	endif
#   endif
}

#ifdef USE_XTOOLKIT

extern Widget XSalAppCreateShell( const char * arg1, const char * arg2, struct _WidgetClassRec * arg3, Display * arg4, ArgList arg5, unsigned int arg6 )
{
    return XtAppCreateShell( arg1, arg2, arg3, arg4, arg5, arg6 );
}


extern XtErrorHandler XSalAppSetErrorHandler( XtAppContext arg1, XtErrorHandler arg2 )
{
    return XtAppSetErrorHandler( arg1, arg2 );
}


extern XtErrorHandler XSalAppSetWarningHandler( XtAppContext arg1, XtErrorHandler arg2 )
{
    return XtAppSetWarningHandler( arg1, arg2 );
}


extern XtAppContext XSalCreateApplicationContext(  )
{
    return XtCreateApplicationContext(  );
}


extern void XSalDestroyWidget( Widget arg1 )
{
    XtDestroyWidget( arg1 );
}


extern void XSalGetValues( Widget arg1, ArgList arg2, unsigned int arg3 )
{
    XtGetValues( arg1, arg2, arg3 );
}


extern Display * XSalOpenDisplay( XtAppContext arg1, const char * arg2, const char * arg3, const char * arg4, XrmOptionDescRec * arg5, unsigned int arg6, int * arg7, char ** arg8 )
{
    return XtOpenDisplay( arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8 );
}


extern void XSalRealizeWidget( Widget arg1 )
{
    XtRealizeWidget( arg1 );
}


extern void XSalSetMappedWhenManaged( Widget arg1, int arg2 )
{
    XtSetMappedWhenManaged( arg1, arg2 );
}


extern void XSalSetValues( Widget arg1, ArgList arg2, unsigned int arg3 )
{
    XtSetValues( arg1, arg2, arg3 );
}


extern void XSalToolkitInitialize(  )
{
    XtToolkitInitialize(  );
}

#endif /* USE_XTOOLKIT */


