/*************************************************************************
 *
 *  $RCSfile: officeacceptthread.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: svesik $ $Date: 2002/03/11 15:16:13 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <stdio.h>
#ifdef UNIX
#include <sys/wait.h>
#endif

#include <officeacceptthread.hxx>

#include <vcl/svapp.hxx>
#include <osl/diagnose.h>
#include <osl/interlck.h>

#include <vos/security.hxx>
#include <vos/timer.hxx>
#include <vos/conditn.hxx>
#include <vos/process.hxx>

#include <com/sun/star/connection/XConnector.hpp>
#include <com/sun/star/bridge/XBridgeFactory.hpp>
#include <com/sun/star/connection/XAcceptor.hpp>
#include <com/sun/star/uno/XNamingService.hpp>

#include <cppuhelper/implbase1.hxx>

#ifndef _UCBHELPER_REMOTECONTENTPROVIDERSCONTROL_HXX_
#include <ucbhelper/remotecontentproviderscontrol.hxx>
#endif
#ifndef _VOS_REF_HXX_
#include <vos/ref.hxx>
#endif
#ifndef _UNOTOOLS_PROCESSFACTORY_HXX
#include <comphelper/processfactory.hxx>
#endif

using namespace ::cppu;
using namespace ::vos;
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::io;
using namespace ::com::sun::star::lang;
using namespace ::com::sun::star::connection;
using namespace ::com::sun::star::bridge;
using namespace ::com::sun::star::container;

#define PATH_DELEMITTER '/'

namespace desktop
{
	rtl::OUString getRemoteProtocol()
	{
		rtl::OUString sProtocol = rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "urp" ) );
		sal_Char *pEnv = getenv( "UNO_PROTOCOL" );
		if( pEnv )
		{
			sProtocol = rtl::OStringToOUString( pEnv , RTL_TEXTENCODING_ASCII_US );
		}
		return sProtocol;
	}

	class ProcessCheck
	{
		public:
			sal_Bool static isProcessRunning( ::vos::OProcess::TProcessInfo& aProcessInfo )
			{
				int nRet;
#if defined (SOLARIS) || defined (IRIX)
				int status;
				nRet = waitpid(aProcessInfo.Ident, &status,WNOHANG);
#elif defined(LINUX) || defined(FREEBSD)
				nRet = kill(aProcessInfo.Ident, 0);
#endif
#if defined (LINUX) || defined (SOLARIS) || defined (IRIX) || defined(FREEBSD)
				if ( nRet == 0 )
					return sal_True; // process is running
				if ( nRet < 0 )
					return sal_False; // error
				if ( nRet > 0 )
					return sal_False; // process terminated
#else
				return sal_True;
#endif				
			}
	};


	class RVPStartupClient
	{
		public:
			RVPStartupClient( const rtl::OUString& aConnectionString, const rtl::OUString& aClientDisplayString, const rtl::OUString& aUserDirString ) :
				m_aConnectionString( aConnectionString ),
				m_aClientDisplayString( aClientDisplayString ),
				m_aUserDirString( aUserDirString ) {}

			::vos::OProcess*	startClient();

		private:
			rtl::OUString	getConnectString( const rtl::OUString& rConnectionDescription );

			rtl::OUString	m_aConnectionString;
			rtl::OUString	m_aClientDisplayString;
			rtl::OUString	m_aUserDirString;

	};

	OProcess* RVPStartupClient::startClient()
	{
		rtl::OUString			aExecutePath;

		::vos::OStartupInfo().getExecutableFile( aExecutePath );
		sal_uInt32	lastIndex = aExecutePath.lastIndexOf( PATH_DELEMITTER );
		if ( lastIndex > 0 )
			aExecutePath = aExecutePath.copy( 0, lastIndex );

		rtl::OUString	aDir( aExecutePath );

#ifdef WNT
		aExecutePath += rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "/sclient.exe" ));
#else
		aExecutePath += rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "/sclient" ));
#endif

#ifdef DEBUG
        rtl::OString tmp1 = rtl::OUStringToOString( aExecutePath, RTL_TEXTENCODING_ASCII_US );
        rtl::OString tmp2 = rtl::OUStringToOString( aDir, RTL_TEXTENCODING_ASCII_US );
        OSL_TRACE( "exec client path=%s, dir=%s", tmp1.getStr(), tmp2.getStr() );
#endif
        ::vos::OProcess* pClientProcess = new OProcess( aExecutePath, aDir );
        OSL_TRACE( "headless client process created" );

        const int nParam = 5;

        int          nActiveParams = 0;
        rtl::OUString	 aParamArray[ nParam ];
		OSecurity	 aSecurity;
		OEnvironment aEnvironment;

		rtl::OUString aConnectString( RTL_CONSTASCII_USTRINGPARAM( """-connect=" ));
		aConnectString += getConnectString( m_aConnectionString );
		aConnectString += rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( """" ));

		aParamArray[nActiveParams++] = rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "-dummy" ));
        aParamArray[nActiveParams++] = aConnectString;
        if ( m_aUserDirString.getLength() > 0 )
        {
            aParamArray[nActiveParams] = rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "-userdir=" ));
            aParamArray[nActiveParams] += m_aUserDirString;
            nActiveParams++;
        }

#ifdef UNX
        if ( m_aClientDisplayString.getLength() > 0 )
        {
            aParamArray[nActiveParams++] = rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "-display" ));
            aParamArray[nActiveParams++] = m_aClientDisplayString;
            rtl::OString aEnv( "DISPLAY=" );
            aEnv += rtl::OUStringToOString( m_aClientDisplayString, RTL_TEXTENCODING_ASCII_US );
            putenv( strdup( aEnv.getStr() ));
        }
#endif

		OArgumentList aArgumentList( aParamArray, nActiveParams );

		//try to launch the headless client!!!
		pClientProcess->execute(	OProcess::TOption_Detached,
									aSecurity,
									aArgumentList,
									aEnvironment );

		return pClientProcess;
	}

	rtl::OUString RVPStartupClient::getConnectString( const rtl::OUString& rConnectionDescription )
	{
		sal_Int32	index;
		sal_Int32	lastIndex = 0;
		rtl::OUString	aUser;
		rtl::OUString	aPort;
		rtl::OUString	aSource;
		rtl::OUString	aTicket;

		do
		{
			index = rConnectionDescription.indexOf((sal_Unicode) ',', lastIndex);
			rtl::OUString token = (index == -1) ? rConnectionDescription.copy(lastIndex) : rConnectionDescription.copy(lastIndex, index - lastIndex);

			lastIndex = index + 1;

			sal_Int32 eindex = token.indexOf((sal_Unicode)'=');
			rtl::OUString left = token.copy(0, eindex).toAsciiLowerCase().trim();
			rtl::OUString right = token.copy(eindex + 1).trim();

			if(left.equals(rtl::OUString(RTL_CONSTASCII_USTRINGPARAM("user"))))
				aUser = right;

			else if(left.equals(rtl::OUString(RTL_CONSTASCII_USTRINGPARAM("source"))))
				aSource = right;

			else if(left.equals(rtl::OUString(RTL_CONSTASCII_USTRINGPARAM("ticket"))))
				aTicket = right;
		}
		while(index != -1);

		sal_Int32 nTokenCount = 0;
		sal_Int32 nIndex = 0;
		do
		{
			aSource.getToken( 0, ':', nIndex );
			nTokenCount++;
		}
		while ( nIndex >= 0 );

		if ( nTokenCount > 1 ) // is there a port ?
		{
			nIndex = 0;
			aPort = aSource.getToken( 1, ':', nIndex );
		}

		rtl::OUString aConnectString( RTL_CONSTASCII_USTRINGPARAM( "portal,service=headless,host=localhost," ));
		aConnectString += rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "port=" ));
		aConnectString += aPort;
		aConnectString += rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( ",user=" ));
		aConnectString += aUser;
		aConnectString += rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( ",ticket=" ));
		aConnectString += aTicket;

		return aConnectString;
	}


	class OInstanceProvider :
		public OWeakObject,
		public XInstanceProvider
	{
	public:
		OInstanceProvider(	Reference< XConnection > rConnection, OProcess* pClientProcess ) :
			m_rConnection( rConnection ), m_pClientProcess( pClientProcess ) {}

		// XInterface
		Any	        SAL_CALL queryInterface( const Type & aType) throw( RuntimeException );
		void 		SAL_CALL acquire() throw( RuntimeException ) { OWeakObject::acquire(); }
		void 		SAL_CALL release() throw( RuntimeException ) { OWeakObject::release(); }

		// XInstanceProvider
		virtual Reference<XInterface> SAL_CALL getInstance(const rtl::OUString & sObjectName) throw(NoSuchElementException, RuntimeException);

	private:
		sal_Bool			 isOfficeInitialized();

		Reference < XConnection >	m_rConnection;
		::vos::OProcess*			m_pClientProcess;
		static sal_Bool				m_bLocalClientConnected;
	};

	sal_Bool OInstanceProvider::m_bLocalClientConnected = sal_False;

	Any OInstanceProvider::queryInterface( const Type & aType ) throw( RuntimeException )
	{
		Any a = ::cppu::queryInterface(aType, SAL_STATIC_CAST(XInstanceProvider * , this));
		if(a.hasValue())
		{
			return a;
		}

		return OWeakObject::queryInterface( aType );
	}

	sal_Bool OInstanceProvider::isOfficeInitialized()
	{
		const long		WAIT_FOR_SERVICEMANAGER = 500000000L; // 50000000ns=500mS=0.5Sec.
		::vos::OProcess::TProcessInfo	aProcessInfo;

		if ( m_pClientProcess )
			m_pClientProcess->getInfo( ::vos::OProcess::TData_Identifier, &aProcessInfo );

		while( !Application::IsInExecute() )
		{
			if ( m_pClientProcess )
			{
				// special code for headless office mode
				if ( !m_bLocalClientConnected && !ProcessCheck::isProcessRunning( aProcessInfo ) )
					return sal_False; // client is not running anymore => return FALSE
			}

			TimeValue aTimeValue = { 0, WAIT_FOR_SERVICEMANAGER };
			osl_waitThread( &aTimeValue );
		}

		return sal_True;
	}

	Reference<XInterface> OInstanceProvider::getInstance(const rtl::OUString & sObjectName) throw(NoSuchElementException, RuntimeException)
	{
		Reference<XInterface> r;

		if ( sObjectName == rtl::OUString(RTL_CONSTASCII_USTRINGPARAM( "StarOffice.Startup" )))
	    {
			// rvp client wants to connect
			r = Application::GetUnoInstance( m_rConnection, sObjectName );
			if ( r.is() )
				m_bLocalClientConnected = sal_True;
	    }
		else if ( sObjectName == rtl::OUString(RTL_CONSTASCII_USTRINGPARAM( "StarOffice.ServiceManager" )))
		{  
			// wait for the office to start ....
            // not needed here in svdem...
			//if ( isOfficeInitialized() )
				r = ::com::sun::star::uno::Reference< ::com::sun::star::uno::XInterface >( 
					::comphelper::getProcessServiceFactory(), ::com::sun::star::uno::UNO_QUERY );
		}
		else if ( sObjectName == rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "StarOffice.NamingService" )))
		{
			::com::sun::star::uno::Reference< ::com::sun::star::lang::XMultiServiceFactory > rSMgr = ::comphelper::getProcessServiceFactory();
			if ( rSMgr.is() )
			{
				::com::sun::star::uno::Reference< ::com::sun::star::uno::XNamingService > rNamingService(
					rSMgr->createInstance( rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "com.sun.star.uno.NamingService" ))),
					::com::sun::star::uno::UNO_QUERY );

				if ( rNamingService.is() )
				{
					rNamingService->registerObject(
						::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "StarOffice.ServiceManager" )),
						rSMgr );

					if ( isOfficeInitialized() )
						r = rNamingService;
				}            
			}
		}            
		else if ( sObjectName == ::rtl::OUString(RTL_CONSTASCII_USTRINGPARAM( "com.sun.star.ucb.RemoteContentProviderAcceptor" )))
		{
			::com::sun::star::uno::Reference< ::com::sun::star::lang::XMultiServiceFactory > rSMgr = ::comphelper::getProcessServiceFactory();
			if ( rSMgr.is() )
				try
				{
					r = rSMgr->createInstance( sObjectName );
				}
				catch (Exception const &) {}
		}

#ifdef DEBUG
		::rtl::OString tmp = ::rtl::OUStringToOString( sObjectName, RTL_TEXTENCODING_ASCII_US );
		OSL_TRACE("getInstance %s %i\n", tmp.getStr(), (int)r.is());
#endif
		return r;
	}

	OOfficeAcceptorThread::OOfficeAcceptorThread(
		const Reference< ::com::sun::star::lang::XMultiServiceFactory > &r ,
		const rtl::OUString &sConnectionDescription,
		sal_Bool bHeadlessMode,
        const rtl::OUString& aClientDisplay,
		const rtl::OUString& aUserDir ) :
		m_rSMgr( r ),
		m_sConnectionDescription( sConnectionDescription ),
		m_connectCount( 0 ),
        m_bHeadlessOffice( bHeadlessMode ),
        m_sClientDisplay( aClientDisplay ),
        m_sUserDir( aUserDir )
	{
		try
		{
			m_rAcceptor = Reference< XAcceptor > (
				m_rSMgr->createInstance(
				rtl::OUString::createFromAscii( "com.sun.star.connection.Acceptor" ) ),
				UNO_QUERY );

			m_rBridgeFactory = Reference < XBridgeFactory > (
				m_rSMgr->createInstance(
					rtl::OUString::createFromAscii( "com.sun.star.bridge.BridgeFactory" ) ),
				UNO_QUERY );
			// make it robust vs uno: prefix
			if( 0 == m_sConnectionDescription.compareToAscii( "uno:" , 4 ) )
			{
				m_sConnectionDescription = m_sConnectionDescription.copy( 4 );
			}
		}
		catch ( RuntimeException& )
		{
			OSL_TRACE( "OOfficeAcceptorThread: runtime exception during creating services" );
		}
	}

	void OOfficeAcceptorThread::run()
	{
		static OProcess* pProcessCheck = NULL;

		sal_Int32		nIndex = m_sConnectionDescription.indexOf( (sal_Unicode) ';' );

		if( -1 == nIndex )
		{
			// wrong format
			m_rAcceptor = Reference< XAcceptor >();
			m_rBridgeFactory = Reference< XBridgeFactory >();
			return;
		}

		rtl::OUString sConnection = m_sConnectionDescription.copy( 0 , nIndex ).trim();
		nIndex++;
		sal_Int32 nIndex2 = m_sConnectionDescription.indexOf( (sal_Unicode) ';' , nIndex );

		if( -1 == nIndex2 )
		{
			nIndex2 = m_sConnectionDescription.getLength();
		}

		rtl::OUString sProtocol   = m_sConnectionDescription.copy( nIndex, nIndex2 - nIndex );

		// Helper for the com.sun.star.ucb.RemoteContentProviderAcceptor
		// service, so that it can clean up when it no longer needs the
		// accepted remote content providers:
		vos::ORef< ucb::RemoteContentProvidersControl >
			xControl(new ucb::RemoteContentProvidersControl(m_rSMgr));

		OProcess* pClientProcess = NULL;
		while ( m_rAcceptor.is() && m_rBridgeFactory.is()  )
		{
			try
			{
				Reference < XConnection > rConnection =
					m_rAcceptor->accept( sConnection );

				if( ! rConnection.is() )
				{
					break;
				}

				xControl->addConnection(rConnection);

                m_aDescriptionString = rConnection->getDescription();

                if ( osl_incrementInterlockedCount( &m_connectCount ) == 1 &&
					 m_bHeadlessOffice )
				{
					// first connect on headless office => start headless client
                    rtl::OString tmp = rtl::OUStringToOString( m_aDescriptionString, RTL_TEXTENCODING_ASCII_US );
                    OSL_TRACE( "connect string=%s", tmp.getStr() );

					RVPStartupClient aRVPClientStarter( m_aDescriptionString, m_sClientDisplay, m_sUserDir );
					pClientProcess = aRVPClientStarter.startClient();
				}

				Reference < XBridge > rBridge =
					m_rBridgeFactory->createBridge(
						rtl::OUString() ,
						sProtocol ,
						rConnection ,
						(XInstanceProvider * ) new OInstanceProvider( rConnection, pClientProcess ) );

                xControl->detectDistributionConnection(rConnection, rBridge);
			}
			catch ( RuntimeException & e )
			{
				rtl::OString o = rtl::OUStringToOString( e.Message , RTL_TEXTENCODING_ASCII_US );
				OSL_TRACE( "OOfficeAcceptorThread: RuntimeException during accepting interprocess connection\n%s",
						   o.getStr() );
				break;
			}
			catch ( Exception & e )
			{
				rtl::OString o = rtl::OUStringToOString( e.Message , RTL_TEXTENCODING_ASCII_US );
				OSL_TRACE( "OOfficeAcceptorThread: Exception during accepting interprocess connection\n%s",
						   o.getStr() );
				break;
			}
		}
	}

	void OOfficeAcceptorThread::stopAccepting()
	{
		if( m_rAcceptor.is() )
		{
			m_rAcceptor->stopAccepting();
		}
	}
}

