/*************************************************************************
 *
 *  $RCSfile: daemtst.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 15:18:17 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifdef GCC   
#define __PUT_STATIC_DATA_MEMBERS_HERE
#endif

#include <iostream.h>
#include <string.h>
#include <errno.h>


#include <vos/evtque.hxx>
#include <vos/string.hxx>
#include <vos/daemon.hxx>
#include <vos/timer.hxx>
#include <vos/conditn.hxx>

#ifndef _VOS_NO_NAMESPACE
using namespace vos;
#endif

class DaemonListener : public IDaemonListener
{
public:
	DaemonListener();
	~DaemonListener();

	void statusChanged(const ORef<IDaemonAccess>& rDaemon, 
					   IDaemonAccess::TDaemonStatus status);

	RefCount acquire()
		{ return m_refCount.acquire(); }

	RefCount release()
		{ RefCount n = m_refCount.release(); if (n == 0) delete this; return n; }

	RefCount referenced() const
		{ return m_refCount.referenced(); }
		
protected:

	ORefCount m_refCount;
};

DaemonListener::DaemonListener()
{
	uLong n = IDaemonManager::getGlobalManager()->getDaemonCount();
	
	cout << "creating listener\n";

	cout << "number of daemons: " << n << "\n";
	
	for (uLong i = 0; i < n; i++)
	{
		ORef<IDaemonAccess> d = IDaemonManager::getGlobalManager()->getDaemonByIndex(i);
		
		cout << i << ". name = '" << (cStr) d->getDisplayName() << "'\n";
	}
	cout.flush();
}	

DaemonListener::~DaemonListener()
{
	cout << "deleting listener\n";
	cout.flush();
}	

void DaemonListener::statusChanged(const ORef<IDaemonAccess>& rDaemon, 
				   				   IDaemonAccess::TDaemonStatus status)
{
	cout << "status of daemon '" << (cStr)rDaemon->getDisplayName() << "' changed to";

	switch (status)
	{
		case IDaemonAccess::TStatus_StartPending:
			cout << "<start pending>\n";
			break;
		case IDaemonAccess::TStatus_StopPending:
			cout << "<stop pending>\n";
			break;
		case IDaemonAccess::TStatus_PausePending:
			cout << "<pause pending>\n";
			break;
		case IDaemonAccess::TStatus_Running:
			cout << "<running>\n";
			break;
		case IDaemonAccess::TStatus_Stopped:
			cout << "<stopped>\n";
			break;
		case IDaemonAccess::TStatus_Paused:
			cout << "<paused>\n";
			break;
		default:
			cout << "<unknown>\n";
			break;
	}
	cout.flush();
}									   

class TestDaemon : public ODaemon, public OThread
{

public:
	TestDaemon() 
		: ODaemon("Test Daemon","a VOS Test Daemon","Star Division Cooperation", 1, TStartupMode_OnDemand) 
		, OThread()
 {}

	virtual void onStart();
	virtual void onStop();
	virtual void onPause();
	virtual void onContinue();
	virtual void onShutdown();
	
	virtual uLong 				getPropertyCount() const;
	virtual uLong 				getProperties(ODaemonProperty* 	pProperties, 
											  uLong 			count) const;
	virtual Boolean				setProperties(ODaemonProperty* 	pProperties, 
											  uLong 			count,
											  uLong&			rErrorCode,
											  OString&			errorText);
	

protected:

	virtual void run();	
	virtual void onTerminated();
	
	OCondition m_stopCond;
	OCondition m_resumeCond;
	Boolean    m_pausePending;
};

uLong TestDaemon::getPropertyCount() const
{
	return 4;	
}	

uLong TestDaemon::getProperties(ODaemonProperty* 	pProperties, 
								  uLong 			count) const
{
	IProfile* pProfile = IDaemonManager::getGlobalManager()->openProfile(((IDaemonAccess*)this)->getIdentifier());

	if (pProfile != NULL)
	{
		if (count > 0)	
		{
			pProperties[0] = ODaemonProperty("a bool", pProfile->readBool("Properties", "a bool", False));		
		}
		if (count > 1)	
		{
			char buffer[64];
			
			if (pProfile->readString("Properties", "a unsigned long", buffer, sizeof(buffer), "0"))
				pProperties[1] = ODaemonProperty("a unsigned long", (uLong)atoi(buffer));		
			else
				pProperties[1] = ODaemonProperty("a unsigned long", (uLong)0);		
		}
		if (count > 2)	
		{
			char buffer[1024];
			
			if (pProfile->readString("Properties", "a string", buffer, sizeof(buffer), ""))
				pProperties[2] = ODaemonProperty("a string", buffer);		
			else
				pProperties[2] = ODaemonProperty("a string", "");		
		}
		if (count > 3)	
		{
			char buffer[64];
			
			ODaemonProperty::TDaemonPropertyType type = ODaemonProperty::TPropertyType_Invalid;
			
			if (pProfile->readString("Properties", "any property list type", buffer, sizeof(buffer), ""))
			{
				if (strcmp(buffer, "Boolean") == 0)
				{
					type = ODaemonProperty::TPropertyType_BooleanList;
				}
				else if (strcmp(buffer, "uLong") == 0)
				{
					type = ODaemonProperty::TPropertyType_uLongList;
				}
				else if (strcmp(buffer, "String") == 0)
				{
					type = ODaemonProperty::TPropertyType_StringList;
				}

				pProperties[3] = ODaemonProperty("a any property list", type, 0);		

				Str entries;
				cStr entry;
				Size_t entriesSize = pProfile->getSectionEntries("any property list", NULL, 0);
				
				entries = new char[entriesSize];

				pProfile->getSectionEntries("any property list", entries, entriesSize);
							
				for (entry = entries; *entry != '\0'; entry += strlen(entry) + 1)
				{
					pProperties[3].setListSize(pProperties[3].getListSize() + 1);
					
					switch (type)
					{
						case ODaemonProperty::TPropertyType_BooleanList:
							{
								Boolean value = pProfile->readBool("any property list", entry, False);
								pProperties[3].setBoolean(value, pProperties[3].getListSize() - 1);
							}
							break;
						case ODaemonProperty::TPropertyType_uLongList:
							{
								char buffer[64];
								
								pProfile->readString("any property list", entry, buffer, sizeof(buffer), "0");
								pProperties[3].setULong(atoi(buffer), pProperties[3].getListSize() - 1);
							}
							break;
						case ODaemonProperty::TPropertyType_StringList:
							{
								char buffer[1024];
								
								pProfile->readString("any property list", entry, buffer, sizeof(buffer), "0");
								pProperties[3].setString(buffer, pProperties[3].getListSize() - 1);
							}
							break;
						default:
							break;
					}					
				}
					
				delete[] entries;
			}
		}
		
		IDaemonManager::getGlobalManager()->closeProfile(pProfile);		
	}	

	
	return VOS_MIN(4, count);
}

Boolean	TestDaemon::setProperties(ODaemonProperty* 	pProperties, 
								  uLong 			count,
								  uLong&			rErrorCode,
								  OString&			errorText)
{
	if (count != 4)
	{
		rErrorCode = 1;
		errorText = "wrong number of properties";
		return False;		
	}
	else
	{
		for (int i = 0; i < 4; i++)
		{
			if (pProperties[i].getName() == OString("a bool"))
			{
				if (pProperties[i].getType() != ODaemonProperty::TPropertyType_Boolean)
				{
					errorText = "'a bool' should be a Boolean";
					return False;
				}
				else if (pProperties[i].getBoolean() != False) 
				{
					errorText = "'a bool' should only be <False>";
					return False;
				}
			}
			else if (pProperties[i].getName() == OString("a unsigned long"))
			{
				if (pProperties[i].getType() != ODaemonProperty::TPropertyType_uLong)
				{
					errorText = "'a unsigned long' should be a uLong";
					return False;
				}
			}
			else if (pProperties[i].getName() == OString("a string"))
			{
				if (pProperties[i].getType() != ODaemonProperty::TPropertyType_String)
				{
					errorText = "'a string' should be a OString";
					return False;
				}
			}
			else if (pProperties[i].getName() == OString("a any property list"))
			{
			}
			else
			{
				errorText = OString("unknown property '") + pProperties[i].getName() + OString("'");
				return False;
			}
		}
		
		IProfile* pProfile = IDaemonManager::getGlobalManager()->openProfile(((IDaemonAccess*)this)->getIdentifier());

		if (pProfile != NULL)
		{
			for (i = 0; i < 4; i++)
			{
				if (pProperties[i].getName() == OString("a bool"))
				{
					pProfile->writeBool("Properties", "a bool", pProperties[i].getBoolean());
				}
				else if (pProperties[i].getName() == OString("a unsigned long"))
				{
					char buffer[64];
					sprintf(buffer, "%i", pProperties[i].getULong());
					pProfile->writeString("Properties", "a unsigned long", buffer);
				}
				else if (pProperties[i].getName() == OString("a string"))
				{
					pProfile->writeString("Properties", "a string", pProperties[i].getString());
				}
				else if (pProperties[i].getName() == OString("a any property list"))
				{
					// remove old list 
					Str entries;
					cStr entry;
					Size_t entriesSize = pProfile->getSectionEntries("any property list", NULL, 0);
					
					entries = new char[entriesSize];

					pProfile->getSectionEntries("any property list", entries, entriesSize);
								
					for (entry = entries; *entry != '\0'; entry += strlen(entry) + 1)
					{
						pProfile->removeEntry("any property list", entry);						
					}				

					delete[] entries;
					
					// add new list				
					char* buffer = NULL;
					char nameDummy[64];
					char valueDummy[64];
					uLong j;
						
					switch (pProperties[i].getType())
					{
						case ODaemonProperty::TPropertyType_BooleanList:
							buffer = "Boolean";
							for (j = 0; j < pProperties[i].getListSize(); j++)
							{
								sprintf(nameDummy, "entry %i", j + 1);
								pProfile->writeBool("any property list", nameDummy, pProperties[i].getBoolean(j));
							}
							break;
						case ODaemonProperty::TPropertyType_uLongList:
							buffer = "uLong";
							for (j = 0; j < pProperties[i].getListSize(); j++)
							{
								sprintf(nameDummy, "entry %i", j + 1);
								sprintf(valueDummy, "%i", pProperties[i].getULong(j));
								pProfile->writeString("any property list", nameDummy, valueDummy);
							}
							break;
						case ODaemonProperty::TPropertyType_StringList:
							buffer = "String";
							for (j = 0; j < pProperties[i].getListSize(); j++)
							{
								sprintf(nameDummy, "entry %i", j + 1);
								pProfile->writeString("any property list", nameDummy, (cStr)pProperties[i].getString(j));
							}
							break;
						default:
							break;
					}
					
					pProfile->writeString("Properties", "any property list type", buffer);
				}
			}
			
			IDaemonManager::getGlobalManager()->closeProfile(pProfile);		
		}
				
		return True;
	}
}											  

void TestDaemon::onStart()
{
	setStatus(TStatus_StartPending);

	m_resumeCond.set();
	m_stopCond.reset();
	m_pausePending = False;	
	
	if (!isRunning()) create();
}

void TestDaemon::onStop()
{
	setStatus(TStatus_StopPending);

	m_resumeCond.set();
	m_stopCond.set();
	m_pausePending = False;	
}

void TestDaemon::onPause()
{
	setStatus(TStatus_PausePending);

	m_resumeCond.reset();
	m_stopCond.reset();
	m_pausePending = True;	
}

void TestDaemon::onContinue()
{
	setStatus(TStatus_StartPending);

	m_resumeCond.set();
	m_stopCond.reset();
	m_pausePending = False;	
}

void TestDaemon::onShutdown()
{
	setStatus(TStatus_StopPending);

	m_resumeCond.set();
	m_stopCond.set();
	m_pausePending = False;	
}

void TestDaemon::run()
{
	TTimeValue time(1, 0);
		
	setStatus(TStatus_Running);
	cout << "started !!!" << "\n";
	cout.flush();
	
	while (m_stopCond.wait(&time) != ICondition::result_ok)
	{
		if (m_pausePending)
		{
			setStatus(TStatus_Paused);
			cout << "paused !!!" << "\n";
			cout.flush();
			m_resumeCond.wait();
			setStatus(TStatus_Running);
			cout << "resumed !!!" << "\n";
			cout.flush();
		}
		else
		{
			cout << "test !!!" << "\n";
			cout.flush();
		}
	}	
}

void TestDaemon::onTerminated()
{
	setStatus(TStatus_Stopped);
	cout << "stopped !!!" << "\n";
	cout.flush();
}	

static void dumpProperties(const ORef<IDaemonAccess>& rAccess)
{
	uLong n = rAccess->getPropertyCount();
	uLong j;
	cout << "----------------------------------------------------\n";
	cout << n << " properties found\n";
	
	if (n > 0)
	{
		ODaemonProperty* pProps = new ODaemonProperty[n];

		rAccess->getProperties(pProps, n);
		
		for (uLong i = 0; i < n; i++)
		{
			cout << i << ". '" << (cStr)pProps[i].getName() << "' ";
			switch (pProps[i].getType())
			{
				case ODaemonProperty::TPropertyType_Boolean:
					cout << "<boolean> ";
					if (pProps[i].getBoolean())
						cout << "= True\n";
					else
						cout << "= False\n";
					break;
				case ODaemonProperty::TPropertyType_BooleanList:
					cout << "<boolean list> size = " << pProps[i].getListSize() << "\n";
					for (j = 0; j < pProps[i].getListSize(); j++)
					{
						cout << "[(" << j << ") = ";
						if (pProps[i].getBoolean(j))
							cout << "True]";
						else
							cout << "False] ";
					}
					cout << "\n";
					break;
				case ODaemonProperty::TPropertyType_uLong:
					cout << "<unsigned long> = " << pProps[i].getULong() << "\n";
					break;
				case ODaemonProperty::TPropertyType_uLongList:
					cout << "<unsigned long list> size = " << pProps[i].getListSize() << "\n";
					for (j = 0; j < pProps[i].getListSize(); j++)
					{
						cout << "[(" << j << ") = "<< pProps[i].getULong(j) << "] ";
					}
					cout << "\n";
					break;
				case ODaemonProperty::TPropertyType_String:
					cout << "<string> = " << (cStr) pProps[i].getString() << "\n";
					break;
				case ODaemonProperty::TPropertyType_StringList:
					cout << "<string list> size = " << pProps[i].getListSize() << "\n";
					for (j = 0; j < pProps[i].getListSize(); j++)
					{
						cout << "[(" << j << ") = '"<< (cStr)pProps[i].getString(j) << "'] ";
					}
					cout << "\n";
					break;
				default:
					cout << "<unknown>\n";
					break;
			}
		}
		
		delete[] pProps;
	}
	cout << "----------------------------------------------------\n";
}	

#ifdef UNX
int main( int argc, char * argv[] )
#else
#ifdef OS2
int main( int argc, char * argv[] )
#else
#ifdef WIN
LRESULT CALLBACK TwainWndProc( HWND hWnd,UINT nMsg, WPARAM nPar1, LPARAM nPar2 )
{
	return DefWindowProc( hWnd, nMsg, nPar1, nPar2 );
}
int PASCAL WinMain(HINSTANCE hinstCurrent, HINSTANCE hinstPrevious,
    LPSTR lpszCmdLine, int nCmdShow)
#else
int _cdecl main( int argc, char * argv[] )
#endif
#endif
#endif
{
	if ((argc >= 2) && (strcmp(argv[1], "-test") == 0))
	{
		ORef<IDaemonAccess> rAccess = IDaemonManager::getGlobalManager()->getDaemonByIdentifier("Test Daemon");	
		uLong i;
		uLong errorCode;
						
		if (rAccess.isValid()) 
		{
			ODaemonProperty newProps[4];
			OString errorText;
					
			dumpProperties(rAccess);
			
			newProps[0] = ODaemonProperty("a bool", (Boolean)False);
			newProps[1] = ODaemonProperty("a unsigned long", (uLong)10);
			newProps[2] = ODaemonProperty("a string", OString("test test test"));
			newProps[3] = ODaemonProperty("a any property list", ODaemonProperty::TPropertyType_uLongList, 10);

			for (i = 0; i < 10; i++)
			{
				newProps[3].setULong(i, i);
			}						

			if (rAccess->setProperties(newProps, 4, errorCode, errorText))
				cout << "setProperty() ok!\n";
			else
				cout << "setProperty() error = " << (cStr) errorText << "\n";
			
			dumpProperties(rAccess);

			newProps[0] = ODaemonProperty("a bool", (Boolean)True);
			newProps[1] = ODaemonProperty("a unsigned long", (uLong)10);
			newProps[2] = ODaemonProperty("a string", OString("test test test"));
			newProps[3] = ODaemonProperty("a any property list", ODaemonProperty::TPropertyType_uLongList, 10);

			for (i = 0; i < 10; i++)
			{
				newProps[3].setULong(i, i);
			}						

			if (rAccess->setProperties(newProps, 4, errorCode, errorText))
				cout << "setProperty() ok!\n";
			else
				cout << "setProperty() error = " << (cStr) errorText << "\n";
			
			dumpProperties(rAccess);

			newProps[0] = ODaemonProperty("a bool", (Boolean)False);
			newProps[1] = ODaemonProperty("a unsigned long", (uLong)10);
			newProps[2] = ODaemonProperty("a string", OString("test test test"));
			newProps[3] = ODaemonProperty("a any property list", ODaemonProperty::TPropertyType_StringList, 10);

			OString tmp;
			char tmpBuffer[10];
			
			for (i = 0; i < 10; i++)
			{
				sprintf(tmpBuffer, "%i ", i);
				tmp += OString(tmpBuffer);
				newProps[3].setString(tmp, i);
			}						

			if (rAccess->setProperties(newProps, 4, errorCode, errorText))
				cout << "setProperty() ok!\n";
			else
				cout << "setProperty() error = " << (cStr) errorText << "\n";
			
			dumpProperties(rAccess);

			newProps[0] = ODaemonProperty("a bool", (Boolean)False);
			newProps[1] = ODaemonProperty("a unsigned long", (uLong)0);
			newProps[2] = ODaemonProperty("a string", OString());
			newProps[3] = ODaemonProperty("a any property list", ODaemonProperty::TPropertyType_uLongList, 0);

			if (rAccess->setProperties(newProps, 4, errorCode, errorText))
				cout << "setProperty() ok!\n";
			else
				cout << "setProperty() error = " << (cStr) errorText << "\n";
			
			dumpProperties(rAccess);
		}
	}
	else if ((argc >= 2) && (strcmp(argv[1], "-watch") == 0))
	{
		ORef<IDaemonListener> listener = new DaemonListener();
		
		IDaemonManager::getGlobalManager()->addListener(listener);	

		TTimeValue time(600,0);
		
		OThread::wait(time);
		
		IDaemonManager::getGlobalManager()->removeListener(listener);	
	}
	else
	{
		ORef<TestDaemon> test = new TestDaemon();

		test->execute(argc, argv);

		TTimeValue time(1,0);
		
		OThread::wait(time);
	}
		
	return 0;
}



