/*************************************************************************
 *
 *  $RCSfile: datagram.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 15:18:17 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#include <iostream.h>
#include <string.h>
#include <vos/socket.hxx>
#include <vos/thrdsrv.hxx>
#include <vos/ref.hxx>
#include <vos/thread.hxx>

#ifndef _VOS_NO_NAMESPACE
using namespace vos;
#endif

class ODatagramSender : public NAMESPACE_VOS(OExecutable)
{
public:

	virtual ~ODatagramSender()
	{
		VOS_TRACE("~ODatagramSender()\n");
	}


	Boolean execute()
	{
		
		NAMESPACE_VOS(OThread)::sleep(500);	// give receiver some time to come up.

		cout << "creating datagram sender" << endl;
		NAMESPACE_VOS(ODatagramSocket) Socket;

		cout << "Binding sender socket to any available address." << endl;

		NAMESPACE_VOS(OInetSocketAddr) Addr; 
		if(!Socket.bind(Addr))
		{
			char err[80];
			Socket.getError(err, sizeof(err));
			cout << "binding sender failed with error: " << err << endl;
			return False;
		}

		NAMESPACE_VOS(OInetSocketAddr) TargetAddr("localhost", 10000);
		cout << "Target is: " << TargetAddr.getDottedAddr() << " Port: " << TargetAddr.getPort() << endl;

		cout << "send data (Trinken 'mer eine?)" << endl;

		char* Data= "Trinken 'mer eine?";
		if(!Socket.sendTo(TargetAddr, Data, strlen(Data)+1))
		{
			char err[80];
			Socket.getError(err, sizeof(err));
			cout << "sendTo failed with error: " << err << endl;
		}

		Socket.close();

		return False;
	}
};


class ODatagramReceiver : public NAMESPACE_VOS(OExecutable)
{
public:

	virtual ~ODatagramReceiver()
	{
		VOS_TRACE("~ODatagramReceiver()\n");
	}

	Boolean execute()
	{
		cout << "creating datagram receiver" << endl;
		NAMESPACE_VOS(ODatagramSocket) Socket;

		cout << "Binding receiver socket to: " << endl;

		NAMESPACE_VOS(OInetSocketAddr) Addr("localhost", 10000); 
		cout << Addr.getDottedAddr() << " Port: " << Addr.getPort() << endl;
		if(!Socket.bind(Addr))
		{
			char err[80];
			Socket.getError(err, sizeof(err));
			cout << "binding receiver failed with error: " << err << endl;
			return False;
		}

		NAMESPACE_VOS(OInetSocketAddr) SourceAddr;

		cout << "Receive data:" << endl;

		char Data[80];
		memset(Data, 0, sizeof(Data));
		if(!Socket.recvFrom(Data, sizeof(Data), &SourceAddr))
		{
			char err[80];
			Socket.getError(err, sizeof(err));
			cout << "recvFrom failed with error: " << err << endl;
		}
		
		cout << Data << endl;

		cout << "Closing Receiver" << endl;

		return False;
	}
};


#ifdef UNX
int main() {
#else
int _cdecl main() {
#endif

	cout << "Test datagram-sockets: " << endl;



	// create sender/receiver-threads
	ORef<NAMESPACE_VOS(OThreadingServer)> server(new NAMESPACE_VOS(OThreadingServer));


	server->add(new ODatagramReceiver);
	server->add(new ODatagramSender);

	server->complete();

	return 0;
}
