/*************************************************************************
 *
 *  $RCSfile: sockets.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: jl $ $Date: 2001/03/14 10:01:12 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifdef GCC   
#define __PUT_STATIC_DATA_MEMBERS_HERE
#endif

#include <iostream.h>
#include <string.h>
#include <errno.h>


#include <vos/socket.hxx>
#include <vos/thrdsrv.hxx>
#include <vos/ref.hxx>
#include <vos/thread.hxx>
#include <vos/profile.hxx>
#include <vos/process.hxx>
#include <vos/timer.hxx>

#ifndef _OSL_TIME_H_
#include <osl/time.h>
#endif
#ifndef _VOS_NO_NAMESPACE
using namespace vos;
#endif

#define PORT   10001

class OSender : public NAMESPACE_VOS(OExecutable)
{
public:
	Boolean execute()
	{
		cout << "creating sender socket" << endl;
		NAMESPACE_VOS(OConnectorSocket) Socket;

		cout << "Binding sender socket to any available address." << endl;

		NAMESPACE_VOS(OInetSocketAddr) Addr; 
		if(!Socket.bind(Addr))
		{
			char err[80];
			Socket.getError(err, sizeof(err));
			cout << "binding sender failed with error: " << err << endl;
			return False;
		}

		cout << "connecting to: " << flush;

		NAMESPACE_VOS(OInetSocketAddr) AddrTarget("localhost", PORT);
		cout << AddrTarget.getHostname() << " Port: " << AddrTarget.getPort() << endl;

		if(Socket.connect(AddrTarget) != osl_sock_result_ok) 
		{
			char err[80];
			Socket.getError(err, sizeof(err));
			cout << "connect failed with error: " << err << endl;
			return False;
		}

		NAMESPACE_VOS(OInetSocketAddr) PeerAddr;
		cout << "Check getPeerAddr(), getPeerHost(), getPeerPort()." << endl 
			 << "All addresses should be equal." << endl << endl;
		Socket.getPeerAddr(PeerAddr);
		cout << "getPeerAddr().getHostName(): " << PeerAddr.getHostname() << endl 
			 << "getPeerAddr().getDottedAddr(): " << PeerAddr.getDottedAddr() << endl
			 << "getPeerAddr().getPort(): " << PeerAddr.getPort() << endl;
		cout << endl;
		cout << "Socket.getPeerHost(): " << Socket.getPeerHost() << endl
			 << "Socket.getPeerPort(): " << Socket.getPeerPort() << endl;


		cout << endl << "Sending data (Hallo)" << endl;

		if(Socket.send("Hallo", 5) != 5)
		{
			char err[80];
			Socket.getError(err, sizeof(err));
			cout << "send failed with error: " << err << endl;
			return False;
		}

		cout << "Closing sender" << endl;
		if(!Socket.shutdown()) 
		{
			char err[80];
			Socket.getError(err, sizeof(err));
			cout << "shutdown failed with error: " << err << endl;
			return False;
		}

		cout << "Sender done." << endl;

		return False;
	}
};

class OReceiver : public NAMESPACE_VOS(OExecutable)
{
public:
	Boolean execute()
	{

		cout << "creating receiver-socket" << endl;
		NAMESPACE_VOS(OAcceptorSocket) Socket;
		NAMESPACE_VOS(OInetSocketAddr) Addr("localhost", PORT);
  		cout << "Receiver Addr is: Host: " << Addr.getHostname() << " IP: " << Addr.getDottedAddr() << " Port: " << Addr.getPort() << endl;

		cout << endl << "binding receiver socket: " << endl;
		Socket.setReuseAddr(1);

		if(!Socket.bind(Addr))
		{
			char err[80];
			Socket.getError(err, sizeof(err));
			cout << "binding receiver failed with error: " << err << endl;
			return False;
		}

		NAMESPACE_VOS(OInetSocketAddr) LocalAddr;
		cout << "check getLocalAddr(), getLocalHost(), getLocalPort()." << endl 
			 << "All addresses should be equal." << endl << endl;

		//
		Socket.getLocalAddr(LocalAddr);

		cout << "getLocalAddr().getHostName(): "; 
		cout << LocalAddr.getHostname() << endl;
		cout << "getLocalAddr().getDottedAddr(): " << LocalAddr.getDottedAddr() << endl;
		cout << "getLocalAddr().getPort(): " << LocalAddr.getPort() << endl;
		cout << endl;
		cout << "Socket.getLocalHost(): " << Socket.getLocalHost() << endl;
		cout << "Socket.getLocalPort(): " << Socket.getLocalPort() << endl;

		cout << endl << "prep for accept" << endl << endl;

		if(!Socket.listen())
		{
			char err[80];
			Socket.getError(err, sizeof(err));
			cout << "listen failed with error: " << err << endl;
			return False;
		}

		TimeValue Tv = { 5, 0 };

		if(Socket.isRecvReady(&Tv)) 
		{
			cout << "Ready" << endl;
		} 
		else 
		{
			cout << "still not ready" << endl;
			char err[80];
			Socket.getError(err, sizeof(err));
			cout << ": " << err << endl;
		}


		NAMESPACE_VOS(OInetSocketAddr) PeerAddr;
		NAMESPACE_VOS(OStreamSocket) Connection;
		
		
		if(Socket.acceptConnection(Connection, PeerAddr) != osl_sock_result_ok)
		{
			char err[80];
			Socket.getError(err, sizeof(err));
			cout << "accept failed with error: " << err << endl;
			return False;
		}
		
		cout << "Connected to: " << endl;
		cout << "PeerAddr.getHostName(): " << PeerAddr.getHostname() << endl 
			 << "PeerAddr.getDottedAddr(): " << PeerAddr.getDottedAddr() << endl
			 << "PeerAddr.getPort(): " << PeerAddr.getPort() << endl;
		
		cout << endl <<  "Receiver got valid connection. Reading: " << flush;

		char Buffer[80];
		memset(Buffer, 0, sizeof(Buffer));
		if(Connection.recv(Buffer, 5) != 5)
		{
			char err[80];
			Socket.getError(err, sizeof(err));
			cout << "recv failed with error: " << err << endl;
			return False;
		}
		
		cout << Buffer << endl;

		cout << endl << "Receiver closes connection." << endl;

		if(!Connection.shutdown()) 
		{
			char err[80];
			Socket.getError(err, sizeof(err));
			cout << "shutdown failed with error: " << err << endl;
			return False;
		}

		Connection.close();
		cout << "Connection closed" << endl;


		cout << "Closing acceptor" << endl;
		Socket.close();
		cout << "Receiver done" << endl;

		return False;
	}
};


class OQuietSender : public NAMESPACE_VOS(OExecutable)
{
public:
	Boolean execute()
	{
		NAMESPACE_VOS(OConnectorSocket) Socket;
		NAMESPACE_VOS(OInetSocketAddr) Addr; 

		if(!Socket.bind(Addr))
		{
			char err[80];
			Socket.getError(err, sizeof(err));
			cout << "binding sender failed with error: " << err << endl;
			return False;
		}
		cout << "connecting. " << endl;

		NAMESPACE_VOS(OInetSocketAddr) AddrTarget("localhost", PORT);

		if(Socket.connect(AddrTarget) != osl_sock_result_ok) 
		{
			char err[80];
			Socket.getError(err, sizeof(err));
			cout << "connect failed with error: " << err << endl;
			return False;
		}

		if(Socket.send("Hallo", 5) != 5)
		{
			char err[80];
			Socket.getError(err, sizeof(err));
			cout << "send failed with error: " << err << endl;
			return False;
		}

		if(!Socket.shutdown()) 
		{
			char err[80];
			Socket.getError(err, sizeof(err));
			cout << "shutdown failed with error: " << err << endl;
			return False;
		}

		return False;
	}
};

class OAbortedSender : public NAMESPACE_VOS(OExecutable)
{
public:

	NAMESPACE_VOS(OConnectorSocket) m_Socket;

	Boolean execute()
	{
		NAMESPACE_VOS(OInetSocketAddr) Addr; 
		if(!m_Socket.bind(Addr))
		{
			char err[80];
			m_Socket.getError(err, sizeof(err));
			cout << "binding sender failed with error: " << err << endl;
			return False;
		}
		cout << "connecting: waiting to be aborted " << endl;

		NAMESPACE_VOS(OInetSocketAddr) AddrTarget("141.99.128.50", PORT);

		OSocket::TResult Result= m_Socket.connect(AddrTarget);
		switch(Result)
		{
		case OSocket::result_ok:
			cout << "connected: which shouldn't have happened here!" << endl;
			break;
		case OSocket::result_timeout:
			cout << "connect timed-out: which shouldn't have happened here!" << endl;
			break;
		case OSocket::result_interrupted:
			cout << "connect interrupted, like expected." << endl;
			return False;
		case OSocket::result_error:
			char err[128];
			m_Socket.getError(err, sizeof(err));
			cout << "connect failed with error: " << err << endl;
			cout << "this wasn't expected, but is not entirely false." << endl;
			return False;
		}

		if(!m_Socket.shutdown()) 
		{
			char err[80];
			m_Socket.getError(err, sizeof(err));
			cout << "shutdown failed with error: " << err << endl;
			return False;
		}

		return False;
	}
};

class OQuietReceiver : public NAMESPACE_VOS(OExecutable)
{
public:
	Boolean execute()
	{

		cout << "creating receiver-socket" << endl;
		NAMESPACE_VOS(OAcceptorSocket) Socket;
		NAMESPACE_VOS(OInetSocketAddr) Addr("localhost", PORT);

		Socket.setReuseAddr(1);

		if(!Socket.bind(Addr))
		{
			char err[80];
			Socket.getError(err, sizeof(err));
			cout << "binding receiver failed with error: " << err << endl;
			return False;
		}

		cout << endl << "Is ready to accept?" << endl << endl;

		if(!Socket.listen())
		{
			char err[80];
			Socket.getError(err, sizeof(err));
			cout << "listen failed with error: " << err << endl;
			return False;
		}

		TimeValue Tv = { 5, 0 };

		if(Socket.isRecvReady(&Tv)) 
		{
			cout << "ready" << endl;
		} else {
			cout << "still not ready" << endl;
		}


		NAMESPACE_VOS(OInetSocketAddr) PeerAddr;
		NAMESPACE_VOS(OStreamSocket) Connection;
		

		if(Socket.acceptConnection(Connection, PeerAddr) != osl_sock_result_ok)
		{
			char err[80];
			Socket.getError(err, sizeof(err));
			cout << "accept failed with error: " << err << endl;
			return False;
		}
		
		cout << "Accepted: " << PeerAddr.getDottedAddr() << " Port: " << PeerAddr.getPort() << endl;
		
		char Buffer[80];
		memset(Buffer, 0, sizeof(Buffer));
		if(Connection.recv(Buffer, 5) != 5)
		{
			char err[80];
			Socket.getError(err, sizeof(err));
			cout << "recv failed with error: " << err << endl;
			return False;
		}
		
		cout << Buffer << endl;

		cout << endl << "Receiver closes connection." << endl;

		if(!Connection.shutdown()) 
		{
			char err[80];
			Socket.getError(err, sizeof(err));
			cout << "shutdown failed with error: " << err << endl;
			return False;
		}

		Connection.close();
		cout << "Connection closed" << endl;


		cout << "Closing acceptor" << endl;
		Socket.close();
		cout << "Receiver done" << endl;

		return False;
	}
};

#ifdef UNX
int main()
#else
int _cdecl main()
#endif
{
	cout << "Test socket: " << endl;

	cout << "Some test on InetSocketAddr:" << endl;

	NAMESPACE_VOS(OInetSocketAddr) Addr("localhost", PORT);

	// getFamily()
	if(Addr.getFamily() != osl_af_inet)
	{
		cout << "Family of OInetSocketAddr is not af_inet as expected!" << endl;
	}
	
	// getServicePort()
	cout << "Service-Port for FTP (21): " << NAMESPACE_VOS(OInetSocketAddr)::getServicePort("ftp", "tcp") << endl;

	// getPort()/setPort
	int Port= 21;
	VOS_VERIFY(Addr.setPort(Port));
	if(Addr.getPort() != Port) 
	{
		cout << "OInetSocketAddr: setPort()/getPort() difference!" << endl;
	}

	// Socket: getType()
	NAMESPACE_VOS(OSocket) Socket(OSocket::sock_stream);
	if(Socket.getType() != OSocket::sock_stream) 
	{
		cout << "Expected socket to be of type sock_stream!" << endl;
	}

	cout << endl;

	// create sender/receiver-threads
	ORef<NAMESPACE_VOS(OThreadingServer)> server(new NAMESPACE_VOS(OThreadingServer));

	cout << "------------------------------------------------------------------" << endl;

	server->add(new OReceiver);
	server->add(new OSender);

	server->complete();


	cout << "------------------------------------------------------------------" << endl;

	// testing timeout (read)
	cout << endl << "timeout-test 1: after 4 seconds receiver should say 'ready' and proceed connecting." << endl;
	server->add(new OQuietReceiver);
	NAMESPACE_VOS(OThread)::wait(TTimeValue(3000));
	server->add(new OQuietSender);

	server->complete();

	cout << "------------------------------------------------------------------" << endl;

	cout << endl << "timeout-test 2: after 5 seconds receiver should say 'still not ready'." << endl;
	server->add(new OQuietReceiver);
	NAMESPACE_VOS(OThread)::wait(TTimeValue(6000));
	server->add(new OQuietSender);

	server->complete();

	cout << "------------------------------------------------------------------" << endl;

	ORef<OAbortedSender> sender(new OAbortedSender);

	server->add(sender.getBodyPtr());
	NAMESPACE_VOS(OThread)::wait(TTimeValue(1000));
	cout << "closing connecting socket from another thread." << endl;
	cout << "Be patient, it may take the system some time to notice an invalid socket.";
	cout << endl;

	sender->m_Socket.close();

	server->complete();

	return 0;
}



