/*************************************************************************
 *
 *  $RCSfile: thr_srv.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 15:18:18 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/



#include <iostream.h>

#include <vos/future.hxx>
#include <vos/execabl.hxx>
#include <vos/ref.hxx>
#include <vos/thread.hxx>
#include <vos/thrdsrv.hxx>

#ifndef _VOS_NO_NAMESPACE
using namespace vos;
#endif

class OGifData {
public:
	char Data[10];
};

class OJpegData {
public:
	char Data[30];
};


class OMpegData {
public:
	char Data[40];
};

class OGifLoader : public VOS_NAMESPACE(OExecutable, vos) {
public:

	OGifLoader(OFutureRef<OGifData> GifDataFuture) {
		m_GifDataFuture= GifDataFuture;
		cout << "OGifLoader" << endl;
	}

	~OGifLoader() {
		cout << "~OGifLoader" << endl;
	}

	Boolean execute()  {
		OGifData GifData;

		cout << "OGifLoader: loading data..." << endl;

		OThread::sleep(3000);

		// load the gif into Data
		m_GifDataFuture.setData(GifData);

		// alternative user declares data valid
		cout << "OGifLoader: declaring data valid" << endl;
		m_GifDataFuture.dataValid();

		return False;
	}

protected:
	OFutureRef<OGifData> m_GifDataFuture;

};

class OGifViewer :public VOS_NAMESPACE(OExecutable,vos) {
public:

	OGifViewer(OFutureRef<OGifData> p) {
		m_Gif= p;
	}

	~OGifViewer() {
		cout << "~OGifViewer" << endl;
	}

	Boolean execute() {

		cout << "OGifViewer::run()" << endl;
		show(m_Gif.getData());

		return False;
	}

protected:
	void show(const OGifData& data) {
		cout << "OGifViewer: show" << endl;
	}

	OFutureRef<OGifData> m_Gif;
};




/****/


class OJpegLoader : public VOS_NAMESPACE(OExecutable, vos) {
public:

	OJpegLoader(OFutureRef<OJpegData> DataFuture) {
		m_DataFuture= DataFuture;
	}

	~OJpegLoader() {
		cout << "~OJpegLoader" << endl;
	}

	Boolean execute()  {
		OJpegData Data;

		cout << "OJPegLoader: loading data..." << endl;

		OThread::sleep(4000);

		// load the gif into Data
		m_DataFuture.setData(Data);

		// alternative user declares data valid
		cout << "OJPegLoader: declaring data valid" << endl;
		m_DataFuture.dataValid();

		return False;
	}

protected:
	OFutureRef<OJpegData> m_DataFuture;
};

class OJpegViewer :public VOS_NAMESPACE(OExecutable,vos) {
public:

	OJpegViewer(OFutureRef<OJpegData> p) {
		m_Data= p;
	}

	~OJpegViewer() {
		cout << "~OJpegViewer" << endl;
	}

	Boolean execute() {

		cout << "OJpegViewer::run()" << endl;
		show(m_Data.getData());

		return False;
	}

protected:
	void show(const OJpegData& data) {
		cout << "OJpegViewer: show" << endl;
	}

	OFutureRef<OJpegData> m_Data;
};


class OTest : virtual public NAMESPACE_VOS(OExecutable)
{
	static int m_count;
	int m_id;
public:
	OTest() 
	{
		m_id= m_count++;
		cout << "OTest " <<  m_id << endl;
	}

	OTest(OTest& t) 
	{
		m_id= m_count++;
		cout << "new OTest " <<  m_id << " as copy of: " << t.m_id << endl;
	}

	~OTest() 
	{
		cout <<  "~OTest " <<  m_id << endl;
	}

	Boolean execute()
	{
		cout << "execute " <<  m_id << endl;
		return True;
	}

	void hello()
	{
		cout << "OTest:hello " <<  m_id << endl;
	}
};

int OTest::m_count= 0;

ORef<OTest> f() 
{


	ORef<OTest> r(new OTest);
	ORef<OTest> r1;



	r1.bind(new OTest);

	r->execute();
	r1->execute();

	r->hello();
	r1->hello();

	r1= r;

	return r;

}


int main() {


	ORef<OThreadingServer> server(new OThreadingServer);

	OFutureRef<OGifData> GifData;
	GifData.create();
	
	server->add(new OGifLoader(GifData));

	OFutureRef<OJpegData> JpegData;
	JpegData.create();

	server->add(new OJpegLoader(JpegData));

	server->add(new OGifViewer(GifData));
	server->add(new OJpegViewer(JpegData));

	cout << "waiting for threads" << endl;

	
	while(server->getNextCompleted().isValid())
	{
		cout << "completed" << endl;
	}
	
	cout << "done" << endl;

/*
	OExecutionServer m_Pool;

	OFutureRef<OGifData> GifData;
	GifData.create();

	OFutureRef<OJpegData> JpegData;
	JpegData.create();

//	OFutureRef<OMpegData> MpegData;
//	MpegData.create();
	// producer
	m_Pool.add(new OGifLoader(GifData));
	m_Pool.add(new OJpegLoader(JpegData));
//	m_Pool.add(new OMPegLoader(MpegData));

	// consumer
	m_Pool.add(new OGifViewer(GifData));
	m_Pool.add(new OJpegViewer(JpegData));
//	m_Pool.add(new OMPegViewer(MPegData));

	m_Pool.execute();

//	m_Pool.complete();
	OGifData d= GifData;
*/

	return 0;
}
