/*************************************************************************
 *
 *  $RCSfile: lst_tdat.c,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 15:29:01 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


#include "precomp.h"
#include "lst_tdat.h"

#include <string.h>
#include "new_del.h"



/*** List ***/

void
ListTagData_CTOR( ListTagData_THIS,
				  char *	i_pType,
				  Bool      i_bAutoDeleteData )
{
	THIS_->dpStart = 0;
	THIS_->pEnd = 0;
	TagType_CTOR( MREF(aType), (i_pType != 0 ? i_pType : "") );
	THIS_->bAutoDeleteData = i_bAutoDeleteData;
}

void
ListTagData_DTOR( ListTagData_THIS )
{
	LTD_Empty(THIS_,THIS_->bAutoDeleteData);
	TagType_DTOR( MREF(aType) );
}

void
LTD_Add( ListTagData_THIS,
		 TagData *	   i_pData )
{
	LTDElem * dpNewElem = 0;
	ASSIGN_NEW1(dpNewElem,LTDElem,i_pData);

	if ( pThis->dpStart != 0)
	{
		LTDE_SetNext(pThis->pEnd,dpNewElem);
		pThis->pEnd = dpNewElem;
	}
	else
	{
		pThis->dpStart = dpNewElem;
		pThis->pEnd = pThis->dpStart;
	}
}

void
LTD_Empty( ListTagData_THIS,
		   Bool	i_bDeleteData )
{
	LTDElem * pIter = 0;
	LTDElem * pDel =  0;

	if (pThis->dpStart == 0)
		return;

	pIter = LTDE_Next(pThis->dpStart);
	pDel =  pThis->dpStart;
	if (i_bDeleteData)
	{
		LTDE_DeleteData( pDel );
	}
	DELETE( pDel, LTDElem );


	while( pIter != 0 )
	{
		pDel = pIter;
		pIter = LTDE_Next(pIter);
		if (i_bDeleteData)
		{
			LTDE_DeleteData( pDel );
		}
		DELETE( pDel, LTDElem );
	}	/* end while */

	pThis->dpStart = 0;
	pThis->pEnd = 0;
}

LTDIterator
LTD_Begin( ListTagData_THIS )
{
	LTDIterator ret;
	LTDIterator_CTOR( REF(ret), pThis->dpStart );
	return ret;
}

TagType *
LTD_Type( ListTagData_THIS )
{
	return MREF(aType);
}


Bool
LTD_MatchesEndTag( ListTagData_THIS,
				   char *  i_pText )
{
	Cstring aEndTag;
	Bool ret = False;

	Cstring_CTOR(&aEndTag,"");
	TT_GetEndTag(MREF(aType),&aEndTag);

	ret = strnicmp(Cs_Str(&aEndTag),i_pText,Cs_Length(&aEndTag));

	Cstring_DTOR(&aEndTag);
    return ret;
}

intt
LTD_EndTagLength( ListTagData_THIS )
{
	return strlen(TT_ElementName(MREF(aType))) + 3;
}


/*** ListIterator ***/

void
LTDIterator_CTOR( LTDIterator_THIS,
				  LTDElem *     i_pElement )
{
	pThis->pElement = i_pElement;
}

void
LTDI_opp( LTDIterator_THIS )
{
	if (pThis->pElement != 0)
		pThis->pElement = LTDE_Next(pThis->pElement);
}


Bool
LTDI_obool( LTDIterator_THIS )
{
	return pThis->pElement != 0;
}

TagData *
LTDI_optr( LTDIterator_THIS )
{
	return pThis->pElement != 0
			? LTDE_Data(pThis->pElement)
			: 0;
}


/*** ListElement ***/

void
LTDElem_CTOR( LTDElem_THIS,
			  TagData *	i_pData )
{
	pThis->pData = i_pData;
	pThis->pNext = 0;
}

void
LTDElem_DTOR( LTDElem_THIS )
{
}

TagData *
LTDE_Data( LTDElem_THIS )
{
	return pThis->pData;
}

LTDElem *
LTDE_Next( LTDElem_THIS )
{
	return pThis->pNext;
}

void
LTDE_SetNext( LTDElem_THIS,
			  LTDElem *	i_pNext )
{
	pThis->pNext = i_pNext;
}

void
LTDE_DeleteData( LTDElem_THIS )
{
	DELETE(THIS_->pData,TagData);
}

