/*************************************************************************
 *
 *  $RCSfile: lst_tdat.h,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 15:29:01 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef CPV_LST_TDAT_H
#define CPV_LST_TDAT_H

#include "tagdata.h"
#include "tagtype.h"




typedef struct LTDElem
{
	TagData *			pData;
	struct LTDElem *	pNext;
} LTDElem;


typedef struct LTDIterator
{
	LTDElem *       	pElement;
} LTDIterator;


typedef struct ListTagData
{
	LTDElem *			dpStart;
	LTDElem *			pEnd;
	TagType				aType;
    Bool                bAutoDeleteData;
} ListTagData;


#define ListTagData_THIS  	ListTagData * pThis
#define LTDIterator_THIS	LTDIterator * pThis
#define LTDElem_THIS	    LTDElem * pThis



void				ListTagData_CTOR( ListTagData_THIS,
						char	*			i_pType,
						Bool                i_bAutoDeleteData );
void				ListTagData_DTOR( ListTagData_THIS );

void				LTD_Add( ListTagData_THIS,
						TagData *			i_pData );
void				LTD_Empty( ListTagData_THIS,
						Bool				i_bDeleteData );

LTDIterator			LTD_Begin( ListTagData_THIS );
TagType *			LTD_Type( ListTagData_THIS );
Bool				LTD_MatchesEndTag( ListTagData_THIS,
						char *				i_pText );
intt				LTD_EndTagLength( ListTagData_THIS );


void				LTDIterator_CTOR( LTDIterator_THIS,
						LTDElem *     		i_pElement );
void				LTDI_opp( LTDIterator_THIS );  	/** operator++()  */

Bool				LTDI_obool( LTDIterator_THIS );
TagData *			LTDI_optr( LTDIterator_THIS );  	/** operator->()  */


void				LTDElem_CTOR( LTDElem_THIS,
						TagData *			i_pData );
void				LTDElem_DTOR( LTDElem_THIS );

TagData *			LTDE_Data( LTDElem_THIS );
LTDElem *			LTDE_Next( LTDElem_THIS );

void				LTDE_SetNext( LTDElem_THIS,
						LTDElem *			i_pNext );
void				LTDE_DeleteData( LTDElem_THIS );



#endif

