*** orig/dmake/sysintf.c	Sat Sep  9 18:36:53 2000
--- modified/dmake/sysintf.c	Sat Sep  9 18:36:53 2000
***************
*** 1,26 ****
! /* RCS  $Id: sysintf.c,v 1.1.1.1 1997/07/15 16:02:26 dvadura Exp $
  --
  -- SYNOPSIS
  --      System independent interface
  -- 
  -- DESCRIPTION
  --	These are the routines constituting the system interface.
  --	The system is taken to be essentially POSIX conformant.
  --	The original code was extensively revised by T J Thompson at MKS,
  --	and the library cacheing was added by Eric Gisin at MKS.  I then
  --	revised the code yet again, to improve the lib cacheing, and to
  --	make it more portable.
  --
  --	The following is a list of routines that are required by this file
  --	in order to work.  These routines are provided as functions by the
  --	standard C lib of the target system or as #defines in system/sysintf.h
  --	or via appropriate C code in the system/ directory for the given
  --	system.
  --
  --	The first group must be provided by a file in the system/ directory
  --	the second group is ideally provided by the C lib.  However, there
  --	are instances where the C lib implementation of the specified routine
  --	does not exist, or is incorrect.  In these instances the routine
  --	must be provided by the the user in the system/ directory of dmake.
  --	(For example, the bsd/ dir contains code for putenv(), and tempnam())
  --
--- 1,26 ----
! /* RCS  $Id: sysintf.c,v 1.2 1998/07/15 11:42:49 hjs Exp $
  --
  -- SYNOPSIS
  --      System independent interface
  -- 
  -- DESCRIPTION
  --	These are the routines constituting the system interface.
  --	The system is taken to be essentially POSIX conformant.
  --	The original code was extensively revised by T J Thompson at MKS,
  --	and the library cacheing was added by Eric Gisin at MKS.  I then
  --	revised the code yet again, to improve the lib cacheing, and to
  --	make it more portable.
  --
  --	The following is a list of routines that are required by this file
  --	in order to work.  These routines are provided as functions by the
  --	standard C lib of the target system or as #defines in system/sysintf.h
  --	or via appropriate C code in the system/ directory for the given
  --	system.
  --
  --	The first group must be provided by a file in the system/ directory
  --	the second group is ideally provided by the C lib.  However, there
  --	are instances where the C lib implementation of the specified routine
  --	does not exist, or is incorrect.  In these instances the routine
  --	must be provided by the the user in the system/ directory of dmake.
  --	(For example, the bsd/ dir contains code for putenv(), and tempnam())
  --
***************
*** 577,627 ****
  int	status;
  int	ignore;
  int	abort_flg;
  CELLPTR target;
  {
     status = ((status&0xff)==0 ? status>>8
  	    : (status & 0xff)==SIGTERM ? -1
  	    : (status & 0x7f)+128);
  
     if( status )
        if( !abort_flg ) {
  	 char buf[512];
  
  	 sprintf(buf, "%s:  Error code %d, while making '%s'",
  		 Pname, status, target->ce_fname );
  
  	 if( ignore || Continue ) {
  	    if (!(Glob_attr & A_SILENT)) {
  	       strcat(buf, " (Ignored" );
  
  	       if ( Continue ) {
  		  strcat(buf,",Continuing");
  		  target->ce_attr |= A_ERROR;
  	       }
  	       strcat(buf,")");
! 	       fprintf(stderr, "%s\n", buf);
  	    }
  
  	    if( target->ce_attr & A_ERRREMOVE
  	     && Remove_file( target->ce_fname ) == 0
  	     && !(Glob_attr & A_SILENT))
  	       fprintf(stderr,"%s:  '%s' removed.\n", Pname, target->ce_fname);
  	 }
  	 else {
  	    fprintf(stderr, "%s\n",buf);
  
  	    if(!(target->ce_attr & A_PRECIOUS)||(target->ce_attr & A_ERRREMOVE))
  	       if( Remove_file( target->ce_fname ) == 0 )
  		  fprintf(stderr,"%s:  '%s' removed.\n", Pname,
  			  target->ce_fname);
  
  	    Quit();
  	 }
        }
        else if(!(target->ce_attr & A_PRECIOUS)||(target->ce_attr & A_ERRREMOVE))
  	 Remove_file( target->ce_fname );
  }
  
  
  PUBLIC void
  Update_time_stamp( cp )
--- 577,628 ----
  int	status;
  int	ignore;
  int	abort_flg;
  CELLPTR target;
  {
     status = ((status&0xff)==0 ? status>>8
  	    : (status & 0xff)==SIGTERM ? -1
  	    : (status & 0x7f)+128);
  
     if( status )
        if( !abort_flg ) {
  	 char buf[512];
  
  	 sprintf(buf, "%s:  Error code %d, while making '%s'",
  		 Pname, status, target->ce_fname );
  
  	 if( ignore || Continue ) {
  	    if (!(Glob_attr & A_SILENT)) {
  	       strcat(buf, " (Ignored" );
  
  	       if ( Continue ) {
  		  strcat(buf,",Continuing");
  		  target->ce_attr |= A_ERROR;
  	       }
  	       strcat(buf,")");
! 		   if (Verbose)
! 	       	fprintf(stderr, "%s\n", buf);
  	    }
  
  	    if( target->ce_attr & A_ERRREMOVE
  	     && Remove_file( target->ce_fname ) == 0
  	     && !(Glob_attr & A_SILENT))
  	       fprintf(stderr,"%s:  '%s' removed.\n", Pname, target->ce_fname);
  	 }
  	 else {
  	    fprintf(stderr, "%s\n",buf);
  
  	    if(!(target->ce_attr & A_PRECIOUS)||(target->ce_attr & A_ERRREMOVE))
  	       if( Remove_file( target->ce_fname ) == 0 )
  		  fprintf(stderr,"%s:  '%s' removed.\n", Pname,
  			  target->ce_fname);
  
  	    Quit();
  	 }
        }
        else if(!(target->ce_attr & A_PRECIOUS)||(target->ce_attr & A_ERRREMOVE))
  	 Remove_file( target->ce_fname );
  }
  
  
  PUBLIC void
  Update_time_stamp( cp )
