/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM ../../../../../mozilla/embedding/components/commandhandler/public/nsIControllerCommandManager.idl
 */

#ifndef __gen_nsIControllerCommandManager_h__
#define __gen_nsIControllerCommandManager_h__


#ifndef __gen_nsISupports_h__
#include "nsISupports.h"
#endif

#ifndef __gen_nsIControllerCommand_h__
#include "nsIControllerCommand.h"
#endif

#ifndef __gen_nsICommandParams_h__
#include "nsICommandParams.h"
#endif

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif

/* starting interface:    nsIControllerCommandManager */
#define NS_ICONTROLLERCOMMANDMANAGER_IID_STR "65a2f51a-1dd2-11b2-889f-d886b255ffe7"

#define NS_ICONTROLLERCOMMANDMANAGER_IID \
  {0x65a2f51a, 0x1dd2, 0x11b2, \
    { 0x88, 0x9f, 0xd8, 0x86, 0xb2, 0x55, 0xff, 0xe7 }}

/**
   * Gets the command states based on the input parameters
   * @param aCommandParams   this will pass in the states that need to beupdated. the results will be
   *                  placed in the value portion of the command Params
   */
/**
 * nsIControllerCommandManager
 * 
 * An interface via which a controller can maintain a series of commands,
 * and efficiently dispatch commands to their respective handlers.
 *
 * Controllers that use an nsIControllerCommandManager should support
 * nsIInterfaceRequestor, and be able to return an interface to their
 * controller command manager via getInterface().
 * 
 */
class NS_NO_VTABLE nsIControllerCommandManager : public nsISupports {
 public: 

  NS_DEFINE_STATIC_IID_ACCESSOR(NS_ICONTROLLERCOMMANDMANAGER_IID)

  /**
   * Register and unregister commands with the command manager.
   *
   * @param aCommandName  the name of the command under which to register or
   *                      unregister the given command handler.
   *
   * @param aCommand      the handler for this command.
   */
  /* void registerCommand (in DOMString aCommandName, in nsIControllerCommand aCommand); */
  NS_IMETHOD RegisterCommand(const nsAString & aCommandName, nsIControllerCommand *aCommand) = 0;

  /* void unregisterCommand (in DOMString aCommandName, in nsIControllerCommand aCommand); */
  NS_IMETHOD UnregisterCommand(const nsAString & aCommandName, nsIControllerCommand *aCommand) = 0;

  /**
   * Find the command handler which has been registered to handle the named command.
   *
   * @param aCommandName  the name of the command to find the handler for.
   */
  /* nsIControllerCommand findCommandHandler (in DOMString aCommandName); */
  NS_IMETHOD FindCommandHandler(const nsAString & aCommandName, nsIControllerCommand **_retval) = 0;

  /**
   * Get whether the named command is enabled.
   *
   * @param aCommandName    the name of the command to test
   * @param aCommandRefCon  the command context data
   */
  /* boolean isCommandEnabled (in DOMString aCommandName, in nsISupports aCommandRefCon); */
  NS_IMETHOD IsCommandEnabled(const nsAString & aCommandName, nsISupports *aCommandRefCon, PRBool *_retval) = 0;

  /**
   * Tell the command to udpate its state (if it is a state updating command)
   *
   * @param aCommandName    the name of the command to update
   * @param aCommandRefCon  the command context data
   */
  /* void updateCommandState (in DOMString aCommandName, in nsISupports aCommandRefCon); */
  NS_IMETHOD UpdateCommandState(const nsAString & aCommandName, nsISupports *aCommandRefCon) = 0;

  /**
   * Get whether the named command is supported.
   *
   * @param aCommandName    the name of the command to test
   * @param aCommandRefCon  the command context data
   */
  /* boolean supportsCommand (in DOMString aCommandName, in nsISupports aCommandRefCon); */
  NS_IMETHOD SupportsCommand(const nsAString & aCommandName, nsISupports *aCommandRefCon, PRBool *_retval) = 0;

  /**
   * Execute the named command.
   *
   * @param aCommandName    the name of the command to execute
   * @param aCommandRefCon  the command context data
   */
  /* void doCommand (in DOMString aCommandName, in nsISupports aCommandRefCon); */
  NS_IMETHOD DoCommand(const nsAString & aCommandName, nsISupports *aCommandRefCon) = 0;

  /* void doCommandParams (in nsICommandParams aParam, in nsISupports aCommandRefCon); */
  NS_IMETHOD DoCommandParams(nsICommandParams *aParam, nsISupports *aCommandRefCon) = 0;

  /* void getCommandState (in nsICommandParams aParam, in nsISupports aCommandRefCon); */
  NS_IMETHOD GetCommandState(nsICommandParams *aParam, nsISupports *aCommandRefCon) = 0;

};

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSICONTROLLERCOMMANDMANAGER \
  NS_IMETHOD RegisterCommand(const nsAString & aCommandName, nsIControllerCommand *aCommand); \
  NS_IMETHOD UnregisterCommand(const nsAString & aCommandName, nsIControllerCommand *aCommand); \
  NS_IMETHOD FindCommandHandler(const nsAString & aCommandName, nsIControllerCommand **_retval); \
  NS_IMETHOD IsCommandEnabled(const nsAString & aCommandName, nsISupports *aCommandRefCon, PRBool *_retval); \
  NS_IMETHOD UpdateCommandState(const nsAString & aCommandName, nsISupports *aCommandRefCon); \
  NS_IMETHOD SupportsCommand(const nsAString & aCommandName, nsISupports *aCommandRefCon, PRBool *_retval); \
  NS_IMETHOD DoCommand(const nsAString & aCommandName, nsISupports *aCommandRefCon); \
  NS_IMETHOD DoCommandParams(nsICommandParams *aParam, nsISupports *aCommandRefCon); \
  NS_IMETHOD GetCommandState(nsICommandParams *aParam, nsISupports *aCommandRefCon); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSICONTROLLERCOMMANDMANAGER(_to) \
  NS_IMETHOD RegisterCommand(const nsAString & aCommandName, nsIControllerCommand *aCommand) { return _to RegisterCommand(aCommandName, aCommand); } \
  NS_IMETHOD UnregisterCommand(const nsAString & aCommandName, nsIControllerCommand *aCommand) { return _to UnregisterCommand(aCommandName, aCommand); } \
  NS_IMETHOD FindCommandHandler(const nsAString & aCommandName, nsIControllerCommand **_retval) { return _to FindCommandHandler(aCommandName, _retval); } \
  NS_IMETHOD IsCommandEnabled(const nsAString & aCommandName, nsISupports *aCommandRefCon, PRBool *_retval) { return _to IsCommandEnabled(aCommandName, aCommandRefCon, _retval); } \
  NS_IMETHOD UpdateCommandState(const nsAString & aCommandName, nsISupports *aCommandRefCon) { return _to UpdateCommandState(aCommandName, aCommandRefCon); } \
  NS_IMETHOD SupportsCommand(const nsAString & aCommandName, nsISupports *aCommandRefCon, PRBool *_retval) { return _to SupportsCommand(aCommandName, aCommandRefCon, _retval); } \
  NS_IMETHOD DoCommand(const nsAString & aCommandName, nsISupports *aCommandRefCon) { return _to DoCommand(aCommandName, aCommandRefCon); } \
  NS_IMETHOD DoCommandParams(nsICommandParams *aParam, nsISupports *aCommandRefCon) { return _to DoCommandParams(aParam, aCommandRefCon); } \
  NS_IMETHOD GetCommandState(nsICommandParams *aParam, nsISupports *aCommandRefCon) { return _to GetCommandState(aParam, aCommandRefCon); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSICONTROLLERCOMMANDMANAGER(_to) \
  NS_IMETHOD RegisterCommand(const nsAString & aCommandName, nsIControllerCommand *aCommand) { return !_to ? NS_ERROR_NULL_POINTER : _to->RegisterCommand(aCommandName, aCommand); } \
  NS_IMETHOD UnregisterCommand(const nsAString & aCommandName, nsIControllerCommand *aCommand) { return !_to ? NS_ERROR_NULL_POINTER : _to->UnregisterCommand(aCommandName, aCommand); } \
  NS_IMETHOD FindCommandHandler(const nsAString & aCommandName, nsIControllerCommand **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->FindCommandHandler(aCommandName, _retval); } \
  NS_IMETHOD IsCommandEnabled(const nsAString & aCommandName, nsISupports *aCommandRefCon, PRBool *_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->IsCommandEnabled(aCommandName, aCommandRefCon, _retval); } \
  NS_IMETHOD UpdateCommandState(const nsAString & aCommandName, nsISupports *aCommandRefCon) { return !_to ? NS_ERROR_NULL_POINTER : _to->UpdateCommandState(aCommandName, aCommandRefCon); } \
  NS_IMETHOD SupportsCommand(const nsAString & aCommandName, nsISupports *aCommandRefCon, PRBool *_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->SupportsCommand(aCommandName, aCommandRefCon, _retval); } \
  NS_IMETHOD DoCommand(const nsAString & aCommandName, nsISupports *aCommandRefCon) { return !_to ? NS_ERROR_NULL_POINTER : _to->DoCommand(aCommandName, aCommandRefCon); } \
  NS_IMETHOD DoCommandParams(nsICommandParams *aParam, nsISupports *aCommandRefCon) { return !_to ? NS_ERROR_NULL_POINTER : _to->DoCommandParams(aParam, aCommandRefCon); } \
  NS_IMETHOD GetCommandState(nsICommandParams *aParam, nsISupports *aCommandRefCon) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetCommandState(aParam, aCommandRefCon); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsControllerCommandManager : public nsIControllerCommandManager
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSICONTROLLERCOMMANDMANAGER

  nsControllerCommandManager();
  virtual ~nsControllerCommandManager();
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsControllerCommandManager, nsIControllerCommandManager)

nsControllerCommandManager::nsControllerCommandManager()
{
  NS_INIT_ISUPPORTS();
  /* member initializers and constructor code */
}

nsControllerCommandManager::~nsControllerCommandManager()
{
  /* destructor code */
}

/* void registerCommand (in DOMString aCommandName, in nsIControllerCommand aCommand); */
NS_IMETHODIMP nsControllerCommandManager::RegisterCommand(const nsAString & aCommandName, nsIControllerCommand *aCommand)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void unregisterCommand (in DOMString aCommandName, in nsIControllerCommand aCommand); */
NS_IMETHODIMP nsControllerCommandManager::UnregisterCommand(const nsAString & aCommandName, nsIControllerCommand *aCommand)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIControllerCommand findCommandHandler (in DOMString aCommandName); */
NS_IMETHODIMP nsControllerCommandManager::FindCommandHandler(const nsAString & aCommandName, nsIControllerCommand **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* boolean isCommandEnabled (in DOMString aCommandName, in nsISupports aCommandRefCon); */
NS_IMETHODIMP nsControllerCommandManager::IsCommandEnabled(const nsAString & aCommandName, nsISupports *aCommandRefCon, PRBool *_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void updateCommandState (in DOMString aCommandName, in nsISupports aCommandRefCon); */
NS_IMETHODIMP nsControllerCommandManager::UpdateCommandState(const nsAString & aCommandName, nsISupports *aCommandRefCon)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* boolean supportsCommand (in DOMString aCommandName, in nsISupports aCommandRefCon); */
NS_IMETHODIMP nsControllerCommandManager::SupportsCommand(const nsAString & aCommandName, nsISupports *aCommandRefCon, PRBool *_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void doCommand (in DOMString aCommandName, in nsISupports aCommandRefCon); */
NS_IMETHODIMP nsControllerCommandManager::DoCommand(const nsAString & aCommandName, nsISupports *aCommandRefCon)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void doCommandParams (in nsICommandParams aParam, in nsISupports aCommandRefCon); */
NS_IMETHODIMP nsControllerCommandManager::DoCommandParams(nsICommandParams *aParam, nsISupports *aCommandRefCon)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void getCommandState (in nsICommandParams aParam, in nsISupports aCommandRefCon); */
NS_IMETHODIMP nsControllerCommandManager::GetCommandState(nsICommandParams *aParam, nsISupports *aCommandRefCon)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif

#define NS_CONTROLLERCOMMANDMANAGER_CID \
{ 0xf424fd81, 0xcca6, 0x11d5, { 0xa7, 0x3c, 0xdc, 0x62, 0x8c, 0x6e, 0x85, 0xbc } }
#define NS_CONTROLLERCOMMANDMANAGER_CONTRACTID \
 "@mozilla.org/embedcomp/controller-command-manager;1"

#endif /* __gen_nsIControllerCommandManager_h__ */
