/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM ../../../../../mozilla/security/manager/ssl/public/nsIPK11TokenDB.idl
 */

#ifndef __gen_nsIPK11TokenDB_h__
#define __gen_nsIPK11TokenDB_h__


#ifndef __gen_nsISupports_h__
#include "nsISupports.h"
#endif

#ifndef __gen_nsIEnumerator_h__
#include "nsIEnumerator.h"
#endif

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif
#define NS_PK11TOKENDB_CONTRACTID "@mozilla.org/security/pk11tokendb;1"

/* starting interface:    nsIPK11Token */
#define NS_IPK11TOKEN_IID_STR "51191434-1dd2-11b2-a17c-e49c4e99a4e3"

#define NS_IPK11TOKEN_IID \
  {0x51191434, 0x1dd2, 0x11b2, \
    { 0xa1, 0x7c, 0xe4, 0x9c, 0x4e, 0x99, 0xa4, 0xe3 }}

/**
 * The PK11 Token Database provides access to the PK11 modules
 * that are installed, and the tokens that are available.
 * Interfaces: nsIPK11TokenDB
 * Threading: ??
 */
class NS_NO_VTABLE nsIPK11Token : public nsISupports {
 public: 

  NS_DEFINE_STATIC_IID_ACCESSOR(NS_IPK11TOKEN_IID)

  enum { ASK_EVERY_TIME = -1 };

  enum { ASK_FIRST_TIME = 0 };

  enum { ASK_EXPIRE_TIME = 1 };

  /* readonly attribute wstring tokenName; */
  NS_IMETHOD GetTokenName(PRUnichar * *aTokenName) = 0;

  /* readonly attribute wstring tokenLabel; */
  NS_IMETHOD GetTokenLabel(PRUnichar * *aTokenLabel) = 0;

  /* readonly attribute wstring tokenManID; */
  NS_IMETHOD GetTokenManID(PRUnichar * *aTokenManID) = 0;

  /* readonly attribute wstring tokenHWVersion; */
  NS_IMETHOD GetTokenHWVersion(PRUnichar * *aTokenHWVersion) = 0;

  /* readonly attribute wstring tokenFWVersion; */
  NS_IMETHOD GetTokenFWVersion(PRUnichar * *aTokenFWVersion) = 0;

  /* readonly attribute wstring tokenSerialNumber; */
  NS_IMETHOD GetTokenSerialNumber(PRUnichar * *aTokenSerialNumber) = 0;

  /* boolean isLoggedIn (); */
  NS_IMETHOD IsLoggedIn(PRBool *_retval) = 0;

  /* void login (in boolean force); */
  NS_IMETHOD Login(PRBool force) = 0;

  /* void logout (); */
  NS_IMETHOD Logout(void) = 0;

  /* void reset (); */
  NS_IMETHOD Reset(void) = 0;

  /* readonly attribute long minimumPasswordLength; */
  NS_IMETHOD GetMinimumPasswordLength(PRInt32 *aMinimumPasswordLength) = 0;

  /* readonly attribute boolean needsUserInit; */
  NS_IMETHOD GetNeedsUserInit(PRBool *aNeedsUserInit) = 0;

  /* boolean checkPassword (in wstring password); */
  NS_IMETHOD CheckPassword(const PRUnichar *password, PRBool *_retval) = 0;

  /* void initPassword (in wstring initialPassword); */
  NS_IMETHOD InitPassword(const PRUnichar *initialPassword) = 0;

  /* void changePassword (in wstring oldPassword, in wstring newPassword); */
  NS_IMETHOD ChangePassword(const PRUnichar *oldPassword, const PRUnichar *newPassword) = 0;

  /* long getAskPasswordTimes (); */
  NS_IMETHOD GetAskPasswordTimes(PRInt32 *_retval) = 0;

  /* long getAskPasswordTimeout (); */
  NS_IMETHOD GetAskPasswordTimeout(PRInt32 *_retval) = 0;

  /* void setAskPasswordDefaults ([const] in long askTimes, [const] in long timeout); */
  NS_IMETHOD SetAskPasswordDefaults(const PRInt32 askTimes, const PRInt32 timeout) = 0;

  /* boolean isHardwareToken (); */
  NS_IMETHOD IsHardwareToken(PRBool *_retval) = 0;

  /* boolean needsLogin (); */
  NS_IMETHOD NeedsLogin(PRBool *_retval) = 0;

  /* boolean isFriendly (); */
  NS_IMETHOD IsFriendly(PRBool *_retval) = 0;

};

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIPK11TOKEN \
  NS_IMETHOD GetTokenName(PRUnichar * *aTokenName); \
  NS_IMETHOD GetTokenLabel(PRUnichar * *aTokenLabel); \
  NS_IMETHOD GetTokenManID(PRUnichar * *aTokenManID); \
  NS_IMETHOD GetTokenHWVersion(PRUnichar * *aTokenHWVersion); \
  NS_IMETHOD GetTokenFWVersion(PRUnichar * *aTokenFWVersion); \
  NS_IMETHOD GetTokenSerialNumber(PRUnichar * *aTokenSerialNumber); \
  NS_IMETHOD IsLoggedIn(PRBool *_retval); \
  NS_IMETHOD Login(PRBool force); \
  NS_IMETHOD Logout(void); \
  NS_IMETHOD Reset(void); \
  NS_IMETHOD GetMinimumPasswordLength(PRInt32 *aMinimumPasswordLength); \
  NS_IMETHOD GetNeedsUserInit(PRBool *aNeedsUserInit); \
  NS_IMETHOD CheckPassword(const PRUnichar *password, PRBool *_retval); \
  NS_IMETHOD InitPassword(const PRUnichar *initialPassword); \
  NS_IMETHOD ChangePassword(const PRUnichar *oldPassword, const PRUnichar *newPassword); \
  NS_IMETHOD GetAskPasswordTimes(PRInt32 *_retval); \
  NS_IMETHOD GetAskPasswordTimeout(PRInt32 *_retval); \
  NS_IMETHOD SetAskPasswordDefaults(const PRInt32 askTimes, const PRInt32 timeout); \
  NS_IMETHOD IsHardwareToken(PRBool *_retval); \
  NS_IMETHOD NeedsLogin(PRBool *_retval); \
  NS_IMETHOD IsFriendly(PRBool *_retval); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIPK11TOKEN(_to) \
  NS_IMETHOD GetTokenName(PRUnichar * *aTokenName) { return _to GetTokenName(aTokenName); } \
  NS_IMETHOD GetTokenLabel(PRUnichar * *aTokenLabel) { return _to GetTokenLabel(aTokenLabel); } \
  NS_IMETHOD GetTokenManID(PRUnichar * *aTokenManID) { return _to GetTokenManID(aTokenManID); } \
  NS_IMETHOD GetTokenHWVersion(PRUnichar * *aTokenHWVersion) { return _to GetTokenHWVersion(aTokenHWVersion); } \
  NS_IMETHOD GetTokenFWVersion(PRUnichar * *aTokenFWVersion) { return _to GetTokenFWVersion(aTokenFWVersion); } \
  NS_IMETHOD GetTokenSerialNumber(PRUnichar * *aTokenSerialNumber) { return _to GetTokenSerialNumber(aTokenSerialNumber); } \
  NS_IMETHOD IsLoggedIn(PRBool *_retval) { return _to IsLoggedIn(_retval); } \
  NS_IMETHOD Login(PRBool force) { return _to Login(force); } \
  NS_IMETHOD Logout(void) { return _to Logout(); } \
  NS_IMETHOD Reset(void) { return _to Reset(); } \
  NS_IMETHOD GetMinimumPasswordLength(PRInt32 *aMinimumPasswordLength) { return _to GetMinimumPasswordLength(aMinimumPasswordLength); } \
  NS_IMETHOD GetNeedsUserInit(PRBool *aNeedsUserInit) { return _to GetNeedsUserInit(aNeedsUserInit); } \
  NS_IMETHOD CheckPassword(const PRUnichar *password, PRBool *_retval) { return _to CheckPassword(password, _retval); } \
  NS_IMETHOD InitPassword(const PRUnichar *initialPassword) { return _to InitPassword(initialPassword); } \
  NS_IMETHOD ChangePassword(const PRUnichar *oldPassword, const PRUnichar *newPassword) { return _to ChangePassword(oldPassword, newPassword); } \
  NS_IMETHOD GetAskPasswordTimes(PRInt32 *_retval) { return _to GetAskPasswordTimes(_retval); } \
  NS_IMETHOD GetAskPasswordTimeout(PRInt32 *_retval) { return _to GetAskPasswordTimeout(_retval); } \
  NS_IMETHOD SetAskPasswordDefaults(const PRInt32 askTimes, const PRInt32 timeout) { return _to SetAskPasswordDefaults(askTimes, timeout); } \
  NS_IMETHOD IsHardwareToken(PRBool *_retval) { return _to IsHardwareToken(_retval); } \
  NS_IMETHOD NeedsLogin(PRBool *_retval) { return _to NeedsLogin(_retval); } \
  NS_IMETHOD IsFriendly(PRBool *_retval) { return _to IsFriendly(_retval); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIPK11TOKEN(_to) \
  NS_IMETHOD GetTokenName(PRUnichar * *aTokenName) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetTokenName(aTokenName); } \
  NS_IMETHOD GetTokenLabel(PRUnichar * *aTokenLabel) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetTokenLabel(aTokenLabel); } \
  NS_IMETHOD GetTokenManID(PRUnichar * *aTokenManID) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetTokenManID(aTokenManID); } \
  NS_IMETHOD GetTokenHWVersion(PRUnichar * *aTokenHWVersion) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetTokenHWVersion(aTokenHWVersion); } \
  NS_IMETHOD GetTokenFWVersion(PRUnichar * *aTokenFWVersion) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetTokenFWVersion(aTokenFWVersion); } \
  NS_IMETHOD GetTokenSerialNumber(PRUnichar * *aTokenSerialNumber) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetTokenSerialNumber(aTokenSerialNumber); } \
  NS_IMETHOD IsLoggedIn(PRBool *_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->IsLoggedIn(_retval); } \
  NS_IMETHOD Login(PRBool force) { return !_to ? NS_ERROR_NULL_POINTER : _to->Login(force); } \
  NS_IMETHOD Logout(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->Logout(); } \
  NS_IMETHOD Reset(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->Reset(); } \
  NS_IMETHOD GetMinimumPasswordLength(PRInt32 *aMinimumPasswordLength) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetMinimumPasswordLength(aMinimumPasswordLength); } \
  NS_IMETHOD GetNeedsUserInit(PRBool *aNeedsUserInit) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetNeedsUserInit(aNeedsUserInit); } \
  NS_IMETHOD CheckPassword(const PRUnichar *password, PRBool *_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->CheckPassword(password, _retval); } \
  NS_IMETHOD InitPassword(const PRUnichar *initialPassword) { return !_to ? NS_ERROR_NULL_POINTER : _to->InitPassword(initialPassword); } \
  NS_IMETHOD ChangePassword(const PRUnichar *oldPassword, const PRUnichar *newPassword) { return !_to ? NS_ERROR_NULL_POINTER : _to->ChangePassword(oldPassword, newPassword); } \
  NS_IMETHOD GetAskPasswordTimes(PRInt32 *_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetAskPasswordTimes(_retval); } \
  NS_IMETHOD GetAskPasswordTimeout(PRInt32 *_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetAskPasswordTimeout(_retval); } \
  NS_IMETHOD SetAskPasswordDefaults(const PRInt32 askTimes, const PRInt32 timeout) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetAskPasswordDefaults(askTimes, timeout); } \
  NS_IMETHOD IsHardwareToken(PRBool *_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->IsHardwareToken(_retval); } \
  NS_IMETHOD NeedsLogin(PRBool *_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->NeedsLogin(_retval); } \
  NS_IMETHOD IsFriendly(PRBool *_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->IsFriendly(_retval); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsPK11Token : public nsIPK11Token
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSIPK11TOKEN

  nsPK11Token();
  virtual ~nsPK11Token();
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsPK11Token, nsIPK11Token)

nsPK11Token::nsPK11Token()
{
  NS_INIT_ISUPPORTS();
  /* member initializers and constructor code */
}

nsPK11Token::~nsPK11Token()
{
  /* destructor code */
}

/* readonly attribute wstring tokenName; */
NS_IMETHODIMP nsPK11Token::GetTokenName(PRUnichar * *aTokenName)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute wstring tokenLabel; */
NS_IMETHODIMP nsPK11Token::GetTokenLabel(PRUnichar * *aTokenLabel)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute wstring tokenManID; */
NS_IMETHODIMP nsPK11Token::GetTokenManID(PRUnichar * *aTokenManID)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute wstring tokenHWVersion; */
NS_IMETHODIMP nsPK11Token::GetTokenHWVersion(PRUnichar * *aTokenHWVersion)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute wstring tokenFWVersion; */
NS_IMETHODIMP nsPK11Token::GetTokenFWVersion(PRUnichar * *aTokenFWVersion)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute wstring tokenSerialNumber; */
NS_IMETHODIMP nsPK11Token::GetTokenSerialNumber(PRUnichar * *aTokenSerialNumber)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* boolean isLoggedIn (); */
NS_IMETHODIMP nsPK11Token::IsLoggedIn(PRBool *_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void login (in boolean force); */
NS_IMETHODIMP nsPK11Token::Login(PRBool force)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void logout (); */
NS_IMETHODIMP nsPK11Token::Logout()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void reset (); */
NS_IMETHODIMP nsPK11Token::Reset()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute long minimumPasswordLength; */
NS_IMETHODIMP nsPK11Token::GetMinimumPasswordLength(PRInt32 *aMinimumPasswordLength)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute boolean needsUserInit; */
NS_IMETHODIMP nsPK11Token::GetNeedsUserInit(PRBool *aNeedsUserInit)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* boolean checkPassword (in wstring password); */
NS_IMETHODIMP nsPK11Token::CheckPassword(const PRUnichar *password, PRBool *_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void initPassword (in wstring initialPassword); */
NS_IMETHODIMP nsPK11Token::InitPassword(const PRUnichar *initialPassword)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void changePassword (in wstring oldPassword, in wstring newPassword); */
NS_IMETHODIMP nsPK11Token::ChangePassword(const PRUnichar *oldPassword, const PRUnichar *newPassword)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* long getAskPasswordTimes (); */
NS_IMETHODIMP nsPK11Token::GetAskPasswordTimes(PRInt32 *_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* long getAskPasswordTimeout (); */
NS_IMETHODIMP nsPK11Token::GetAskPasswordTimeout(PRInt32 *_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void setAskPasswordDefaults ([const] in long askTimes, [const] in long timeout); */
NS_IMETHODIMP nsPK11Token::SetAskPasswordDefaults(const PRInt32 askTimes, const PRInt32 timeout)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* boolean isHardwareToken (); */
NS_IMETHODIMP nsPK11Token::IsHardwareToken(PRBool *_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* boolean needsLogin (); */
NS_IMETHODIMP nsPK11Token::NeedsLogin(PRBool *_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* boolean isFriendly (); */
NS_IMETHODIMP nsPK11Token::IsFriendly(PRBool *_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


/* starting interface:    nsIPK11TokenDB */
#define NS_IPK11TOKENDB_IID_STR "4ee28c82-1dd2-11b2-aabf-bb4017abe395"

#define NS_IPK11TOKENDB_IID \
  {0x4ee28c82, 0x1dd2, 0x11b2, \
    { 0xaa, 0xbf, 0xbb, 0x40, 0x17, 0xab, 0xe3, 0x95 }}

/**
 * nsIPK11TokenDB - Manages PK11 Tokens
 */
class NS_NO_VTABLE nsIPK11TokenDB : public nsISupports {
 public: 

  NS_DEFINE_STATIC_IID_ACCESSOR(NS_IPK11TOKENDB_IID)

  /* nsIPK11Token getInternalKeyToken (); */
  NS_IMETHOD GetInternalKeyToken(nsIPK11Token **_retval) = 0;

  /* nsIPK11Token findTokenByName (in wstring tokenName); */
  NS_IMETHOD FindTokenByName(const PRUnichar *tokenName, nsIPK11Token **_retval) = 0;

  /* nsIEnumerator listTokens (); */
  NS_IMETHOD ListTokens(nsIEnumerator **_retval) = 0;

};

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIPK11TOKENDB \
  NS_IMETHOD GetInternalKeyToken(nsIPK11Token **_retval); \
  NS_IMETHOD FindTokenByName(const PRUnichar *tokenName, nsIPK11Token **_retval); \
  NS_IMETHOD ListTokens(nsIEnumerator **_retval); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIPK11TOKENDB(_to) \
  NS_IMETHOD GetInternalKeyToken(nsIPK11Token **_retval) { return _to GetInternalKeyToken(_retval); } \
  NS_IMETHOD FindTokenByName(const PRUnichar *tokenName, nsIPK11Token **_retval) { return _to FindTokenByName(tokenName, _retval); } \
  NS_IMETHOD ListTokens(nsIEnumerator **_retval) { return _to ListTokens(_retval); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIPK11TOKENDB(_to) \
  NS_IMETHOD GetInternalKeyToken(nsIPK11Token **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetInternalKeyToken(_retval); } \
  NS_IMETHOD FindTokenByName(const PRUnichar *tokenName, nsIPK11Token **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->FindTokenByName(tokenName, _retval); } \
  NS_IMETHOD ListTokens(nsIEnumerator **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->ListTokens(_retval); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsPK11TokenDB : public nsIPK11TokenDB
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSIPK11TOKENDB

  nsPK11TokenDB();
  virtual ~nsPK11TokenDB();
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsPK11TokenDB, nsIPK11TokenDB)

nsPK11TokenDB::nsPK11TokenDB()
{
  NS_INIT_ISUPPORTS();
  /* member initializers and constructor code */
}

nsPK11TokenDB::~nsPK11TokenDB()
{
  /* destructor code */
}

/* nsIPK11Token getInternalKeyToken (); */
NS_IMETHODIMP nsPK11TokenDB::GetInternalKeyToken(nsIPK11Token **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIPK11Token findTokenByName (in wstring tokenName); */
NS_IMETHODIMP nsPK11TokenDB::FindTokenByName(const PRUnichar *tokenName, nsIPK11Token **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIEnumerator listTokens (); */
NS_IMETHODIMP nsPK11TokenDB::ListTokens(nsIEnumerator **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


#endif /* __gen_nsIPK11TokenDB_h__ */
