/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM /work/mozilla/1.0/mozilla.new/netwerk/base/public/nsIIOService.idl
 */

#ifndef __gen_nsIIOService_h__
#define __gen_nsIIOService_h__


#ifndef __gen_nsISupports_h__
#include "nsISupports.h"
#endif

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif
class nsIProtocolHandler; /* forward declaration */

class nsIChannel; /* forward declaration */

class nsIURI; /* forward declaration */

class nsIURLParser; /* forward declaration */

class nsIFile; /* forward declaration */


/* starting interface:    nsIIOService */
#define NS_IIOSERVICE_IID_STR "ab7c3a84-d488-11d3-8cda-0060b0fc14a3"

#define NS_IIOSERVICE_IID \
  {0xab7c3a84, 0xd488, 0x11d3, \
    { 0x8c, 0xda, 0x00, 0x60, 0xb0, 0xfc, 0x14, 0xa3 }}

class NS_NO_VTABLE nsIIOService : public nsISupports {
 public: 

  NS_DEFINE_STATIC_IID_ACCESSOR(NS_IIOSERVICE_IID)

  /**
     * Returns a protocol handler for a given URI scheme.
     *
     * @param scheme  URI scheme
     * @return reference to nsIProtcolHandler
     */
  /* nsIProtocolHandler getProtocolHandler (in string scheme); */
  NS_IMETHOD GetProtocolHandler(const char *scheme, nsIProtocolHandler **_retval) = 0;

  /**
     * Returns the protocol flags for a given scheme.
     *
     * @param scheme  URI scheme 
     * @return returns unsigned long for protocol flags
     */
  /* unsigned long getProtocolFlags (in string scheme); */
  NS_IMETHOD GetProtocolFlags(const char *scheme, PRUint32 *_retval) = 0;

  /**
     * This method constructs a new URI by first determining the scheme
     * of the URI spec, and then delegating the construction of the URI
     * to the protocol handler for that scheme. QueryInterface can be used
     * on the resulting URI object to obtain a more specific type of URI.
     * @see nsIProtocolHandler::newURI
     */
  /* nsIURI newURI (in AUTF8String aSpec, in string aOriginCharset, in nsIURI aBaseURI); */
  NS_IMETHOD NewURI(const nsACString & aSpec, const char *aOriginCharset, nsIURI *aBaseURI, nsIURI **_retval) = 0;

  /**
     * This method constructs a new file URI 
     *
     * @param aFile  nsIFile from which to make an URI from
     * @return reference to a new nsIURI object
     */
  /* nsIURI newFileURI (in nsIFile aFile); */
  NS_IMETHOD NewFileURI(nsIFile *aFile, nsIURI **_retval) = 0;

  /**
     * Creates a channel for a given URI. The notificationCallbacks argument
     * is used to obtain the appropriate callbacks for the URI's protocol 
     * from the application.
     *
     * @param originalURI - Specifies the original URI which caused the 
     * creation of this channel. This can occur when the construction of 
     * one channel (e.g. for resource:) causes another channel to be created 
     * on its behalf (e.g. a file: channel), or if a redirect occurs, 
     * causing the current URL to become different from the original URL. 
     * If NULL, the aURI parameter will be used as the originalURI instead.
     *
     * @param aURI  nsIURI to make a channel from
     * @return a reference to the new nsIChannel object
     */
  /* nsIChannel newChannelFromURI (in nsIURI aURI); */
  NS_IMETHOD NewChannelFromURI(nsIURI *aURI, nsIChannel **_retval) = 0;

  /**
     * Shortcut equivalent to newChannelFromURI(newURI(...))
     */
  /* nsIChannel newChannel (in AUTF8String aSpec, in string aOriginCharset, in nsIURI aBaseURI); */
  NS_IMETHOD NewChannel(const nsACString & aSpec, const char *aOriginCharset, nsIURI *aBaseURI, nsIChannel **_retval) = 0;

  /**
     * Returns true if networking is in "offline" mode. When in offline mode, 
     * attempts to access the network will fail (although this is not 
     * necessarily corrolated with whether there is actually a network 
     * available -- that's hard to detect without causing the dialer to 
     * come up).
     */
  /* attribute boolean offline; */
  NS_IMETHOD GetOffline(PRBool *aOffline) = 0;
  NS_IMETHOD SetOffline(PRBool aOffline) = 0;

  /**
     * Checks if a port number is banned.
     *
     * |allowPort| will check a list of "known-to-do-bad-things" 
     * port numbers.  If the given port is found on the blacklist, 
     * |allowPort| will ask the protocol handler if it wishes to override. 
     * Scheme can be null. 
     */
  /* boolean allowPort (in long port, in string scheme); */
  NS_IMETHOD AllowPort(PRInt32 port, const char *scheme, PRBool *_retval) = 0;

  /**
     * Utility for protocol implementors -- extracts the scheme from a URL 
     * string, consistently and according to spec.
     *
     * @param urlString  the URL string to parse
     * @return scheme 
     *
     * @throws NS_ERROR_MALFORMED_URI if urlString is not of the right form.
     */
  /* ACString extractScheme (in AUTF8String urlString); */
  NS_IMETHOD ExtractScheme(const nsACString & urlString, nsACString & _retval) = 0;

  /**
     * returns the protocol specific URL parser
     */
  /* nsIURLParser getParserForScheme (in string scheme); */
  NS_IMETHOD GetParserForScheme(const char *scheme, nsIURLParser **_retval) = 0;

  /**
     * @param urlString  absolute URL path.
     * @param flags      combination of url_XXX flags.
     *
     * @throws NS_ERROR_MALFORMED_URI if urlString is not of the right form.
     */
  /* AUTF8String extractUrlPart (in AUTF8String urlString, in short flags); */
  NS_IMETHOD ExtractUrlPart(const nsACString & urlString, PRInt16 flags, nsACString & _retval) = 0;

  /**
     * Constants for the mask in the call to extractUrlPart
     *
     * XXX these should really be enumerated in left-to-right order!
     */
  enum { url_Scheme = 1 };

  enum { url_Username = 2 };

  enum { url_Password = 4 };

  enum { url_Host = 8 };

  enum { url_Directory = 16 };

  enum { url_FileBaseName = 32 };

  enum { url_FileExtension = 64 };

  enum { url_Param = 128 };

  enum { url_Query = 256 };

  enum { url_Ref = 512 };

  enum { url_Path = 1024 };

  enum { url_Port = 2048 };

  /**
     * Resolves a relative path string containing "." and ".."
     * with respect to a base path (assumed to already be resolved). 
     * For example, resolving "../../foo/./bar/../baz.html" w.r.t.
     * "/a/b/c/d/e/" yields "/a/b/c/foo/baz.html". Attempting to 
     * ascend above the base results in the NS_ERROR_MALFORMED_URI
     * exception. If basePath is null, it treats it as "/".
     *
     * @param relativePath  a relative URI
     * @param basePath      a base URI
     *
     * @return a new string, representing canonical uri
     */
  /* AUTF8String resolveRelativePath (in AUTF8String relativePath, in AUTF8String basePath); */
  NS_IMETHOD ResolveRelativePath(const nsACString & relativePath, const nsACString & basePath, nsACString & _retval) = 0;

  /**
     * conversions between nsILocalFile and a file url string
     */
/**
     * gets a file:// url out of an nsIFile
     * @param file  the file to extract the path from
     * @return a file:// style url string
     */
  /* AUTF8String getURLSpecFromFile (in nsIFile file); */
  NS_IMETHOD GetURLSpecFromFile(nsIFile *file, nsACString & _retval) = 0;

  /**
     * Sets the native path of the file given the url string
     * @param file  the file to initialize with the given spec
     * @param url   the url string which will be used to initialize the file
     */
  /* void initFileFromURLSpec (in nsIFile file, in AUTF8String url); */
  NS_IMETHOD InitFileFromURLSpec(nsIFile *file, const nsACString & url) = 0;

};

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIIOSERVICE \
  NS_IMETHOD GetProtocolHandler(const char *scheme, nsIProtocolHandler **_retval); \
  NS_IMETHOD GetProtocolFlags(const char *scheme, PRUint32 *_retval); \
  NS_IMETHOD NewURI(const nsACString & aSpec, const char *aOriginCharset, nsIURI *aBaseURI, nsIURI **_retval); \
  NS_IMETHOD NewFileURI(nsIFile *aFile, nsIURI **_retval); \
  NS_IMETHOD NewChannelFromURI(nsIURI *aURI, nsIChannel **_retval); \
  NS_IMETHOD NewChannel(const nsACString & aSpec, const char *aOriginCharset, nsIURI *aBaseURI, nsIChannel **_retval); \
  NS_IMETHOD GetOffline(PRBool *aOffline); \
  NS_IMETHOD SetOffline(PRBool aOffline); \
  NS_IMETHOD AllowPort(PRInt32 port, const char *scheme, PRBool *_retval); \
  NS_IMETHOD ExtractScheme(const nsACString & urlString, nsACString & _retval); \
  NS_IMETHOD GetParserForScheme(const char *scheme, nsIURLParser **_retval); \
  NS_IMETHOD ExtractUrlPart(const nsACString & urlString, PRInt16 flags, nsACString & _retval); \
  NS_IMETHOD ResolveRelativePath(const nsACString & relativePath, const nsACString & basePath, nsACString & _retval); \
  NS_IMETHOD GetURLSpecFromFile(nsIFile *file, nsACString & _retval); \
  NS_IMETHOD InitFileFromURLSpec(nsIFile *file, const nsACString & url); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIIOSERVICE(_to) \
  NS_IMETHOD GetProtocolHandler(const char *scheme, nsIProtocolHandler **_retval) { return _to GetProtocolHandler(scheme, _retval); } \
  NS_IMETHOD GetProtocolFlags(const char *scheme, PRUint32 *_retval) { return _to GetProtocolFlags(scheme, _retval); } \
  NS_IMETHOD NewURI(const nsACString & aSpec, const char *aOriginCharset, nsIURI *aBaseURI, nsIURI **_retval) { return _to NewURI(aSpec, aOriginCharset, aBaseURI, _retval); } \
  NS_IMETHOD NewFileURI(nsIFile *aFile, nsIURI **_retval) { return _to NewFileURI(aFile, _retval); } \
  NS_IMETHOD NewChannelFromURI(nsIURI *aURI, nsIChannel **_retval) { return _to NewChannelFromURI(aURI, _retval); } \
  NS_IMETHOD NewChannel(const nsACString & aSpec, const char *aOriginCharset, nsIURI *aBaseURI, nsIChannel **_retval) { return _to NewChannel(aSpec, aOriginCharset, aBaseURI, _retval); } \
  NS_IMETHOD GetOffline(PRBool *aOffline) { return _to GetOffline(aOffline); } \
  NS_IMETHOD SetOffline(PRBool aOffline) { return _to SetOffline(aOffline); } \
  NS_IMETHOD AllowPort(PRInt32 port, const char *scheme, PRBool *_retval) { return _to AllowPort(port, scheme, _retval); } \
  NS_IMETHOD ExtractScheme(const nsACString & urlString, nsACString & _retval) { return _to ExtractScheme(urlString, _retval); } \
  NS_IMETHOD GetParserForScheme(const char *scheme, nsIURLParser **_retval) { return _to GetParserForScheme(scheme, _retval); } \
  NS_IMETHOD ExtractUrlPart(const nsACString & urlString, PRInt16 flags, nsACString & _retval) { return _to ExtractUrlPart(urlString, flags, _retval); } \
  NS_IMETHOD ResolveRelativePath(const nsACString & relativePath, const nsACString & basePath, nsACString & _retval) { return _to ResolveRelativePath(relativePath, basePath, _retval); } \
  NS_IMETHOD GetURLSpecFromFile(nsIFile *file, nsACString & _retval) { return _to GetURLSpecFromFile(file, _retval); } \
  NS_IMETHOD InitFileFromURLSpec(nsIFile *file, const nsACString & url) { return _to InitFileFromURLSpec(file, url); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIIOSERVICE(_to) \
  NS_IMETHOD GetProtocolHandler(const char *scheme, nsIProtocolHandler **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetProtocolHandler(scheme, _retval); } \
  NS_IMETHOD GetProtocolFlags(const char *scheme, PRUint32 *_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetProtocolFlags(scheme, _retval); } \
  NS_IMETHOD NewURI(const nsACString & aSpec, const char *aOriginCharset, nsIURI *aBaseURI, nsIURI **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->NewURI(aSpec, aOriginCharset, aBaseURI, _retval); } \
  NS_IMETHOD NewFileURI(nsIFile *aFile, nsIURI **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->NewFileURI(aFile, _retval); } \
  NS_IMETHOD NewChannelFromURI(nsIURI *aURI, nsIChannel **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->NewChannelFromURI(aURI, _retval); } \
  NS_IMETHOD NewChannel(const nsACString & aSpec, const char *aOriginCharset, nsIURI *aBaseURI, nsIChannel **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->NewChannel(aSpec, aOriginCharset, aBaseURI, _retval); } \
  NS_IMETHOD GetOffline(PRBool *aOffline) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetOffline(aOffline); } \
  NS_IMETHOD SetOffline(PRBool aOffline) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetOffline(aOffline); } \
  NS_IMETHOD AllowPort(PRInt32 port, const char *scheme, PRBool *_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->AllowPort(port, scheme, _retval); } \
  NS_IMETHOD ExtractScheme(const nsACString & urlString, nsACString & _retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->ExtractScheme(urlString, _retval); } \
  NS_IMETHOD GetParserForScheme(const char *scheme, nsIURLParser **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetParserForScheme(scheme, _retval); } \
  NS_IMETHOD ExtractUrlPart(const nsACString & urlString, PRInt16 flags, nsACString & _retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->ExtractUrlPart(urlString, flags, _retval); } \
  NS_IMETHOD ResolveRelativePath(const nsACString & relativePath, const nsACString & basePath, nsACString & _retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->ResolveRelativePath(relativePath, basePath, _retval); } \
  NS_IMETHOD GetURLSpecFromFile(nsIFile *file, nsACString & _retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetURLSpecFromFile(file, _retval); } \
  NS_IMETHOD InitFileFromURLSpec(nsIFile *file, const nsACString & url) { return !_to ? NS_ERROR_NULL_POINTER : _to->InitFileFromURLSpec(file, url); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsIOService : public nsIIOService
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSIIOSERVICE

  nsIOService();
  virtual ~nsIOService();
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsIOService, nsIIOService)

nsIOService::nsIOService()
{
  NS_INIT_ISUPPORTS();
  /* member initializers and constructor code */
}

nsIOService::~nsIOService()
{
  /* destructor code */
}

/* nsIProtocolHandler getProtocolHandler (in string scheme); */
NS_IMETHODIMP nsIOService::GetProtocolHandler(const char *scheme, nsIProtocolHandler **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* unsigned long getProtocolFlags (in string scheme); */
NS_IMETHODIMP nsIOService::GetProtocolFlags(const char *scheme, PRUint32 *_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIURI newURI (in AUTF8String aSpec, in string aOriginCharset, in nsIURI aBaseURI); */
NS_IMETHODIMP nsIOService::NewURI(const nsACString & aSpec, const char *aOriginCharset, nsIURI *aBaseURI, nsIURI **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIURI newFileURI (in nsIFile aFile); */
NS_IMETHODIMP nsIOService::NewFileURI(nsIFile *aFile, nsIURI **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIChannel newChannelFromURI (in nsIURI aURI); */
NS_IMETHODIMP nsIOService::NewChannelFromURI(nsIURI *aURI, nsIChannel **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIChannel newChannel (in AUTF8String aSpec, in string aOriginCharset, in nsIURI aBaseURI); */
NS_IMETHODIMP nsIOService::NewChannel(const nsACString & aSpec, const char *aOriginCharset, nsIURI *aBaseURI, nsIChannel **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute boolean offline; */
NS_IMETHODIMP nsIOService::GetOffline(PRBool *aOffline)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsIOService::SetOffline(PRBool aOffline)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* boolean allowPort (in long port, in string scheme); */
NS_IMETHODIMP nsIOService::AllowPort(PRInt32 port, const char *scheme, PRBool *_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* ACString extractScheme (in AUTF8String urlString); */
NS_IMETHODIMP nsIOService::ExtractScheme(const nsACString & urlString, nsACString & _retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIURLParser getParserForScheme (in string scheme); */
NS_IMETHODIMP nsIOService::GetParserForScheme(const char *scheme, nsIURLParser **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* AUTF8String extractUrlPart (in AUTF8String urlString, in short flags); */
NS_IMETHODIMP nsIOService::ExtractUrlPart(const nsACString & urlString, PRInt16 flags, nsACString & _retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* AUTF8String resolveRelativePath (in AUTF8String relativePath, in AUTF8String basePath); */
NS_IMETHODIMP nsIOService::ResolveRelativePath(const nsACString & relativePath, const nsACString & basePath, nsACString & _retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* AUTF8String getURLSpecFromFile (in nsIFile file); */
NS_IMETHODIMP nsIOService::GetURLSpecFromFile(nsIFile *file, nsACString & _retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void initFileFromURLSpec (in nsIFile file, in AUTF8String url); */
NS_IMETHODIMP nsIOService::InitFileFromURLSpec(nsIFile *file, const nsACString & url)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


#endif /* __gen_nsIIOService_h__ */
