*** orig/stlport/stl_rope.h	Sat Aug 26 17:52:08 2000
--- modified/stlport/stl_rope.h	Sat Aug 26 17:59:30 2000
***************
*** 823,875 ****
--- 823,882 ----
  
  #endif /* !__STL_FUNCTION_TMPL_PARTIAL_ORDER */
  
  template<class _CharT, class _Alloc>
  class _Rope_char_ptr_proxy {
      // XXX this class should be rewritten.
      typedef _Rope_char_ptr_proxy<_CharT, _Alloc> _Self;
      friend class _Rope_char_ref_proxy<_CharT,_Alloc>;
      size_t _M_pos;
      rope<_CharT,_Alloc>* _M_root;     // The whole rope.
    public:
      _Rope_char_ptr_proxy(const _Rope_char_ref_proxy<_CharT,_Alloc>& __x) 
        : _M_pos(__x._M_pos), _M_root(__x._M_root) {}
      _Rope_char_ptr_proxy(const _Self& __x)
        : _M_pos(__x._M_pos), _M_root(__x._M_root) {}
      _Rope_char_ptr_proxy() {}
      _Rope_char_ptr_proxy(_CharT* __x) : _M_pos(0), _M_root(0) {
          __stl_assert(0 == __x);
      }
      _Self& 
      operator= (const _Self& __x) {
          _M_pos = __x._M_pos;
          _M_root = __x._M_root;
          return *this;
      }
+     #ifdef GCC
+     friend bool operator==  __STL_NULL_TMPL_ARGS
+                 (const _Rope_char_ptr_proxy<_CharT,_Alloc>& __x,
+                  const _Rope_char_ptr_proxy<_CharT,_Alloc>& __y);
+     #else
      friend inline bool operator==  __STL_NULL_TMPL_ARGS
                  (const _Rope_char_ptr_proxy<_CharT,_Alloc>& __x,
                   const _Rope_char_ptr_proxy<_CharT,_Alloc>& __y);
+     #endif
+     
  
      _Rope_char_ref_proxy<_CharT,_Alloc> operator*() const {
          return _Rope_char_ref_proxy<_CharT,_Alloc>(_M_root, _M_pos);
      }
  };
  
  
  // Rope iterators:
  // Unlike in the C version, we cache only part of the stack
  // for rope iterators, since they must be efficiently copyable.
  // When we run out of cache, we have to reconstruct the iterator
  // value.
  // Pointers from iterators are not included in reference counts.
  // Iterators are assumed to be thread private.  Ropes can
  // be shared.
  
  #if defined(__sgi) && !defined(__GNUC__) && (_MIPS_SIM != _MIPS_SIM_ABI32)
  #pragma set woff 1375
  #endif
  
  template<class _CharT, class _Alloc>
  class _Rope_iterator_base
  /*   : public random_access_iterator<_CharT, ptrdiff_t>  */
  {
      friend class rope<_CharT,_Alloc>;
***************
*** 1413,1463 ****
--- 1420,1474 ----
          private:
          static size_t _S_char_ptr_len(const _CharT* __s) {
  	  const _CharT* __p = __s;
  	  
  	  while (!_S_is0(*__p)) { ++__p; }
  	  return (__p - __s);
  	}
  
  public: /* for operators */
          rope(_RopeRep* __t, const allocator_type& __a = __STL_ALLOC_INSTANCE(allocator_type))
            : _M_tree_ptr(__a, __t) { }
          private:
          // Copy __r to the _CharT buffer.
          // Returns __buffer + __r->_M_size._M_data.
          // Assumes that buffer is uninitialized.
          static _CharT* _S_flatten(_RopeRep* __r, _CharT* __buffer);
  
          // Again, with explicit starting position and length.
          // Assumes that buffer is uninitialized.
          static _CharT* _S_flatten(_RopeRep* __r,
                                    size_t __start, size_t __len,
                                    _CharT* __buffer);
  
  // fbp : HP aCC prohibits access to protected min_len from within static methods ( ?? )
  public:
+ #if defined(GCC)		
+         static const unsigned long _S_min_len[__ROPE_DEPTH_SIZE];
+ #else		
          static const unsigned long _S_min_len[46];
+ #endif		
  protected:
          static bool _S_is_balanced(_RopeRep* __r)
                  { return (__r->_M_size._M_data >= _S_min_len[__r->_M_depth]); }
  
          static bool _S_is_almost_balanced(_RopeRep* __r)
                  { return (__r->_M_depth == 0 ||
                            __r->_M_size._M_data >= _S_min_len[__r->_M_depth - 1]); }
  
          static bool _S_is_roughly_balanced(_RopeRep* __r)
                  { return (__r->_M_depth <= 1 ||
                            __r->_M_size._M_data >= _S_min_len[__r->_M_depth - 2]); }
  
          // Assumes the result is not empty.
          static _RopeRep* _S_concat_and_set_balanced(_RopeRep* __left,
                                                       _RopeRep* __right)
          {
              _RopeRep* __result = _S_concat_rep(__left, __right);
              if (_S_is_balanced(__result)) __result->_M_is_balanced = true;
              return __result;
          }
  
          // The basic rebalancing operation.  Logically copies the
          // rope.  The result has refcount of 1.  The client will
          // usually decrement the reference count of __r.
          // The result is within height 2 of balanced by the above
