*** orig/jri.h	Wed Aug 30 11:20:44 2000
--- modified/jri.h	Wed Aug 30 11:20:44 2000
***************
*** 1,49 ****
! /* -*- Mode: C; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
!  *
!  * The contents of this file are subject to the Netscape Public
!  * License Version 1.1 (the "License"); you may not use this file
!  * except in compliance with the License. You may obtain a copy of
!  * the License at http://www.mozilla.org/NPL/
!  *
!  * Software distributed under the License is distributed on an "AS
!  * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
!  * implied. See the License for the specific language governing
!  * rights and limitations under the License.
!  *
!  * The Original Code is mozilla.org code.
!  *
!  * The Initial Developer of the Original Code is Netscape
!  * Communications Corporation.  Portions created by Netscape are
!  * Copyright (C) 1998 Netscape Communications Corporation. All
!  * Rights Reserved.
!  *
!  * Contributor(s): 
!  */
! 
  /*******************************************************************************
   * Java Runtime Interface
   ******************************************************************************/
  
  #ifndef JRI_H
  #define JRI_H
  
  #include "jritypes.h"
  
  #ifdef __cplusplus
  extern "C" {
  #endif /* __cplusplus */
  
  /*******************************************************************************
   * JRIEnv
   ******************************************************************************/
  
  /* The type of the JRIEnv interface. */
  typedef struct JRIEnvInterface	JRIEnvInterface;
  
  /* The type of a JRIEnv instance. */
  typedef const JRIEnvInterface*	JRIEnv;
  
  /*******************************************************************************
   * JRIEnv Operations
   ******************************************************************************/
  
--- 1,29 ----
! /* -*- Mode: C; tab-width: 4; -*- */
  /*******************************************************************************
   * Java Runtime Interface
+  * Copyright (c) 1996 Netscape Communications Corporation. All rights reserved.
   ******************************************************************************/
  
  #ifndef JRI_H
  #define JRI_H
  
  #include "jritypes.h"
  
  #ifdef __cplusplus
  extern "C" {
  #endif /* __cplusplus */
  
  /*******************************************************************************
   * JRIEnv
   ******************************************************************************/
  
  /* The type of the JRIEnv interface. */
  typedef struct JRIEnvInterface	JRIEnvInterface;
  
  /* The type of a JRIEnv instance. */
  typedef const JRIEnvInterface*	JRIEnv;
  
  /*******************************************************************************
   * JRIEnv Operations
   ******************************************************************************/
  
***************
*** 349,405 ****
  
  #define JRI_GetScalarArrayLength(env, array)	\
  	(((*(env))->GetScalarArrayLength)(env, JRI_GetScalarArrayLength_op, array))
  
  #define JRI_GetScalarArrayElements(env, array)	\
  	(((*(env))->GetScalarArrayElements)(env, JRI_GetScalarArrayElements_op, array))
  
  #define JRI_NewObjectArray(env, length, elementClass, initialElement)	\
  	(((*(env))->NewObjectArray)(env, JRI_NewObjectArray_op, length, elementClass, initialElement))
  
  #define JRI_GetObjectArrayLength(env, array)	\
  	(((*(env))->GetObjectArrayLength)(env, JRI_GetObjectArrayLength_op, array))
  
  #define JRI_GetObjectArrayElement(env, array, index)	\
  	(((*(env))->GetObjectArrayElement)(env, JRI_GetObjectArrayElement_op, array, index))
  
  #define JRI_SetObjectArrayElement(env, array, index, value)	\
  	(((*(env))->SetObjectArrayElement)(env, JRI_SetObjectArrayElement_op, array, index, value))
  
  #define JRI_RegisterNatives(env, clazz, nameAndSigArray, nativeProcArray)	\
  	(((*(env))->RegisterNatives)(env, JRI_RegisterNatives_op, clazz, nameAndSigArray, nativeProcArray))
  
  #define JRI_UnregisterNatives(env, clazz)	\
  	(((*(env))->UnregisterNatives)(env, JRI_UnregisterNatives_op, clazz))
  
- #define JRI_NewStringPlatform(env, string, len, encoding, encodingLength)	\
- 	(((*(env))->NewStringPlatform)(env, JRI_NewStringPlatform_op, string, len, encoding, encodingLength))
- 
- #define JRI_GetStringPlatformChars(env, string, encoding, encodingLength)	\
- 	(((*(env))->GetStringPlatformChars)(env, JRI_GetStringPlatformChars_op, string, encoding, encodingLength))
- 
- 
  /*******************************************************************************
   * JRIEnv Interface
   ******************************************************************************/
  
  struct java_lang_ClassLoader;
  struct java_lang_Class;
  struct java_lang_Throwable;
  struct java_lang_Object;
  struct java_lang_String;
  
  struct JRIEnvInterface {
  	void*	reserved0;
  	void*	reserved1;
  	void*	reserved2;
  	void*	reserved3;
  	struct java_lang_Class*	(*FindClass)(JRIEnv* env, jint op, const char* a);
  	void	(*Throw)(JRIEnv* env, jint op, struct java_lang_Throwable* a);
  	void	(*ThrowNew)(JRIEnv* env, jint op, struct java_lang_Class* a, const char* b);
  	struct java_lang_Throwable*	(*ExceptionOccurred)(JRIEnv* env, jint op);
  	void	(*ExceptionDescribe)(JRIEnv* env, jint op);
  	void	(*ExceptionClear)(JRIEnv* env, jint op);
  	jglobal	(*NewGlobalRef)(JRIEnv* env, jint op, void* a);
  	void	(*DisposeGlobalRef)(JRIEnv* env, jint op, jglobal a);
  	void*	(*GetGlobalRef)(JRIEnv* env, jint op, jglobal a);
  	void	(*SetGlobalRef)(JRIEnv* env, jint op, jglobal a, void* b);
--- 329,378 ----
***************
*** 498,556 ****
  	void	(*SetStaticField)(JRIEnv* env, jint op, struct java_lang_Class* a, jint b, void* c);
  	void	(*SetStaticFieldBoolean)(JRIEnv* env, jint op, struct java_lang_Class* a, jint b, jbool c);
  	void	(*SetStaticFieldByte)(JRIEnv* env, jint op, struct java_lang_Class* a, jint b, jbyte c);
  	void	(*SetStaticFieldChar)(JRIEnv* env, jint op, struct java_lang_Class* a, jint b, jchar c);
  	void	(*SetStaticFieldShort)(JRIEnv* env, jint op, struct java_lang_Class* a, jint b, jshort c);
  	void	(*SetStaticFieldInt)(JRIEnv* env, jint op, struct java_lang_Class* a, jint b, jint c);
  	void	(*SetStaticFieldLong)(JRIEnv* env, jint op, struct java_lang_Class* a, jint b, jlong c);
  	void	(*SetStaticFieldFloat)(JRIEnv* env, jint op, struct java_lang_Class* a, jint b, jfloat c);
  	void	(*SetStaticFieldDouble)(JRIEnv* env, jint op, struct java_lang_Class* a, jint b, jdouble c);
  	struct java_lang_String*	(*NewString)(JRIEnv* env, jint op, const jchar* a, jint b);
  	jint	(*GetStringLength)(JRIEnv* env, jint op, struct java_lang_String* a);
  	const jchar*	(*GetStringChars)(JRIEnv* env, jint op, struct java_lang_String* a);
  	struct java_lang_String*	(*NewStringUTF)(JRIEnv* env, jint op, const jbyte* a, jint b);
  	jint	(*GetStringUTFLength)(JRIEnv* env, jint op, struct java_lang_String* a);
  	const jbyte*	(*GetStringUTFChars)(JRIEnv* env, jint op, struct java_lang_String* a);
  	void*	(*NewScalarArray)(JRIEnv* env, jint op, jint a, const char* b, const jbyte* c);
  	jint	(*GetScalarArrayLength)(JRIEnv* env, jint op, void* a);
  	jbyte*	(*GetScalarArrayElements)(JRIEnv* env, jint op, void* a);
  	void*	(*NewObjectArray)(JRIEnv* env, jint op, jint a, struct java_lang_Class* b, void* c);
  	jint	(*GetObjectArrayLength)(JRIEnv* env, jint op, void* a);
  	void*	(*GetObjectArrayElement)(JRIEnv* env, jint op, void* a, jint b);
  	void	(*SetObjectArrayElement)(JRIEnv* env, jint op, void* a, jint b, void* c);
  	void	(*RegisterNatives)(JRIEnv* env, jint op, struct java_lang_Class* a, char** b, void** c);
  	void	(*UnregisterNatives)(JRIEnv* env, jint op, struct java_lang_Class* a);
  	struct java_lang_Class*	(*DefineClass)(JRIEnv* env, jint op, struct java_lang_ClassLoader* a, jbyte* b, jsize bLen);
- 	struct java_lang_String*	(*NewStringPlatform)(JRIEnv* env, jint op, const jbyte* a, jint b, const jbyte* c, jint d);
- 	const jbyte*	(*GetStringPlatformChars)(JRIEnv* env, jint op, struct java_lang_String* a, const jbyte* b, jint c);
  };
  
! /*
! ** ****************************************************************************
! ** JRIEnv Operation IDs
! ** ***************************************************************************
! */
  
  typedef enum JRIEnvOperations {
  	JRI_Reserved0_op,
  	JRI_Reserved1_op,
  	JRI_Reserved2_op,
  	JRI_Reserved3_op,
  	JRI_FindClass_op,
  	JRI_Throw_op,
  	JRI_ThrowNew_op,
  	JRI_ExceptionOccurred_op,
  	JRI_ExceptionDescribe_op,
  	JRI_ExceptionClear_op,
  	JRI_NewGlobalRef_op,
  	JRI_DisposeGlobalRef_op,
  	JRI_GetGlobalRef_op,
  	JRI_SetGlobalRef_op,
  	JRI_IsSameObject_op,
  	JRI_NewObject_op,
  	JRI_NewObject_op_va_list,
  	JRI_NewObject_op_array,
  	JRI_GetObjectClass_op,
  	JRI_IsInstanceOf_op,
  	JRI_GetMethodID_op,
  	JRI_CallMethod_op,
  	JRI_CallMethod_op_va_list,
--- 471,525 ----
  	void	(*SetStaticField)(JRIEnv* env, jint op, struct java_lang_Class* a, jint b, void* c);
  	void	(*SetStaticFieldBoolean)(JRIEnv* env, jint op, struct java_lang_Class* a, jint b, jbool c);
  	void	(*SetStaticFieldByte)(JRIEnv* env, jint op, struct java_lang_Class* a, jint b, jbyte c);
  	void	(*SetStaticFieldChar)(JRIEnv* env, jint op, struct java_lang_Class* a, jint b, jchar c);
  	void	(*SetStaticFieldShort)(JRIEnv* env, jint op, struct java_lang_Class* a, jint b, jshort c);
  	void	(*SetStaticFieldInt)(JRIEnv* env, jint op, struct java_lang_Class* a, jint b, jint c);
  	void	(*SetStaticFieldLong)(JRIEnv* env, jint op, struct java_lang_Class* a, jint b, jlong c);
  	void	(*SetStaticFieldFloat)(JRIEnv* env, jint op, struct java_lang_Class* a, jint b, jfloat c);
  	void	(*SetStaticFieldDouble)(JRIEnv* env, jint op, struct java_lang_Class* a, jint b, jdouble c);
  	struct java_lang_String*	(*NewString)(JRIEnv* env, jint op, const jchar* a, jint b);
  	jint	(*GetStringLength)(JRIEnv* env, jint op, struct java_lang_String* a);
  	const jchar*	(*GetStringChars)(JRIEnv* env, jint op, struct java_lang_String* a);
  	struct java_lang_String*	(*NewStringUTF)(JRIEnv* env, jint op, const jbyte* a, jint b);
  	jint	(*GetStringUTFLength)(JRIEnv* env, jint op, struct java_lang_String* a);
  	const jbyte*	(*GetStringUTFChars)(JRIEnv* env, jint op, struct java_lang_String* a);
  	void*	(*NewScalarArray)(JRIEnv* env, jint op, jint a, const char* b, const jbyte* c);
  	jint	(*GetScalarArrayLength)(JRIEnv* env, jint op, void* a);
  	jbyte*	(*GetScalarArrayElements)(JRIEnv* env, jint op, void* a);
  	void*	(*NewObjectArray)(JRIEnv* env, jint op, jint a, struct java_lang_Class* b, void* c);
  	jint	(*GetObjectArrayLength)(JRIEnv* env, jint op, void* a);
  	void*	(*GetObjectArrayElement)(JRIEnv* env, jint op, void* a, jint b);
  	void	(*SetObjectArrayElement)(JRIEnv* env, jint op, void* a, jint b, void* c);
  	void	(*RegisterNatives)(JRIEnv* env, jint op, struct java_lang_Class* a, char** b, void** c);
  	void	(*UnregisterNatives)(JRIEnv* env, jint op, struct java_lang_Class* a);
  	struct java_lang_Class*	(*DefineClass)(JRIEnv* env, jint op, struct java_lang_ClassLoader* a, jbyte* b, jsize bLen);
  };
  
! /*******************************************************************************
!  * JRIEnv Operation IDs
!  ******************************************************************************/
  
  typedef enum JRIEnvOperations {
  	JRI_Reserved0_op,
  	JRI_Reserved1_op,
  	JRI_Reserved2_op,
  	JRI_Reserved3_op,
  	JRI_FindClass_op,
  	JRI_Throw_op,
  	JRI_ThrowNew_op,
  	JRI_ExceptionOccurred_op,
  	JRI_ExceptionDescribe_op,
  	JRI_ExceptionClear_op,
  	JRI_NewGlobalRef_op,
  	JRI_DisposeGlobalRef_op,
  	JRI_GetGlobalRef_op,
  	JRI_SetGlobalRef_op,
  	JRI_IsSameObject_op,
  	JRI_NewObject_op,
  	JRI_NewObject_op_va_list,
  	JRI_NewObject_op_array,
  	JRI_GetObjectClass_op,
  	JRI_IsInstanceOf_op,
  	JRI_GetMethodID_op,
  	JRI_CallMethod_op,
  	JRI_CallMethod_op_va_list,
***************
*** 639,674 ****
  	JRI_GetStaticFieldDouble_op,
  	JRI_SetStaticField_op,
  	JRI_SetStaticFieldBoolean_op,
  	JRI_SetStaticFieldByte_op,
  	JRI_SetStaticFieldChar_op,
  	JRI_SetStaticFieldShort_op,
  	JRI_SetStaticFieldInt_op,
  	JRI_SetStaticFieldLong_op,
  	JRI_SetStaticFieldFloat_op,
  	JRI_SetStaticFieldDouble_op,
  	JRI_NewString_op,
  	JRI_GetStringLength_op,
  	JRI_GetStringChars_op,
  	JRI_NewStringUTF_op,
  	JRI_GetStringUTFLength_op,
  	JRI_GetStringUTFChars_op,
  	JRI_NewScalarArray_op,
  	JRI_GetScalarArrayLength_op,
  	JRI_GetScalarArrayElements_op,
  	JRI_NewObjectArray_op,
  	JRI_GetObjectArrayLength_op,
  	JRI_GetObjectArrayElement_op,
  	JRI_SetObjectArrayElement_op,
  	JRI_RegisterNatives_op,
  	JRI_UnregisterNatives_op,
! 	JRI_DefineClass_op,
! 	JRI_NewStringPlatform_op,
! 	JRI_GetStringPlatformChars_op
  } JRIEnvOperations;
  
  #ifdef __cplusplus
  } /* extern "C" */
  #endif /* __cplusplus */
  
  #endif /* JRI_H */
  /******************************************************************************/
--- 608,641 ----
  	JRI_GetStaticFieldDouble_op,
  	JRI_SetStaticField_op,
  	JRI_SetStaticFieldBoolean_op,
  	JRI_SetStaticFieldByte_op,
  	JRI_SetStaticFieldChar_op,
  	JRI_SetStaticFieldShort_op,
  	JRI_SetStaticFieldInt_op,
  	JRI_SetStaticFieldLong_op,
  	JRI_SetStaticFieldFloat_op,
  	JRI_SetStaticFieldDouble_op,
  	JRI_NewString_op,
  	JRI_GetStringLength_op,
  	JRI_GetStringChars_op,
  	JRI_NewStringUTF_op,
  	JRI_GetStringUTFLength_op,
  	JRI_GetStringUTFChars_op,
  	JRI_NewScalarArray_op,
  	JRI_GetScalarArrayLength_op,
  	JRI_GetScalarArrayElements_op,
  	JRI_NewObjectArray_op,
  	JRI_GetObjectArrayLength_op,
  	JRI_GetObjectArrayElement_op,
  	JRI_SetObjectArrayElement_op,
  	JRI_RegisterNatives_op,
  	JRI_UnregisterNatives_op,
! 	JRI_DefineClass_op
  } JRIEnvOperations;
  
  #ifdef __cplusplus
  } /* extern "C" */
  #endif /* __cplusplus */
  
  #endif /* JRI_H */
  /******************************************************************************/
