*** orig/win32_65/inc/pgpKeys.h	Wed Aug 30 12:08:29 2000
--- modified/win32_65/inc/pgpKeys.h	Wed Aug 30 12:08:29 2000
***************
*** 1,34 ****
  /*____________________________________________________________________________
  	pgpKeys.h
  	
  	Copyright(C) 1996,1997 Network Associates Inc. and affiliated companies.
  	All rights reserved.
  	
  	Public definitions for PGP KeyDB Library
  
! 	$Id: pgpKeys.h,v 1.132 1999/05/18 19:38:45 heller Exp $
  ____________________________________________________________________________*/
  #ifndef Included_pgpKeys_h	/* [ */
  #define Included_pgpKeys_h
  
  
  
  #include "pgpPubTypes.h"
  #include "pgpHash.h"
  #include "pgpOptionList.h"
  
  
  
  /* Key ordering */
  enum PGPKeyOrdering_
  {
  	kPGPInvalidOrdering					= 0,
  	kPGPAnyOrdering 					= 1,
  	kPGPUserIDOrdering					= 2,
  	kPGPReverseUserIDOrdering			= 3,
  	kPGPKeyIDOrdering					= 4,
  	kPGPReverseKeyIDOrdering			= 5,
  	kPGPValidityOrdering				= 6,
  	kPGPReverseValidityOrdering			= 7,
  	kPGPTrustOrdering					= 8,
  	kPGPReverseTrustOrdering			= 9,
--- 1,34 ----
  /*____________________________________________________________________________
  	pgpKeys.h
  	
  	Copyright(C) 1996,1997 Network Associates Inc. and affiliated companies.
  	All rights reserved.
  	
  	Public definitions for PGP KeyDB Library
  
! 	$Id: pgpKeys.h,v 1.1 2000/07/28 15:58:01 mhu Exp $
  ____________________________________________________________________________*/
  #ifndef Included_pgpKeys_h	/* [ */
  #define Included_pgpKeys_h
  
  
  
  #include "pgpPubTypes.h"
  #include "pgpHash.h"
  #include "pgpOptionList.h"
  
  
  
  /* Key ordering */
  enum PGPKeyOrdering_
  {
  	kPGPInvalidOrdering					= 0,
  	kPGPAnyOrdering 					= 1,
  	kPGPUserIDOrdering					= 2,
  	kPGPReverseUserIDOrdering			= 3,
  	kPGPKeyIDOrdering					= 4,
  	kPGPReverseKeyIDOrdering			= 5,
  	kPGPValidityOrdering				= 6,
  	kPGPReverseValidityOrdering			= 7,
  	kPGPTrustOrdering					= 8,
  	kPGPReverseTrustOrdering			= 9,
***************
*** 222,879 ****
  	kPGPMatchGreaterOrEqual = 2, /* searched val >= supplied val */
  	kPGPMatchLessOrEqual = 3, /* searched val <= supplied val */
  	kPGPMatchSubString = 4,	 /* searched val is contained in supplied val */
  
  	PGP_ENUM_FORCE( PGPMatchCriterion_ )
  } ;
  PGPENUM_TYPEDEF( PGPMatchCriterion_, PGPMatchCriterion );
  
  
  /* This is the value of the expiration time which means "never expires" */
  #define kPGPExpirationTime_Never	( (PGPTime)0 )
  
  /* Secret sharing header size */
  #define kPGPShareHeaderSize		4
  
  /* Public entry points */
  
  PGP_BEGIN_C_DECLARATIONS
  #if PRAGMA_IMPORT_SUPPORTED
  #pragma import on
  #endif
  
  
  /* Functions for setting up key filters. */
  
! PGPError 		PGPIncFilterRefCount ( PGPFilterRef filter );
  
! PGPError 		PGPFreeFilter ( PGPFilterRef filter );
  
! PGPError 		PGPNewKeyIDFilter( PGPContextRef context, 
  						PGPKeyID const * keyID, PGPFilterRef *outFilter);
  
! PGPError		PGPNewSubKeyIDFilter( PGPContextRef		context,
  						PGPKeyID const *	subKeyID,  
  						PGPFilterRef *		outFilter);
  
! PGPError 		PGPNewKeyEncryptAlgorithmFilter( PGPContextRef context, 
  						PGPPublicKeyAlgorithm encryptAlgorithm,
  						PGPFilterRef *outFilter );
  
! PGPError 		PGPNewKeyFingerPrintFilter( PGPContextRef context, 
  						void const *fingerPrint, 
  						PGPSize fingerPrintLength, PGPFilterRef *outFilter );
  
! PGPError 		PGPNewKeyCreationTimeFilter( PGPContextRef context, 
  						PGPTime creationTime, PGPMatchCriterion match, 
  						PGPFilterRef *outFilter );
  
! PGPError 		PGPNewKeyExpirationTimeFilter( PGPContextRef context, 
  						PGPTime expirationTime, 
  						PGPMatchCriterion match, PGPFilterRef *outFilter );
  
! PGPError 		PGPNewKeyRevokedFilter( PGPContextRef context,
  						PGPBoolean revoked, PGPFilterRef *outFilter );
  
! PGPError		PGPNewKeyDisabledFilter( PGPContextRef context, 
  						PGPBoolean			disabled, 
  						PGPFilterRef *		outFilter);
  
! PGPError 		PGPNewKeySigAlgorithmFilter( PGPContextRef context,
  						PGPPublicKeyAlgorithm sigAlgorithm, 
  						PGPFilterRef *outFilter );
  
! PGPError 		PGPNewKeyEncryptKeySizeFilter( PGPContextRef context,
  						PGPUInt32 keySize, PGPMatchCriterion match,
  						PGPFilterRef *outFilter );
  
! PGPError 		PGPNewKeySigKeySizeFilter( PGPContextRef context,
  						PGPUInt32 keySize, PGPMatchCriterion match,
  						PGPFilterRef *outFilter );
  
! PGPError		PGPNewUserIDStringFilter( PGPContextRef context,
  						char const *		userIDString, 
  						PGPMatchCriterion	match,
  						PGPFilterRef *		outFilter);
  
! PGPError 		PGPNewUserIDEmailFilter( PGPContextRef context,
  						char const *		emailString, 
  						PGPMatchCriterion	match,
  						PGPFilterRef *		outFilter);
  
! PGPError 		PGPNewUserIDNameFilter( PGPContextRef context,
  						char const *		nameString, 
  						PGPMatchCriterion	match,
  						PGPFilterRef *		outFilter);
  
! PGPError 		PGPNewSigKeyIDFilter( PGPContextRef context,
  						PGPKeyID const * keyID,
  						PGPFilterRef *outFilter );
  
! PGPError 		PGPNewKeyBooleanFilter( PGPContextRef context,
  						PGPKeyPropName property, PGPBoolean match,
  						PGPFilterRef *outFilter );
  
! PGPError 		PGPNewKeyNumberFilter( PGPContextRef context,
  						PGPKeyPropName property, PGPUInt32 value,
  						PGPMatchCriterion match, PGPFilterRef *outFilter );
  
! PGPError 		PGPNewKeyTimeFilter( PGPContextRef context,
  						PGPKeyPropName property, PGPTime value,
  						PGPMatchCriterion match, PGPFilterRef *outFilter );
  
! PGPError 		PGPNewKeyPropertyBufferFilter( PGPContextRef context,
  						PGPKeyPropName property, void *buffer, PGPSize length,
  						PGPMatchCriterion match, PGPFilterRef *outFilter );
  
! PGPError 		PGPNewSubKeyBooleanFilter( PGPContextRef context,
  						PGPKeyPropName property, PGPBoolean match,
  						PGPFilterRef *outFilter );
  
! PGPError 		PGPNewSubKeyNumberFilter( PGPContextRef context,
  						PGPKeyPropName property, PGPUInt32 value,
  						PGPMatchCriterion match, PGPFilterRef *outFilter );
  
! PGPError 		PGPNewSubKeyTimeFilter( PGPContextRef context,
  						PGPKeyPropName property, PGPTime value,
  						PGPMatchCriterion match, PGPFilterRef *outFilter );
  
! PGPError 		PGPNewSubKeyPropertyBufferFilter( PGPContextRef context,
  						PGPKeyPropName property, void *buffer, PGPSize length,
  						PGPMatchCriterion match, PGPFilterRef *outFilter );
  
! PGPError 		PGPNewUserIDBooleanFilter( PGPContextRef context,
  						PGPUserIDPropName property, PGPBoolean match,
  						PGPFilterRef *outFilter );
  
! PGPError 		PGPNewUserIDNumberFilter( PGPContextRef context,
  						PGPUserIDPropName property, PGPUInt32 value,
  						PGPMatchCriterion match, PGPFilterRef *outFilter );
  
! PGPError 		PGPNewUserIDStringBufferFilter( PGPContextRef context,
  						PGPUserIDPropName property,
  						void *buffer, PGPSize length,
  						PGPMatchCriterion match, PGPFilterRef *outFilter );
  
! PGPError 		PGPNewSigBooleanFilter( PGPContextRef context,
  						PGPSigPropName property, PGPBoolean match,
  						PGPFilterRef *outFilter );
  
! PGPError 		PGPNewSigNumberFilter( PGPContextRef context,
  						PGPSigPropName property, PGPUInt32 value,
  						PGPMatchCriterion match, PGPFilterRef *outFilter );
  
! PGPError 		PGPNewSigTimeFilter( PGPContextRef context,
  						PGPSigPropName property, PGPTime value,
  						PGPMatchCriterion match, PGPFilterRef *outFilter );
  
! PGPError 		PGPNewSigPropertyBufferFilter( PGPContextRef context,
  						PGPSigPropName property, void *buffer, PGPSize length,
  						PGPMatchCriterion match, PGPFilterRef *outFilter );
  
  /* freeing outfilter will call PGPFreeFilter on filter */
! PGPError 		PGPNegateFilter( PGPFilterRef filter,
  						PGPFilterRef *outFilter);
  
  /* freeing outfilter will call PGPFreeFilter on filter1, filter2 */
! PGPError 		PGPIntersectFilters( PGPFilterRef filter1,
  						PGPFilterRef filter2, PGPFilterRef *outFilter);
  
  /* freeing outfilter will call PGPFreeFilter on filter1, filter2 */
! PGPError 		PGPUnionFilters( PGPFilterRef filter1,
  						PGPFilterRef filter2, PGPFilterRef *outFilter);
  
  
! PGPError 		PGPFilterKeySet( PGPKeySetRef origSet,
  						PGPFilterRef filter, PGPKeySetRef *resultSet);
  
  
  /* Keyserver filter functions */
  
! PGPError 		PGPLDAPQueryFromFilter( PGPFilterRef filter,
  						char **queryOut );
  
! PGPError 		PGPHKSQueryFromFilter( PGPFilterRef	filter,
  						char **queryOut );
  						
! PGPError		PGPNetToolsCAHTTPQueryFromFilter( PGPFilterRef filter,
  						char **queryOut );
  
  /* KeySet manipulations */
  
  
  /* Creates a new memory-based KeyDB and returns its root set */
! PGPError  		PGPNewKeySet(PGPContextRef context, PGPKeySetRef *keySet);
  
  
  /* Used for building arbitrary subsets of an existing KeyDB */
! PGPError  		PGPNewEmptyKeySet(PGPKeySetRef origSet, PGPKeySetRef *newSet);
! PGPError  		PGPNewSingletonKeySet(PGPKeyRef key, PGPKeySetRef *keySet);
! PGPError		PGPUnionKeySets(PGPKeySetRef set1, PGPKeySetRef set2,
  								PGPKeySetRef *newSet);
  
! PGPError  		PGPOpenDefaultKeyRings( PGPContextRef context,
  						PGPKeyRingOpenFlags openFlags, PGPKeySetRef *keySet);
  
! PGPError  		PGPOpenKeyRingPair( PGPContextRef context,
  						PGPKeyRingOpenFlags openFlags, 
  						PGPFileSpecRef pubFileRef, PGPFileSpecRef secFileRef,
  						PGPKeySetRef *keySet);
  
! PGPError  		PGPOpenKeyRing (PGPContextRef context,
  						PGPKeyRingOpenFlags openFlags, PGPFileSpecRef fileRef,
  						PGPKeySetRef *keySet);
  
! PGPError 		PGPCommitKeyRingChanges (PGPKeySetRef keys);
  
! PGPError 		PGPPropagateTrust (PGPKeySetRef keys);
  
! PGPError 		PGPRevertKeyRingChanges (PGPKeySetRef keys);
  
! PGPError 		PGPCheckKeyRingSigs (PGPKeySetRef keysToCheck,
  						PGPKeySetRef keysSigning, PGPBoolean checkAll,
  						PGPEventHandlerProcPtr eventHandler,
  						PGPUserValue eventHandlerData);
  
! PGPError 		PGPReloadKeyRings (PGPKeySetRef keys);
  
! PGPError 		PGPGetKeyByKeyID (PGPKeySetRef keys,
  						PGPKeyID const * keyID,
  						PGPPublicKeyAlgorithm pubKeyAlgorithm,
  						PGPKeyRef *outRef);
  
! PGPBoolean 		PGPKeySetIsMember(PGPKeyRef key, PGPKeySetRef set);
  
! PGPError 		PGPCountKeys( PGPKeySetRef keys, PGPUInt32 *numKeys);
  
! PGPError 		PGPIncKeySetRefCount( PGPKeySetRef keys);
  
! PGPError 		PGPFreeKeySet( PGPKeySetRef keys);
  
! PGPBoolean 		PGPKeySetIsMutable( PGPKeySetRef keys);
  
! PGPBoolean 		PGPKeySetNeedsCommit( PGPKeySetRef keys);
  
  
! PGPError 		PGPAddKeys( PGPKeySetRef keysToAdd, PGPKeySetRef set );
  
! PGPError 		PGPRemoveKeys( PGPKeySetRef keysToRemove, PGPKeySetRef set );
  
  
  
  /* Key manipulation functions */
  
! PGPError 		PGPDisableKey( PGPKeyRef key);
  
! PGPError 		PGPEnableKey( PGPKeyRef key);
  
! PGPError 		PGPRemoveSubKey( PGPSubKeyRef subkey);
  
! PGPError 		PGPRemoveUserID( PGPUserIDRef userID);
  
! PGPError 		PGPSetPrimaryUserID( PGPUserIDRef userid);
  
! PGPError 		PGPCertifyPrimaryUserID( PGPUserIDRef userid,
  						PGPOptionListRef firstOption, ...);
  
! PGPError 		PGPGetSigCertifierKey( PGPSigRef cert, PGPKeySetRef allkeys,
  						PGPKeyRef *certkey);
  
! PGPError 		PGPGetSigX509CertifierSig( PGPSigRef cert,
  						PGPKeySetRef allkeys, PGPSigRef *certsig);
  
! PGPError 		PGPRemoveSig( PGPSigRef cert);
  
! PGPError		PGPCountAdditionalRecipientRequests( PGPKeyRef basekey,
  					PGPUInt32 * numARKeys);
  					
! PGPError 		PGPGetIndexedAdditionalRecipientRequestKey(
  						PGPKeyRef basekey, PGPKeySetRef allkeys, PGPUInt32 nth,
  						PGPKeyRef *arkey, PGPKeyID *arkeyid,
  						PGPByte *arclass );
  
! PGPError		PGPCountRevocationKeys( PGPKeyRef basekey,
  					PGPUInt32 * numRevKeys);
  
! PGPError 		PGPGetIndexedRevocationKey(
  						PGPKeyRef basekey, PGPKeySetRef allkeys, PGPUInt32 nth,
  						PGPKeyRef *revkey, PGPKeyID *revkeyid );
! PGPError		PGPGetCRLDistributionPoints(
  						PGPKeyRef cakey, PGPKeySetRef keyset,
  						PGPUInt32 *pnDistPoints, PGPByte **pDpoints,
  						PGPSize **pdpointLengths );
  
  
  /* Wrapper functions */
! PGPError			PGPGenerateKey( PGPContextRef context, PGPKeyRef *key,
  						PGPOptionListRef firstOption, ...);
! PGPError			PGPGenerateSubKey( PGPContextRef context,
  						PGPSubKeyRef *subkey,
  						PGPOptionListRef firstOption, ...);
! PGPUInt32			PGPGetKeyEntropyNeeded( PGPContextRef context,
  						PGPOptionListRef firstOption, ...);
! PGPError			PGPExportKeySet( PGPKeySetRef keys,
  						PGPOptionListRef firstOption, ...);
! PGPError			PGPExport( PGPContextRef context,
  						PGPOptionListRef firstOption, ...);
! PGPError			PGPImportKeySet( PGPContextRef context,
  						PGPKeySetRef *keys,
  						PGPOptionListRef firstOption, ...);
! PGPError			PGPSignUserID( PGPUserIDRef userID,
  						PGPKeyRef certifyingKey,
  						PGPOptionListRef firstOption, ...);
! PGPError			PGPAddUserID( PGPKeyRef key, char const *userID,
  						PGPOptionListRef firstOption, ...);
! PGPError			PGPAddAttributeUserID( PGPKeyRef key,
  						PGPAttributeType attributeType,
  						PGPByte *attributeData, PGPSize attributeLength,
  						PGPOptionListRef firstOption, ...);
! PGPError			PGPRevokeSig( PGPSigRef cert, PGPKeySetRef allkeys,
  						PGPOptionListRef firstOption, ...);
! PGPError			PGPRevokeKey( PGPKeyRef key,
  						PGPOptionListRef firstOption, ...);
! PGPError			PGPRevokeSubKey( PGPSubKeyRef subkey,
  						PGPOptionListRef firstOption, ...);
! PGPError	 		PGPChangePassphrase( PGPKeyRef key,
  						PGPOptionListRef firstOption, ...);
! PGPError	 		PGPChangeSubKeyPassphrase( PGPSubKeyRef subkey,
  						PGPOptionListRef firstOption, ...);
! PGPBoolean			PGPPassphraseIsValid( PGPKeyRef key,
  						PGPOptionListRef firstOption, ...);
! PGPError	 		PGPSetKeyAxiomatic( PGPKeyRef key,
  						PGPOptionListRef firstOption, ...);
  
  
  
  /*
   * Trust values for PGPSetKeyTrust and kPGPKeyPropTrust property:
   * 
   * kPGPKeyTrust_Undefined	(do not pass to PGPSetKeyTrust)
   * kPGPKeyTrust_Unknown		(unknown)
   * kPGPKeyTrust_Never		(never)
   * kPGPKeyTrust_Marginal	(sometimes)
   * kPGPKeyTrust_Complete	(always)
   * kPGPKeyTrust_Ultimate	(do not pass to PGPSetKeyTrust)
   */
  
   /* old trust model */
! PGPError 		PGPSetKeyTrust( PGPKeyRef key, PGPUInt32 trust);
  
! PGPError 		PGPUnsetKeyAxiomatic( PGPKeyRef key);
  
  /*  Get property functions */
  
! PGPError 		PGPGetKeyBoolean( PGPKeyRef key, PGPKeyPropName propname,
  						PGPBoolean *prop);
  
! PGPError 		PGPGetKeyNumber( PGPKeyRef key, PGPKeyPropName propname,
  						PGPInt32 *prop);
  
  /* 'buffer' is NOT null-terminated */
  /* returns kPGPError_BufferTooSmall if buffer is too small, but
  fill buffer to capacity */
! PGPError 		PGPGetKeyPropertyBuffer( PGPKeyRef key,
  						PGPKeyPropName propname,
  						PGPSize bufferSize, void *data, PGPSize *fullSize);
  
! PGPError 		PGPGetKeyTime( PGPKeyRef key, PGPKeyPropName propname,
  						PGPTime *prop);
  
! PGPError 		PGPGetSubKeyBoolean( PGPSubKeyRef subkey,
  						PGPKeyPropName propname, PGPBoolean *prop);
  
! PGPError 		PGPGetSubKeyNumber( PGPSubKeyRef subkey,
  						PGPKeyPropName propname, PGPInt32 *prop);
  
  /* returns kPGPError_BufferTooSmall if buffer is too small, but
  fill buffer to capacity */
! PGPError 		PGPGetSubKeyPropertyBuffer( PGPSubKeyRef subkey,
  						PGPKeyPropName propname,
  						PGPSize bufferSize, void *prop, PGPSize *fullSize);
  
! PGPError 		PGPGetSubKeyTime( PGPSubKeyRef subkey,
  						PGPKeyPropName propname, PGPTime *prop);
  
! PGPError 		PGPGetUserIDNumber( PGPUserIDRef userID,
  						PGPUserIDPropName propname, PGPInt32 *prop);
  
! PGPError 		PGPGetUserIDBoolean( PGPUserIDRef userID,
  						PGPUserIDPropName propname, PGPBoolean *prop);
  
  /* 'string' is always NULL-terminated */
  /* returns kPGPError_BufferTooSmall if buffer is too small, but
  fill buffer to capacity */
! PGPError 		PGPGetUserIDStringBuffer( PGPUserIDRef userID,
  						PGPUserIDPropName propname,
  						PGPSize bufferSize,
  						char *		string,
  						PGPSize *	fullSize);
  
  /* 'buffer' is NOT null-terminated */
  /* returns kPGPError_BufferTooSmall if buffer is too small, but
  fill buffer to capacity */
! PGPError 		PGPGetSigPropertyBuffer( PGPSigRef cert,
  						PGPSigPropName propname,
  						PGPSize bufferSize, void *data, PGPSize *fullSize);
  
! PGPError 		PGPGetSigBoolean( PGPSigRef cert,
  						PGPSigPropName propname, PGPBoolean *prop);
  
! PGPError 		PGPGetSigNumber( PGPSigRef cert, PGPSigPropName propname,
  						PGPInt32 *prop);
  						
! PGPError 		PGPGetKeyIDOfCertifier( PGPSigRef sig, PGPKeyID *outID );
  	
! PGPError 		PGPGetSigTime( PGPSigRef cert, PGPSigPropName propname,
  						PGPTime *prop);
  
! PGPError 		PGPGetHashAlgUsed( PGPKeyRef key, PGPHashAlgorithm *hashAlg);
  
  /* Convenience property functions */
  
! PGPError  		PGPGetPrimaryUserID( PGPKeyRef key, PGPUserIDRef *outRef );
! PGPError		PGPGetPrimaryAttributeUserID (PGPKeyRef key,
  						PGPAttributeType attributeType, PGPUserIDRef *outRef);
  
  /* 'string' is always a C string and
  	*fullSize includes the '\0' terminator */
  /* returns kPGPError_BufferTooSmall if buffer is too small, but
  fill buffer to capacity */
! PGPError 		PGPGetPrimaryUserIDNameBuffer( PGPKeyRef key, 
  					PGPSize bufferSize,
  					char *	string, PGPSize *fullSize );
  
! PGPError 		PGPGetPrimaryUserIDValidity(PGPKeyRef key,
  					PGPValidity *validity);
  
  
! PGPInt32 		PGPCompareKeys(PGPKeyRef a, PGPKeyRef b,
  						PGPKeyOrdering order);
  
! PGPInt32 		PGPCompareUserIDStrings(char const *a, char const *b);
  
! PGPError  		PGPOrderKeySet( PGPKeySetRef src,
  						PGPKeyOrdering order, PGPKeyListRef *outRef );
  
! PGPError 		PGPIncKeyListRefCount( PGPKeyListRef keys);
  
! PGPError 		PGPFreeKeyList( PGPKeyListRef keys);
  
  
  /* Key iteration functions */
  
  
  
! PGPError 		PGPNewKeyIter (PGPKeyListRef keys, PGPKeyIterRef *outRef);
  
! PGPError 		PGPCopyKeyIter (PGPKeyIterRef orig, PGPKeyIterRef *outRef);
  	
! PGPError 		PGPFreeKeyIter (PGPKeyIterRef iter);
  
! PGPInt32 		PGPKeyIterIndex (PGPKeyIterRef iter);
  
! PGPError 		PGPKeyIterRewind (PGPKeyIterRef iter);
  
! PGPInt32 		PGPKeyIterSeek (PGPKeyIterRef iter, PGPKeyRef key);
  
! PGPError 		PGPKeyIterMove (PGPKeyIterRef iter, PGPInt32 relOffset,
  						PGPKeyRef *outRef);
  
! PGPError 		PGPKeyIterNext (PGPKeyIterRef iter, PGPKeyRef *outRef);
  
! PGPError 		PGPKeyIterPrev (PGPKeyIterRef iter, PGPKeyRef *outRef);
  
! PGPError 		PGPKeyIterKey (PGPKeyIterRef iter, PGPKeyRef *outRef);
  
! PGPError  		PGPKeyIterSubKey (PGPKeyIterRef iter,
  						PGPSubKeyRef *outRef );
  
! PGPError  		PGPKeyIterUserID (PGPKeyIterRef iter,
  						PGPUserIDRef *outRef );
! PGPError  		PGPKeyIterSig (PGPKeyIterRef iter,
  						PGPSigRef *outRef );
  
! PGPError  		PGPKeyIterNextSubKey (PGPKeyIterRef iter,
  						PGPSubKeyRef *outRef );
  
! PGPError  		PGPKeyIterPrevSubKey (PGPKeyIterRef iter,
  						PGPSubKeyRef *outRef);
  
! PGPError 		PGPKeyIterRewindSubKey (PGPKeyIterRef iter);
  
! PGPError  		PGPKeyIterNextUserID (PGPKeyIterRef iter,
  						PGPUserIDRef *outRef);
  
! PGPError  		PGPKeyIterPrevUserID (PGPKeyIterRef iter,
  						PGPUserIDRef *outRef);
  
! PGPError 		PGPKeyIterRewindUserID (PGPKeyIterRef iter);
  
! PGPError  		PGPKeyIterNextUIDSig (PGPKeyIterRef iter,
  						PGPSigRef *outRef);
  
! PGPError  		PGPKeyIterPrevUIDSig (PGPKeyIterRef iter,
  						PGPSigRef *outRef);
  
! PGPError 		PGPKeyIterRewindUIDSig (PGPKeyIterRef iter);
  
  
  /* Get/set default private key */
  
! PGPError 		PGPGetDefaultPrivateKey( PGPKeySetRef keyset,
  						PGPKeyRef *outRef );
  
! PGPError 		PGPSetDefaultPrivateKey( PGPKeyRef key);
  
  
  
  /* Get/set user value */
  
! PGPError 		PGPSetKeyUserVal( PGPKeyRef key, PGPUserValue userValue);
  
! PGPError 		PGPSetUserIDUserVal( PGPUserIDRef userid,
  						PGPUserValue userValue);
  
! PGPError 		PGPSetSubKeyUserVal( PGPSubKeyRef subkey,
  						PGPUserValue userValue);
  
! PGPError 		PGPSetSigUserVal( PGPSigRef cert,
  						PGPUserValue userValue);
  
! PGPError 		PGPGetKeyUserVal( PGPKeyRef key,
  						PGPUserValue *userValue);
  
! PGPError 		PGPGetUserIDUserVal( PGPUserIDRef userid,
  						PGPUserValue *userValue);
  
! PGPError 		PGPGetSubKeyUserVal( PGPSubKeyRef subkey,
  						PGPUserValue *userValue);
  
! PGPError 		PGPGetSigUserVal( PGPSigRef cert,
  						PGPUserValue *userValue);
  
  /* Passphrase conversion to passkeybuffer */
  /* The size of the output buffer is from the kPGPKeyPropLockingBits property */
  
! PGPError		PGPGetKeyPasskeyBuffer ( PGPKeyRef key,
  						void *passkeyBuffer, PGPOptionListRef firstOption,...);
  
! PGPError		PGPGetSubKeyPasskeyBuffer ( PGPSubKeyRef subkey,
  						void *passkeyBuffer, PGPOptionListRef firstOption,...);
  
  
  /* Change key options which are stored in self signatures internally */
  
! PGPError		PGPAddKeyOptions( PGPKeyRef key,
  						PGPOptionListRef firstOption, ...);
  
! PGPError		PGPRemoveKeyOptions( PGPKeyRef key,
  						PGPOptionListRef firstOption, ...);
  
! PGPError		PGPUpdateKeyOptions( PGPKeyRef key,
  						PGPOptionListRef firstOption, ...);
  
  
  
  /*____________________________________________________________________________
  	Key IDs
  ____________________________________________________________________________*/
! PGPError 	PGPGetKeyIDFromString(
  				const char *string, PGPKeyID *id );
  					
! PGPError 	PGPGetKeyIDFromKey( PGPKeyRef key, PGPKeyID *id );
  
! PGPError 	PGPGetKeyIDFromSubKey( PGPSubKeyRef key, PGPKeyID * id );
  
  enum PGPKeyIDStringType_
  {
  	kPGPKeyIDString_Abbreviated = 2,
  	kPGPKeyIDString_Full = 3,
  	PGP_ENUM_FORCE( PGPKeyIDStringType_ )
  };
  PGPENUM_TYPEDEF( PGPKeyIDStringType_, PGPKeyIDStringType );
  
  
  #define kPGPMaxKeyIDStringSize		( 127 + 1 )
! PGPError 	PGPGetKeyIDString( PGPKeyID const * ref,
  					PGPKeyIDStringType type,
  					char outString[ kPGPMaxKeyIDStringSize ] );
  
  
  /* outputs opaque string of bytes for storage of maximum size as keyID*/
  /* do NOT attempt to parse the output; it is opaque to you */
  #define kPGPMaxExportedKeyIDSize		( sizeof( PGPKeyID ) )
! PGPError 	PGPExportKeyID( PGPKeyID const * keyID,
  					PGPByte exportedData[ kPGPMaxExportedKeyIDSize ],
  					PGPSize *exportedLength );
  
  /* must be in format output by PGPExportKeyID */
! PGPError 	PGPImportKeyID(  void const * data, PGPKeyID * id );
  
  /* returns 0 if equal, -1 if key1 < key2, 1 if key1 > key2 */
! PGPInt32 	PGPCompareKeyIDs( PGPKeyID const * key, PGPKeyID const * key2);
  
  
  
  
  /*____________________________________________________________________________
  	Getting contexts back from key related items.  If the key is invalid,
  	you get kPGPInvalidRef back.
  ____________________________________________________________________________*/
  
! PGPContextRef	PGPGetKeyListContext( PGPKeyListRef ref );
! PGPContextRef	PGPGetKeySetContext( PGPKeySetRef ref );
! PGPContextRef	PGPGetKeyIterContext( PGPKeyIterRef ref );
! PGPContextRef	PGPGetKeyContext( PGPKeyRef ref );
! PGPContextRef	PGPGetSubKeyContext( PGPSubKeyRef ref );
! PGPContextRef	PGPGetUserIDContext( PGPUserIDRef ref );
  
  /*____________________________________________________________________________
  	Getting parent objects from key related items.  If the input is invalid,
  	you get kPGPInvalidRef back.
  ____________________________________________________________________________*/
! PGPKeyRef		PGPGetUserIDKey( PGPUserIDRef ref );
! PGPUserIDRef	PGPGetSigUserID( PGPSigRef ref );
! PGPKeyRef		PGPGetSigKey( PGPSigRef ref );
  
  
  /*____________________________________________________________________________
      Secret sharing functionality
  ____________________________________________________________________________*/
  
! PGPError		PGPSecretShareData(PGPContextRef context,
  						void const * input, PGPSize inputBytes,
  						PGPUInt32 threshold, PGPUInt32 nShares, void * output);
  
! PGPError		PGPSecretReconstructData(PGPContextRef context,
  						void * input, PGPSize outputBytes,
  						PGPUInt32 nShares, void * output);
  
  
  /*____________________________________________________________________________
      X509 certificate specific
  ____________________________________________________________________________*/
  
! PGPError		PGPVerifyX509CertificateChain (PGPContextRef context,
  						PGPByte *certchain, PGPByte *rootcerts);
  
! PGPError		PGPCreateDistinguishedName( PGPContextRef context,
  						char const *str,
  						PGPByte **pdname, PGPSize *pdnamelen );
  
  
  #if PRAGMA_IMPORT_SUPPORTED
  #pragma import reset
  #endif
  PGP_END_C_DECLARATIONS
  
  
  #endif /* ] Included_pgpKeys_h */
  
  /*__Editor_settings____
  
  	Local Variables:
  	tab-width: 4
  	End:
  	vi: ts=4 sw=4
  	vim: si
  _____________________*/
--- 222,879 ----
  	kPGPMatchGreaterOrEqual = 2, /* searched val >= supplied val */
  	kPGPMatchLessOrEqual = 3, /* searched val <= supplied val */
  	kPGPMatchSubString = 4,	 /* searched val is contained in supplied val */
  
  	PGP_ENUM_FORCE( PGPMatchCriterion_ )
  } ;
  PGPENUM_TYPEDEF( PGPMatchCriterion_, PGPMatchCriterion );
  
  
  /* This is the value of the expiration time which means "never expires" */
  #define kPGPExpirationTime_Never	( (PGPTime)0 )
  
  /* Secret sharing header size */
  #define kPGPShareHeaderSize		4
  
  /* Public entry points */
  
  PGP_BEGIN_C_DECLARATIONS
  #if PRAGMA_IMPORT_SUPPORTED
  #pragma import on
  #endif
  
  
  /* Functions for setting up key filters. */
  
! PGPError 	PGPAPI PGPIncFilterRefCount ( PGPFilterRef filter );
  
! PGPError 	PGPAPI PGPFreeFilter ( PGPFilterRef filter );
  
! PGPError 	PGPAPI PGPNewKeyIDFilter( PGPContextRef context, 
  						PGPKeyID const * keyID, PGPFilterRef *outFilter);
  
! PGPError	PGPAPI PGPNewSubKeyIDFilter( PGPContextRef		context,
  						PGPKeyID const *	subKeyID,  
  						PGPFilterRef *		outFilter);
  
! PGPError 	PGPAPI PGPNewKeyEncryptAlgorithmFilter( PGPContextRef context, 
  						PGPPublicKeyAlgorithm encryptAlgorithm,
  						PGPFilterRef *outFilter );
  
! PGPError 	PGPAPI PGPNewKeyFingerPrintFilter( PGPContextRef context, 
  						void const *fingerPrint, 
  						PGPSize fingerPrintLength, PGPFilterRef *outFilter );
  
! PGPError 	PGPAPI PGPNewKeyCreationTimeFilter( PGPContextRef context, 
  						PGPTime creationTime, PGPMatchCriterion match, 
  						PGPFilterRef *outFilter );
  
! PGPError 	PGPAPI PGPNewKeyExpirationTimeFilter( PGPContextRef context, 
  						PGPTime expirationTime, 
  						PGPMatchCriterion match, PGPFilterRef *outFilter );
  
! PGPError 	PGPAPI PGPNewKeyRevokedFilter( PGPContextRef context,
  						PGPBoolean revoked, PGPFilterRef *outFilter );
  
! PGPError	PGPAPI PGPNewKeyDisabledFilter( PGPContextRef context, 
  						PGPBoolean			disabled, 
  						PGPFilterRef *		outFilter);
  
! PGPError 	PGPAPI PGPNewKeySigAlgorithmFilter( PGPContextRef context,
  						PGPPublicKeyAlgorithm sigAlgorithm, 
  						PGPFilterRef *outFilter );
  
! PGPError 	PGPAPI PGPNewKeyEncryptKeySizeFilter( PGPContextRef context,
  						PGPUInt32 keySize, PGPMatchCriterion match,
  						PGPFilterRef *outFilter );
  
! PGPError 	PGPAPI PGPNewKeySigKeySizeFilter( PGPContextRef context,
  						PGPUInt32 keySize, PGPMatchCriterion match,
  						PGPFilterRef *outFilter );
  
! PGPError	PGPAPI PGPNewUserIDStringFilter( PGPContextRef context,
  						char const *		userIDString, 
  						PGPMatchCriterion	match,
  						PGPFilterRef *		outFilter);
  
! PGPError 	PGPAPI PGPNewUserIDEmailFilter( PGPContextRef context,
  						char const *		emailString, 
  						PGPMatchCriterion	match,
  						PGPFilterRef *		outFilter);
  
! PGPError 	PGPAPI PGPNewUserIDNameFilter( PGPContextRef context,
  						char const *		nameString, 
  						PGPMatchCriterion	match,
  						PGPFilterRef *		outFilter);
  
! PGPError 	PGPAPI PGPNewSigKeyIDFilter( PGPContextRef context,
  						PGPKeyID const * keyID,
  						PGPFilterRef *outFilter );
  
! PGPError 	PGPAPI PGPNewKeyBooleanFilter( PGPContextRef context,
  						PGPKeyPropName property, PGPBoolean match,
  						PGPFilterRef *outFilter );
  
! PGPError 	PGPAPI PGPNewKeyNumberFilter( PGPContextRef context,
  						PGPKeyPropName property, PGPUInt32 value,
  						PGPMatchCriterion match, PGPFilterRef *outFilter );
  
! PGPError 	PGPAPI PGPNewKeyTimeFilter( PGPContextRef context,
  						PGPKeyPropName property, PGPTime value,
  						PGPMatchCriterion match, PGPFilterRef *outFilter );
  
! PGPError 	PGPAPI PGPNewKeyPropertyBufferFilter( PGPContextRef context,
  						PGPKeyPropName property, void *buffer, PGPSize length,
  						PGPMatchCriterion match, PGPFilterRef *outFilter );
  
! PGPError 	PGPAPI PGPNewSubKeyBooleanFilter( PGPContextRef context,
  						PGPKeyPropName property, PGPBoolean match,
  						PGPFilterRef *outFilter );
  
! PGPError 	PGPAPI PGPNewSubKeyNumberFilter( PGPContextRef context,
  						PGPKeyPropName property, PGPUInt32 value,
  						PGPMatchCriterion match, PGPFilterRef *outFilter );
  
! PGPError 	PGPAPI PGPNewSubKeyTimeFilter( PGPContextRef context,
  						PGPKeyPropName property, PGPTime value,
  						PGPMatchCriterion match, PGPFilterRef *outFilter );
  
! PGPError 	PGPAPI PGPNewSubKeyPropertyBufferFilter( PGPContextRef context,
  						PGPKeyPropName property, void *buffer, PGPSize length,
  						PGPMatchCriterion match, PGPFilterRef *outFilter );
  
! PGPError 	PGPAPI PGPNewUserIDBooleanFilter( PGPContextRef context,
  						PGPUserIDPropName property, PGPBoolean match,
  						PGPFilterRef *outFilter );
  
! PGPError 	PGPAPI PGPNewUserIDNumberFilter( PGPContextRef context,
  						PGPUserIDPropName property, PGPUInt32 value,
  						PGPMatchCriterion match, PGPFilterRef *outFilter );
  
! PGPError 	PGPAPI PGPNewUserIDStringBufferFilter( PGPContextRef context,
  						PGPUserIDPropName property,
  						void *buffer, PGPSize length,
  						PGPMatchCriterion match, PGPFilterRef *outFilter );
  
! PGPError 	PGPAPI PGPNewSigBooleanFilter( PGPContextRef context,
  						PGPSigPropName property, PGPBoolean match,
  						PGPFilterRef *outFilter );
  
! PGPError 	PGPAPI PGPNewSigNumberFilter( PGPContextRef context,
  						PGPSigPropName property, PGPUInt32 value,
  						PGPMatchCriterion match, PGPFilterRef *outFilter );
  
! PGPError 	PGPAPI PGPNewSigTimeFilter( PGPContextRef context,
  						PGPSigPropName property, PGPTime value,
  						PGPMatchCriterion match, PGPFilterRef *outFilter );
  
! PGPError 	PGPAPI PGPNewSigPropertyBufferFilter( PGPContextRef context,
  						PGPSigPropName property, void *buffer, PGPSize length,
  						PGPMatchCriterion match, PGPFilterRef *outFilter );
  
  /* freeing outfilter will call PGPFreeFilter on filter */
! PGPError 	PGPAPI PGPNegateFilter( PGPFilterRef filter,
  						PGPFilterRef *outFilter);
  
  /* freeing outfilter will call PGPFreeFilter on filter1, filter2 */
! PGPError 	PGPAPI PGPIntersectFilters( PGPFilterRef filter1,
  						PGPFilterRef filter2, PGPFilterRef *outFilter);
  
  /* freeing outfilter will call PGPFreeFilter on filter1, filter2 */
! PGPError 	PGPAPI PGPUnionFilters( PGPFilterRef filter1,
  						PGPFilterRef filter2, PGPFilterRef *outFilter);
  
  
! PGPError 	PGPAPI PGPFilterKeySet( PGPKeySetRef origSet,
  						PGPFilterRef filter, PGPKeySetRef *resultSet);
  
  
  /* Keyserver filter functions */
  
! PGPError 	PGPAPI PGPLDAPQueryFromFilter( PGPFilterRef filter,
  						char **queryOut );
  
! PGPError 	PGPAPI PGPHKSQueryFromFilter( PGPFilterRef	filter,
  						char **queryOut );
  						
! PGPError	PGPAPI PGPNetToolsCAHTTPQueryFromFilter( PGPFilterRef filter,
  						char **queryOut );
  
  /* KeySet manipulations */
  
  
  /* Creates a new memory-based KeyDB and returns its root set */
! PGPError  	PGPAPI PGPNewKeySet(PGPContextRef context, PGPKeySetRef *keySet);
  
  
  /* Used for building arbitrary subsets of an existing KeyDB */
! PGPError  	PGPAPI PGPNewEmptyKeySet(PGPKeySetRef origSet, PGPKeySetRef *newSet);
! PGPError  	PGPAPI PGPNewSingletonKeySet(PGPKeyRef key, PGPKeySetRef *keySet);
! PGPError	PGPAPI PGPUnionKeySets(PGPKeySetRef set1, PGPKeySetRef set2,
  								PGPKeySetRef *newSet);
  
! PGPError  	PGPAPI PGPOpenDefaultKeyRings( PGPContextRef context,
  						PGPKeyRingOpenFlags openFlags, PGPKeySetRef *keySet);
  
! PGPError  	PGPAPI PGPOpenKeyRingPair( PGPContextRef context,
  						PGPKeyRingOpenFlags openFlags, 
  						PGPFileSpecRef pubFileRef, PGPFileSpecRef secFileRef,
  						PGPKeySetRef *keySet);
  
! PGPError  	PGPAPI PGPOpenKeyRing (PGPContextRef context,
  						PGPKeyRingOpenFlags openFlags, PGPFileSpecRef fileRef,
  						PGPKeySetRef *keySet);
  
! PGPError 	PGPAPI PGPCommitKeyRingChanges (PGPKeySetRef keys);
  
! PGPError 	PGPAPI PGPPropagateTrust (PGPKeySetRef keys);
  
! PGPError 	PGPAPI PGPRevertKeyRingChanges (PGPKeySetRef keys);
  
! PGPError 	PGPAPI PGPCheckKeyRingSigs (PGPKeySetRef keysToCheck,
  						PGPKeySetRef keysSigning, PGPBoolean checkAll,
  						PGPEventHandlerProcPtr eventHandler,
  						PGPUserValue eventHandlerData);
  
! PGPError 	PGPAPI PGPReloadKeyRings (PGPKeySetRef keys);
  
! PGPError 	PGPAPI PGPGetKeyByKeyID (PGPKeySetRef keys,
  						PGPKeyID const * keyID,
  						PGPPublicKeyAlgorithm pubKeyAlgorithm,
  						PGPKeyRef *outRef);
  
! PGPBoolean 	PGPAPI PGPKeySetIsMember(PGPKeyRef key, PGPKeySetRef set);
  
! PGPError 	PGPAPI PGPCountKeys( PGPKeySetRef keys, PGPUInt32 *numKeys);
  
! PGPError 	PGPAPI PGPIncKeySetRefCount( PGPKeySetRef keys);
  
! PGPError 	PGPAPI PGPFreeKeySet( PGPKeySetRef keys);
  
! PGPBoolean 	PGPAPI PGPKeySetIsMutable( PGPKeySetRef keys);
  
! PGPBoolean 	PGPAPI PGPKeySetNeedsCommit( PGPKeySetRef keys);
  
  
! PGPError 	PGPAPI PGPAddKeys( PGPKeySetRef keysToAdd, PGPKeySetRef set );
  
! PGPError 	PGPAPI PGPRemoveKeys( PGPKeySetRef keysToRemove, PGPKeySetRef set );
  
  
  
  /* Key manipulation functions */
  
! PGPError 	PGPAPI PGPDisableKey( PGPKeyRef key);
  
! PGPError 	PGPAPI PGPEnableKey( PGPKeyRef key);
  
! PGPError 	PGPAPI PGPRemoveSubKey( PGPSubKeyRef subkey);
  
! PGPError 	PGPAPI PGPRemoveUserID( PGPUserIDRef userID);
  
! PGPError 	PGPAPI PGPSetPrimaryUserID( PGPUserIDRef userid);
  
! PGPError 	PGPAPI PGPCertifyPrimaryUserID( PGPUserIDRef userid,
  						PGPOptionListRef firstOption, ...);
  
! PGPError 	PGPAPI PGPGetSigCertifierKey( PGPSigRef cert, PGPKeySetRef allkeys,
  						PGPKeyRef *certkey);
  
! PGPError 	PGPAPI PGPGetSigX509CertifierSig( PGPSigRef cert,
  						PGPKeySetRef allkeys, PGPSigRef *certsig);
  
! PGPError 	PGPAPI PGPRemoveSig( PGPSigRef cert);
  
! PGPError	PGPAPI PGPCountAdditionalRecipientRequests( PGPKeyRef basekey,
  					PGPUInt32 * numARKeys);
  					
! PGPError 	PGPAPI PGPGetIndexedAdditionalRecipientRequestKey(
  						PGPKeyRef basekey, PGPKeySetRef allkeys, PGPUInt32 nth,
  						PGPKeyRef *arkey, PGPKeyID *arkeyid,
  						PGPByte *arclass );
  
! PGPError	PGPAPI PGPCountRevocationKeys( PGPKeyRef basekey,
  					PGPUInt32 * numRevKeys);
  
! PGPError 	PGPAPI PGPGetIndexedRevocationKey(
  						PGPKeyRef basekey, PGPKeySetRef allkeys, PGPUInt32 nth,
  						PGPKeyRef *revkey, PGPKeyID *revkeyid );
! PGPError	PGPAPI PGPGetCRLDistributionPoints(
  						PGPKeyRef cakey, PGPKeySetRef keyset,
  						PGPUInt32 *pnDistPoints, PGPByte **pDpoints,
  						PGPSize **pdpointLengths );
  
  
  /* Wrapper functions */
! PGPError	PGPAPI PGPGenerateKey( PGPContextRef context, PGPKeyRef *key,
  						PGPOptionListRef firstOption, ...);
! PGPError	PGPAPI PGPGenerateSubKey( PGPContextRef context,
  						PGPSubKeyRef *subkey,
  						PGPOptionListRef firstOption, ...);
! PGPUInt32	PGPAPI PGPGetKeyEntropyNeeded( PGPContextRef context,
  						PGPOptionListRef firstOption, ...);
! PGPError	PGPAPI PGPExportKeySet( PGPKeySetRef keys,
  						PGPOptionListRef firstOption, ...);
! PGPError	PGPAPI PGPExport( PGPContextRef context,
  						PGPOptionListRef firstOption, ...);
! PGPError	PGPAPI PGPImportKeySet( PGPContextRef context,
  						PGPKeySetRef *keys,
  						PGPOptionListRef firstOption, ...);
! PGPError	PGPAPI PGPSignUserID( PGPUserIDRef userID,
  						PGPKeyRef certifyingKey,
  						PGPOptionListRef firstOption, ...);
! PGPError	PGPAPI PGPAddUserID( PGPKeyRef key, char const *userID,
  						PGPOptionListRef firstOption, ...);
! PGPError	PGPAPI PGPAddAttributeUserID( PGPKeyRef key,
  						PGPAttributeType attributeType,
  						PGPByte *attributeData, PGPSize attributeLength,
  						PGPOptionListRef firstOption, ...);
! PGPError	PGPAPI PGPRevokeSig( PGPSigRef cert, PGPKeySetRef allkeys,
  						PGPOptionListRef firstOption, ...);
! PGPError	PGPAPI PGPRevokeKey( PGPKeyRef key,
  						PGPOptionListRef firstOption, ...);
! PGPError	PGPAPI PGPRevokeSubKey( PGPSubKeyRef subkey,
  						PGPOptionListRef firstOption, ...);
! PGPError	PGPAPI PGPChangePassphrase( PGPKeyRef key,
  						PGPOptionListRef firstOption, ...);
! PGPError	PGPAPI PGPChangeSubKeyPassphrase( PGPSubKeyRef subkey,
  						PGPOptionListRef firstOption, ...);
! PGPBoolean	PGPAPI PGPPassphraseIsValid( PGPKeyRef key,
  						PGPOptionListRef firstOption, ...);
! PGPError	PGPAPI PGPSetKeyAxiomatic( PGPKeyRef key,
  						PGPOptionListRef firstOption, ...);
  
  
  
  /*
   * Trust values for PGPSetKeyTrust and kPGPKeyPropTrust property:
   * 
   * kPGPKeyTrust_Undefined	(do not pass to PGPSetKeyTrust)
   * kPGPKeyTrust_Unknown		(unknown)
   * kPGPKeyTrust_Never		(never)
   * kPGPKeyTrust_Marginal	(sometimes)
   * kPGPKeyTrust_Complete	(always)
   * kPGPKeyTrust_Ultimate	(do not pass to PGPSetKeyTrust)
   */
  
   /* old trust model */
! PGPError 	PGPAPI PGPSetKeyTrust( PGPKeyRef key, PGPUInt32 trust);
  
! PGPError 	PGPAPI PGPUnsetKeyAxiomatic( PGPKeyRef key);
  
  /*  Get property functions */
  
! PGPError 	PGPAPI PGPGetKeyBoolean( PGPKeyRef key, PGPKeyPropName propname,
  						PGPBoolean *prop);
  
! PGPError 	PGPAPI PGPGetKeyNumber( PGPKeyRef key, PGPKeyPropName propname,
  						PGPInt32 *prop);
  
  /* 'buffer' is NOT null-terminated */
  /* returns kPGPError_BufferTooSmall if buffer is too small, but
  fill buffer to capacity */
! PGPError 	PGPAPI PGPGetKeyPropertyBuffer( PGPKeyRef key,
  						PGPKeyPropName propname,
  						PGPSize bufferSize, void *data, PGPSize *fullSize);
  
! PGPError 	PGPAPI PGPGetKeyTime( PGPKeyRef key, PGPKeyPropName propname,
  						PGPTime *prop);
  
! PGPError 	PGPAPI PGPGetSubKeyBoolean( PGPSubKeyRef subkey,
  						PGPKeyPropName propname, PGPBoolean *prop);
  
! PGPError 	PGPAPI PGPGetSubKeyNumber( PGPSubKeyRef subkey,
  						PGPKeyPropName propname, PGPInt32 *prop);
  
  /* returns kPGPError_BufferTooSmall if buffer is too small, but
  fill buffer to capacity */
! PGPError 	PGPAPI PGPGetSubKeyPropertyBuffer( PGPSubKeyRef subkey,
  						PGPKeyPropName propname,
  						PGPSize bufferSize, void *prop, PGPSize *fullSize);
  
! PGPError 	PGPAPI PGPGetSubKeyTime( PGPSubKeyRef subkey,
  						PGPKeyPropName propname, PGPTime *prop);
  
! PGPError 	PGPAPI PGPGetUserIDNumber( PGPUserIDRef userID,
  						PGPUserIDPropName propname, PGPInt32 *prop);
  
! PGPError 	PGPAPI PGPGetUserIDBoolean( PGPUserIDRef userID,
  						PGPUserIDPropName propname, PGPBoolean *prop);
  
  /* 'string' is always NULL-terminated */
  /* returns kPGPError_BufferTooSmall if buffer is too small, but
  fill buffer to capacity */
! PGPError 	PGPAPI PGPGetUserIDStringBuffer( PGPUserIDRef userID,
  						PGPUserIDPropName propname,
  						PGPSize bufferSize,
  						char *		string,
  						PGPSize *	fullSize);
  
  /* 'buffer' is NOT null-terminated */
  /* returns kPGPError_BufferTooSmall if buffer is too small, but
  fill buffer to capacity */
! PGPError 	PGPAPI PGPGetSigPropertyBuffer( PGPSigRef cert,
  						PGPSigPropName propname,
  						PGPSize bufferSize, void *data, PGPSize *fullSize);
  
! PGPError 	PGPAPI PGPGetSigBoolean( PGPSigRef cert,
  						PGPSigPropName propname, PGPBoolean *prop);
  
! PGPError 	PGPAPI PGPGetSigNumber( PGPSigRef cert, PGPSigPropName propname,
  						PGPInt32 *prop);
  						
! PGPError 	PGPAPI PGPGetKeyIDOfCertifier( PGPSigRef sig, PGPKeyID *outID );
  	
! PGPError 	PGPAPI PGPGetSigTime( PGPSigRef cert, PGPSigPropName propname,
  						PGPTime *prop);
  
! PGPError 	PGPAPI PGPGetHashAlgUsed( PGPKeyRef key, PGPHashAlgorithm *hashAlg);
  
  /* Convenience property functions */
  
! PGPError  	PGPAPI PGPGetPrimaryUserID( PGPKeyRef key, PGPUserIDRef *outRef );
! PGPError	PGPAPI PGPGetPrimaryAttributeUserID (PGPKeyRef key,
  						PGPAttributeType attributeType, PGPUserIDRef *outRef);
  
  /* 'string' is always a C string and
  	*fullSize includes the '\0' terminator */
  /* returns kPGPError_BufferTooSmall if buffer is too small, but
  fill buffer to capacity */
! PGPError 	PGPAPI PGPGetPrimaryUserIDNameBuffer( PGPKeyRef key, 
  					PGPSize bufferSize,
  					char *	string, PGPSize *fullSize );
  
! PGPError 	PGPAPI PGPGetPrimaryUserIDValidity(PGPKeyRef key,
  					PGPValidity *validity);
  
  
! PGPInt32 	PGPAPI PGPCompareKeys(PGPKeyRef a, PGPKeyRef b,
  						PGPKeyOrdering order);
  
! PGPInt32 	PGPAPI PGPCompareUserIDStrings(char const *a, char const *b);
  
! PGPError  	PGPAPI PGPOrderKeySet( PGPKeySetRef src,
  						PGPKeyOrdering order, PGPKeyListRef *outRef );
  
! PGPError 	PGPAPI PGPIncKeyListRefCount( PGPKeyListRef keys);
  
! PGPError 	PGPAPI PGPFreeKeyList( PGPKeyListRef keys);
  
  
  /* Key iteration functions */
  
  
  
! PGPError 	PGPAPI PGPNewKeyIter (PGPKeyListRef keys, PGPKeyIterRef *outRef);
  
! PGPError 	PGPAPI PGPCopyKeyIter (PGPKeyIterRef orig, PGPKeyIterRef *outRef);
  	
! PGPError 	PGPAPI PGPFreeKeyIter (PGPKeyIterRef iter);
  
! PGPInt32 	PGPAPI PGPKeyIterIndex (PGPKeyIterRef iter);
  
! PGPError 	PGPAPI PGPKeyIterRewind (PGPKeyIterRef iter);
  
! PGPInt32 	PGPAPI PGPKeyIterSeek (PGPKeyIterRef iter, PGPKeyRef key);
  
! PGPError 	PGPAPI PGPKeyIterMove (PGPKeyIterRef iter, PGPInt32 relOffset,
  						PGPKeyRef *outRef);
  
! PGPError 	PGPAPI PGPKeyIterNext (PGPKeyIterRef iter, PGPKeyRef *outRef);
  
! PGPError 	PGPAPI PGPKeyIterPrev (PGPKeyIterRef iter, PGPKeyRef *outRef);
  
! PGPError 	PGPAPI PGPKeyIterKey (PGPKeyIterRef iter, PGPKeyRef *outRef);
  
! PGPError  	PGPAPI PGPKeyIterSubKey (PGPKeyIterRef iter,
  						PGPSubKeyRef *outRef );
  
! PGPError  	PGPAPI PGPKeyIterUserID (PGPKeyIterRef iter,
  						PGPUserIDRef *outRef );
! PGPError  	PGPAPI PGPKeyIterSig (PGPKeyIterRef iter,
  						PGPSigRef *outRef );
  
! PGPError  	PGPAPI PGPKeyIterNextSubKey (PGPKeyIterRef iter,
  						PGPSubKeyRef *outRef );
  
! PGPError  	PGPAPI PGPKeyIterPrevSubKey (PGPKeyIterRef iter,
  						PGPSubKeyRef *outRef);
  
! PGPError 	PGPAPI PGPKeyIterRewindSubKey (PGPKeyIterRef iter);
  
! PGPError  	PGPAPI PGPKeyIterNextUserID (PGPKeyIterRef iter,
  						PGPUserIDRef *outRef);
  
! PGPError  	PGPAPI PGPKeyIterPrevUserID (PGPKeyIterRef iter,
  						PGPUserIDRef *outRef);
  
! PGPError 	PGPAPI PGPKeyIterRewindUserID (PGPKeyIterRef iter);
  
! PGPError  	PGPAPI PGPKeyIterNextUIDSig (PGPKeyIterRef iter,
  						PGPSigRef *outRef);
  
! PGPError  	PGPAPI PGPKeyIterPrevUIDSig (PGPKeyIterRef iter,
  						PGPSigRef *outRef);
  
! PGPError 	PGPAPI PGPKeyIterRewindUIDSig (PGPKeyIterRef iter);
  
  
  /* Get/set default private key */
  
! PGPError 	PGPAPI PGPGetDefaultPrivateKey( PGPKeySetRef keyset,
  						PGPKeyRef *outRef );
  
! PGPError 	PGPAPI PGPSetDefaultPrivateKey( PGPKeyRef key);
  
  
  
  /* Get/set user value */
  
! PGPError 	PGPAPI PGPSetKeyUserVal( PGPKeyRef key, PGPUserValue userValue);
  
! PGPError 	PGPAPI PGPSetUserIDUserVal( PGPUserIDRef userid,
  						PGPUserValue userValue);
  
! PGPError 	PGPAPI PGPSetSubKeyUserVal( PGPSubKeyRef subkey,
  						PGPUserValue userValue);
  
! PGPError 	PGPAPI PGPSetSigUserVal( PGPSigRef cert,
  						PGPUserValue userValue);
  
! PGPError 	PGPAPI PGPGetKeyUserVal( PGPKeyRef key,
  						PGPUserValue *userValue);
  
! PGPError 	PGPAPI PGPGetUserIDUserVal( PGPUserIDRef userid,
  						PGPUserValue *userValue);
  
! PGPError 	PGPAPI PGPGetSubKeyUserVal( PGPSubKeyRef subkey,
  						PGPUserValue *userValue);
  
! PGPError 	PGPAPI PGPGetSigUserVal( PGPSigRef cert,
  						PGPUserValue *userValue);
  
  /* Passphrase conversion to passkeybuffer */
  /* The size of the output buffer is from the kPGPKeyPropLockingBits property */
  
! PGPError	PGPAPI PGPGetKeyPasskeyBuffer ( PGPKeyRef key,
  						void *passkeyBuffer, PGPOptionListRef firstOption,...);
  
! PGPError	PGPAPI PGPGetSubKeyPasskeyBuffer ( PGPSubKeyRef subkey,
  						void *passkeyBuffer, PGPOptionListRef firstOption,...);
  
  
  /* Change key options which are stored in self signatures internally */
  
! PGPError	PGPAPI PGPAddKeyOptions( PGPKeyRef key,
  						PGPOptionListRef firstOption, ...);
  
! PGPError	PGPAPI PGPRemoveKeyOptions( PGPKeyRef key,
  						PGPOptionListRef firstOption, ...);
  
! PGPError	PGPAPI PGPUpdateKeyOptions( PGPKeyRef key,
  						PGPOptionListRef firstOption, ...);
  
  
  
  /*____________________________________________________________________________
  	Key IDs
  ____________________________________________________________________________*/
! PGPError 	PGPAPI PGPGetKeyIDFromString(
  				const char *string, PGPKeyID *id );
  					
! PGPError 	PGPAPI PGPGetKeyIDFromKey( PGPKeyRef key, PGPKeyID *id );
  
! PGPError 	PGPAPI PGPGetKeyIDFromSubKey( PGPSubKeyRef key, PGPKeyID * id );
  
  enum PGPKeyIDStringType_
  {
  	kPGPKeyIDString_Abbreviated = 2,
  	kPGPKeyIDString_Full = 3,
  	PGP_ENUM_FORCE( PGPKeyIDStringType_ )
  };
  PGPENUM_TYPEDEF( PGPKeyIDStringType_, PGPKeyIDStringType );
  
  
  #define kPGPMaxKeyIDStringSize		( 127 + 1 )
! PGPError 	PGPAPI PGPGetKeyIDString( PGPKeyID const * ref,
  					PGPKeyIDStringType type,
  					char outString[ kPGPMaxKeyIDStringSize ] );
  
  
  /* outputs opaque string of bytes for storage of maximum size as keyID*/
  /* do NOT attempt to parse the output; it is opaque to you */
  #define kPGPMaxExportedKeyIDSize		( sizeof( PGPKeyID ) )
! PGPError 	PGPAPI PGPExportKeyID( PGPKeyID const * keyID,
  					PGPByte exportedData[ kPGPMaxExportedKeyIDSize ],
  					PGPSize *exportedLength );
  
  /* must be in format output by PGPExportKeyID */
! PGPError 	PGPAPI PGPImportKeyID(  void const * data, PGPKeyID * id );
  
  /* returns 0 if equal, -1 if key1 < key2, 1 if key1 > key2 */
! PGPInt32 	PGPAPI PGPCompareKeyIDs( PGPKeyID const * key, PGPKeyID const * key2);
  
  
  
  
  /*____________________________________________________________________________
  	Getting contexts back from key related items.  If the key is invalid,
  	you get kPGPInvalidRef back.
  ____________________________________________________________________________*/
  
! PGPContextRef	PGPAPI PGPGetKeyListContext( PGPKeyListRef ref );
! PGPContextRef	PGPAPI PGPGetKeySetContext( PGPKeySetRef ref );
! PGPContextRef	PGPAPI PGPGetKeyIterContext( PGPKeyIterRef ref );
! PGPContextRef	PGPAPI PGPGetKeyContext( PGPKeyRef ref );
! PGPContextRef	PGPAPI PGPGetSubKeyContext( PGPSubKeyRef ref );
! PGPContextRef	PGPAPI PGPGetUserIDContext( PGPUserIDRef ref );
  
  /*____________________________________________________________________________
  	Getting parent objects from key related items.  If the input is invalid,
  	you get kPGPInvalidRef back.
  ____________________________________________________________________________*/
! PGPKeyRef		PGPAPI PGPGetUserIDKey( PGPUserIDRef ref );
! PGPUserIDRef	PGPAPI PGPGetSigUserID( PGPSigRef ref );
! PGPKeyRef		PGPAPI PGPGetSigKey( PGPSigRef ref );
  
  
  /*____________________________________________________________________________
      Secret sharing functionality
  ____________________________________________________________________________*/
  
! PGPError	PGPAPI PGPSecretShareData(PGPContextRef context,
  						void const * input, PGPSize inputBytes,
  						PGPUInt32 threshold, PGPUInt32 nShares, void * output);
  
! PGPError	PGPAPI PGPSecretReconstructData(PGPContextRef context,
  						void * input, PGPSize outputBytes,
  						PGPUInt32 nShares, void * output);
  
  
  /*____________________________________________________________________________
      X509 certificate specific
  ____________________________________________________________________________*/
  
! PGPError	PGPAPI PGPVerifyX509CertificateChain (PGPContextRef context,
  						PGPByte *certchain, PGPByte *rootcerts);
  
! PGPError	PGPAPI PGPCreateDistinguishedName( PGPContextRef context,
  						char const *str,
  						PGPByte **pdname, PGPSize *pdnamelen );
  
  
  #if PRAGMA_IMPORT_SUPPORTED
  #pragma import reset
  #endif
  PGP_END_C_DECLARATIONS
  
  
  #endif /* ] Included_pgpKeys_h */
  
  /*__Editor_settings____
  
  	Local Variables:
  	tab-width: 4
  	End:
  	vi: ts=4 sw=4
  	vim: si
  _____________________*/
