*** orig/win32_65/inc/pgpMemoryMgr.h	Wed Aug 30 12:08:30 2000
--- modified/win32_65/inc/pgpMemoryMgr.h	Wed Aug 30 12:08:30 2000
***************
*** 1,32 ****
  /*____________________________________________________________________________
  	Copyright (C) 1997 Network Associates Inc. and affiliated companies.
  	All rights reserved.
  	
  	Contains the definition of the PGPMemoryMgr object.
  
! 	$Id: pgpMemoryMgr.h,v 1.21 1999/05/07 01:55:45 heller Exp $
  ____________________________________________________________________________*/
  
  #ifndef Included_pgpMemoryMgr_h	/* [ */
  #define Included_pgpMemoryMgr_h
  
  
  #include "pgpBase.h"
  
  /*____________________________________________________________________________
  	Mini-tutorial:
  	
  	A PGPMemoryMgr is an object which implements memory management, including
  	allocation, reallocation, deallocation, and secure versions of the same.
  	
  	*** Using it ***
  	A typical sequence of calls is as follows:
  		PGPNewMemoryMgr
  		...
  		PGPNewData or PGPNewSecureData
  		PGPFreeData
  		...
  		PGPFreeMemoryMgr
  	
  	Typically, a program will create one PGPMemoryMgr per thread at
  	thread creation time and use that memory mgr until the thread dies.
--- 1,32 ----
  /*____________________________________________________________________________
  	Copyright (C) 1997 Network Associates Inc. and affiliated companies.
  	All rights reserved.
  	
  	Contains the definition of the PGPMemoryMgr object.
  
! 	$Id: pgpMemoryMgr.h,v 1.1 2000/07/28 15:58:02 mhu Exp $
  ____________________________________________________________________________*/
  
  #ifndef Included_pgpMemoryMgr_h	/* [ */
  #define Included_pgpMemoryMgr_h
  
  
  #include "pgpBase.h"
  
  /*____________________________________________________________________________
  	Mini-tutorial:
  	
  	A PGPMemoryMgr is an object which implements memory management, including
  	allocation, reallocation, deallocation, and secure versions of the same.
  	
  	*** Using it ***
  	A typical sequence of calls is as follows:
  		PGPNewMemoryMgr
  		...
  		PGPNewData or PGPNewSecureData
  		PGPFreeData
  		...
  		PGPFreeMemoryMgr
  	
  	Typically, a program will create one PGPMemoryMgr per thread at
  	thread creation time and use that memory mgr until the thread dies.
***************
*** 127,235 ****
  	/* sizeofStruct must be inited to sizeof( PGPNewMemoryMgrStruct ) */
  	PGPUInt32		sizeofStruct;
  	PGPFlags		reservedFlags;
  	
  	PGPMemoryMgrAllocationProc		allocProc;
  	PGPMemoryMgrReallocationProc	reallocProc;
  	PGPMemoryMgrDeallocationProc	deallocProc;
  	
  	PGPMemoryMgrSecureAllocationProc		secureAllocProc;
  	void *									reserved;	/* MUST be zeroed */
  	PGPMemoryMgrSecureDeallocationProc		secureDeallocProc;
  	
  	PGPUserValue					customValue;
  	void *							pad[ 8 ];	/* MUST be zeroed */
  } PGPNewMemoryMgrStruct;
  
  PGP_BEGIN_C_DECLARATIONS
  #if PRAGMA_IMPORT_SUPPORTED
  #pragma import on
  #endif
  
  
  /*____________________________________________________________________________
  	Memory Mgr routines
  ____________________________________________________________________________*/
! PGPBoolean	PGPMemoryMgrIsValid( PGPMemoryMgrRef mgr );
  #define PGPValidateMemoryMgr( mgr )	\
  		PGPValidateParam( PGPMemoryMgrIsValid( mgr ) )
  
! PGPError	PGPNewMemoryMgr( PGPFlags reserved,
  				PGPMemoryMgrRef *newMemoryMgr );
  
! PGPError	PGPNewMemoryMgrCustom( PGPNewMemoryMgrStruct const * custom,
  				PGPMemoryMgrRef *newMemoryMgr );
  
! PGPError	PGPFreeMemoryMgr( PGPMemoryMgrRef mgr );
  
! PGPError	PGPGetMemoryMgrCustomValue( PGPMemoryMgrRef mgr,
  					PGPUserValue *customValue );
! PGPError	PGPSetMemoryMgrCustomValue( PGPMemoryMgrRef mgr,
  				PGPUserValue customValue );
  
  /* allocate a block of the specified size */
! void *  	PGPNewData( PGPMemoryMgrRef mgr,
  				PGPSize requestSize, PGPMemoryMgrFlags flags );
  				
  /* allocate a block of the specified size in non-pageable memory */
  /* *isSecure is TRUE if the block definitely can't be paged */
! void *  	PGPNewSecureData( PGPMemoryMgrRef mgr,
  				PGPSize requestSize, PGPMemoryMgrFlags flags );
  
  /* properly reallocs secure or non-secure blocks */
  /* WARNING: the block may move, even if its size is being reduced */
! PGPError  	PGPReallocData( PGPMemoryMgrRef mgr,
  					void **allocation, PGPSize newAllocationSize,
  					PGPMemoryMgrFlags flags );
  					
  /* properly frees secure or non-secure blocks */
! PGPError 	PGPFreeData( void *allocation );
  
  
  /*____________________________________________________________________________
  	Block Info:
  		kPGPMemoryMgrBlockInfo_Valid		it's a valid block
  		kPGPMemoryMgrBlockInfo_Secure		block is a secure allocation
  		kPGPMemoryMgrBlockInfo_NonPageable	block cannot be paged by VM
  		
  	Secure blocks are always wiped before being disposed,
  	but may or may not be pageable, depending on the OS facilities.  Some
  	OSs may not provide the ability to make blocks non-pageable.
  	
  	You should check these flags if the information matters to you.
  ____________________________________________________________________________*/
  #define kPGPMemoryMgrBlockInfo_Valid		( ((PGPFlags)1) << 0 )
  #define kPGPMemoryMgrBlockInfo_Secure		( ((PGPFlags)1) << 1 )
  #define kPGPMemoryMgrBlockInfo_NonPageable	( ((PGPFlags)1) << 2 )
! PGPFlags		PGPGetMemoryMgrDataInfo( void *allocation );
  
  
  /*____________________________________________________________________________
  	Default memory manager routines:
  ____________________________________________________________________________*/
  
! PGPMemoryMgrRef	PGPGetDefaultMemoryMgr(void);
! PGPError		PGPSetDefaultMemoryMgr(PGPMemoryMgrRef memoryMgr);
  
  
  #if PRAGMA_IMPORT_SUPPORTED
  #pragma import reset
  #endif
  PGP_END_C_DECLARATIONS
  
  
  
  #if PRAGMA_ALIGN_SUPPORTED
  #pragma options align=reset
  #endif
  
  
  #endif /* ] Included_pgpMemoryMgr_h */
  
  /*__Editor_settings____
  
  	Local Variables:
  	tab-width: 4
  	End:
  	vi: ts=4 sw=4
  	vim: si
  _____________________*/
--- 127,236 ----
  	/* sizeofStruct must be inited to sizeof( PGPNewMemoryMgrStruct ) */
  	PGPUInt32		sizeofStruct;
  	PGPFlags		reservedFlags;
  	
  	PGPMemoryMgrAllocationProc		allocProc;
  	PGPMemoryMgrReallocationProc	reallocProc;
  	PGPMemoryMgrDeallocationProc	deallocProc;
  	
  	PGPMemoryMgrSecureAllocationProc		secureAllocProc;
  	void *									reserved;	/* MUST be zeroed */
  	PGPMemoryMgrSecureDeallocationProc		secureDeallocProc;
  	
  	PGPUserValue					customValue;
  	void *							pad[ 8 ];	/* MUST be zeroed */
  } PGPNewMemoryMgrStruct;
  
  PGP_BEGIN_C_DECLARATIONS
  #if PRAGMA_IMPORT_SUPPORTED
  #pragma import on
  #endif
  
  
  /*____________________________________________________________________________
  	Memory Mgr routines
  ____________________________________________________________________________*/
! PGPBoolean	PGPAPI PGPMemoryMgrIsValid( PGPMemoryMgrRef mgr );
  #define PGPValidateMemoryMgr( mgr )	\
  		PGPValidateParam( PGPMemoryMgrIsValid( mgr ) )
  
! PGPError	PGPAPI PGPNewMemoryMgr( PGPFlags reserved,
  				PGPMemoryMgrRef *newMemoryMgr );
  
! PGPError	PGPAPI PGPNewMemoryMgrCustom( PGPNewMemoryMgrStruct const * custom,
  				PGPMemoryMgrRef *newMemoryMgr );
  
! PGPError	PGPAPI PGPFreeMemoryMgr( PGPMemoryMgrRef mgr );
  
! PGPError	PGPAPI PGPGetMemoryMgrCustomValue( PGPMemoryMgrRef mgr,
  					PGPUserValue *customValue );
! PGPError	PGPAPI PGPSetMemoryMgrCustomValue( PGPMemoryMgrRef mgr,
  				PGPUserValue customValue );
  
  /* allocate a block of the specified size */
! void *  	PGPAPI PGPNewData( PGPMemoryMgrRef mgr,
  				PGPSize requestSize, PGPMemoryMgrFlags flags );
  				
  /* allocate a block of the specified size in non-pageable memory */
  /* *isSecure is TRUE if the block definitely can't be paged */
! void *  	PGPAPI PGPNewSecureData( PGPMemoryMgrRef mgr,
  				PGPSize requestSize, PGPMemoryMgrFlags flags );
  
  /* properly reallocs secure or non-secure blocks */
  /* WARNING: the block may move, even if its size is being reduced */
! PGPError  	PGPAPI PGPReallocData( PGPMemoryMgrRef mgr,
  					void **allocation, PGPSize newAllocationSize,
  					PGPMemoryMgrFlags flags );
  					
  /* properly frees secure or non-secure blocks */
! PGPError 	PGPAPI PGPFreeData( void *allocation );
  
  
  /*____________________________________________________________________________
  	Block Info:
  		kPGPMemoryMgrBlockInfo_Valid		it's a valid block
  		kPGPMemoryMgrBlockInfo_Secure		block is a secure allocation
  		kPGPMemoryMgrBlockInfo_NonPageable	block cannot be paged by VM
  		
  	Secure blocks are always wiped before being disposed,
  	but may or may not be pageable, depending on the OS facilities.  Some
  	OSs may not provide the ability to make blocks non-pageable.
  	
  	You should check these flags if the information matters to you.
  ____________________________________________________________________________*/
  #define kPGPMemoryMgrBlockInfo_Valid		( ((PGPFlags)1) << 0 )
  #define kPGPMemoryMgrBlockInfo_Secure		( ((PGPFlags)1) << 1 )
  #define kPGPMemoryMgrBlockInfo_NonPageable	( ((PGPFlags)1) << 2 )
! 
! PGPFlags	PGPAPI PGPGetMemoryMgrDataInfo( void *allocation );
  
  
  /*____________________________________________________________________________
  	Default memory manager routines:
  ____________________________________________________________________________*/
  
! PGPMemoryMgrRef	PGPAPI PGPGetDefaultMemoryMgr(void);
! PGPError		PGPAPI PGPSetDefaultMemoryMgr(PGPMemoryMgrRef memoryMgr);
  
  
  #if PRAGMA_IMPORT_SUPPORTED
  #pragma import reset
  #endif
  PGP_END_C_DECLARATIONS
  
  
  
  #if PRAGMA_ALIGN_SUPPORTED
  #pragma options align=reset
  #endif
  
  
  #endif /* ] Included_pgpMemoryMgr_h */
  
  /*__Editor_settings____
  
  	Local Variables:
  	tab-width: 4
  	End:
  	vi: ts=4 sw=4
  	vim: si
  _____________________*/
