/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM /work/mozilla/mozilla/rdf/chrome/public/nsIChromeRegistry.idl
 */

#ifndef __gen_nsIChromeRegistry_h__
#define __gen_nsIChromeRegistry_h__


#ifndef __gen_nsISupports_h__
#include "nsISupports.h"
#endif

#ifndef __gen_nsIURL_h__
#include "nsIURL.h"
#endif

#ifndef __gen_nsISimpleEnumerator_h__
#include "nsISimpleEnumerator.h"
#endif

#ifndef __gen_nsISupportsArray_h__
#include "nsISupportsArray.h"
#endif

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif
class nsIDocShell; /* forward declaration */


/* starting interface:    nsIChromeRegistry */
#define NS_ICHROMEREGISTRY_IID_STR "d8c7d8a1-e84c-11d2-bf87-00105a1b0627"

#define NS_ICHROMEREGISTRY_IID \
  {0xd8c7d8a1, 0xe84c, 0x11d2, \
    { 0xbf, 0x87, 0x00, 0x10, 0x5a, 0x1b, 0x06, 0x27 }}

class NS_NO_VTABLE nsIChromeRegistry : public nsISupports {
 public: 

  NS_DEFINE_STATIC_IID_ACCESSOR(NS_ICHROMEREGISTRY_IID)

  enum { NONE = 0 };

  enum { PARTIAL = 1 };

  enum { FULL = 2 };

  /**
   * Convert a chrome URL into a canonical representation; specifically,
   *
   *   chrome://package/provider/file
   *
   * Chrome URLs are allowed to be specified in "shorthand", leaving the
   * "file" portion off. In that case, the URL is expanded to:
   *
   *   chrome://package/provider/package.ext
   *
   * where "ext" is:
   *
   *   "xul" for a "content" package,
   *   "css" for a "skin" package, and
   *   "dtd" for a "locale" package.
   *
   * @param aChromeURL the URL that is to be canonified.
   */
  /* void canonify (in nsIURI aChromeURL); */
  NS_IMETHOD Canonify(nsIURI *aChromeURL) = 0;

  /**
   * Convert a chrome URL to a "real" using the information in the registry.
   * Does not modify aChromeURL.
   *
   * @param aChromeURL the URL that is to be converted.
   */
  /* string convertChromeURL (in nsIURI aChromeURL); */
  NS_IMETHOD ConvertChromeURL(nsIURI *aChromeURL, char **_retval) = 0;

  /* nsISimpleEnumerator getOverlays (in nsIURI aChromeURL); */
  NS_IMETHOD GetOverlays(nsIURI *aChromeURL, nsISimpleEnumerator **_retval) = 0;

  /* nsISupportsArray getStyleSheets (in nsIURI aChromeURL); */
  NS_IMETHOD GetStyleSheets(nsIURI *aChromeURL, nsISupportsArray **_retval) = 0;

  /* void reloadChrome (); */
  NS_IMETHOD ReloadChrome(void) = 0;

  /* void refreshSkins (); */
  NS_IMETHOD RefreshSkins(void) = 0;

  /* void selectSkin (in wstring skinName, in boolean useProfile); */
  NS_IMETHOD SelectSkin(const PRUnichar *skinName, PRBool useProfile) = 0;

  /* void selectLocale (in wstring localeName, in boolean useProfile); */
  NS_IMETHOD SelectLocale(const PRUnichar *localeName, PRBool useProfile) = 0;

  /* void deselectSkin (in wstring skinName, in boolean useProfile); */
  NS_IMETHOD DeselectSkin(const PRUnichar *skinName, PRBool useProfile) = 0;

  /* void deselectLocale (in wstring localeName, in boolean useProfile); */
  NS_IMETHOD DeselectLocale(const PRUnichar *localeName, PRBool useProfile) = 0;

  /* PRInt32 isSkinSelected (in wstring skinName, in boolean useProfile); */
  NS_IMETHOD IsSkinSelected(const PRUnichar *skinName, PRBool useProfile, PRInt32 *_retval) = 0;

  /* PRInt32 isLocaleSelected (in wstring localeName, in boolean useProfile); */
  NS_IMETHOD IsLocaleSelected(const PRUnichar *localeName, PRBool useProfile, PRInt32 *_retval) = 0;

  /* void selectSkinForPackage (in wstring skinName, in wstring packageName, in boolean useProfile); */
  NS_IMETHOD SelectSkinForPackage(const PRUnichar *skinName, const PRUnichar *packageName, PRBool useProfile) = 0;

  /* void selectLocaleForPackage (in wstring localeName, in wstring packageName, in boolean useProfile); */
  NS_IMETHOD SelectLocaleForPackage(const PRUnichar *localeName, const PRUnichar *packageName, PRBool useProfile) = 0;

  /* void deselectSkinForPackage (in wstring skinName, in wstring packageName, in boolean useProfile); */
  NS_IMETHOD DeselectSkinForPackage(const PRUnichar *skinName, const PRUnichar *packageName, PRBool useProfile) = 0;

  /* void deselectLocaleForPackage (in wstring localeName, in wstring packageName, in boolean useProfile); */
  NS_IMETHOD DeselectLocaleForPackage(const PRUnichar *localeName, const PRUnichar *packageName, PRBool useProfile) = 0;

  /* boolean isSkinSelectedForPackage (in wstring skinName, in wstring packageName, in boolean useProfile); */
  NS_IMETHOD IsSkinSelectedForPackage(const PRUnichar *skinName, const PRUnichar *packageName, PRBool useProfile, PRBool *_retval) = 0;

  /* boolean isLocaleSelectedForPackage (in wstring localeName, in wstring packageName, in boolean useProfile); */
  NS_IMETHOD IsLocaleSelectedForPackage(const PRUnichar *localeName, const PRUnichar *packageName, PRBool useProfile, PRBool *_retval) = 0;

  /* void selectLocaleForProfile (in wstring localeName, in wstring profilePath); */
  NS_IMETHOD SelectLocaleForProfile(const PRUnichar *localeName, const PRUnichar *profilePath) = 0;

  /* wstring getSelectedLocale (in wstring packageName); */
  NS_IMETHOD GetSelectedLocale(const PRUnichar *packageName, PRUnichar **_retval) = 0;

  /* void setRuntimeProvider (in boolean runtimeProvider); */
  NS_IMETHOD SetRuntimeProvider(PRBool runtimeProvider) = 0;

  /* void installSkin (in string baseURL, in boolean useProfile, in boolean allowScripts); */
  NS_IMETHOD InstallSkin(const char *baseURL, PRBool useProfile, PRBool allowScripts) = 0;

  /* void uninstallSkin (in wstring skinName, in boolean useProfile); */
  NS_IMETHOD UninstallSkin(const PRUnichar *skinName, PRBool useProfile) = 0;

  /* void installLocale (in string baseURL, in boolean useProfile); */
  NS_IMETHOD InstallLocale(const char *baseURL, PRBool useProfile) = 0;

  /* void uninstallLocale (in wstring localeName, in boolean useProfile); */
  NS_IMETHOD UninstallLocale(const PRUnichar *localeName, PRBool useProfile) = 0;

  /* void installPackage (in string baseURL, in boolean useProfile); */
  NS_IMETHOD InstallPackage(const char *baseURL, PRBool useProfile) = 0;

  /* void uninstallPackage (in wstring packageName, in boolean useProfile); */
  NS_IMETHOD UninstallPackage(const PRUnichar *packageName, PRBool useProfile) = 0;

  /* void getAgentSheets (in nsIDocShell docShell, out nsISupportsArray styleSheets); */
  NS_IMETHOD GetAgentSheets(nsIDocShell *docShell, nsISupportsArray **styleSheets) = 0;

  /* void getUserSheets (in boolean useChromeSheets, out nsISupportsArray styleSheets); */
  NS_IMETHOD GetUserSheets(PRBool useChromeSheets, nsISupportsArray **styleSheets) = 0;

  /* boolean allowScriptsForSkin (in nsIURI url); */
  NS_IMETHOD AllowScriptsForSkin(nsIURI *url, PRBool *_retval) = 0;

  /* void checkForNewChrome (); */
  NS_IMETHOD CheckForNewChrome(void) = 0;

  /* boolean checkThemeVersion (in wstring skinName); */
  NS_IMETHOD CheckThemeVersion(const PRUnichar *skinName, PRBool *_retval) = 0;

  /* boolean checkLocaleVersion (in wstring localeName); */
  NS_IMETHOD CheckLocaleVersion(const PRUnichar *localeName, PRBool *_retval) = 0;

};

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSICHROMEREGISTRY \
  NS_IMETHOD Canonify(nsIURI *aChromeURL); \
  NS_IMETHOD ConvertChromeURL(nsIURI *aChromeURL, char **_retval); \
  NS_IMETHOD GetOverlays(nsIURI *aChromeURL, nsISimpleEnumerator **_retval); \
  NS_IMETHOD GetStyleSheets(nsIURI *aChromeURL, nsISupportsArray **_retval); \
  NS_IMETHOD ReloadChrome(void); \
  NS_IMETHOD RefreshSkins(void); \
  NS_IMETHOD SelectSkin(const PRUnichar *skinName, PRBool useProfile); \
  NS_IMETHOD SelectLocale(const PRUnichar *localeName, PRBool useProfile); \
  NS_IMETHOD DeselectSkin(const PRUnichar *skinName, PRBool useProfile); \
  NS_IMETHOD DeselectLocale(const PRUnichar *localeName, PRBool useProfile); \
  NS_IMETHOD IsSkinSelected(const PRUnichar *skinName, PRBool useProfile, PRInt32 *_retval); \
  NS_IMETHOD IsLocaleSelected(const PRUnichar *localeName, PRBool useProfile, PRInt32 *_retval); \
  NS_IMETHOD SelectSkinForPackage(const PRUnichar *skinName, const PRUnichar *packageName, PRBool useProfile); \
  NS_IMETHOD SelectLocaleForPackage(const PRUnichar *localeName, const PRUnichar *packageName, PRBool useProfile); \
  NS_IMETHOD DeselectSkinForPackage(const PRUnichar *skinName, const PRUnichar *packageName, PRBool useProfile); \
  NS_IMETHOD DeselectLocaleForPackage(const PRUnichar *localeName, const PRUnichar *packageName, PRBool useProfile); \
  NS_IMETHOD IsSkinSelectedForPackage(const PRUnichar *skinName, const PRUnichar *packageName, PRBool useProfile, PRBool *_retval); \
  NS_IMETHOD IsLocaleSelectedForPackage(const PRUnichar *localeName, const PRUnichar *packageName, PRBool useProfile, PRBool *_retval); \
  NS_IMETHOD SelectLocaleForProfile(const PRUnichar *localeName, const PRUnichar *profilePath); \
  NS_IMETHOD GetSelectedLocale(const PRUnichar *packageName, PRUnichar **_retval); \
  NS_IMETHOD SetRuntimeProvider(PRBool runtimeProvider); \
  NS_IMETHOD InstallSkin(const char *baseURL, PRBool useProfile, PRBool allowScripts); \
  NS_IMETHOD UninstallSkin(const PRUnichar *skinName, PRBool useProfile); \
  NS_IMETHOD InstallLocale(const char *baseURL, PRBool useProfile); \
  NS_IMETHOD UninstallLocale(const PRUnichar *localeName, PRBool useProfile); \
  NS_IMETHOD InstallPackage(const char *baseURL, PRBool useProfile); \
  NS_IMETHOD UninstallPackage(const PRUnichar *packageName, PRBool useProfile); \
  NS_IMETHOD GetAgentSheets(nsIDocShell *docShell, nsISupportsArray **styleSheets); \
  NS_IMETHOD GetUserSheets(PRBool useChromeSheets, nsISupportsArray **styleSheets); \
  NS_IMETHOD AllowScriptsForSkin(nsIURI *url, PRBool *_retval); \
  NS_IMETHOD CheckForNewChrome(void); \
  NS_IMETHOD CheckThemeVersion(const PRUnichar *skinName, PRBool *_retval); \
  NS_IMETHOD CheckLocaleVersion(const PRUnichar *localeName, PRBool *_retval); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSICHROMEREGISTRY(_to) \
  NS_IMETHOD Canonify(nsIURI *aChromeURL) { return _to Canonify(aChromeURL); } \
  NS_IMETHOD ConvertChromeURL(nsIURI *aChromeURL, char **_retval) { return _to ConvertChromeURL(aChromeURL, _retval); } \
  NS_IMETHOD GetOverlays(nsIURI *aChromeURL, nsISimpleEnumerator **_retval) { return _to GetOverlays(aChromeURL, _retval); } \
  NS_IMETHOD GetStyleSheets(nsIURI *aChromeURL, nsISupportsArray **_retval) { return _to GetStyleSheets(aChromeURL, _retval); } \
  NS_IMETHOD ReloadChrome(void) { return _to ReloadChrome(); } \
  NS_IMETHOD RefreshSkins(void) { return _to RefreshSkins(); } \
  NS_IMETHOD SelectSkin(const PRUnichar *skinName, PRBool useProfile) { return _to SelectSkin(skinName, useProfile); } \
  NS_IMETHOD SelectLocale(const PRUnichar *localeName, PRBool useProfile) { return _to SelectLocale(localeName, useProfile); } \
  NS_IMETHOD DeselectSkin(const PRUnichar *skinName, PRBool useProfile) { return _to DeselectSkin(skinName, useProfile); } \
  NS_IMETHOD DeselectLocale(const PRUnichar *localeName, PRBool useProfile) { return _to DeselectLocale(localeName, useProfile); } \
  NS_IMETHOD IsSkinSelected(const PRUnichar *skinName, PRBool useProfile, PRInt32 *_retval) { return _to IsSkinSelected(skinName, useProfile, _retval); } \
  NS_IMETHOD IsLocaleSelected(const PRUnichar *localeName, PRBool useProfile, PRInt32 *_retval) { return _to IsLocaleSelected(localeName, useProfile, _retval); } \
  NS_IMETHOD SelectSkinForPackage(const PRUnichar *skinName, const PRUnichar *packageName, PRBool useProfile) { return _to SelectSkinForPackage(skinName, packageName, useProfile); } \
  NS_IMETHOD SelectLocaleForPackage(const PRUnichar *localeName, const PRUnichar *packageName, PRBool useProfile) { return _to SelectLocaleForPackage(localeName, packageName, useProfile); } \
  NS_IMETHOD DeselectSkinForPackage(const PRUnichar *skinName, const PRUnichar *packageName, PRBool useProfile) { return _to DeselectSkinForPackage(skinName, packageName, useProfile); } \
  NS_IMETHOD DeselectLocaleForPackage(const PRUnichar *localeName, const PRUnichar *packageName, PRBool useProfile) { return _to DeselectLocaleForPackage(localeName, packageName, useProfile); } \
  NS_IMETHOD IsSkinSelectedForPackage(const PRUnichar *skinName, const PRUnichar *packageName, PRBool useProfile, PRBool *_retval) { return _to IsSkinSelectedForPackage(skinName, packageName, useProfile, _retval); } \
  NS_IMETHOD IsLocaleSelectedForPackage(const PRUnichar *localeName, const PRUnichar *packageName, PRBool useProfile, PRBool *_retval) { return _to IsLocaleSelectedForPackage(localeName, packageName, useProfile, _retval); } \
  NS_IMETHOD SelectLocaleForProfile(const PRUnichar *localeName, const PRUnichar *profilePath) { return _to SelectLocaleForProfile(localeName, profilePath); } \
  NS_IMETHOD GetSelectedLocale(const PRUnichar *packageName, PRUnichar **_retval) { return _to GetSelectedLocale(packageName, _retval); } \
  NS_IMETHOD SetRuntimeProvider(PRBool runtimeProvider) { return _to SetRuntimeProvider(runtimeProvider); } \
  NS_IMETHOD InstallSkin(const char *baseURL, PRBool useProfile, PRBool allowScripts) { return _to InstallSkin(baseURL, useProfile, allowScripts); } \
  NS_IMETHOD UninstallSkin(const PRUnichar *skinName, PRBool useProfile) { return _to UninstallSkin(skinName, useProfile); } \
  NS_IMETHOD InstallLocale(const char *baseURL, PRBool useProfile) { return _to InstallLocale(baseURL, useProfile); } \
  NS_IMETHOD UninstallLocale(const PRUnichar *localeName, PRBool useProfile) { return _to UninstallLocale(localeName, useProfile); } \
  NS_IMETHOD InstallPackage(const char *baseURL, PRBool useProfile) { return _to InstallPackage(baseURL, useProfile); } \
  NS_IMETHOD UninstallPackage(const PRUnichar *packageName, PRBool useProfile) { return _to UninstallPackage(packageName, useProfile); } \
  NS_IMETHOD GetAgentSheets(nsIDocShell *docShell, nsISupportsArray **styleSheets) { return _to GetAgentSheets(docShell, styleSheets); } \
  NS_IMETHOD GetUserSheets(PRBool useChromeSheets, nsISupportsArray **styleSheets) { return _to GetUserSheets(useChromeSheets, styleSheets); } \
  NS_IMETHOD AllowScriptsForSkin(nsIURI *url, PRBool *_retval) { return _to AllowScriptsForSkin(url, _retval); } \
  NS_IMETHOD CheckForNewChrome(void) { return _to CheckForNewChrome(); } \
  NS_IMETHOD CheckThemeVersion(const PRUnichar *skinName, PRBool *_retval) { return _to CheckThemeVersion(skinName, _retval); } \
  NS_IMETHOD CheckLocaleVersion(const PRUnichar *localeName, PRBool *_retval) { return _to CheckLocaleVersion(localeName, _retval); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSICHROMEREGISTRY(_to) \
  NS_IMETHOD Canonify(nsIURI *aChromeURL) { return !_to ? NS_ERROR_NULL_POINTER : _to->Canonify(aChromeURL); } \
  NS_IMETHOD ConvertChromeURL(nsIURI *aChromeURL, char **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->ConvertChromeURL(aChromeURL, _retval); } \
  NS_IMETHOD GetOverlays(nsIURI *aChromeURL, nsISimpleEnumerator **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetOverlays(aChromeURL, _retval); } \
  NS_IMETHOD GetStyleSheets(nsIURI *aChromeURL, nsISupportsArray **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetStyleSheets(aChromeURL, _retval); } \
  NS_IMETHOD ReloadChrome(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->ReloadChrome(); } \
  NS_IMETHOD RefreshSkins(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->RefreshSkins(); } \
  NS_IMETHOD SelectSkin(const PRUnichar *skinName, PRBool useProfile) { return !_to ? NS_ERROR_NULL_POINTER : _to->SelectSkin(skinName, useProfile); } \
  NS_IMETHOD SelectLocale(const PRUnichar *localeName, PRBool useProfile) { return !_to ? NS_ERROR_NULL_POINTER : _to->SelectLocale(localeName, useProfile); } \
  NS_IMETHOD DeselectSkin(const PRUnichar *skinName, PRBool useProfile) { return !_to ? NS_ERROR_NULL_POINTER : _to->DeselectSkin(skinName, useProfile); } \
  NS_IMETHOD DeselectLocale(const PRUnichar *localeName, PRBool useProfile) { return !_to ? NS_ERROR_NULL_POINTER : _to->DeselectLocale(localeName, useProfile); } \
  NS_IMETHOD IsSkinSelected(const PRUnichar *skinName, PRBool useProfile, PRInt32 *_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->IsSkinSelected(skinName, useProfile, _retval); } \
  NS_IMETHOD IsLocaleSelected(const PRUnichar *localeName, PRBool useProfile, PRInt32 *_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->IsLocaleSelected(localeName, useProfile, _retval); } \
  NS_IMETHOD SelectSkinForPackage(const PRUnichar *skinName, const PRUnichar *packageName, PRBool useProfile) { return !_to ? NS_ERROR_NULL_POINTER : _to->SelectSkinForPackage(skinName, packageName, useProfile); } \
  NS_IMETHOD SelectLocaleForPackage(const PRUnichar *localeName, const PRUnichar *packageName, PRBool useProfile) { return !_to ? NS_ERROR_NULL_POINTER : _to->SelectLocaleForPackage(localeName, packageName, useProfile); } \
  NS_IMETHOD DeselectSkinForPackage(const PRUnichar *skinName, const PRUnichar *packageName, PRBool useProfile) { return !_to ? NS_ERROR_NULL_POINTER : _to->DeselectSkinForPackage(skinName, packageName, useProfile); } \
  NS_IMETHOD DeselectLocaleForPackage(const PRUnichar *localeName, const PRUnichar *packageName, PRBool useProfile) { return !_to ? NS_ERROR_NULL_POINTER : _to->DeselectLocaleForPackage(localeName, packageName, useProfile); } \
  NS_IMETHOD IsSkinSelectedForPackage(const PRUnichar *skinName, const PRUnichar *packageName, PRBool useProfile, PRBool *_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->IsSkinSelectedForPackage(skinName, packageName, useProfile, _retval); } \
  NS_IMETHOD IsLocaleSelectedForPackage(const PRUnichar *localeName, const PRUnichar *packageName, PRBool useProfile, PRBool *_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->IsLocaleSelectedForPackage(localeName, packageName, useProfile, _retval); } \
  NS_IMETHOD SelectLocaleForProfile(const PRUnichar *localeName, const PRUnichar *profilePath) { return !_to ? NS_ERROR_NULL_POINTER : _to->SelectLocaleForProfile(localeName, profilePath); } \
  NS_IMETHOD GetSelectedLocale(const PRUnichar *packageName, PRUnichar **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetSelectedLocale(packageName, _retval); } \
  NS_IMETHOD SetRuntimeProvider(PRBool runtimeProvider) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetRuntimeProvider(runtimeProvider); } \
  NS_IMETHOD InstallSkin(const char *baseURL, PRBool useProfile, PRBool allowScripts) { return !_to ? NS_ERROR_NULL_POINTER : _to->InstallSkin(baseURL, useProfile, allowScripts); } \
  NS_IMETHOD UninstallSkin(const PRUnichar *skinName, PRBool useProfile) { return !_to ? NS_ERROR_NULL_POINTER : _to->UninstallSkin(skinName, useProfile); } \
  NS_IMETHOD InstallLocale(const char *baseURL, PRBool useProfile) { return !_to ? NS_ERROR_NULL_POINTER : _to->InstallLocale(baseURL, useProfile); } \
  NS_IMETHOD UninstallLocale(const PRUnichar *localeName, PRBool useProfile) { return !_to ? NS_ERROR_NULL_POINTER : _to->UninstallLocale(localeName, useProfile); } \
  NS_IMETHOD InstallPackage(const char *baseURL, PRBool useProfile) { return !_to ? NS_ERROR_NULL_POINTER : _to->InstallPackage(baseURL, useProfile); } \
  NS_IMETHOD UninstallPackage(const PRUnichar *packageName, PRBool useProfile) { return !_to ? NS_ERROR_NULL_POINTER : _to->UninstallPackage(packageName, useProfile); } \
  NS_IMETHOD GetAgentSheets(nsIDocShell *docShell, nsISupportsArray **styleSheets) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetAgentSheets(docShell, styleSheets); } \
  NS_IMETHOD GetUserSheets(PRBool useChromeSheets, nsISupportsArray **styleSheets) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetUserSheets(useChromeSheets, styleSheets); } \
  NS_IMETHOD AllowScriptsForSkin(nsIURI *url, PRBool *_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->AllowScriptsForSkin(url, _retval); } \
  NS_IMETHOD CheckForNewChrome(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->CheckForNewChrome(); } \
  NS_IMETHOD CheckThemeVersion(const PRUnichar *skinName, PRBool *_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->CheckThemeVersion(skinName, _retval); } \
  NS_IMETHOD CheckLocaleVersion(const PRUnichar *localeName, PRBool *_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->CheckLocaleVersion(localeName, _retval); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsChromeRegistry : public nsIChromeRegistry
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSICHROMEREGISTRY

  nsChromeRegistry();
  virtual ~nsChromeRegistry();
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsChromeRegistry, nsIChromeRegistry)

nsChromeRegistry::nsChromeRegistry()
{
  NS_INIT_ISUPPORTS();
  /* member initializers and constructor code */
}

nsChromeRegistry::~nsChromeRegistry()
{
  /* destructor code */
}

/* void canonify (in nsIURI aChromeURL); */
NS_IMETHODIMP nsChromeRegistry::Canonify(nsIURI *aChromeURL)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* string convertChromeURL (in nsIURI aChromeURL); */
NS_IMETHODIMP nsChromeRegistry::ConvertChromeURL(nsIURI *aChromeURL, char **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsISimpleEnumerator getOverlays (in nsIURI aChromeURL); */
NS_IMETHODIMP nsChromeRegistry::GetOverlays(nsIURI *aChromeURL, nsISimpleEnumerator **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsISupportsArray getStyleSheets (in nsIURI aChromeURL); */
NS_IMETHODIMP nsChromeRegistry::GetStyleSheets(nsIURI *aChromeURL, nsISupportsArray **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void reloadChrome (); */
NS_IMETHODIMP nsChromeRegistry::ReloadChrome()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void refreshSkins (); */
NS_IMETHODIMP nsChromeRegistry::RefreshSkins()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void selectSkin (in wstring skinName, in boolean useProfile); */
NS_IMETHODIMP nsChromeRegistry::SelectSkin(const PRUnichar *skinName, PRBool useProfile)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void selectLocale (in wstring localeName, in boolean useProfile); */
NS_IMETHODIMP nsChromeRegistry::SelectLocale(const PRUnichar *localeName, PRBool useProfile)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void deselectSkin (in wstring skinName, in boolean useProfile); */
NS_IMETHODIMP nsChromeRegistry::DeselectSkin(const PRUnichar *skinName, PRBool useProfile)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void deselectLocale (in wstring localeName, in boolean useProfile); */
NS_IMETHODIMP nsChromeRegistry::DeselectLocale(const PRUnichar *localeName, PRBool useProfile)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* PRInt32 isSkinSelected (in wstring skinName, in boolean useProfile); */
NS_IMETHODIMP nsChromeRegistry::IsSkinSelected(const PRUnichar *skinName, PRBool useProfile, PRInt32 *_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* PRInt32 isLocaleSelected (in wstring localeName, in boolean useProfile); */
NS_IMETHODIMP nsChromeRegistry::IsLocaleSelected(const PRUnichar *localeName, PRBool useProfile, PRInt32 *_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void selectSkinForPackage (in wstring skinName, in wstring packageName, in boolean useProfile); */
NS_IMETHODIMP nsChromeRegistry::SelectSkinForPackage(const PRUnichar *skinName, const PRUnichar *packageName, PRBool useProfile)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void selectLocaleForPackage (in wstring localeName, in wstring packageName, in boolean useProfile); */
NS_IMETHODIMP nsChromeRegistry::SelectLocaleForPackage(const PRUnichar *localeName, const PRUnichar *packageName, PRBool useProfile)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void deselectSkinForPackage (in wstring skinName, in wstring packageName, in boolean useProfile); */
NS_IMETHODIMP nsChromeRegistry::DeselectSkinForPackage(const PRUnichar *skinName, const PRUnichar *packageName, PRBool useProfile)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void deselectLocaleForPackage (in wstring localeName, in wstring packageName, in boolean useProfile); */
NS_IMETHODIMP nsChromeRegistry::DeselectLocaleForPackage(const PRUnichar *localeName, const PRUnichar *packageName, PRBool useProfile)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* boolean isSkinSelectedForPackage (in wstring skinName, in wstring packageName, in boolean useProfile); */
NS_IMETHODIMP nsChromeRegistry::IsSkinSelectedForPackage(const PRUnichar *skinName, const PRUnichar *packageName, PRBool useProfile, PRBool *_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* boolean isLocaleSelectedForPackage (in wstring localeName, in wstring packageName, in boolean useProfile); */
NS_IMETHODIMP nsChromeRegistry::IsLocaleSelectedForPackage(const PRUnichar *localeName, const PRUnichar *packageName, PRBool useProfile, PRBool *_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void selectLocaleForProfile (in wstring localeName, in wstring profilePath); */
NS_IMETHODIMP nsChromeRegistry::SelectLocaleForProfile(const PRUnichar *localeName, const PRUnichar *profilePath)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* wstring getSelectedLocale (in wstring packageName); */
NS_IMETHODIMP nsChromeRegistry::GetSelectedLocale(const PRUnichar *packageName, PRUnichar **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void setRuntimeProvider (in boolean runtimeProvider); */
NS_IMETHODIMP nsChromeRegistry::SetRuntimeProvider(PRBool runtimeProvider)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void installSkin (in string baseURL, in boolean useProfile, in boolean allowScripts); */
NS_IMETHODIMP nsChromeRegistry::InstallSkin(const char *baseURL, PRBool useProfile, PRBool allowScripts)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void uninstallSkin (in wstring skinName, in boolean useProfile); */
NS_IMETHODIMP nsChromeRegistry::UninstallSkin(const PRUnichar *skinName, PRBool useProfile)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void installLocale (in string baseURL, in boolean useProfile); */
NS_IMETHODIMP nsChromeRegistry::InstallLocale(const char *baseURL, PRBool useProfile)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void uninstallLocale (in wstring localeName, in boolean useProfile); */
NS_IMETHODIMP nsChromeRegistry::UninstallLocale(const PRUnichar *localeName, PRBool useProfile)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void installPackage (in string baseURL, in boolean useProfile); */
NS_IMETHODIMP nsChromeRegistry::InstallPackage(const char *baseURL, PRBool useProfile)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void uninstallPackage (in wstring packageName, in boolean useProfile); */
NS_IMETHODIMP nsChromeRegistry::UninstallPackage(const PRUnichar *packageName, PRBool useProfile)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void getAgentSheets (in nsIDocShell docShell, out nsISupportsArray styleSheets); */
NS_IMETHODIMP nsChromeRegistry::GetAgentSheets(nsIDocShell *docShell, nsISupportsArray **styleSheets)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void getUserSheets (in boolean useChromeSheets, out nsISupportsArray styleSheets); */
NS_IMETHODIMP nsChromeRegistry::GetUserSheets(PRBool useChromeSheets, nsISupportsArray **styleSheets)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* boolean allowScriptsForSkin (in nsIURI url); */
NS_IMETHODIMP nsChromeRegistry::AllowScriptsForSkin(nsIURI *url, PRBool *_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void checkForNewChrome (); */
NS_IMETHODIMP nsChromeRegistry::CheckForNewChrome()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* boolean checkThemeVersion (in wstring skinName); */
NS_IMETHODIMP nsChromeRegistry::CheckThemeVersion(const PRUnichar *skinName, PRBool *_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* boolean checkLocaleVersion (in wstring localeName); */
NS_IMETHODIMP nsChromeRegistry::CheckLocaleVersion(const PRUnichar *localeName, PRBool *_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif

// for component registration
// {D8C7D8A2-E84C-11d2-BF87-00105A1B0627}
#define NS_CHROMEREGISTRY_CID \
{ 0xd8c7d8a2, 0xe84c, 0x11d2, { 0xbf, 0x87, 0x0, 0x10, 0x5a, 0x1b, 0x6, 0x27 } }

#endif /* __gen_nsIChromeRegistry_h__ */
