/*************************************************************************
 *
 *  $RCSfile: cntbase.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: kso $ $Date: 2001/01/31 15:51:59 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _CNTBASE_HXX
#define _CNTBASE_HXX 1

#ifndef _ERRCODE_HXX //autogen
#include <tools/errcode.hxx>
#endif
#ifndef _LIST_HXX //autogen
#include <tools/list.hxx>
#endif
#ifndef _REF_HXX //autogen
#include <tools/ref.hxx>
#endif
#ifndef _STRING_HXX //autogen
#include <tools/string.hxx>
#endif
#ifndef _URLOBJ_HXX //autogen
#include <tools/urlobj.hxx>
#endif
#ifndef _SFXLSTNER_HXX //autogen
#include <svtools/lstner.hxx>
#endif
#ifndef _SFXBRDCST_HXX //autogen
#include <svtools/brdcst.hxx>
#endif
#ifndef _SFXITEMSET_HXX //autogen
#include <svtools/itemset.hxx>
#endif
#ifndef _SFXITEMPOOL_HXX //autogen
#include <svtools/itempool.hxx>
#endif
#ifndef _INETTYPE_HXX //autogen
#include <svtools/inettype.hxx>
#endif

#ifndef _CNTIDS_HRC
#include <cntids.hrc>
#endif

class LoginErrorInfo;
class SfxCancellable;

namespace chaos {

#define CASE_SENSITIVE_USERNAMES

//========================================================================
// Macros for accessing item values.

// This macro obtains an item value from an item.
#define ITEM_VALUE( _type_, _item_ ) \
  ( ( (const _type_&)(_item_) ).GetValue() )

// This macro obtains an item value from 'this' itemset.
#define THIS_ITEM_VALUE( _type_, _whichid_ ) \
  ( ITEM_VALUE( _type_, ( SfxItemSet::Get( (_whichid_) ) ) ) )

// This macro obtains an item value from an itemset.
#define ITEMSET_VALUE( _pitemset_, _type_, _whichid_ ) \
  ( ITEM_VALUE( _type_, ( (_pitemset_)->SfxItemSet::Get( (_whichid_) ) ) ) )

// This macro obtains WID_OWN_URL value from an itemset.
#define OWN_URL( _pitemset_ ) \
  ( ITEMSET_VALUE( (_pitemset_), CntStringItem, WID_OWN_URL ) )

// This macro obtains WID_REFERED_URL value from an itemset.
#define REFERED_URL( _pitemset_ ) \
  ( ITEMSET_VALUE( (_pitemset_), CntStringItem, WID_REFERED_URL ) )

//=========================================================================

// A CntAction is contained in each CntAnchorHint.
enum CntAction {
	CNT_ACTION_INSERTED,		// a new child-node/anchor was inserted
	CNT_ACTION_REMOVED,			// the node/anchor is to be removed from a
								// parent
	CNT_ACTION_DELETED,			// a node was physically destroyed
	CNT_ACTION_MODIFIED,		// some properties of node/anchor have changed
	CNT_ACTION_EXCHANGED,   	// the (refered) node must be exchanged
	CNT_ACTION_RESULT,			// this node is a result from a query request
	CNT_ACTION_NODE_SET, 		// the refered node was initially set
	CNT_ACTION_KILL_ALL,		// kill all your children!
	CNT_ACTION_KILL_FOLDERS,	// kill all your folder-children!
	CNT_ACTION_KILL_MESSAGES, 	// kill all your message-children!
	CNT_ACTION_FILENAME_CHANGED,// a file was renamed ( own URL changed )
	CNT_ACTION_STOP_UPDATING,	// UpdateMode auf FALSE setzen
	CNT_ACTION_BEGIN_UPDATING,	// UpdateMode auf TRUE setzen
	CNT_ACTION_INSERTED_IN_MULTIPLE, // insert node in multiple anchors
	CNT_ACTION_REMOVED_FROM_MULTIPLE, // remove node from multiple anchors
	CNT_ACTION_CREATED, 		// A new node/anchor was created
								// --> ( WID_CREATE_NEW )
	CNT_ACTION_REMOVING_LAST, 	// the last child will be removed now
	CNT_ACTION_REMOVING,	 	// the child will be removed now
	CNT_ACTION_EXPANDING,	 	// the first level of the anchor has been expanded
								// other level might follow
	CNT_ACTION_SHOW_SELECTION,	// make the selected anchor visible
	CNT_ACTION_FINISHED,		// finished open, all children should be inserted
	CNT_ACTION_END
};

// Seen Status
#define CNT_SEENSTATUS_COUNT 3
enum CntSeenStatus {
	CNT_NONE_SEEN,
	CNT_SOME_SEEN,
	CNT_ALL_SEEN
};

// Connection Modes
#define CNT_CONNMODE_COUNT 3
enum CntConnMode {
	CNT_CONN_MODE_ONLINE,
	CNT_CONN_MODE_OFFLINE,
	CNT_CONN_MODE_OFFLINE_TRANSACTED
};

// Object creation flags.
// ( Contained in WID_CREATE_NEW items only as WID_CREATION_FLAGS )
#define CNT_CREATION_FLAG_STANDARD				0x0001
#define CNT_CREATION_FLAG_TITLE         		0x0002
#define CNT_CREATION_FLAG_MESSAGEDOC    		0x0004
#define CNT_CREATION_FLAG_SENDMESSAGE   		0x0008
#define CNT_CREATION_FLAG_PROT_HANDLER  		0x0010
#define CNT_CREATION_FLAG_PROPERTIES    		0x0020
#define CNT_CREATION_FLAG_HIDDEN    			0x0040
#define CNT_CREATION_FLAG_COMPONENT    			0x0080
#define CNT_CREATION_FLAG_ONE_INSTANCE  		0x0100
#define CNT_CREATION_FLAG_INSERT_WITH_STREAM  	0x0200
#define CNT_CREATION_FLAG_KIND_DOCUMENT	  		0x0400
#define CNT_CREATION_FLAG_KIND_FOLDER  			0x0800
#define CNT_CREATION_FLAG_KIND_LINK  			0x1000

#ifndef STG_FILE_EXTENSION
// Extension for view storage files.
#define STG_FILE_EXTENSION 				"scc"
#endif

// Item flags.
#define CNT_ITEM_MULTISELECTION SFX_ITEM_USERFLAG0	// enables item for multiselection
#define CNT_ITEM_SYNCHRON		SFX_ITEM_USERFLAG1	// forces synchronous execution
#define CNT_ITEM_AUTO_INHERIT	SFX_ITEM_USERFLAG2	// autom. inherited data
#define CNT_ITEM_HIDDEN			SFX_ITEM_USERFLAG3	// hidden flag (i.e. for UI)
#define CNT_ITEM_AUTO_VIEWPROP  SFX_ITEM_USERFLAG4	// autom. saved view data
#define CNT_ITEM_AUTO_USERPROP  SFX_ITEM_USERFLAG5	// autom. saved user data
#define CNT_ITEM_AUTO_OWNPROP   SFX_ITEM_USERFLAG6	// autom. saved own data
#define CNT_ITEM_AUTO_GARBLE  	SFX_ITEM_USERFLAG7	// autom. en-/decoding
#define CNT_ITEM_RULES_RELEVANT SFX_ITEM_USERFLAG8  // item used for rules tabp.
#define CNT_ITEM_UI_CANCELABLE	SFX_ITEM_USERFLAG9  // item is cancelable from UI ( Stop Button )

// The bits in WID_FSYS_FLAGS (which, in fact, is rather WID_FLAGS):
#define CNT_FLAG_LINK               0x00000001
#define CNT_FLAG_FSYS_USERREAD      0x00000002
#define CNT_FLAG_FSYS_USERWRITE     0x00000004
#define CNT_FLAG_FSYS_USEREXECUTE   0x00000008
#define CNT_FLAG_FSYS_GROUPREAD     0x00000010
#define CNT_FLAG_FSYS_GROUPWRITE    0x00000020
#define CNT_FLAG_FSYS_GROUPEXECUTE  0x00000040
#define CNT_FLAG_FSYS_OTHERSREAD    0x00000080
#define CNT_FLAG_FSYS_OTHERSWRITE   0x00000100
#define CNT_FLAG_FSYS_OTHERSEXECUTE 0x00000200
#define CNT_FLAG_FSYS_STICKY        0x00000400
#define CNT_FLAG_FSYS_SUID          0x00000800
#define CNT_FLAG_FSYS_SGID          0x00001000
#define CNT_FLAG_FSYS_HIDDEN        0x00002000
#define CNT_FLAG_FSYS_ARCHIVE       0x00004000
#define CNT_FLAG_FSYS_SYSTEM        0x00008000
#define CNT_FLAG_FSYS_COMPRESSED    0x00010000
#define CNT_FLAG_FSYS_COPYABLE      0x00020000
#define CNT_FLAG_FSYS_MOVABLE       0x00040000
#define CNT_FLAG_FSYS_LINKABLE      0x00080000
#define CNT_FLAG_FSYS_DISCARDABLE   0x00100000
#define CNT_FLAG_FSYS_RENAMABLE     0x00200000
#define CNT_FLAG_FSYS_EXISTS        0x00400000
#define CNT_FLAG_FSYS_REMOTE        0x00800000
#define CNT_FLAG_FSYS_TEMPLATE		0x01000000
#define CNT_FLAG_FSYS_NOFILTERS		0x02000000
#define CNT_FLAG_TEMPLATE			CNT_FLAG_FSYS_TEMPLATE
#define CNT_FLAG_NOFILTERS			CNT_FLAG_FSYS_NOFILTERS

// email notification modes
#define CNT_ENOTIFY_USE_OUTTRAY_ADDRESS		0x0001
#define CNT_ENOTIFY_USE_OWN_ADDRESS			0x0002
#define CNT_ENOTIFY_AS_TEXT	  				0x0004
#define CNT_ENOTIFY_AS_HTML					0x0008
#define CNT_ENOTIFY_SEE_ERROR				0x0010

// states for WID_GETMODE
#define CNT_GETMODE_CHECK_ONLY				0
#define CNT_GETMODE_MARKED					1
#define CNT_GETMODE_SPECIFY	   				2

//========================================================================

class CntAnchor;
SV_DECL_REF( CntAnchor )

class CntNode;
SV_DECL_REF( CntNode )

//========================================================================

// Prefix for own, non-official, URL schemes, to use when converting
// URL's to the official "vendor scheme".
// ( i.e. private:trashcan: <-> vnd.sun.staroffice.trashcan )
#define INET_VENDOR_SCHEME_PREFIX "vnd.sun.staroffice."

//========================================================================

// This function converts a given URL to a CHAOS-conform one.
BOOL NormalizeURL( String& rURL );

// Message send/receive protocols supported by CHAOS.
enum CntMsgProtocolType
{
	CNT_MSG_PROTOCOL_IMAP,
	CNT_MSG_PROTOCOL_MAPI,
	CNT_MSG_PROTOCOL_MBOX,
	CNT_MSG_PROTOCOL_NNTP,
	CNT_MSG_PROTOCOL_POP3,
	CNT_MSG_PROTOCOL_SMTP,
	CNT_MSG_PROTOCOL_VIM
};

// Check a protocol-specific value for conformance.
ErrCode CheckProtSpecValue( CntMsgProtocolType eProtocol,
                            USHORT nWhich,
						    const String & rValue );
ErrCode CheckProtSpecValue( INetProtocol eProtocol,
                            USHORT nWhich,
						    const String & rValue );

//========================================================================
// Function for backward compatible string decryption:
ByteString CntStringDecode(bool bNew, ByteString const & rSource);

//========================================================================

class CntInterface: public SvRefBase, public SfxItemSet,
					public SfxListener, public SfxBroadcaster
{
protected:
	virtual	~CntInterface();
	virtual void Changed( const SfxPoolItem& rOld, const SfxPoolItem& rNew );

public:
	TYPEINFO();

	CntInterface();
	CntInterface( const USHORT *pRanges );

	virtual FASTBOOL IsItemFlag( USHORT nWID, USHORT nFlag ) const;

	// SfxListener.
	virtual void 	 Notify( SfxBroadcaster& rBC, const SfxHint& rHint );

	// SfxItemSet.
    virtual const SfxPoolItem*
    				Put( const SfxPoolItem& rProp, USHORT nWhich )
					{ return SfxItemSet::Put( rProp, nWhich );}
    const SfxPoolItem*
    				Put( const SfxPoolItem& rProp )
					{ return SfxItemSet::Put( rProp ); }
	virtual int		Put( const SfxItemSet&, BOOL bInvalidAsDefault = TRUE );

	virtual void   DisableItem( USHORT nWhich );
	virtual USHORT ClearItem  ( USHORT nWhich = 0 );
};

SV_DECL_IMPL_REF( CntInterface );

//========================================================================

enum CntStatus
{
	CNT_STATUS_STARTED = 0,
	CNT_STATUS_DONE,
	CNT_STATUS_ERROR
};

// Definitions:
// "Action started"				= CNT_STATUS_STARTED + ERRCODE_NONE
// "Action successfully ended"	= CNT_STATUS_DONE  	 + ERRCODE_NONE
// "Action canceled" 			= CNT_STATUS_ERROR   + ERRCODE_ABORT
// "Error during processing"	= CNT_STATUS_ERROR   + aError

class CntStatusHint : public SfxHint
{
private:
	SfxCancellable*		_pCancelable;
	const SfxPoolItem*	_pRequest;
	ErrCode				_aError;
	CntStatus			_eStatus;

	// forbidden and not implemented.
	CntStatusHint( const CntStatusHint& );
	// forbidden and not implemented.
    CntStatusHint& operator=( const CntStatusHint& );

public:
	TYPEINFO();

	CntStatusHint( SfxCancellable *pJob, const SfxPoolItem* pRequest,
				   CntStatus eStatus, ErrCode aError = ERRCODE_NONE )
	: _pCancelable( pJob ), _pRequest( pRequest ), _aError( aError ),
	  _eStatus( eStatus ) {}

	SfxCancellable*	   GetCancelable() const { return _pCancelable; }
	const SfxPoolItem* GetRequest() const    { return _pRequest; }
	const CntStatus	   GetStatus() const	 { return _eStatus; }
	const ErrCode	   GetError() const 	 { return _aError; }
};

//========================================================================

enum CntItemStateAction
{
	CNT_ITEM_CLEARED  =	0,
	CNT_ITEM_DISABLED
};

class CntItemStateChangedHint : public SfxHint
{
private:
	CntItemStateAction  m_nAction;
	USHORT 				m_nWhich;

public:
	TYPEINFO();

	CntItemStateChangedHint( USHORT nWhich, CntItemStateAction nAction )
	: m_nWhich( nWhich ), m_nAction( nAction ) {}

	USHORT GetWhich() const { return m_nWhich; }
	CntItemStateAction GetAction() const { return m_nAction; }
};

//========================================================================

enum CntStatusBarAction
{
	CNT_STATUSBARACTION_PROGRESS_START = 0,
	CNT_STATUSBARACTION_PROGRESS_END,
	CNT_STATUSBARACTION_PROGRESS_SET,
	CNT_STATUSBARACTION_SHOW_STATUS_TEXT
};

class CntStatusBarHint : public SfxHint
{
private:
	String				_aProgressText;
	ULONG				_nProgressMin;
	ULONG				_nProgressMax;
	ULONG				_nProgressCur;
	CntStatusBarAction 	_eAction;
	USHORT			   	_nHintId;

	CntStatusBarHint( const CntStatusBarHint& ); // n.i.
    CntStatusBarHint& operator=( const CntStatusBarHint& ); // n.i.

public:
	TYPEINFO();

	// Die HintId sorgt dafuer, dass nur derjenige einen ProgressBar
	// hochzaehlen und beenden kann, der ihn gestartet hat. Eine eindeutige
	// Id kann per CntStatusBarHint::CreateHintId() generiert werden
	CntStatusBarHint( USHORT nHintId, ULONG nMin, ULONG nMax,
					  const String& rStatText )
	: _nProgressMin( nMin ), _nProgressMax( nMax ),
	  _eAction( CNT_STATUSBARACTION_PROGRESS_START ),
	  _aProgressText( rStatText ), _nHintId( nHintId ) {}

	CntStatusBarHint( USHORT nHintId, ULONG nCur )
	: _nProgressCur( nCur ), _eAction( CNT_STATUSBARACTION_PROGRESS_SET ),
	  _nHintId( nHintId ) {}

	CntStatusBarHint( USHORT nHintId,
			  CntStatusBarAction eAction = CNT_STATUSBARACTION_PROGRESS_END )
	: _eAction( eAction ), _nHintId( nHintId ) {}

	CntStatusBarHint( const String& rText )
	: _eAction( CNT_STATUSBARACTION_SHOW_STATUS_TEXT ),
	  _aProgressText( rText ) {}

	ULONG				GetProgressMin() const { return _nProgressMin; }
	ULONG				GetProgressMax() const { return _nProgressMax; }
	ULONG				GetProgressCur() const { return _nProgressCur; }
	const String&		GetProgressText() const { return _aProgressText; }
	const String&		GetStatusText() const { return _aProgressText; }
	CntStatusBarAction  GetAction() const { return _eAction; }
	USHORT				GetHintId() const { return _nHintId; }
	static USHORT		CreateHintId();
};

//========================================================================

#define CNT_RESET_NEWMESSAGES 			( (ULONG)0 )
#define CNT_RESET_NEWMESSAGES_RECURSIVE ( (ULONG)-1 )

struct CntUpdateResult
{
	String  aTargetURL;
	String	aTitle;
	ULONG	nNewMessages;

	CntUpdateResult()
	: nNewMessages( 0 )	{}

	CntUpdateResult( const CntUpdateResult &rOrig )
	: nNewMessages( rOrig.nNewMessages ),
	  aTargetURL( rOrig.aTargetURL ),
	  aTitle( rOrig.aTitle ) {}
};

class CntUpdateHint : public SfxHint
{
private:
	CntUpdateResult* _pResult;

	CntUpdateHint( const CntUpdateHint& ); // n.i.
    CntUpdateHint& operator=( const CntUpdateHint& ); // n.i.

public:
	TYPEINFO();

	CntUpdateHint( CntUpdateResult* pResult )
	: _pResult( pResult ) {}

	const CntUpdateResult& GetResult() const { return *_pResult; }
};

//=========================================================================

struct CntViewEntry
{
	String aViewURL;
	String aContentType;

	CntViewEntry( const String& rViewURL,
				  const String& rContentType )
	: aViewURL( rViewURL ),
	  aContentType( rContentType )
	{
	}
};

DECLARE_LIST( CntViewList, CntViewEntry* )

//========================================================================

DECLARE_LIST( CntExplorerList, String* )

//========================================================================

class CntFolderStateHint : public SfxHint
{
private:
	ULONG  _nCount;
	USHORT _nKind;

	CntFolderStateHint  (const CntFolderStateHint&); // n.i.
	CntFolderStateHint& operator=(const CntFolderStateHint&); // n.i.

public:
	TYPEINFO();

	CntFolderStateHint(ULONG nCount, USHORT nKind)
	: _nCount(nCount), _nKind(nKind) {}

	ULONG  GetCount() const { return _nCount; }
	USHORT GetKind()  const { return _nKind;  }
};

//========================================================================

class CntTransferHint : public SfxHint
{
private:
	String _sTargetURL;
	String _sSourceURL;

	CntTransferHint  (const CntTransferHint&); // n.i.
	CntTransferHint& operator=(const CntTransferHint&); // n.i.

public:
	TYPEINFO();

	CntTransferHint(const String &rSourceURL, const String &rTargetURL)
	: _sSourceURL(rSourceURL), _sTargetURL(rTargetURL) {}

	const String& GetSourceURL(void) const { return _sSourceURL; }
	const String& GetTargetURL(void) const { return _sTargetURL; }
};

//=========================================================================

struct CntErrorData
{
	ErrCode 	  		_nError;
	const SfxPoolItem*	_pRequest;
	SfxCancellable*		_pCancelable;
	const String* 		_pErrorStr;
	void*         		_pData;

	CntErrorData( ErrCode nError,
				  const SfxPoolItem* pRequest,
				  SfxCancellable* pCancelable,
				  const String* pErrorStr,
				  void* pData )
	: _nError( nError ),
	  _pRequest( pRequest ),
	  _pCancelable( pCancelable ),
	  _pErrorStr( pErrorStr ),
	  _pData( pData )
	{}
};

//============================================================================

class CntLoginErrorData
{
	CntNode * m_pTarget;
	LoginErrorInfo & m_rInfo;

public:
	CntLoginErrorData(CntNode * pTheTarget, LoginErrorInfo & rTheInfo):
		m_pTarget(pTheTarget), m_rInfo(rTheInfo) {}

	CntNode * getTarget() const { return m_pTarget; }

	LoginErrorInfo & getInfo() const { return m_rInfo; }
};

//=========================================================================

// Type-ID's. ( Obsolete, but used outside CHAOS! )
#define CNT_TYPE_MESSAGE	CONTENT_TYPE_X_CNT_MESSAGE

}


#endif /* !_CNTBASE_HXX */
