/*************************************************************************
 *
 *  $RCSfile: addrconv.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/25 16:02:55 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#endif
#ifndef _COM_SUN_STAR_DATA_XDATABASE_HPP_
#include <com/sun/star/data/XDatabase.hpp>
#endif
#ifndef _COM_SUN_STAR_DATA_XDATABASEENGINE_HPP_
#include <com/sun/star/data/XDatabaseEngine.hpp>
#endif
#ifndef _COM_SUN_STAR_DATA_XDATABASETABLE_HPP_
#include <com/sun/star/data/XDatabaseTable.hpp>
#endif
#ifndef _COM_SUN_STAR_DATA_XDATABASEWORKSPACE_HPP_
#include <com/sun/star/data/XDatabaseWorkspace.hpp>
#endif
#ifndef _COM_SUN_STAR_DATA_XDATABASECONNECTION_HPP_
#include <com/sun/star/data/XDatabaseConnection.hpp>
#endif
#ifndef _COM_SUN_STAR_DATA_XDATABASEFIELDSSUPPLIER_HPP_
#include <com/sun/star/data/XDatabaseFieldsSupplier.hpp>
#endif
#ifndef _COM_SUN_STAR_DATA_XDATABASECONNECTION_HPP_
#include <com/sun/star/data/XDatabaseRecordSupplier.hpp>
#endif
#ifndef _COM_SUN_STAR_DATA_XDATABASEFIELDDESCRIPTORFACTORY_HPP_
#include <com/sun/star/data/XDatabaseFieldDescriptorFactory.hpp>
#endif
#ifndef _COM_SUN_STAR_DATA_XDATABASENAMECONTAINER_HPP_
#include <com/sun/star/data/XDatabaseNameContainer.hpp>
#endif
#ifndef _COM_SUN_STAR_DATA_XDATABASEUPDATE_HPP_
#include <com/sun/star/data/XDatabaseUpdate.hpp>
#endif
#ifndef _COM_SUN_STAR_DATA_DATABASEFIELDTYPE_HPP_
#include <com/sun/star/data/DatabaseFieldType.hpp>
#endif
#ifndef _COM_SUN_STAR_CONTAINER_XNAMED_HPP_
#include <com/sun/star/container/XNamed.hpp>
#endif

#ifndef _USR_USTRING_HXX
#include <usr/ustring.hxx>
#endif
#ifndef _FSYS_HXX
#include <tools/fsys.hxx>
#endif
#ifndef _XCEPTION_HXX_
#include <vos/xception.hxx>
#endif
#ifndef _SV_CONFIG_HXX
#include <vcl/config.hxx>
#endif
#ifndef _USR_SMARTSERVICES_HXX_
#include <usr/smartservices.hxx>
#endif
#ifndef _TOOLS_DEBUG_HXX
#include <tools/debug.hxx>
#endif
#ifndef _SFXINIPROP_HXX
#include <svtools/iniprop.hxx>
#endif
#ifndef _SFXINIMGR_HXX
#include <svtools/iniman.hxx>
#endif
#include "addrconv.hxx"

#ifdef UNX
#define ADRBKMAP_INI	"addrconvrc"
#else
#define ADRBKMAP_INI	"addrconv.ini"
#endif

// namespaces
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::lang;
using namespace ::com::sun::star::beans;
using namespace ::com::sun::star::data;
using namespace ::com::sun::star::container;
using namespace ::rtl;


SV_IMPL_OBJARR( AddrBookNameMappingList, AddrBookNameMapping );


BOOL AddressBookConverter::BuildNameMapping()
{
	BOOL  bReturn = TRUE;
	XubString		aAddressBookConfigFilePath;
	const XubString aAddressBookConfigFile( ADRBKMAP_INI );
	const XubString aAddressBookConvertGroup( "AddressBookConvert" );

	// initialize mappings with logical, standard database name and the field type, size definition
	USHORT i = 0;
	_aNameMappings.Insert( AddrBookNameMapping( "Company", "COMPANY", DatabaseFieldType::VARCHAR, 50 ), i++ );
	_aNameMappings.Insert( AddrBookNameMapping( "Department", "DEPARTMENT", DatabaseFieldType::VARCHAR, 50 ), i++ );
	_aNameMappings.Insert( AddrBookNameMapping( "FirstName", "FIRSTNAME", DatabaseFieldType::VARCHAR, 50 ), i++ );
	_aNameMappings.Insert( AddrBookNameMapping( "LastName", "LASTNAME", DatabaseFieldType::VARCHAR, 50 ), i++ );
	_aNameMappings.Insert( AddrBookNameMapping( "Street", "ADDRESS", DatabaseFieldType::VARCHAR, 50 ), i++ );
	_aNameMappings.Insert( AddrBookNameMapping( "State", "STATEPROV", DatabaseFieldType::VARCHAR, 50 ), i++ );
	_aNameMappings.Insert( AddrBookNameMapping( "Country", "COUNTRY", DatabaseFieldType::VARCHAR, 50 ), i++ );
	_aNameMappings.Insert( AddrBookNameMapping( "Zip", "POSTALCODE", DatabaseFieldType::VARCHAR, 15  ), i++ );
	_aNameMappings.Insert( AddrBookNameMapping( "City", "CITY", DatabaseFieldType::VARCHAR, 50 ), i++ );
	_aNameMappings.Insert( AddrBookNameMapping( "Title", "TITLE", DatabaseFieldType::VARCHAR, 50 ), i++ );
	_aNameMappings.Insert( AddrBookNameMapping( "Position", "POSITION", DatabaseFieldType::VARCHAR, 100 ), i++ );
	_aNameMappings.Insert( AddrBookNameMapping( "AddrForm", "PREFIX", DatabaseFieldType::VARCHAR, 25 ), i++ );
	_aNameMappings.Insert( AddrBookNameMapping( "Code", "INITIALS", DatabaseFieldType::VARCHAR, 10  ), i++ );
	_aNameMappings.Insert( AddrBookNameMapping( "AddrFormMail", "SALUTATION", DatabaseFieldType::VARCHAR, 50 ), i++ );
	_aNameMappings.Insert( AddrBookNameMapping( "PhonePriv", "PHONEHOME", DatabaseFieldType::VARCHAR, 25 ), i++ );
	_aNameMappings.Insert( AddrBookNameMapping( "PhoneComp", "PHONEWORK", DatabaseFieldType::VARCHAR, 25 ), i++ );
	_aNameMappings.Insert( AddrBookNameMapping( "PhoneOffice", "PHONEOFFI",DatabaseFieldType::VARCHAR, 25 ), i++ );
	_aNameMappings.Insert( AddrBookNameMapping( "Fax", "FAX", DatabaseFieldType::VARCHAR, 25 ), i++ );
	_aNameMappings.Insert( AddrBookNameMapping( "Pager", "PAGER", DatabaseFieldType::VARCHAR, 25 ), i++ );
	_aNameMappings.Insert( AddrBookNameMapping( "PhoneCell", "MOBILE", DatabaseFieldType::VARCHAR, 25 ), i++ );
	_aNameMappings.Insert( AddrBookNameMapping( "PhoneOther", "PHONEOTHE", DatabaseFieldType::VARCHAR, 25 ), i++ );
	_aNameMappings.Insert( AddrBookNameMapping( "EMail", "EMAIL", DatabaseFieldType::VARCHAR, 50 ), i++ );
	_aNameMappings.Insert( AddrBookNameMapping( "URL", "URL", DatabaseFieldType::VARCHAR, 128 ), i++ );
	_aNameMappings.Insert( AddrBookNameMapping( "Note", "NOTE", DatabaseFieldType::LONGVARCHAR, 200 ), i++ );
	_aNameMappings.Insert( AddrBookNameMapping( "Altfield1", "ALTFIELD1", DatabaseFieldType::VARCHAR, 100 ), i++ );
	_aNameMappings.Insert( AddrBookNameMapping( "Altfield2", "ALTFIELD2", DatabaseFieldType::VARCHAR, 100 ), i++ );
	_aNameMappings.Insert( AddrBookNameMapping( "Altfield3", "ALTFIELD3", DatabaseFieldType::VARCHAR, 100  ), i++ );
	_aNameMappings.Insert( AddrBookNameMapping( "Altfield4", "ALTFIELD4", DatabaseFieldType::VARCHAR, 100  ), i++ );
	_aNameMappings.Insert( AddrBookNameMapping( "Id", "ID", DatabaseFieldType::VARCHAR, 20 ), i++ );
	_aNameMappings.Insert( AddrBookNameMapping( "CalendarURL", "CALENDAR", DatabaseFieldType::VARCHAR, 100 ), i++ );
	_aNameMappings.Insert( AddrBookNameMapping( "InviteParticipant", "INVITE", DatabaseFieldType::BOOL, 1 ), i++ );

	SfxAppIniManagerProperty aProp;
	GetpApp()->Property( aProp );
	if ( aProp.GetIniManager() )
	{
		aAddressBookConfigFilePath = aProp.GetIniManager()->Get( SFX_KEY_DATABASE_PATH );
		aAddressBookConfigFilePath += "/";
		aAddressBookConfigFilePath += aAddressBookConfigFile;
	}

	Config aAddressBookConfig( aAddressBookConfigFilePath );
	aAddressBookConfig.SetGroup( aAddressBookConvertGroup );

	UString aAddressFields = StringToOUString(
				aAddressBookConfig.ReadKey( 
					"LogicColumnToLangColumn" ), CHARSET_SYSTEM );
	
	if ( aAddressFields.getLength() )
	{
		UString aField, aLogicName;
		for ( USHORT nPos = aAddressFields.getTokenCount( ';' ); nPos--; )
		{
			aField			= aAddressFields.getToken( nPos, ';' );
			aLogicName		= aField.getToken( 0, ':' );
			for ( i = _aNameMappings.Count(); i--; )
				if (_aNameMappings[i]._aLogicName == aLogicName )
					_aNameMappings[i]._aDBName	= aField.getToken( 1, ':' );
		}
	}
	else
		bReturn = FALSE;

	// remove language mapping file
	DirEntry aConfigFile( aAddressBookConfigFilePath );
	aConfigFile.Kill();
	
	return bReturn;
}

const OUString& AddressBookConverter::GetStdDBFieldNameFromLangName( const OUString& aLangFieldName ) const
{
	static OUString empty;
	
	USHORT i;
	for ( i = _aNameMappings.Count(); i--; )
		if (_aNameMappings[i]._aDBName == aLangFieldName )
			return _aNameMappings[i]._aDBStdName;

	return empty;
}

void AddressBookConverter::MarkDBFieldAsConverted( const OUString& aDBFieldName )
{
	USHORT i;
	for ( i = _aNameMappings.Count(); i--; )
		if (_aNameMappings[i]._aDBStdName == aDBFieldName )
			_aNameMappings[i]._bDBConverted = TRUE;
}

BOOL AddressBookConverter::Convert()
{
	const UString	aAddressBookTableName = OUString::createFromAscii( "address" );
	const UString	aAddressDBFile = OUString::createFromAscii( "address.sdb" );
	const UString	aOldAddressDBFile = OUString::createFromAscii( "_address.sdb" );
	
	UString			aDBAddressBookURL;
	UString			aOldDBAddressBookURL;
	DirEntry		aCWDPath;
	
	SfxAppIniManagerProperty aProp;
	GetpApp()->Property( aProp );
	if ( aProp.GetIniManager() )
	{
		aDBAddressBookURL = OUString::createFromAscii( aProp.GetIniManager()->Get( SFX_KEY_DATABASE_PATH ) );
		aDBAddressBookURL += OUString::createFromAscii( "/" );
		aDBAddressBookURL += aAddressDBFile;

		aOldDBAddressBookURL = OUString::createFromAscii( aProp.GetIniManager()->Get( SFX_KEY_DATABASE_PATH ) );
		aOldDBAddressBookURL += OUString::createFromAscii( "/" );
		aOldDBAddressBookURL += aOldAddressDBFile;
	}

	if ( !BuildNameMapping() )
		return FALSE;

	Reference< XMultiServiceFactory > xMgr = ::usr::getProcessServiceFactory();

	try
	{
		OUString aCharsetString( OUString::createFromAscii( "charset" ) );
		OUString aDeletedString( OUString::createFromAscii( "deleted" ) );
		OUString aNoFilenameString( OUString::createFromAscii( "nofilenamelimit" ) );
			
		Reference< XDatabaseEngine > xEngine(
			xMgr->createInstance( 
				OUString::createFromAscii( "com.sun.star.data.DatabaseEngine" )), UNO_QUERY );
		Reference< XDatabaseWorkspace > xWorkspace( *(Reference< XInterface >*)
			xEngine->getWorkspaces()->getByName( 
				OUString::createFromAscii( "DefaultWorkspace" )).getValue(), UNO_QUERY );
	
		OUString aCharsetValue;
		OUString aDeletedValue;
		OUString aNoFileNameValue;
		
		// try to open old sdb-file and extract some configuration settings!
		{
			try
			{
				Reference< XDatabase > xOldDatabase = xWorkspace->open( aOldDBAddressBookURL );
				Reference< XPropertySet > xPropSet( xOldDatabase, UNO_QUERY );
				Any aPropAny = xPropSet->getPropertyValue(
									OUString::createFromAscii( "ConnectionSettings" ));
				Sequence< PropertyValue > aSeq;
				aPropAny >>= aSeq;
				
				Any		 aPropValue;
				OUString aProperty;
				
				for ( USHORT i = 0; i < aSeq.getLength(); i++ )
				{
					aProperty = aSeq[i].Name;
					if ( aProperty.equalsIgnoreCase( aCharsetString ))
						aSeq[i].Value >>= aCharsetValue;
					else if ( aProperty.equalsIgnoreCase( aDeletedString ))
						aSeq[i].Value >>= aDeletedValue;
					else if ( aProperty.equalsIgnoreCase( aNoFilenameString ))
						aSeq[i].Value >>= aNoFileNameValue;
				}
			}
			catch( RuntimeException e )
			{
			}
			catch( DatabaseException e )
			{
			}
			catch ( UnknownPropertyException e )
			{
			}
			catch ( WrappedTargetException e )
			{
			}
			
			// remove old database file
			DirEntry aOldDBFile( OUStringToString( 
				aOldDBAddressBookURL, CHARSET_SYSTEM ));
			aOldDBFile.Kill();
		}

		Reference<XDatabase> xDatabase = xWorkspace->open( aDBAddressBookURL );
		
		// copy some configuration entries from the old database to the new one!
		{
			BOOL bCharsetSet = FALSE;
			BOOL bDeletedSet = FALSE;
			BOOL bNoFilenameSet = FALSE;
			Reference< XPropertySet > xPropSet( xDatabase, UNO_QUERY );
			Any aPropAny = xPropSet->getPropertyValue(
								OUString::createFromAscii( "ConnectionSettings" ));
			Sequence< PropertyValue > aSeq;
			aPropAny >>= aSeq;
			
			Any		 aPropValue;
			OUString aProperty;
				
			for ( USHORT i = 0; i < aSeq.getLength(); i++ )
			{
				aProperty = aSeq[i].Name;
				if ( aProperty.equalsIgnoreCase( aCharsetString ) &&
					 aCharsetValue.getLength() > 0 )
				{
					aSeq[i].Value <<= aCharsetValue;
					bCharsetSet = TRUE;
				}
				else if ( aProperty.equalsIgnoreCase( aDeletedString ) &&
						  aDeletedValue.getLength() > 0 )
				{
					aSeq[i].Value <<= aDeletedValue;
					bDeletedSet = TRUE;
				}
				else if ( aProperty.equalsIgnoreCase( aNoFilenameString ) &&
						  aNoFileNameValue.getLength() > 0 )
				{
					aSeq[i].Value <<= aNoFileNameValue;
					bNoFilenameSet = TRUE;
				}
			}

			if ( !bCharsetSet && aCharsetValue.getLength() > 0 )
			{
				aPropValue <<= aCharsetValue;
				sal_Int32 index = aSeq.getLength();
				aSeq.realloc( index + 1 );
				aSeq[index].Name = aCharsetString;
				aSeq[index].Value = aPropValue;
			}
			
			if ( !bDeletedSet && aDeletedValue.getLength() > 0 )
			{
				aPropValue <<= aDeletedValue;
				sal_Int32 index = aSeq.getLength();
				aSeq.realloc( index + 1 );
				aSeq[index].Name = aDeletedString;
				aSeq[index].Value = aPropValue;
			}
			
			if ( !bNoFilenameSet && aNoFileNameValue.getLength() > 0 )
			{
				aPropValue <<= aNoFileNameValue;
				sal_Int32 index = aSeq.getLength();
				aSeq.realloc( index + 1 );
				aSeq[index].Name = aNoFilenameString;
				aSeq[index].Value = aPropValue;
			}

			try
			{
				aPropValue <<= aSeq;
				xPropSet->setPropertyValue(
							OUString::createFromAscii( "ConnectionSettings" ),
							aPropValue );
			}
			catch ( UnknownPropertyException e )
			{
			}
			catch ( PropertyVetoException e )
			{
			}
			catch ( IllegalArgumentException e )
			{
			}
			catch ( WrappedTargetException e )
			{
			}
		}

		Reference< XDatabaseConnection > xConnection( xDatabase, UNO_QUERY );
		Reference< XDatabaseTable > xTable( *(Reference< XInterface >*)
								  xConnection->getTables()->getByName( 
									aAddressBookTableName ).getValue(),
								  UNO_QUERY);
		Reference< XDatabaseUpdate > xTableUpdate( xTable, UNO_QUERY );
		Reference< XDatabaseFieldsSupplier > xFieldsSupp( xTable, UNO_QUERY );
		Reference< XNameAccess > xNames = xFieldsSupp->getFields();
		Reference< XDatabaseFieldDescriptorFactory > xFieldsFactory( xNames, UNO_QUERY );
		Reference< XDatabaseNameContainer > xTableFieldContainer( xNames, UNO_QUERY );
		
		Sequence< OUString > aSeq = xNames->getElementNames();
		
		Any aAny;
		OUString aField;
		// convert all fields in the database
		for ( USHORT i = 0; i < aSeq.getLength(); i++ )
		{
			aField = GetStdDBFieldNameFromLangName( aSeq[i] );
			if ( aField.getLength() )
			{
				Reference< XPropertySet > xOldField( *(Reference< XInterface >*)
													xNames->getByName( aSeq[i] ).getValue(), UNO_QUERY );
				Reference< XPropertySet > xNewField = xFieldsFactory->create();
				xNewField = xOldField;
				aAny <<= xNewField;
				xTableFieldContainer->removeByName( aSeq[i] );
				xTableFieldContainer->insertNewByName( aField, aAny );
				MarkDBFieldAsConverted( aField ); // mark field as converted!
			}
			else
			{
				// we have to preserve the order of the fields, so we have to remove and insert the same field!!
				Reference< XPropertySet > xOldField( *(Reference< XInterface >*)
													xNames->getByName( aSeq[i] ).getValue(), UNO_QUERY );
				aAny <<= xOldField;
				xTableFieldContainer->removeByName( aSeq[i] );
				xTableFieldContainer->insertNewByName( aSeq[i], aAny );
			}
		}
		xTableUpdate->update();
	}
	catch( RuntimeException e )
	{
	}
	catch( DatabaseException e )
	{
	}
	catch( NoSupportException e )
	{
	}
	catch( ElementExistException e )
	{
	}
	catch( IllegalArgumentException e )
	{
	}
		
	// insert the missing fields in the database, so we have all fields we need
	BOOL bNewFieldInserted = FALSE;
	
	Reference< XDatabaseEngine > xEngine(
		xMgr->createInstance( 
			OUString::createFromAscii( "com.sun.star.data.DatabaseEngine" )), UNO_QUERY );
	Reference< XDatabaseWorkspace > xWorkspace( 
		*(Reference< XInterface >*)
		xEngine->getWorkspaces()->getByName( 
			OUString::createFromAscii( "DefaultWorkspace" )).getValue(), 
		UNO_QUERY );
	
	Reference< XDatabase > xDatabase = xWorkspace->open( aDBAddressBookURL );
	Reference< XDatabaseConnection > xConnection( xDatabase, UNO_QUERY );
	Reference< XDatabaseTable > xTable( *(Reference< XInterface >*)
							  xConnection->getTables()->getByName( 
								aAddressBookTableName ).getValue(),
							  UNO_QUERY);
	Reference< XDatabaseUpdate > xTableUpdate( xTable, UNO_QUERY );
	Reference< XDatabaseFieldsSupplier > xFieldsSupp( xTable, UNO_QUERY );
	Reference< XNameAccess > xNames = xFieldsSupp->getFields();
	Reference< XDatabaseFieldDescriptorFactory > xFieldsFactory( xNames, UNO_QUERY );
	Reference< XDatabaseNameContainer > xTableFieldContainer( xNames, UNO_QUERY );

	for ( USHORT i = 0; i < _aNameMappings.Count(); i++ )
	{
		if ( _aNameMappings[i]._bDBConverted == FALSE )
		{
			// field is not in the converted database, so we have to insert it!
			try
			{
				Reference<XPropertySet> xNewField( xFieldsFactory->create(), UNO_QUERY );
				if ( xNewField.is() )
				{
					Any a;

					a <<= _aNameMappings[i]._aFieldType;
					xNewField->setPropertyValue( 
						OUString::createFromAscii( "Type" ),
						a );
					a <<= _aNameMappings[i]._aFieldSize;
					xNewField->setPropertyValue(
						OUString::createFromAscii( "Size" ),
						a );

					if ( _aNameMappings[i]._aFieldType == DatabaseFieldType::VARCHAR )
						a <<= OUString::createFromAscii( "" );
					else if ( _aNameMappings[i]._aFieldType == DatabaseFieldType::LONGVARCHAR )
						a <<= OUString::createFromAscii( "" );
					else if ( _aNameMappings[i]._aFieldType == DatabaseFieldType::BOOL )
						a <<= sal_False;
					xNewField->setPropertyValue( 
						OUString::createFromAscii( "DefaultValue" ), a );

					a <<= xNewField;
					xTableFieldContainer->insertNewByName( 
						_aNameMappings[i]._aDBStdName, a );
					bNewFieldInserted = TRUE;
				}
			}				
			catch( RuntimeException e )
			{
			}
			catch( ElementExistException e )
			{
			}
			catch( DatabaseException e )
			{
			}
		}
	}
	
	try
	{
		if ( bNewFieldInserted )
			xTableUpdate->update();
	}
	catch( DatabaseException e )
	{
	}

	return TRUE;
}
