/*************************************************************************
 *
 *  $RCSfile: SimpleBeanBeanInfo.java,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: hr $ $Date: 2003/06/30 15:31:19 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  the BSD license.
 *  
 *  Copyright (c) 2003 by Sun Microsystems, Inc.
 *  All rights reserved.
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *  1. Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 *  2. Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *  3. Neither the name of Sun Microsystems, Inc. nor the names of its
 *     contributors may be used to endorse or promote products derived
 *     from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 *  FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 *  COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 *  BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
 *  OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 *  ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
 *  TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 *  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *     
 *************************************************************************/

import java.beans.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.event.*;
import com.sun.star.beans.*;

/** The BeanInfo class for the bean SimpleBean. */

public class SimpleBeanBeanInfo extends BeanInfoAdapter
{
  /**
   * Public constructor
   */
	public SimpleBeanBeanInfo()
	{
	    addStandardBooleanRWPropertyDescriptor("MenuBarVisible", true, false);

	    addMethodDescriptors("load");
	    addMethodDescriptors("closeConnection");
	    addMethodDescriptors("setOfficeConnection");
	}
  
  /**
   * Returns the Bean Class
   * @return The SimpleBean class
   */
	public Class getBeanClass()
	{
		return SimpleBean.class;
	}

  /**
   * Get the Display name for the Bean
   * @return Returns a string - <code>Simple Bean</code>
   */
	public String getDisplayName()
	{
		return "Simple Bean";
	}
 
  /**
   * Gets an Icon to be displayed
   *
   * @param iconKind The kind of icon to be displayed
   * @return An Image of the icon
   */
	public java.awt.Image getIcon(int iconKind)
	{
		if (iconKind == BeanInfo.ICON_COLOR_16x16) {
			java.awt.Image img = loadImage("OfficeIconColor16.jpg");
			return img;
		}

		if (iconKind == BeanInfo.ICON_COLOR_32x32) {
			java.awt.Image img = loadImage("OfficeIconColor32.jpg");
			return img;
		}

		if (iconKind == BeanInfo.ICON_MONO_16x16) {
			java.awt.Image img = loadImage("OfficeIconMono16.jpg");
			return img;
		}

		if (iconKind == BeanInfo.ICON_MONO_32x32) {
			java.awt.Image img = loadImage("OfficeIconMono32.jpg");
			return img;
		}
		return null;
	}
}
