/*************************************************************************
 *
 *  $RCSfile: scplink.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/27 10:22:20 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#include <stdio.h>

#ifndef _SV_SVAPP_HXX
#include <vcl/svapp.hxx>
#endif

#include "setup2/sistream.hxx"
#include "setup2/script.hxx"
#include "setup2/instdb.hxx"
#include "scplink.hxx"

DECLARE_LIST( SecondLevel, SiAnsiFileStream* )
SecondLevel aSecondLevelList;

DECLARE_LIST( IncludeList, ByteString* )
IncludeList aIncList;

///////////////////////////////////////////////////////////////////////////////

void PrintUsage()
{
	fprintf( stderr, "usage:\n" );
	fprintf( stderr, "\t@<responsefile>\n" );
	fprintf( stderr, "\t-i <includepath,...>\n" );
	fprintf( stderr, "\t-o <outputfile>\n" );
	fprintf( stderr, "\t-w (show warning for unlinked objects)\n" );
	exit( -1 );
}

///////////////////////////////////////////////////////////////////////////////

BOOL CompileParticel( SiAnsiFileStream* pStrm, SiCompiledScript* pCS, BOOL bIgnoreError = FALSE )
{
	SiCompilerRef xCompiler = new SiCompiler( *pStrm, OS::GetType() );
	xCompiler->NoApplication();
	xCompiler->SetIgnoreError( bIgnoreError );

	return xCompiler->SecondLevelCompile(pCS);
}

BOOL CompileParticel( const ByteString& rFilename, SiCompiledScript* pCS )
{
	ByteString aRealFilename;
	for( USHORT xx = 0; xx < aIncList.Count(); ++xx )
	{
		SiDirEntry aEntry( *(aIncList.GetObject(xx)) );
		aEntry += rFilename;

		if( aEntry.Exists() ) {
			aRealFilename = aEntry.GetFull();
			break;
		}
	}

	SiAnsiFileStream* pStrm = new SiAnsiFileStream;
    pStrm->Open( UniString::CreateFromAscii(aRealFilename.GetBuffer()), STREAM_READ );
	if( !pStrm->IsOpen() )
	{
		fprintf( stdout, "error: source '%s' cannot be found.\n", aRealFilename.GetBuffer() );
		delete pStrm;
		return FALSE;
	}
	BOOL bOpenRefs = CompileParticel(pStrm, pCS, TRUE);
	if( bOpenRefs )
	{
		aSecondLevelList.Insert(pStrm);
		return FALSE;
	}

	delete pStrm;
	return TRUE;
}

///////////////////////////////////////////////////////////////////////////////

int __LOADONCALLAPI main( int argv, char** argc )
{
	fprintf( stderr, "\nScript Particel Linker (c) 1999 StarDivision\n" );
	if( argv == 1 )
	{
		PrintUsage();
		return -1;
	}

	ByteString 	aResponseFilename;
	ByteString 	aOutFilename;
	BOOL 		bWarning = FALSE;

	for( USHORT n = 1; n < argv; n++ )
	{
		if( argc[ n ][ 0 ] == '@' )
		{
			aResponseFilename = &(argc[ n ][ 1 ]);
		}
		else
		if( argc[ n ][ 0 ] == '-' )
		{
			switch( argc[ n ][ 1 ] )
			{
				case 'o': aOutFilename = argc[ ++n ]; break;
				case 'w': bWarning = TRUE; break;
				case 'i':
				{
					ByteString aTmp( argc[ ++n ] );
					USHORT nTok = 0;
					USHORT nTokCnt = aTmp.GetTokenCount(',');
					for( USHORT x = 0; x < nTokCnt; ++x )
					{
						ByteString* pInc = new ByteString(aTmp.GetToken(0, ',', nTok));
						pInc->EraseLeadingChars();
						pInc->EraseTrailingChars();
						aIncList.Insert( pInc, LIST_APPEND );
					}
				} break;
			}
		}
	}

	if( !aResponseFilename.Len() )
	{
		fprintf( stdout, "error: no responsefile\n" );
		return -1;
	}

	if( !aIncList.Count() )
	{
		fprintf( stdout, "error: include path specified\n" );
		return -1;
	}

	DirEntry aEntry( aOutFilename );
	aEntry.GetPath().MakeDir();

	SiFileStream aResponseFile;
	aResponseFile.Open(UniString::CreateFromAscii(aResponseFilename.GetBuffer()),
		STREAM_STD_READ);

	if( !aResponseFile.IsOpen() )
	{
		fprintf( stdout, "error: responsefile '%s' cannot be found.\n", aResponseFilename.GetBuffer() );
		return -1;
	}

	// first level
	SiCompiledScript* pCS = new SiCompiledScript;
	pCS->DoBindUnlinkedObjects(FALSE);

	ByteString aLine;
	aResponseFile.ReadLine(aLine);
	if( !aLine.Len() )
		return -1;

	USHORT nDelimTok = 0;
	USHORT nTokCount = aLine.GetTokenCount(',');
	for( USHORT x = 0; x < nTokCount; ++x )
	{
		ByteString aParticle = aLine.GetToken(0, ',', nDelimTok);
		aParticle.EraseLeadingChars();
		aParticle.EraseTrailingChars();
		if( aParticle.Len() )
			CompileParticel(aParticle, pCS);
	}
	aResponseFile.Close();

	// second level
	for( USHORT i = 0; i < aSecondLevelList.Count(); ++i )
	{
		SiAnsiFileStream* pStrm = aSecondLevelList.GetObject(i);
		pStrm->Seek( STREAM_SEEK_TO_BEGIN );
		CompileParticel( pStrm, pCS );
		delete pStrm;
	}
	aSecondLevelList.Clear();

	pCS->DoBindUnlinkedObjects(TRUE, bWarning);
	pCS->SetSecondLevel(TRUE);
	pCS->AddUnlinkedObjectsToRoot();
	pCS->SetSecondLevel(FALSE);

	SiFileStream aOutFile;
	aOutFile.Open( UniString::CreateFromAscii(aOutFilename.GetBuffer()),
		STREAM_STD_WRITE | STREAM_TRUNC );

	SiDatabase aInstDB( aOutFile );
	pCS->SetWriteScpAction(TRUE);
	pCS->SetSecondLevel(TRUE);
	aInstDB.Create( pCS );

	delete pCS;

	for( USHORT xx = 0; xx < aIncList.Count(); ++xx )
		delete aIncList.GetObject(xx);
	aIncList.Clear();

	return 0;
}

