/*************************************************************************
 *
 *  $RCSfile: prvwshll.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: thb $ $Date: 2001/11/28 18:44:18 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SFXDISPATCH_HXX
#include <sfx2/dispatch.hxx>
#endif
#ifndef _SFXREQUEST_HXX
#include <sfx2/request.hxx>
#endif
#ifndef _DRAWDOC_HXX
#include <drawdoc.hxx>
#endif

#include <svtools/moduleoptions.hxx>
#include <svx/svxids.hrc>
#include <sfx2/app.hxx>
#include "sdwindow.hxx"
#include "sdview.hxx"
#include "sdresid.hxx"
#include "grdocsh.hxx"
#include "docshell.hxx"
#include "prvwshll.hxx"
#include "app.hrc"
#include "strings.hrc"
#include "glob.hrc"

#define SdPreviewViewShell
#include "sdslots.hxx"

// -------------------
// - SdPreviewViewShell -
// -------------------

SFX_IMPL_INTERFACE( SdPreviewViewShell, SdDrawViewShell, SdResId( STR_PREVIEWVIEWSHELL ) )
{
}

// -----------------------------------------------------------------------------

SFX_IMPL_VIEWFACTORY( SdPreviewViewShell, SdResId( STR_DEFAULTVIEW ) )
{
    // #94383# Guard against missing modules
	if (SvtModuleOptions().IsImpress())
	{
        SFX_VIEW_REGISTRATION( SdDrawDocShell );
    }

    // #94383# Guard against missing modules
	if (SvtModuleOptions().IsDraw()) 
    {
        SFX_VIEW_REGISTRATION( SdGraphicDocShell );
    }
}

// -----------------------------------------------------------------------------

TYPEINIT1( SdPreviewViewShell, SdDrawViewShell );

// -----------------------------------------------------------------------------

SdPreviewViewShell::SdPreviewViewShell( SfxViewFrame* pFrame, SfxViewShell *pOldShell ) :
    SdDrawViewShell( pFrame, pOldShell )
{
	// disable scrollbars etc.
	ShowUIControls( sal_False );
}

// -----------------------------------------------------------------------------

SdPreviewViewShell::SdPreviewViewShell( SfxViewFrame* pFrame, const SdDrawViewShell& rShell ) :
    SdDrawViewShell( pFrame, rShell )
{
	// disable scrollbars etc.
	ShowUIControls( sal_False );
}

// -----------------------------------------------------------------------------

SdPreviewViewShell::~SdPreviewViewShell()
{
}

// -----------------------------------------------------------------------------

void SdPreviewViewShell::OuterResizePixel(const Point &rPos, const Size &rSize)
{
	// override parent class, forward to AdjustPosSizePixel()
 	AdjustPosSizePixel(rPos, rSize);
}

// -----------------------------------------------------------------------------

void SdPreviewViewShell::InnerResizePixel(	const Point&	rPos, 
											const Size&		rSize	)
{
	// override parent class, forward to AdjustPosSizePixel()
 	AdjustPosSizePixel(rPos, rSize);
}

// -----------------------------------------------------------------------------

void SdPreviewViewShell::AdjustPosSizePixel( const Point&	rNewPos,
											 const Size&	rNewSize	)
{
	// precondition: there's only *one* view window
#ifdef DBG_UTIL
	for (short nX = 1; nX < MAX_HSPLIT_CNT; nX++)
	{
		for (short nY = 0; nY < MAX_VSPLIT_CNT; nY++)
		{
			DBG_ASSERT(pWinArray[nX][nY]==NULL, "Can't handle splitted view!");
		}
	}
#endif

	// prevent border
 	SvBorder aSvBorder;
 	SetBorderPixel(aSvBorder);

	pWindow->UpdateMapOrigin();

	// re-zoom to full page
	SfxRequest aReq(SID_SIZE_PAGE, 0, pDoc->GetItemPool());
	ExecuteSlot( aReq );
}

// -----------------------------------------------------------------------------

BOOL SdPreviewViewShell::KeyInput(const KeyEvent& rKEvt, SdWindow* pWin)
{
	// disable user interaction
	return FALSE;
}

// -----------------------------------------------------------------------------

void SdPreviewViewShell::MouseMove(const MouseEvent& rMEvt, SdWindow* pWin)
{
	// disable user interaction
}

// -----------------------------------------------------------------------------

void SdPreviewViewShell::MouseButtonUp(const MouseEvent& rMEvt, SdWindow* pWin)
{
	// disable user interaction
}

// -----------------------------------------------------------------------------

void SdPreviewViewShell::MouseButtonDown(const MouseEvent& rMEvt, SdWindow* pWin)
{
	// disable user interaction
}

// -----------------------------------------------------------------------------

SvxRuler* SdPreviewViewShell::CreateHRuler(SdWindow* pWin, BOOL bIsFirst)
{
	return NULL;
}

// -----------------------------------------------------------------------------

SvxRuler* SdPreviewViewShell::CreateVRuler(SdWindow* pWin)
{
	return NULL;
}
