/*************************************************************************
 *
 *  $RCSfile: test.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: ka $ $Date: 2000/10/30 10:40:02 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#include <tools/debug.hxx>
#include <vcl/window.hxx>
#include <usr/uno.hxx>
#include <usr/serinfo.hxx>
#include <sfx2/xcollect.hxx>

#include <sd/xienum.hxx>
#include <sd/ximodel.hxx>
#include <sd/xipage.hxx>
#include <sd/xicreate.hxx>
#include <sd/xiobject.hxx>
#include <sd/xifill.hxx>

#ifndef _SV_BUTTON_HXX //autogen
#include <vcl/imagebtn.hxx>
#endif
#ifndef _SV_EDIT_HXX
#include <vcl/edit.hxx>
#endif
#include <vcl/fixed.hxx>

/*-----------------11.12.97 10:25-------------------

--------------------------------------------------*/
class MyWindow : public Window
{
	USHORT 		nIndex;
	FixedText	aFt1;
	Edit		aEdt1;
	Edit		aEdt2;
	Edit		aEdt3;
	Edit		aEdt4;
	PushButton 	aBtn1;
	PushButton 	aBtn2;
	PushButton 	aBtn3;
	PushButton 	aBtn4;

		DECL_LINK(ClickHdl, PushButton*);

public:
			MyWindow( Window *pParent );
};

/*-----------------11.12.97 10:25-------------------

--------------------------------------------------*/
MyWindow::MyWindow( Window *pParent )
				: Window( pParent ),
				aFt1	( this ),
				aEdt1	( this ),
				aEdt2	( this ),
				aEdt3	( this ),
				aEdt4	( this ),
				aBtn1	( this ),
				aBtn2	( this ),
				aBtn3	( this ),
				aBtn4	( this ),
				nIndex	( 0 )
{
	Link aLink( LINK( this, MyWindow, ClickHdl ) );

	aFt1.SetPosSizePixel( 10, 10, 100, 20 );
	aFt1.SetText("Aktuelle Seite");
	aFt1.Show();

	aEdt1.SetPosSizePixel( 110, 10, 50, 20 );
	aEdt1.SetText("1");
	aEdt1.Show();

	aEdt2.SetPosSizePixel( 10, 35, 150, 20 );
	aEdt2.Show();

	aEdt3.SetPosSizePixel( 10, 60, 150, 20 );
	aEdt3.Show();

	aEdt4.SetPosSizePixel( 10, 85, 150, 20 );
	aEdt4.Show();

	aBtn1.SetText("Do it!");
	aBtn1.SetPosSizePixel( 10, 110, 150, 30 );
	aBtn1.SetClickHdl( aLink );
	aBtn1.Show();

	aBtn2.SetText("Insert Page");
	aBtn2.SetPosSizePixel( 10, 150, 150, 30 );
	aBtn2.SetClickHdl( aLink );
	aBtn2.Show();

	aBtn3.SetText("AutoLayout (Edit 2)");
	aBtn3.SetPosSizePixel( 10, 190, 150, 30 );
	aBtn3.SetClickHdl( aLink );
	aBtn3.Show();

	aBtn4.SetText("Seitenname (Edit 2)");
	aBtn4.SetPosSizePixel( 10, 230, 150, 30 );
	aBtn4.SetClickHdl( aLink );
	aBtn4.Show();
}

/*-----------------11.12.97 10:25-------------------

--------------------------------------------------*/
IMPL_LINK( MyWindow, ClickHdl, PushButton*, pBtn )
{
	nIndex++;
	XServiceProviderRef xProv = getGlobalServiceProvider();
	DBG_ASSERT( xProv, "Kein ServiceProvider!" );

	XServiceRegistryRef xReg = XServiceRegistryRef::queryInterface( xProv );
	if ( !xReg )
		return 0;

	UikSequence aIfaces( 1 );
	aIfaces.getArray()[0] = USR_XMODELCOLLECTION_ID;
	XServiceInfoRef xSSI = xProv->getServiceInfo( "stardiv.desktop.ModelCollection", aIfaces, UikSequence() );

	XModelCollectionRef aCollRef = (XModelCollection*) xSSI->newInstance()->queryInterface( USR_XMODELCOLLECTION_ID );
	USHORT nCount = aCollRef->getCount();
	for (  USHORT i = 0; i < nCount; i++ )
	{
		XModelRef aRef = aCollRef->getItemByIndex( i );
		if ( aRef )
		{
			XubString aName = aRef->getClassName();
			XImpressDocument* pImpressDocument = (XImpressDocument*)aRef->queryInterface(USR_SD_IMPRESS_DOCUMENT);
			if( pImpressDocument )
			{
				USHORT nCount = pImpressDocument->getPageCount();
				XubString aStr("Anzahl Seiten: ");
				aStr += String( nCount );
				aEdt4.SetText( aStr );
				if( pBtn != &aBtn2 )
				{
					USHORT nActPage = 0;
					aStr = aEdt1.GetText();
					if( aStr.IsNumeric() )
						nActPage = aStr;
					if( nActPage >= nCount )
						nActPage = nCount;
					if( nActPage > 0 )
						nActPage--;
					XImpressPageRef xImpressPage = pImpressDocument->getPage( nActPage );
					if( xImpressPage )
					{
						if( pBtn == &aBtn3 )
						{
							aStr = aEdt2.GetText();
							if( aStr.IsNumeric() )
							{
								long nTmp = (long)aStr;
								if( nTmp >= 0 && nTmp <= 26 )
									xImpressPage->Layout_setProperty( (AutoLayout)nTmp );
							}
						}
						else if( pBtn == &aBtn4 )
						{
							aStr = aEdt2.GetText();
							xImpressPage->Name_setProperty( aStr );
						}
						else
						{
							XObjectCreation* pObjCreation = (XObjectCreation*)
								xImpressPage->queryInterface( USR_SD_OBJECT_CREATION );

							if( pObjCreation )
							{
								Point aPt( 5000, 5000 );
								Size  aSize( 1000, 1000 );

								for( int i = 0; i <= 10; i++ )
								{
									aPt.Y() += 1000;
									XImpressObjectRef xImpressObject = pObjCreation->createRectangle( aPt, aSize, TRUE, FALSE );
									if( xImpressObject )
									{
										XFillAttributes* pAttr = (XFillAttributes*)
											xImpressObject->queryInterface( USR_FILL_ATTRIBUTES );
										if( pAttr )
											pAttr->Color_setProperty( Color( COL_LIGHTRED ) );
									}
								}
								for( i = 0; i <= 10; i++ )
								{
									aPt.X() += 1000;
									XImpressObjectRef xImpressObject = pObjCreation->createRectangle( aPt, aSize, TRUE, FALSE );
									if( xImpressObject )
									{
										XFillAttributes* pAttr = (XFillAttributes*)
											xImpressObject->queryInterface( USR_FILL_ATTRIBUTES );
										if( pAttr )
											pAttr->Color_setProperty( Color( COL_LIGHTBLUE ) );
									}
								}
								for( i = 0; i <= 10; i++ )
								{
									aPt.Y() -= 1000;
									XImpressObjectRef xImpressObject = pObjCreation->createRectangle( aPt, aSize, TRUE, FALSE );
									if( xImpressObject )
									{
										XFillAttributes* pAttr = (XFillAttributes*)
											xImpressObject->queryInterface( USR_FILL_ATTRIBUTES );
										if( pAttr )
											pAttr->Color_setProperty( Color( COL_LIGHTGREEN ) );
									}
								}
								for( i = 0; i <= 10; i++ )
								{
									aPt.X() -= 1000;
									XImpressObjectRef xImpressObject = pObjCreation->createRectangle( aPt, aSize, TRUE, FALSE );
									if( xImpressObject )
									{
										XFillAttributes* pAttr = (XFillAttributes*)
											xImpressObject->queryInterface( USR_FILL_ATTRIBUTES );
										if( pAttr )
											pAttr->Color_setProperty( Color( COL_YELLOW ) );
									}
								}
								aPt.X() = 8000;
								aPt.Y() = 9000;
								XImpressObjectRef xImpressObject = pObjCreation->createEllipse( aPt, aSize, TRUE );
								if( xImpressObject )
								{
									XFillAttributes* pAttr = (XFillAttributes*)
										xImpressObject->queryInterface( USR_FILL_ATTRIBUTES );
									if( pAttr )
										pAttr->Color_setProperty( Color( COL_BLACK ) );
								}
								aPt.X() = 13000;
								//aPt.Y() = 8000;
								xImpressObject = pObjCreation->createEllipse( aPt, aSize, TRUE );
								if( xImpressObject )
								{
									XFillAttributes* pAttr = (XFillAttributes*)
										xImpressObject->queryInterface( USR_FILL_ATTRIBUTES );
									if( pAttr )
										pAttr->Color_setProperty( Color( COL_BLACK ) );
								}
								aPt.X() = 8000;
								aPt.Y() = 12000;
								aSize.Width() = 6000;
								aSize.Height() = 3000;
								xImpressObject = pObjCreation->createEllipse( aPt, aSize, TRUE );
								if( xImpressObject )
								{
									XFillAttributes* pAttr = (XFillAttributes*)
										xImpressObject->queryInterface( USR_FILL_ATTRIBUTES );
									if( pAttr )
										pAttr->Color_setProperty( Color( COL_WHITE ) );
								}
								//XImpressObjectRef xImpressObject = pObjCreation->createRectangle( aPt, aSize, TRUE, FALSE );
								//if( xImpressObject )
								//	xImpressObject->Position_setProperty( aPt );
							}
						}
					}
				}
				else
					pImpressDocument->insertPage( 0 );
			}
		}
	}
	return 0;
}

/*-----------------11.12.97 10:25-------------------

--------------------------------------------------*/
extern "C" Window* __LOADONCALLAPI CreateWindow( Window *pParent, const String& rParam )
{
	MyWindow *pWin = new MyWindow( pParent );


	return pWin;
}
