/*************************************************************************
 *
 *  $RCSfile: frmhtmlw.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: mib $ $Date: 2001/07/03 07:45:45 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _FRMHTMLW_HXX
#define _FRMHTMLW_HXX

#include "frmdescr.hxx"

#ifndef _STREAM_HXX
#include <tools/stream.hxx>
#endif

#ifndef _PARHTML_HXX
#include <svtools/parhtml.hxx>
#endif
#ifndef _HTMLOUT_HXX
#include <svtools/htmlout.hxx>
#endif
#ifndef _HTMLKYWD_HXX
#include <svtools/htmlkywd.hxx>
#endif

class SfxDocumentInfo;
class SfxFrameSetObjectShell;
class SfxFrame;

class SfxFrameHTMLWriter
{
	static const sal_Char 	sNewLine[];
	ByteString 				aFill;
	SvStream* 				pStrm;		// der Stream
	USHORT					nNestCnt;		// FRAMESET-Schachtungstiefe
	SfxFrameSetObjectShell*	pDoc;

							// den Header ausgeben
	void 					OutHeader( rtl_TextEncoding eDestEnc );
	void 					OutFooter();	// den Footer ausgeben
	void 					OutNestSpace();	// Spaces fuer Schachtelung ausgeben
	void 					Out_FrameSetDescriptor(
		const SfxFrameSetDescriptor *pFSet, BOOL bFlatten,
		SfxFrame* pTopFrame, rtl_TextEncoding eDestEnc,
							String *pNonConvertableChars = 0 );
	SvStream& 				Strm()
							{ return *pStrm; }
	static void 			OutMeta( SvStream& rStrm,
								const sal_Char *pIndent, const String& rName,
								const String& rContent, BOOL bHTTPEquiv,
								rtl_TextEncoding eDestEnc,
							String *pNonConvertableChars = 0 );
	inline static void 		OutMeta( SvStream& rStrm,
								const sal_Char *pIndent, const sal_Char *pName,
								const String& rContent, BOOL bHTTPEquiv,
								rtl_TextEncoding eDestEnc,
							String *pNonConvertableChars = 0 );

public:
	SfxFrameHTMLWriter();
	~SfxFrameHTMLWriter();

	static void Out_DocInfo( SvStream& rStrm, const SfxDocumentInfo* pInfo,
							 const sal_Char *pIndent,
							rtl_TextEncoding eDestEnc = RTL_TEXTENCODING_MS_1252,
							String *pNonConvertableChars = 0 );

	static void Out_FrameDescriptor(
		SvStream&, const SfxFrameDescriptor*,
		BOOL bFlatten = FALSE, SfxFrame* pTopFrame = 0,
		rtl_TextEncoding eDestEnc = RTL_TEXTENCODING_MS_1252,
		String *pNonConvertableChars = 0 );

	ULONG Write( SfxFrameSetObjectShell *pDoc,  SvStream& rOut,
				 const SfxFrameSetDescriptor* pSet = 0, BOOL bFlatten = FALSE,
				 SfxFrame* pTopFrame = 0 );
	static String CreateDataURL(SfxFrameSetObjectShell *pDoc,
								const SfxFrameSetDescriptor* pSet,
								SfxFrame* pTopFrame );
	static String CreateURL( SfxFrame* pTopFrame );
};

/*  */

inline void SfxFrameHTMLWriter::OutMeta( SvStream& rStrm,
							const sal_Char *pIndent, const sal_Char *pName,
							const String& rContent, BOOL bHTTPEquiv,
							rtl_TextEncoding eDestEnc,
							String *pNonConvertableChars )
{
	String sTmp = String::CreateFromAscii( pName );
	OutMeta( rStrm, pIndent, sTmp, rContent, bHTTPEquiv, eDestEnc, pNonConvertableChars );
}

inline void SfxFrameHTMLWriter::OutFooter()
{
	// </HTML>
	HTMLOutFuncs::Out_AsciiTag( Strm(), sHTML_html, FALSE ) << sNewLine;
}

inline void SfxFrameHTMLWriter::OutNestSpace()
{
	if( nNestCnt>0 )
		Strm() << aFill.Copy( 0, nNestCnt ).GetBuffer();
}


#endif


