/*************************************************************************
 *
 *  $RCSfile: sw3attr.cxx,v $
 *
 *  $Revision: 1.8 $
 *
 *  last change: $Author: vg $ $Date: 2003/04/17 14:18:08 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


#pragma hdrstop

#include <stdlib.h>
#include <stdio.h>


#ifndef _PARATR_HXX
#include <paratr.hxx>
#endif
#ifndef _DOC_HXX
#include <doc.hxx>
#endif
#ifndef _FMTURL_HXX //autogen
#include <fmturl.hxx>
#endif
#ifndef _FMTTSPLT_HXX //autogen
#include <fmtlsplt.hxx>
#endif
#ifndef _FMTEIRO_HXX //autogen
#include <fmteiro.hxx>
#endif
#ifndef _SW_HF_EAT_SPACINGITEM_HXX
#include <hfspacingitem.hxx>
#endif
#ifndef _FMTHBSH_HXX //autogen
#include <fmthbsh.hxx>
#endif
#ifndef _FMTSRND_HXX //autogen
#include <fmtsrnd.hxx>
#endif
#ifndef _FMTORNT_HXX //autogen
#include <fmtornt.hxx>
#endif
#ifndef _FMTFSIZE_HXX //autogen
#include <fmtfsize.hxx>
#endif
#ifndef _FMTFORDR_HXX //autogen
#include <fmtfordr.hxx>
#endif
#ifndef _FMTCLDS_HXX //autogen
#include <fmtclds.hxx>
#endif
#ifndef _NUMRULE_HXX
#include <numrule.hxx>
#endif
#ifndef _POOLFMT_HXX
#include <poolfmt.hxx>
#endif
#ifndef _FMTLINE_HXX
#include <fmtline.hxx>
#endif
#ifndef _SW3IMP_HXX
#include <sw3imp.hxx>
#endif
#ifndef _CHARFMT_HXX
#include <charfmt.hxx>
#endif
#ifndef _GRFATR_HXX
#include <grfatr.hxx>
#endif
#ifndef _CELLATR_HXX
#include <cellatr.hxx>
#endif
#ifndef _TOX_HXX
#include <tox.hxx>
#endif
#ifndef _FLYFRM_HXX
#include <flyfrm.hxx>
#endif
#ifndef _FMTFTNTX_HXX //autogen
#include <fmtftntx.hxx>
#endif
#ifndef _FMTCLBL_HXX
#include <fmtclbl.hxx>
#endif
#ifndef _SWSTYLENAMEMAPPER_HXX
#include <SwStyleNameMapper.hxx>
#endif

////////////////////////////// Frame-Attribute ////////////////////////////


USHORT SwFmtSurround::GetVersion( USHORT nFFVer ) const
{
	ASSERT( SOFFICE_FILEFORMAT_31==nFFVer ||
			SOFFICE_FILEFORMAT_40==nFFVer ||
			SOFFICE_FILEFORMAT_50==nFFVer,
			"SwFmtSurround: Gibt es ein neues Fileformat?" );
	return SOFFICE_FILEFORMAT_31==nFFVer ? 0 :
		   (SOFFICE_FILEFORMAT_40==nFFVer ? 4 :	5);
}


SfxPoolItem* SwFmtSurround::Create( SvStream& rStrm, USHORT nVrs ) const
{
	BYTE nType, bGold = 0, bAnch=0, bCont=0, bOutside = 0;
	rStrm >> nType;
	if ( nVrs < 5 )
		rStrm >> bGold;
	if ( nVrs > 1 )
		rStrm >> bAnch;
	if ( nVrs > 2 )
		rStrm >> bCont;
	if ( nVrs > 3 )
		rStrm >> bOutside;

	SwFmtSurround *pRet = new SwFmtSurround( (SwSurround) nType );
	if( bGold && SURROUND_NONE != (SwSurround)nType &&
				 SURROUND_THROUGHT != (SwSurround)nType )
		pRet->SetSurround( SURROUND_IDEAL );
	pRet->SetAnchorOnly( BOOL(bAnch) );
	pRet->SetContour( BOOL(bCont) );
	pRet->SetOutside( BOOL(bOutside) );
	return pRet;
}


SvStream& SwFmtSurround::Store( SvStream& rStrm, USHORT nIVer ) const
{
	if ( nIVer < 5 )
	{
		SwSurround eType = GetSurround();
		BYTE bGold = 0;
		if( SURROUND_IDEAL == eType )
		{
			eType = SURROUND_PARALLEL;
			bGold = 1;
		}
		rStrm << (BYTE) eType
			  << (BYTE) bGold;
	}
	else
		rStrm << (BYTE) GetSurround();
	if( nIVer > 1 )
		  rStrm << (BYTE) IsAnchorOnly();
	if( nIVer > 2 )
		  rStrm << (BYTE) IsContour();
	if( nIVer > 3 )
		  rStrm << (BYTE) IsOutside();
	return rStrm;
}

USHORT SwFmtVertOrient::GetVersion( USHORT nFFVer ) const
{
	ASSERT( SOFFICE_FILEFORMAT_31==nFFVer ||
			SOFFICE_FILEFORMAT_40==nFFVer ||
			SOFFICE_FILEFORMAT_50==nFFVer,
			"SwFmtHoriOrient: Gibt es ein neues Fileformat?" );
	return ( SOFFICE_FILEFORMAT_31==nFFVer ||
			 SOFFICE_FILEFORMAT_40==nFFVer ) ? 0 : IVER_VERTORIENT_REL;
}

SfxPoolItem* SwFmtVertOrient::Create( SvStream& rStrm, USHORT nIVer ) const
{
	long nPos;
	BYTE nOrient, nRelation;
	rStrm >> nPos >> nOrient >> nRelation;

	// fix #48690#: In 4.0-Doks wurde bei VERT_NONE die Relation nicht
	// beachtet, aber wie FRAME behandelt. Das Attribut enthielt aber PRTAREA
	if( VERT_NONE == (SwVertOrient)nOrient && nIVer < IVER_VERTORIENT_REL )
		nRelation = FRAME;

	return new SwFmtVertOrient( (SwTwips) nPos, (SwVertOrient) nOrient,
								(SwRelationOrient) nRelation );
}


SvStream& SwFmtVertOrient::Store( SvStream& rStrm, USHORT ) const
{
	Sw3IoImp* pIo = Sw3IoImp::GetCurrentIo();

	SwTwips nPos = GetPos();

	if( pIo && pIo->IsSw31Export() && pIo->pExportInfo &&
		pIo->pExportInfo->bFlyFrmFmt )
	{
		const SfxItemSet *pItemSet = pIo->pExportInfo->pItemSet;
		if( pItemSet )
		{
			const SvxULSpaceItem& rULSpace =
				(const SvxULSpaceItem&)pItemSet->Get( RES_UL_SPACE );

			nPos = GetPosConvertedToSw31( &rULSpace );
		}
	}

	rStrm << (long) nPos
		  << (BYTE) GetVertOrient()
		  << (BYTE) GetRelationOrient();
	return rStrm;
}

USHORT SwFmtHoriOrient::GetVersion( USHORT nFFVer ) const
{
	ASSERT( SOFFICE_FILEFORMAT_31==nFFVer ||
			SOFFICE_FILEFORMAT_40==nFFVer ||
			SOFFICE_FILEFORMAT_50==nFFVer,
			"SwFmtHoriOrient: Gibt es ein neues Fileformat?" );
	return ( SOFFICE_FILEFORMAT_31==nFFVer ||
			 SOFFICE_FILEFORMAT_40==nFFVer ) ? 0 : IVER_HORIORIENT_REL;
}

SfxPoolItem* SwFmtHoriOrient::Create( SvStream& rStrm, USHORT nIVer ) const
{
	long nPos;
	BYTE nOrient, nRelation, bToggle = 0, bGrf = 0;
	rStrm >> nPos >> nOrient >> nRelation;

	if( nIVer >= IVER_HORIORIENT_TOGGLE )
		rStrm >> bToggle;

	// fix #48690#: In 4.0-Doks wurde bei HORI_NONE die Relation nicht
	// beachtet, aber wie FRAME behandelt. Das Attribut enthielt aber PRTAREA
	if( HORI_NONE == (SwHoriOrient)nOrient && nIVer < IVER_HORIORIENT_REL )
		nRelation = FRAME;

	return new SwFmtHoriOrient
		( (SwTwips) nPos, (SwHoriOrient) nOrient, (SwRelationOrient) nRelation,
		  BOOL( bToggle ) );
}


SvStream& SwFmtHoriOrient::Store( SvStream& rStrm, USHORT nVersion ) const
{
	Sw3IoImp* pIo = Sw3IoImp::GetCurrentIo();

	SwTwips nPos = GetPos();

	if( pIo && pIo->IsSw31Export() && pIo->pExportInfo &&
		pIo->pExportInfo->bFlyFrmFmt )
	{
		const SfxItemSet *pItemSet = pIo->pExportInfo->pItemSet;
		if( pItemSet )
		{
			const SvxLRSpaceItem& rLRSpace =
				(const SvxLRSpaceItem&)pItemSet->Get( RES_LR_SPACE );

			nPos = GetPosConvertedToSw31( &rLRSpace );
		}
	}

	if( nVersion >= IVER_HORIORIENT_TOGGLE )
	{
		rStrm	<< (long) nPos
				<< (BYTE) GetHoriOrient()
				<< (BYTE) GetRelationOrient()
				<< (BYTE) IsPosToggle();
	}
	else
	{
		SwHoriOrient eHori = GetHoriOrient();
		SwRelationOrient eRel = GetRelationOrient();
		if( eRel > PRTAREA )
		{
			if( !(pIo && pIo->pExportInfo && pIo->pExportInfo->pFlyFrm &&
				pIo->pExportInfo->pFlyFrm->ConvertHoriTo40( eHori, eRel, nPos ) ) )
			{
				switch ( eRel )
				{
					case REL_PG_LEFT: eRel = FRAME; eHori = HORI_LEFT; break;
					case REL_PG_RIGHT: eRel = FRAME; break;
					case REL_FRM_LEFT: eRel = PRTAREA; break;
					case REL_FRM_RIGHT: eRel = PRTAREA; break;
					case REL_PG_PRTAREA: eRel = PRTAREA; break;
					default: eRel = FRAME; break;
				}
			}
		}
		rStrm << (long) nPos
			  << (BYTE) eHori;
		rStrm << (BYTE) eRel;
	}
	return rStrm;
}


USHORT SwFmtFrmSize::GetVersion( USHORT nFFVer ) const
{
	ASSERT( SOFFICE_FILEFORMAT_31==nFFVer ||
			SOFFICE_FILEFORMAT_40==nFFVer ||
			SOFFICE_FILEFORMAT_50==nFFVer,
			"SwFmtFrmSize: Gibt es ein neues Fileformat?" );
	return SOFFICE_FILEFORMAT_31==nFFVer ? 0 : 2;
}


SfxPoolItem* SwFmtFrmSize::Create( SvStream& rStrm, USHORT nVersion ) const
{
	BYTE nSizeType, nWidthPercent = 0, nHeightPercent = 0;
	INT32 nWidth, nHeight;
	rStrm >> nSizeType >> nWidth >> nHeight;

	if ( nVersion > 1 )
		rStrm >> nWidthPercent >> nHeightPercent;

	SwFmtFrmSize *pRet = new SwFmtFrmSize( (SwFrmSize) nSizeType, nWidth, nHeight );
	pRet->SetWidthPercent ( nWidthPercent );
	pRet->SetHeightPercent( nHeightPercent );
	return pRet;
}


SvStream& SwFmtFrmSize::Store( SvStream& rStrm, USHORT nIVer ) const
{
	Sw3IoImp* pIo = Sw3IoImp::GetCurrentIo();

	Size aSz( GetSize() );
	if( pIo && pIo->IsSw31Export() && pIo->pExportInfo &&
		pIo->pExportInfo->bFlyFrmFmt )
	{
		const SfxItemSet *pItemSet = pIo->pExportInfo->pItemSet;
		if( pItemSet )
		{
			const SvxLRSpaceItem& rLRSpace =
				(const SvxLRSpaceItem&)pItemSet->Get( RES_LR_SPACE );
			const SvxULSpaceItem& rULSpace =
				(const SvxULSpaceItem&)pItemSet->Get( RES_UL_SPACE );

			aSz = GetSizeConvertedToSw31( &rLRSpace, &rULSpace );
		}
	}

	rStrm << (BYTE)  GetSizeType()
		  << (INT32) aSz.Width()
		  << (INT32) aSz.Height();

	if( nIVer > 1 )
	{
		rStrm << (BYTE)  GetWidthPercent()
			  << (BYTE)  GetHeightPercent();
	}
	return rStrm;
}


SfxPoolItem* SwFmtFillOrder::Create( SvStream& rStrm, USHORT ) const
{
	BYTE nFillOrder;
	rStrm >> nFillOrder;
	return new SwFmtFillOrder( (SwFillOrder) nFillOrder );
}


SvStream& SwFmtFillOrder::Store( SvStream& rStrm, USHORT ) const
{
	rStrm << (BYTE) GetFillOrder();
	return rStrm;
}


SfxPoolItem* SwFmtCol::Create( SvStream& rStrm, USHORT ) const
{
	// Die Longs muessen runtergerechnet werden
	BYTE   nLineAdj, bOrtho, nLineHeight, nPenStyle;
	INT16  nGutterWidth, nPenWidth;
	UINT16 nWishWidth, nPenRed, nPenGreen, nPenBlue;
	rStrm >> nLineAdj
		  >> bOrtho
		  >> nLineHeight
		  >> nGutterWidth
		  >> nWishWidth
		  >> nPenStyle
		  >> nPenWidth
		  >> nPenRed
		  >> nPenGreen
		  >> nPenBlue;
	SwFmtCol* p = new SwFmtCol;
	Color aPenColor( nPenRed >> 8, nPenGreen >> 8, nPenBlue >> 8 );
//	Pen aPen( aPenColor, nPenWidth, (PenStyle) nPenStyle );
	INT16 nCol;
	rStrm >> nCol;
	ASSERT( nWishWidth, "Damaged Doc: No WishWidth" );
	if( !nWishWidth )
	{
		nWishWidth = USHRT_MAX;
		if( nCol )
			p->Init( nCol, nGutterWidth, nWishWidth );
	}
	else
	{
		for( short i = 0; i < nCol; i++ )
		{
			UINT16 nWidth, nLeft, nUpper, nRight, nLower;
			rStrm >> nWidth >> nLeft >> nUpper >> nRight >> nLower;
			SwColumn* pCol = new SwColumn;
			pCol->SetWishWidth( nWidth );
			pCol->SetLeft( nLeft );
			pCol->SetUpper( nUpper );
			pCol->SetRight( nRight );
			pCol->SetLower( nLower );
			p->GetColumns().Insert( pCol, i );
		}
	}
	p->SetLineWidth( nPenWidth );
	p->SetLineColor( aPenColor );
	p->SetWishWidth( nWishWidth );
	p->SetLineHeight( nLineHeight );
	p->SetLineAdj( (SwColLineAdj) nLineAdj );
	// temporaerer Bug Fix
	if( nCol )
		// Wert direkt mit dem Silberhammer einschlagen.
		p->_SetOrtho( (BOOL) bOrtho );
	return p;
}


SvStream& SwFmtCol::Store( SvStream& rStrm, USHORT ) const
{

	rStrm << (BYTE)  GetLineAdj()
		  << (BYTE)  IsOrtho()
		  << (BYTE)  GetLineHeight()
		  << (INT16) GetGutterWidth()
		  << (UINT16)GetWishWidth()
		  << (BYTE)  0 // rPen.GetStyle() - not available anymore
		  << (INT16) GetLineWidth()
		  << (UINT16)(GetLineColor().GetRed() << 8 )
		  << (UINT16)(GetLineColor().GetGreen() << 8 )
		  << (UINT16)(GetLineColor().GetBlue() << 8 )
			;
	INT16 nCol = GetNumCols();
	rStrm << (INT16) nCol;
	for( short i = 0; i < nCol; i++ )
	{
		const SwColumn* pCol = GetColumns()[ i ];
		rStrm << (UINT16)pCol->GetWishWidth()
			  << (INT16) pCol->GetLeft()
			  << (INT16) pCol->GetUpper()
			  << (INT16) pCol->GetRight()
			  << (INT16) pCol->GetLower();
	}
	return rStrm;
}


SfxPoolItem * SwFmtURL::Create(SvStream &rStrm, USHORT nIVer) const
{
	Sw3IoImp* pIo = Sw3IoImp::GetCurrentIo();
	ASSERT( pIo, "Reader/Writer not found" );

	String sURL, sTargetFrameName, sName;
	BOOL bServerMap;

	SwFmtURL *pNew = new SwFmtURL;

	if( pIo )
		pNew->SetMap( pIo->InImageMap( sURL, sTargetFrameName, bServerMap ) );
	if( nIVer>=1 )
		rStrm.ReadByteString( sName, rStrm.GetStreamCharSet() );

	// fix #30592#: Boese Falle: Beim setzen einer URL wird eine Image-Map
	// wieder geloescht.
	if( sURL.Len() )
		pNew->SetURL( sURL, bServerMap );
	pNew->SetTargetFrameName( sTargetFrameName );
	pNew->SetName( sName );
	return pNew;
}


SvStream & SwFmtURL::Store( SvStream &rStrm, USHORT nIVer ) const
{
	ASSERT( nIVer != USHRT_MAX,
			"SwFmtURL: Wer faengt da Version USHRT_MAX nicht ab?" );

	Sw3IoImp* pIo = Sw3IoImp::GetCurrentIo();
	ASSERT( pIo, "Reader/Writer not found" );

	if( pIo )
		pIo->OutImageMap( sURL, sTargetFrameName, pMap, bIsServerMap );
	if( nIVer >= 1 )
		rStrm.WriteByteString( GetName(), rStrm.GetStreamCharSet() );

	return rStrm;
}


USHORT SwFmtURL::GetVersion( USHORT nFFVer ) const
{
	ASSERT( SOFFICE_FILEFORMAT_31==nFFVer ||
			SOFFICE_FILEFORMAT_40==nFFVer ||
			SOFFICE_FILEFORMAT_50==nFFVer,
			"SwFmtURL: Gibt es ein neues Fileformat?" );
	return SOFFICE_FILEFORMAT_31==nFFVer ? USHRT_MAX : 1;
}


SfxPoolItem* SwFmtEditInReadonly::Create(SvStream &rStrm, USHORT) const
{
	BYTE n;
	rStrm >> n;
	return new SwFmtEditInReadonly( RES_EDIT_IN_READONLY, BOOL(n) );
}


SvStream& SwFmtEditInReadonly::Store(SvStream &rStrm, USHORT ) const
{
	rStrm << BYTE(GetValue());
	return rStrm;
}


USHORT SwFmtEditInReadonly::GetVersion( USHORT nFFVer ) const
{
	ASSERT( SOFFICE_FILEFORMAT_31==nFFVer ||
			SOFFICE_FILEFORMAT_40==nFFVer ||
			SOFFICE_FILEFORMAT_50==nFFVer,
			"SwFmtEditInReadonly: Gibt es ein neues Fileformat?" );
	return SOFFICE_FILEFORMAT_31==nFFVer ? USHRT_MAX : 0;
}


SfxPoolItem* SwFmtLayoutSplit::Create(SvStream &rStrm, USHORT) const
{
	BYTE n;
	rStrm >> n;
	return new SwFmtLayoutSplit( BOOL(n) );
}


SvStream& SwFmtLayoutSplit::Store(SvStream &rStrm, USHORT ) const
{
	rStrm << BYTE(GetValue());
	return rStrm;
}


USHORT SwFmtLayoutSplit::GetVersion( USHORT nFFVer ) const
{
	ASSERT( SOFFICE_FILEFORMAT_31==nFFVer ||
			SOFFICE_FILEFORMAT_40==nFFVer ||
			SOFFICE_FILEFORMAT_50==nFFVer,
			"SwFmtLayoutSplit: Gibt es ein neues Fileformat?" );
	return SOFFICE_FILEFORMAT_31==nFFVer ||
		   SOFFICE_FILEFORMAT_40==nFFVer ? USHRT_MAX : 0;
}

SvStream& SwFmtFtnEndAtTxtEnd::Store( SvStream & rStrm, USHORT nIVer ) const
{
// alt: nur ein BOOL, jetzt 2 enums, 2 Strings, 1 uint16
	if( 0 == nIVer )		// old - only a boolitem
	{
		rStrm << (BYTE)( FTNEND_ATPGORDOCEND == GetValue() ? 0 : 1 );
	}
	else
	{
		rStrm << (BYTE)GetValue()
			  << (UINT16)nOffset
			  << (UINT16)aFmt.GetNumberingType();
		rStrm.WriteByteString( sPrefix, rStrm.GetStreamCharSet() );
		rStrm.WriteByteString( sSuffix, rStrm.GetStreamCharSet() );
	}

	return rStrm;
}

SfxPoolItem* SwFmtFtnEndAtTxtEnd::Create( SvStream &rStrm, USHORT nVer ) const
{
	SwFmtFtnEndAtTxtEnd* pNew = (SwFmtFtnEndAtTxtEnd*)Clone();

	BYTE nVal;
	rStrm >> nVal;
	pNew->SetValue( nVal );

	if( 0 < nVer )
	{
		UINT16 nOffset, nFmtType;
		String sPostfix, sSuffix;
		rStrm >> nOffset
			  >> nFmtType;
		rStrm.ReadByteString( sPostfix, rStrm.GetStreamCharSet() );
		rStrm.ReadByteString( sSuffix, rStrm.GetStreamCharSet() );

		pNew->SetNumType( (SvxExtNumType)nFmtType );
		pNew->SetOffset( nOffset );
		pNew->SetPrefix( sPostfix );
		pNew->SetSuffix( sSuffix );
	}
	return pNew;
}

USHORT SwFmtFtnEndAtTxtEnd::GetVersion( USHORT nFFVer ) const
{
	ASSERT( SOFFICE_FILEFORMAT_31==nFFVer ||
			SOFFICE_FILEFORMAT_40==nFFVer ||
			SOFFICE_FILEFORMAT_50==nFFVer,
			"SwFmtFtnEndAtTxtEnd: Gibt es ein neues Fileformat?" );
	return SOFFICE_FILEFORMAT_31==nFFVer ||
		   SOFFICE_FILEFORMAT_40==nFFVer ? USHRT_MAX : 1;
}

SfxPoolItem* SwFmtNoBalancedColumns::Create(SvStream &rStrm, USHORT) const
{
	BYTE n;
	rStrm >> n;
	return new SwFmtNoBalancedColumns( BOOL(n) );
}


SvStream& SwFmtNoBalancedColumns::Store(SvStream &rStrm, USHORT ) const
{
	rStrm << BYTE(GetValue());
	return rStrm;
}


USHORT SwFmtNoBalancedColumns::GetVersion( USHORT nFFVer ) const
{
	ASSERT( SOFFICE_FILEFORMAT_31==nFFVer ||
			SOFFICE_FILEFORMAT_40==nFFVer ||
			SOFFICE_FILEFORMAT_50==nFFVer,
			"SwFmtNoBalancedColumns: Gibt es ein neues Fileformat?" );
	return SOFFICE_FILEFORMAT_31==nFFVer ||
		   SOFFICE_FILEFORMAT_40==nFFVer ? USHRT_MAX : 0;
}


SfxPoolItem* SwHeaderAndFooterEatSpacingItem::Create(SvStream &rStrm, USHORT) const
{
    ASSERT( sal_False, "SwHeaderAndFooterEatSpacingItem::Create called for old fileformat" )
	BYTE n;
	rStrm >> n;
    return new SwHeaderAndFooterEatSpacingItem( RES_HEADER_FOOTER_EAT_SPACING, BOOL(n) );
}


SvStream& SwHeaderAndFooterEatSpacingItem::Store(SvStream &rStrm, USHORT ) const
{
    ASSERT( sal_False, "SwHeaderAndFooterEatSpacingItem::Store called for old fileformat" )
	rStrm << BYTE(GetValue());
	return rStrm;
}


USHORT SwHeaderAndFooterEatSpacingItem::GetVersion( USHORT nFFVer ) const
{
	ASSERT( SOFFICE_FILEFORMAT_31==nFFVer ||
			SOFFICE_FILEFORMAT_40==nFFVer ||
			SOFFICE_FILEFORMAT_50==nFFVer,
            "SwHeaderAndFooterEatSpacingItem: Gibt es ein neues Fileformat?" );
    return USHRT_MAX;
}


/////////////////////////////// Grafik-Attribute /////////////////////////


SfxPoolItem* SwMirrorGrf::Create( SvStream& rStrm, USHORT nIVer) const
{
	BYTE nState;
	BYTE nToggle = FALSE;

	rStrm >> nState;

	if (nIVer > 0)
		rStrm >> nToggle;

	SwMirrorGrf* pRet = new SwMirrorGrf( nState );
	pRet->SetGrfToggle((BOOL)nToggle);
	return pRet;
}


SvStream& SwMirrorGrf::Store( SvStream& rStrm, USHORT nIVer) const
{
	rStrm << (BYTE)GetValue();

	if (nIVer > 0)
		rStrm << (BYTE)bGrfToggle;

	return rStrm;
}


USHORT SwMirrorGrf::GetVersion( USHORT nFFVer ) const
{
	ASSERT( SOFFICE_FILEFORMAT_31==nFFVer ||
			SOFFICE_FILEFORMAT_40==nFFVer ||
			SOFFICE_FILEFORMAT_50==nFFVer,
			"SwFmtSurround: Gibt es ein neues Fileformat?" );

	return SOFFICE_FILEFORMAT_40 < nFFVer ? 1 : 0;
}


USHORT	SwCropGrf::GetVersion( USHORT nFFVer ) const
{
	ASSERT( SOFFICE_FILEFORMAT_31==nFFVer ||
			SOFFICE_FILEFORMAT_40==nFFVer ||
			SOFFICE_FILEFORMAT_50==nFFVer,
			"SwCropGrf: Gibt es ein neues Fileformat?" );

	return GRFCROP_VERSION_SWDEFAULT;
}

USHORT	SwRotationGrf::GetVersion( USHORT nFFVer ) const
{
	ASSERT( SOFFICE_FILEFORMAT_31==nFFVer ||
			SOFFICE_FILEFORMAT_40==nFFVer ||
			SOFFICE_FILEFORMAT_50==nFFVer,
			"SwRotationGrf: Gibt es ein neues Fileformat?" );

	return SOFFICE_FILEFORMAT_50 > nFFVer ? USHRT_MAX : 0;
}

SfxPoolItem* SwRotationGrf::Create( SvStream & rStrm, USHORT nVer ) const
{
	SwRotationGrf* pRet = (SwRotationGrf*)SfxUInt16Item::Create( rStrm, nVer );
	Size aSz;
	rStrm >> aSz;
	pRet->SetUnrotatedSize( aSz );
	return pRet;
}

SvStream& SwRotationGrf::Store( SvStream & rStrm, USHORT nIVer) const
{
	SfxUInt16Item::Store( rStrm, nIVer );
	rStrm << GetUnrotatedSize();
	return rStrm;
}

USHORT SwLuminanceGrf::GetVersion( USHORT nFFVer ) const
{
	ASSERT( SOFFICE_FILEFORMAT_31==nFFVer ||
			SOFFICE_FILEFORMAT_40==nFFVer ||
			SOFFICE_FILEFORMAT_50==nFFVer,
			"SwLuminanceGrf: Gibt es ein neues Fileformat?" );

	return SOFFICE_FILEFORMAT_50 > nFFVer ? USHRT_MAX : 0;
}

USHORT SwContrastGrf::GetVersion( USHORT nFFVer ) const
{
	ASSERT( SOFFICE_FILEFORMAT_31==nFFVer ||
			SOFFICE_FILEFORMAT_40==nFFVer ||
			SOFFICE_FILEFORMAT_50==nFFVer,
			"SwContrastGrf: Gibt es ein neues Fileformat?" );

	return SOFFICE_FILEFORMAT_50 > nFFVer ? USHRT_MAX : 0;
}
USHORT SwChannelGrf::GetVersion( USHORT nFFVer ) const
{
	ASSERT( SOFFICE_FILEFORMAT_31==nFFVer ||
			SOFFICE_FILEFORMAT_40==nFFVer ||
			SOFFICE_FILEFORMAT_50==nFFVer,
			"SwChannelGrf: Gibt es ein neues Fileformat?" );

	return SOFFICE_FILEFORMAT_50 > nFFVer ? USHRT_MAX : 0;
}

USHORT SwGammaGrf::GetVersion( USHORT nFFVer ) const
{
	ASSERT( SOFFICE_FILEFORMAT_31==nFFVer ||
			SOFFICE_FILEFORMAT_40==nFFVer ||
			SOFFICE_FILEFORMAT_50==nFFVer,
			"SwChannelGrf: Gibt es ein neues Fileformat?" );

	return SOFFICE_FILEFORMAT_50 > nFFVer ? USHRT_MAX : 0;
}

SfxPoolItem* SwGammaGrf::Create(SvStream & rStrm, USHORT ) const
{
	SwGammaGrf* pRet = (SwGammaGrf*)Clone();
	double aVal;
	rStrm >> aVal;
	pRet->SetValue( aVal );
	return pRet;
}

SvStream& SwGammaGrf::Store(SvStream & rStrm, USHORT ) const
{
	rStrm << GetValue();
	return rStrm;
}

USHORT SwInvertGrf::GetVersion( USHORT nFFVer ) const
{
	ASSERT( SOFFICE_FILEFORMAT_31==nFFVer ||
			SOFFICE_FILEFORMAT_40==nFFVer ||
			SOFFICE_FILEFORMAT_50==nFFVer,
			"SwInvertGrf: Gibt es ein neues Fileformat?" );

	return SOFFICE_FILEFORMAT_50 > nFFVer ? USHRT_MAX : 0;
}

USHORT	SwTransparencyGrf::GetVersion( USHORT nFFVer ) const
{
	ASSERT( SOFFICE_FILEFORMAT_31==nFFVer ||
			SOFFICE_FILEFORMAT_40==nFFVer ||
			SOFFICE_FILEFORMAT_50==nFFVer,
			"SwInvertGrf: Gibt es ein neues Fileformat?" );

	return SOFFICE_FILEFORMAT_50 > nFFVer ? USHRT_MAX : 0;
}

USHORT	SwDrawModeGrf::GetVersion( USHORT nFFVer ) const
{
	ASSERT( SOFFICE_FILEFORMAT_31==nFFVer ||
			SOFFICE_FILEFORMAT_40==nFFVer ||
			SOFFICE_FILEFORMAT_50==nFFVer,
			"SwDrawModeGrf: Gibt es ein neues Fileformat?" );

	return SOFFICE_FILEFORMAT_50 > nFFVer ? USHRT_MAX : 0;
}



//////////////////////////////// Text-Attribute ////////////////////////////


SfxPoolItem* SwFmtHardBlank::Create( SvStream& rStrm, USHORT nV ) const
{
	sal_Char cChr = ' ';
	if( nV )
		rStrm >> cChr;
	sal_Unicode c = ByteString::ConvertToUnicode( cChr, rStrm.GetStreamCharSet() );
	return new SwFmtHardBlank( c, FALSE );
}


SvStream& SwFmtHardBlank::Store( SvStream& rStrm, USHORT nIVer ) const
{
	if( nIVer )
	{
		sal_Char c = ByteString::ConvertFromUnicode( GetChar(),
												 	rStrm.GetStreamCharSet(),
												 	FALSE );
		if( !c )
			c = ' ';	// TODO: unicode: is this sensible?
		rStrm << c;
	}
	return rStrm;
}


USHORT SwFmtHardBlank::GetVersion( USHORT nFFVer ) const
{
	ASSERT( SOFFICE_FILEFORMAT_31==nFFVer ||
			SOFFICE_FILEFORMAT_40==nFFVer ||
			SOFFICE_FILEFORMAT_50==nFFVer,
			"SwFmtHardBlank: Gibt es ein neues Fileformat?" );
	return SOFFICE_FILEFORMAT_31==nFFVer ? 0 : 1;
}


SfxPoolItem* SwFmtSoftHyph::Create( SvStream& rStrm, USHORT ) const
{
	return new SwFmtSoftHyph;
}


SvStream& SwFmtSoftHyph::Store( SvStream& rStrm, USHORT ) const
{
	return rStrm;
}

/////////////////////////////// Absatz-Attribute ///////////////////////////


USHORT SwFmtDrop::GetVersion( USHORT nFFVer ) const
{
	ASSERT( SOFFICE_FILEFORMAT_31==nFFVer ||
			SOFFICE_FILEFORMAT_40==nFFVer ||
			SOFFICE_FILEFORMAT_50==nFFVer,
			"SwFmtDrop: Gibt es ein neues Fileformat?" );
	return ( SOFFICE_FILEFORMAT_31==nFFVer ||
			 SOFFICE_FILEFORMAT_40==nFFVer ) ? 0 : DROP_WHOLEWORD;
	return 0;
}

SfxPoolItem* SwFmtDrop::Create( SvStream& rStrm, USHORT nVer ) const
{
	UINT16 nLines, nChars, nDistance, nX, nY, nFmt;
	BYTE bWhole = 0;
	rStrm >> nFmt >> nLines >> nChars >> nDistance;
	if( nVer >= DROP_WHOLEWORD )
		rStrm >> bWhole;
	else
		rStrm >> nX >> nY;
	SwFmtDrop* pAttr = new SwFmtDrop;
	pAttr->GetLines() = (BYTE) nLines;
	pAttr->GetChars() = (BYTE) nChars;
	pAttr->GetDistance() = nDistance;
	pAttr->GetWholeWord() = (BOOL) bWhole;
	if( nFmt != IDX_NO_VALUE )
	{
		Sw3IoImp* pIo = Sw3IoImp::GetCurrentIo();
		if( pIo )
		{
			if( pIo->aStringPool.Count() )
			{
				SwCharFmt* pSet = (SwCharFmt*) pIo->FindFmt( nFmt, SWG_CHARFMT );
				if( pSet )
					pAttr->SetCharFmt( pSet );
			}
			else
				pAttr->nReadFmt = nFmt;
		}
	}
	return pAttr;
}


SvStream& SwFmtDrop::Store( SvStream& rStrm, USHORT nVer ) const
{
	USHORT nFmt = IDX_NO_VALUE;
	USHORT nChars = GetWholeWord() ? 1 : GetChars();
	const SwFmt* pFmt = GetCharFmt();
	if( pFmt )
	{
		Sw3IoImp* pIo = Sw3IoImp::GetCurrentIo();
		if( pIo )
			nFmt = pIo->aStringPool.Find( pFmt->GetName(),
										  pFmt->GetPoolFmtId() );
	}
	rStrm << (UINT16) nFmt
		  << (UINT16) GetLines()
		  << (UINT16) nChars
		  << (UINT16) GetDistance();
	if( nVer >= DROP_WHOLEWORD )
		rStrm << (BYTE) GetWholeWord();
	else
		rStrm << (UINT16) 0 << (UINT16) 0;
	return rStrm;
}

// -----------------------------------------------------------------------

SvStream& SwRegisterItem::Store( SvStream& rStrm, USHORT nIVer ) const
{
	ASSERT( nIVer != USHRT_MAX,
			"SwRegisterItem: Wer faengt da Version USHRT_MAX nicht ab?" );

	rStrm << (BYTE)GetValue();
	return rStrm;
}

// -----------------------------------------------------------------------

SfxPoolItem* SwRegisterItem::Create( SvStream& rStrm, USHORT ) const
{
	BYTE bIsRegister;
	rStrm >> bIsRegister;
	return new SwRegisterItem( BOOL( bIsRegister != 0 ) );
}

// -----------------------------------------------------------------------

USHORT SwRegisterItem::GetVersion( USHORT nFFVer ) const
{
	ASSERT( SOFFICE_FILEFORMAT_31==nFFVer ||
			SOFFICE_FILEFORMAT_40==nFFVer ||
			SOFFICE_FILEFORMAT_50==nFFVer,
			"SwRegisterItem: Gibt es ein neues Fileformat?" );

	// im 3.1 FF nicht speichern
	return SOFFICE_FILEFORMAT_31==nFFVer ? USHRT_MAX : 0;
}

// -----------------------------------------------------------------------

SvStream& SwFmtLineNumber::Store( SvStream& rStrm, USHORT nIVer ) const
{
	ASSERT( nIVer != USHRT_MAX,
			"SwFmtLineNumber: Wer faengt da Version USHRT_MAX nicht ab?" );

	rStrm << nStartValue << IsCount();
	return rStrm;
}

// -----------------------------------------------------------------------

SfxPoolItem* SwFmtLineNumber::Create( SvStream& rStrm, USHORT ) const
{
	SwFmtLineNumber *pTmp = new SwFmtLineNumber;
	ULONG nTmp; BOOL bTmp;
	rStrm >> nTmp; pTmp->SetStartValue( nTmp );
	rStrm >> bTmp; pTmp->SetCountLines( bTmp );
	return pTmp;
}

// -----------------------------------------------------------------------

USHORT SwFmtLineNumber::GetVersion( USHORT nFFVer ) const
{
	ASSERT( SOFFICE_FILEFORMAT_31==nFFVer ||
			SOFFICE_FILEFORMAT_40==nFFVer ||
			SOFFICE_FILEFORMAT_50==nFFVer,
			"SwFmtLineNumber: Gibt es ein neues Fileformat?" );

	// vor 5.0 nicht speichern
	return SOFFICE_FILEFORMAT_40 <= nFFVer ? 0 : USHRT_MAX;
}



// -----------------------------------------------------------------------

SvStream& SwNumRuleItem::Store( SvStream& rStrm, USHORT nIVer ) const
{
	ASSERT( nIVer != USHRT_MAX,
			"SwNumRuleItem: Wer faengt da Version USHRT_MAX nicht ab?" );

	// Damit wir Pool-NumRules umbenennen koennen, muessen wir die
	// PoolId der NumRule rausfinden und mit speichern.
	UINT16 nPoolId = USHRT_MAX;
	Sw3IoImp* pIo = Sw3IoImp::GetCurrentIo();
	if( pIo )
	{
		const SwNumRule *pNumRule = pIo->pDoc->FindNumRulePtr( GetValue() );
		if( pNumRule )
			nPoolId = pNumRule->GetPoolFmtId();
	}

	rStrm.WriteByteString( GetValue(), rStrm.GetStreamCharSet() ) << nPoolId;
	return rStrm;
}

// -----------------------------------------------------------------------

SfxPoolItem* SwNumRuleItem::Create( SvStream& rStrm,
											 USHORT nIVer ) const
{
	String sTmp;
	UINT16 nPoolId;

	rStrm.ReadByteString( sTmp, rStrm.GetStreamCharSet() );
	if( nIVer>0 )
	{
		// Pool-NumRules muessen evtl. noch umbenannt werden.
		rStrm >> nPoolId;

		Sw3IoImp* pIo = Sw3IoImp::GetCurrentIo();
		if( pIo && nPoolId >= RES_POOLNUMRULE_BEGIN &&
			nPoolId < RES_POOLNUMRULE_END )
			SwStyleNameMapper::FillUIName( nPoolId, sTmp );
	}

	return new SwNumRuleItem( sTmp );
}

// -----------------------------------------------------------------------

USHORT SwNumRuleItem::GetVersion( USHORT nFFVer ) const
{
	ASSERT( SOFFICE_FILEFORMAT_31==nFFVer ||
			SOFFICE_FILEFORMAT_40==nFFVer ||
			SOFFICE_FILEFORMAT_50==nFFVer,
			"SwNumRuleItem: Gibt es ein neues Fileformat?" );

	// im 3.1 und 4.0 FF nicht speichern
	// Die FF-Version 0 enthielt keine PoolId.
	return nFFVer <= SOFFICE_FILEFORMAT_40 ? USHRT_MAX : 1;
}

// -----------------------------------------------------------------------


SfxPoolItem* SwTblBoxNumFormat::Create( SvStream& rStrm, USHORT nVer) const
{
	BYTE nFlag;
	UINT32 nTmp;

	rStrm >> nTmp >> nFlag;

	Sw3IoImp* pIo = Sw3IoImp::GetCurrentIo();
	SvNumberFormatter* pN;
	if( pIo && 0 != ( pN = pIo->pDoc->GetNumberFormatter( FALSE ) ) )
		nTmp = pN->GetMergeFmtIndex( nTmp );

	SwTblBoxNumFormat* pNew = new SwTblBoxNumFormat( nTmp, 0 != nFlag );
	return pNew;
}


SvStream& SwTblBoxNumFormat::Store( SvStream& rStrm, USHORT nIVer ) const
{
	rStrm << GetValue() << (BYTE)bAuto;
	return rStrm;
}


USHORT SwTblBoxNumFormat::GetVersion( USHORT nFFVer ) const
{
	ASSERT( SOFFICE_FILEFORMAT_31==nFFVer ||
			SOFFICE_FILEFORMAT_40==nFFVer ||
			SOFFICE_FILEFORMAT_50==nFFVer,
			"SwTblBoxNumFormat: Gibt es ein neues Fileformat?" );
	return SOFFICE_FILEFORMAT_31==nFFVer ? USHRT_MAX : 0;
}

// -----------------------------------------------------------------------


SfxPoolItem* SwTblBoxValue::Create( SvStream& rStrm, USHORT nIVer ) const
{
	double dVal;
	if( 0 == nIVer )
	{
		sal_Char* dummy;
		ByteString sValue;
		rStrm.ReadByteString( sValue );
		dVal = strtod( sValue.GetBuffer(), &dummy );
	}
	else
		rStrm >> dVal;

	return new SwTblBoxValue( dVal );
}


SvStream& SwTblBoxValue::Store( SvStream& rStrm, USHORT nIVer ) const
{
	if( 0 == nIVer )
	{
        ByteString sValue(ByteString::CreateFromDouble(nValue));
        rStrm.WriteByteString( sValue );
	}
	else
		rStrm << nValue;

	return rStrm;
}


USHORT SwTblBoxValue::GetVersion( USHORT nFFVer ) const
{
	ASSERT( SOFFICE_FILEFORMAT_31==nFFVer ||
			SOFFICE_FILEFORMAT_40==nFFVer ||
			SOFFICE_FILEFORMAT_50==nFFVer,
			"SwTblBoxValue: Gibt es ein neues Fileformat?" );
	return SOFFICE_FILEFORMAT_31==nFFVer ? USHRT_MAX :
		   (SOFFICE_FILEFORMAT_40==nFFVer ? 0 : 1 );
}


