/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.model;

import com.sun.xml.internal.bind.api.TypeReference;
import com.sun.xml.internal.ws.model.CheckedException;
import com.sun.xml.internal.ws.model.Parameter;
import com.sun.xml.internal.ws.model.WrapperParameter;
import com.sun.xml.internal.ws.model.soap.SOAPBinding;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaMethod {
    private List<CheckedException> exceptions = new ArrayList<CheckedException>();
    private Method method;
    private final List<Parameter> requestParams = new ArrayList<Parameter>();
    private final List<Parameter> responseParams = new ArrayList<Parameter>();
    private final List<Parameter> unmReqParams = Collections.unmodifiableList(this.requestParams);
    private final List<Parameter> unmResParams = Collections.unmodifiableList(this.responseParams);
    private Object binding;
    private int mep;
    private String operationName;

    public JavaMethod(Method method) {
        this.method = method;
    }

    public Method getMethod() {
        return this.method;
    }

    public int getMEP() {
        return this.mep;
    }

    public void setMEP(int n) {
        this.mep = n;
    }

    public Object getBinding() {
        if (this.binding == null) {
            return new SOAPBinding();
        }
        return this.binding;
    }

    public void setBinding(Object object) {
        this.binding = object;
    }

    public void setOperationName(String string) {
        this.operationName = string;
    }

    public String getOperationName() {
        return this.operationName;
    }

    public List<Parameter> getRequestParameters() {
        return this.unmReqParams;
    }

    public List<Parameter> getResponseParameters() {
        return this.unmResParams;
    }

    public void addParameter(Parameter parameter) {
        if (parameter.isIN() || parameter.isINOUT()) {
            if (this.requestParams.contains(parameter)) {
                // empty if block
            }
            this.requestParams.add(parameter);
        }
        if (parameter.isOUT() || parameter.isINOUT()) {
            if (this.requestParams.contains(parameter)) {
                // empty if block
            }
            this.responseParams.add(parameter);
        }
    }

    public void addRequestParameter(Parameter parameter) {
        if (parameter.isIN() || parameter.isINOUT()) {
            this.requestParams.add(parameter);
        }
    }

    public void addResponseParameter(Parameter parameter) {
        if (parameter.isOUT() || parameter.isINOUT()) {
            this.responseParams.add(parameter);
        }
    }

    public int getInputParametersCount() {
        int n = 0;
        for (Parameter parameter : this.requestParams) {
            if (parameter.isWrapperStyle()) {
                n += ((WrapperParameter)parameter).getWrapperChildren().size();
                continue;
            }
            ++n;
        }
        for (Parameter parameter : this.responseParams) {
            if (parameter.isWrapperStyle()) {
                for (Parameter parameter2 : ((WrapperParameter)parameter).getWrapperChildren()) {
                    if (parameter2.isResponse() || !parameter2.isOUT()) continue;
                    ++n;
                }
                continue;
            }
            if (parameter.isResponse() || !parameter.isOUT()) continue;
            ++n;
        }
        return n;
    }

    public void addException(CheckedException checkedException) {
        if (!this.exceptions.contains(checkedException)) {
            this.exceptions.add(checkedException);
        }
    }

    public CheckedException getCheckedException(Class clazz) {
        for (CheckedException checkedException : this.exceptions) {
            if (!checkedException.getExcpetionClass().equals(clazz)) continue;
            return checkedException;
        }
        return null;
    }

    public List<CheckedException> getCheckedExceptions() {
        return Collections.unmodifiableList(this.exceptions);
    }

    public CheckedException getCheckedException(TypeReference typeReference) {
        for (CheckedException checkedException : this.exceptions) {
            TypeReference typeReference2 = checkedException.getDetailType();
            if (!typeReference2.tagName.equals(typeReference.tagName) || !typeReference2.type.getClass().getName().equals(typeReference.type.getClass().getName())) continue;
            return checkedException;
        }
        return null;
    }

    public boolean isAsync() {
        return this.mep == 4 || this.mep == 3;
    }
}

