/*
 * Decompiled with CFR 0.152.
 */
package sun.print;

import java.awt.Toolkit;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.MediaTray;
import sun.print.AttributeClass;
import sun.print.CustomMediaSizeName;
import sun.print.CustomMediaTray;
import sun.print.IPPPrintService;

public class CUPSPrinter {
    private static final double PRINTER_DPI = 72.0;
    private static boolean initialized;
    private MediaPrintableArea[] cupsMediaPrintables;
    private MediaSizeName[] cupsMediaSNames;
    private CustomMediaSizeName[] cupsCustomMediaSNames;
    private MediaTray[] cupsMediaTrays;
    public int nPageSizes = 0;
    public int nTrays = 0;
    private String[] media;
    private float[] pageSizes;
    private String printer;
    private static boolean libFound;

    private static native String getCupsServer();

    private static native int getCupsPort();

    private static native boolean canConnect(String var0, int var1);

    private static native boolean initIDs();

    private static synchronized native String[] getMedia(String var0);

    private static synchronized native float[] getPageSizes(String var0);

    CUPSPrinter(String string) {
        if (string == null) {
            throw new IllegalArgumentException("null printer name");
        }
        this.printer = string;
        this.cupsMediaSNames = null;
        this.cupsMediaPrintables = null;
        this.cupsMediaTrays = null;
        initialized = false;
        if (!libFound) {
            throw new RuntimeException("cups lib not found");
        }
        this.media = CUPSPrinter.getMedia(this.printer);
        if (this.media == null) {
            throw new RuntimeException("error getting PPD");
        }
        this.pageSizes = CUPSPrinter.getPageSizes(this.printer);
        if (this.pageSizes != null) {
            this.nPageSizes = this.pageSizes.length / 6;
            this.nTrays = this.media.length / 2 - this.nPageSizes;
            assert (this.nTrays >= 0);
        }
    }

    public MediaSizeName[] getMediaSizeNames() {
        this.initMedia();
        return this.cupsMediaSNames;
    }

    public CustomMediaSizeName[] getCustomMediaSizeNames() {
        this.initMedia();
        return this.cupsCustomMediaSNames;
    }

    public MediaPrintableArea[] getMediaPrintableArea() {
        this.initMedia();
        return this.cupsMediaPrintables;
    }

    public MediaTray[] getMediaTrays() {
        this.initMedia();
        return this.cupsMediaTrays;
    }

    private void initMedia() {
        if (initialized) {
            return;
        }
        initialized = true;
        if (this.pageSizes == null) {
            return;
        }
        this.cupsMediaPrintables = new MediaPrintableArea[this.nPageSizes];
        this.cupsMediaSNames = new MediaSizeName[this.nPageSizes];
        this.cupsCustomMediaSNames = new CustomMediaSizeName[this.nPageSizes];
        for (int i = 0; i < this.nPageSizes; ++i) {
            MediaPrintableArea mediaPrintableArea;
            block8: {
                float f = (float)((double)this.pageSizes[i * 6] / 72.0);
                float f2 = (float)((double)this.pageSizes[i * 6 + 1] / 72.0);
                float f3 = (float)((double)this.pageSizes[i * 6 + 2] / 72.0);
                float f4 = (float)((double)this.pageSizes[i * 6 + 3] / 72.0);
                float f5 = (float)((double)this.pageSizes[i * 6 + 4] / 72.0);
                float f6 = (float)((double)this.pageSizes[i * 6 + 5] / 72.0);
                CustomMediaSizeName customMediaSizeName = new CustomMediaSizeName(this.media[i * 2], this.media[i * 2 + 1], f, f2);
                this.cupsMediaSNames[i] = customMediaSizeName.getStandardMedia();
                if (this.cupsMediaSNames[i] == null) {
                    this.cupsMediaSNames[i] = customMediaSizeName;
                    if ((double)f > 0.0 && (double)f2 > 0.0) {
                        new MediaSize(f, f2, 25400, (MediaSizeName)customMediaSizeName);
                    }
                }
                this.cupsCustomMediaSNames[i] = customMediaSizeName;
                mediaPrintableArea = null;
                try {
                    mediaPrintableArea = new MediaPrintableArea(f3, f6, f5, f4, 25400);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if (!(f > 0.0f) || !(f2 > 0.0f)) break block8;
                    mediaPrintableArea = new MediaPrintableArea(0.0f, 0.0f, f, f2, 25400);
                }
            }
            this.cupsMediaPrintables[i] = mediaPrintableArea;
        }
        this.cupsMediaTrays = new MediaTray[this.nTrays];
        for (int i = 0; i < this.nTrays; ++i) {
            CustomMediaTray customMediaTray = new CustomMediaTray(this.media[(this.nPageSizes + i) * 2], this.media[(this.nPageSizes + i) * 2 + 1]);
            this.cupsMediaTrays[i] = customMediaTray;
        }
    }

    public static String getDefaultPrinter() {
        try {
            URL uRL = new URL("http", CUPSPrinter.getServer(), CUPSPrinter.getPort(), "");
            final HttpURLConnection httpURLConnection = IPPPrintService.getIPPConnection(uRL);
            if (httpURLConnection != null) {
                OutputStream outputStream = (OutputStream)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        try {
                            return httpURLConnection.getOutputStream();
                        }
                        catch (Exception exception) {
                            return null;
                        }
                    }
                });
                if (outputStream == null) {
                    return null;
                }
                AttributeClass[] attributeClassArray = new AttributeClass[]{AttributeClass.ATTRIBUTES_CHARSET, AttributeClass.ATTRIBUTES_NATURAL_LANGUAGE, new AttributeClass("requested-attributes", 68, "printer-name")};
                if (IPPPrintService.writeIPPRequest(outputStream, "4001", attributeClassArray)) {
                    HashMap hashMap = null;
                    InputStream inputStream = httpURLConnection.getInputStream();
                    HashMap[] hashMapArray = IPPPrintService.readIPPResponse(inputStream);
                    inputStream.close();
                    if (hashMapArray.length > 0) {
                        hashMap = hashMapArray[0];
                    }
                    if (hashMap == null) {
                        outputStream.close();
                        httpURLConnection.disconnect();
                        return null;
                    }
                    AttributeClass attributeClass = (AttributeClass)hashMap.get("printer-name");
                    if (attributeClass != null) {
                        String string = attributeClass.getStringValue();
                        outputStream.close();
                        httpURLConnection.disconnect();
                        return string;
                    }
                }
                outputStream.close();
                httpURLConnection.disconnect();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static String[] getAllPrinters() {
        try {
            URL uRL = new URL("http", CUPSPrinter.getServer(), CUPSPrinter.getPort(), "");
            final HttpURLConnection httpURLConnection = IPPPrintService.getIPPConnection(uRL);
            if (httpURLConnection != null) {
                OutputStream outputStream = (OutputStream)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        try {
                            return httpURLConnection.getOutputStream();
                        }
                        catch (Exception exception) {
                            return null;
                        }
                    }
                });
                if (outputStream == null) {
                    return null;
                }
                AttributeClass[] attributeClassArray = new AttributeClass[]{AttributeClass.ATTRIBUTES_CHARSET, AttributeClass.ATTRIBUTES_NATURAL_LANGUAGE, new AttributeClass("requested-attributes", 68, "printer-name")};
                if (IPPPrintService.writeIPPRequest(outputStream, "4002", attributeClassArray)) {
                    InputStream inputStream = httpURLConnection.getInputStream();
                    HashMap[] hashMapArray = IPPPrintService.readIPPResponse(inputStream);
                    inputStream.close();
                    outputStream.close();
                    httpURLConnection.disconnect();
                    if (hashMapArray == null || hashMapArray.length == 0) {
                        return null;
                    }
                    ArrayList<String> arrayList = new ArrayList<String>();
                    for (int i = 0; i < hashMapArray.length; ++i) {
                        AttributeClass attributeClass = (AttributeClass)hashMapArray[i].get("printer-name");
                        if (attributeClass == null) continue;
                        String string = attributeClass.getStringValue();
                        arrayList.add(string);
                    }
                    return arrayList.toArray(new String[0]);
                }
                outputStream.close();
                httpURLConnection.disconnect();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static String getServer() {
        if (libFound) {
            return CUPSPrinter.getCupsServer();
        }
        return null;
    }

    public static int getPort() {
        if (libFound) {
            return CUPSPrinter.getCupsPort();
        }
        return 0;
    }

    public static boolean isCupsRunning() {
        IPPPrintService.debug_println("libFound " + libFound);
        if (libFound) {
            IPPPrintService.debug_println("CUPS server " + CUPSPrinter.getServer() + " port " + CUPSPrinter.getPort());
            return CUPSPrinter.canConnect(CUPSPrinter.getServer(), CUPSPrinter.getPort());
        }
        return false;
    }

    static {
        Toolkit.getDefaultToolkit();
        libFound = CUPSPrinter.initIDs();
    }
}

