/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws;

import com.sun.deploy.Environment;
import com.sun.deploy.cache.Cache;
import com.sun.deploy.cache.CacheEntry;
import com.sun.deploy.cache.LocalApplicationProperties;
import com.sun.deploy.config.JREInfo;
import com.sun.deploy.net.DownloadEngine;
import com.sun.deploy.util.Trace;
import com.sun.javaws.Globals;
import com.sun.javaws.Launcher;
import com.sun.javaws.LocalInstallHandler;
import com.sun.javaws.jnl.IconDesc;
import com.sun.javaws.jnl.InformationDesc;
import com.sun.javaws.jnl.JARDesc;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.LaunchDescFactory;
import com.sun.javaws.jnl.RContentDesc;
import com.sun.javaws.jnl.ResourcesDesc;
import com.sun.javaws.ui.SplashScreen;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;

public class CacheUtil {
    public static void remove() {
        File[] fileArray;
        Iterator iterator = Cache.getJnlpCacheEntries((boolean)Environment.isSystemCacheMode());
        while (iterator.hasNext()) {
            fileArray = (File[])iterator.next();
            LaunchDesc launchDesc = null;
            try {
                launchDesc = LaunchDescFactory.buildDescriptor((File)fileArray);
            }
            catch (Exception exception) {
                Trace.ignoredException((Exception)exception);
            }
            if (launchDesc == null) continue;
            CacheUtil.remove((File)fileArray, launchDesc);
        }
        if (Globals.isShortcutMode()) {
            return;
        }
        fileArray = Cache.getCacheEntries((boolean)Environment.isSystemCacheMode());
        for (int i = 0; i < fileArray.length; ++i) {
            CacheEntry cacheEntry = Cache.getCacheEntryFromFile((File)fileArray[i]);
            if (cacheEntry != null) {
                Cache.removeCacheEntry((CacheEntry)cacheEntry);
                continue;
            }
            fileArray[i].delete();
        }
        try {
            Cache.removeAllMuffins();
        }
        catch (Exception exception) {
            Trace.ignored((Throwable)exception);
        }
    }

    public static void remove(CacheEntry cacheEntry) {
        try {
            LaunchDesc launchDesc = LaunchDescFactory.buildDescriptor(cacheEntry.getDataFile());
            CacheUtil.remove(cacheEntry, launchDesc);
        }
        catch (Exception exception) {
            Trace.ignored((Throwable)exception);
        }
    }

    public static void remove(File file, LaunchDesc launchDesc) {
        File file2 = new File(file.getPath() + ".idx");
        if (file2.exists()) {
            CacheEntry cacheEntry = Cache.getCacheEntryFromFile((File)file2);
            if (cacheEntry != null) {
                CacheUtil.remove(cacheEntry, launchDesc);
            } else {
                file2.delete();
                file.delete();
            }
        } else if (file.exists() && Cache.getCacheDir().equals(file.getParentFile())) {
            file.delete();
        } else {
            CacheEntry cacheEntry = Cache.getCacheEntry((URL)launchDesc.getCanonicalHome(), null, null);
            if (cacheEntry != null) {
                CacheUtil.remove(cacheEntry, launchDesc);
            }
        }
    }

    public static void remove(CacheEntry cacheEntry, LaunchDesc launchDesc) {
        Object object;
        Object object2;
        Object object3;
        LocalApplicationProperties localApplicationProperties = Cache.getLocalApplicationProperties((CacheEntry)cacheEntry);
        InformationDesc informationDesc = launchDesc.getInformation();
        LocalInstallHandler localInstallHandler = LocalInstallHandler.getInstance();
        if (localInstallHandler != null) {
            localInstallHandler.uninstall(launchDesc, localApplicationProperties);
        }
        if (Globals.isShortcutMode()) {
            return;
        }
        if (launchDesc.isApplicationDescriptor() && launchDesc.getLocation() != null) {
            Cache.saveRemovedApp((URL)launchDesc.getLocation(), (String)informationDesc.getTitle());
        }
        localApplicationProperties.refresh();
        if (localApplicationProperties.isLocallyInstalled() && launchDesc.isInstaller()) {
            object3 = new ArrayList();
            ((ArrayList)object3).add(cacheEntry.getDataFile());
            try {
                object2 = localApplicationProperties.getInstallDirectory();
                Launcher.executeUninstallers((ArrayList)object3);
                JREInfo.removeJREsIn((String)object2);
            }
            catch (Exception exception) {
                Trace.ignoredException((Exception)exception);
            }
        }
        SplashScreen.removeCustomSplash(launchDesc);
        if (informationDesc != null) {
            object3 = informationDesc.getIcons();
            if (object3 != null) {
                for (int i = 0; i < ((Object)object3).length; ++i) {
                    URL uRL = ((IconDesc)object3[i]).getLocation();
                    object = ((IconDesc)object3[i]).getVersion();
                    CacheUtil.removeEntries(uRL, (String)object);
                }
            }
            if ((object2 = informationDesc.getRelatedContent()) != null) {
                for (int i = 0; i < ((RContentDesc[])object2).length; ++i) {
                    object = object2[i].getIcon();
                    if (object == null) continue;
                    CacheUtil.removeEntries((URL)object, null);
                }
            }
        }
        if ((object3 = launchDesc.getResources()) != null && (object2 = ((ResourcesDesc)object3).getEagerOrAllJarDescs(true)) != null) {
            for (int i = ((RContentDesc[])object2).length - 1; i >= 0; --i) {
                object = ((JARDesc)((Object)object2[i])).getLocation();
                String string = ((JARDesc)((Object)object2[i])).getVersion();
                CacheUtil.removeEntries((URL)object, string);
            }
        }
        object2 = cacheEntry.getURL();
        String string = cacheEntry.getVersion();
        try {
            object = new URL((String)object2);
            if (object != null) {
                CacheUtil.removeEntries((URL)object, string);
            }
        }
        catch (MalformedURLException malformedURLException) {
            Trace.ignored((Throwable)malformedURLException);
        }
        Cache.removeLoadedProperties((String)object2);
    }

    private static void removeEntries(URL uRL, String string) {
        if (uRL != null) {
            DownloadEngine.removeCachedResource((URL)uRL, null, (String)string);
        }
    }
}

