/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.ui;

import com.sun.deploy.config.Config;
import com.sun.deploy.ui.ImageLoader;
import com.sun.deploy.ui.ImageLoaderCallback;
import com.sun.deploy.util.Trace;
import com.sun.javaws.Globals;
import com.sun.javaws.jnl.IconDesc;
import com.sun.javaws.jnl.InformationDesc;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.ui.LaunchErrorDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;

class SplashGenerator
extends Thread
implements ImageLoaderCallback {
    private File _index;
    private File _dir;
    private final String _key;
    private final LaunchDesc _ld;
    private final Component _owner;
    private Properties _props = new Properties();
    private boolean _useAppSplash = false;

    public SplashGenerator(Component component, LaunchDesc launchDesc) {
        this._owner = component;
        this._ld = launchDesc;
        this._dir = new File(Config.getSplashDir());
        this._key = this._ld.getSplashCanonicalHome().toString();
        String string = Config.getSplashIndex();
        this._index = new File(string);
        Config.setSplashCache();
        Config.storeIfDirty();
        if (this._index.exists()) {
            try {
                FileInputStream fileInputStream = new FileInputStream(this._index);
                if (fileInputStream != null) {
                    this._props.load(fileInputStream);
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {
                Trace.ignoredException((Exception)iOException);
            }
        }
    }

    public boolean needsCustomSplash() {
        return !this._props.containsKey(this._key);
    }

    public void remove() {
        this.addSplashToCacheIndex(this._key, null);
    }

    public void run() {
        InformationDesc informationDesc = this._ld.getInformation();
        IconDesc[] iconDescArray = informationDesc.getIcons();
        if (!this._dir.getParentFile().canWrite() || this._dir.exists() && !this._dir.canWrite() || this._index.exists() && !this._index.canWrite()) {
            return;
        }
        try {
            this._dir.mkdirs();
        }
        catch (Throwable throwable) {
            this.splashError(throwable);
        }
        try {
            this._index.createNewFile();
        }
        catch (Throwable throwable) {
            this.splashError(throwable);
        }
        IconDesc iconDesc = informationDesc.getIconLocation(2, 4);
        if (iconDesc == null) {
            return;
        }
        ImageLoader.getInstance().loadImage(iconDesc.getLocation(), iconDesc.getVersion(), (ImageLoaderCallback)this);
    }

    public void imageAvailable(URL uRL, String string, Image image, File file) {
    }

    public void finalImageAvailable(URL uRL, String string, Image image, File file) {
        if (!Globals.isHeadless()) {
            try {
                this.create(image, file);
            }
            catch (Throwable throwable) {
                if (throwable instanceof OutOfMemoryError) {
                    this.splashError(throwable);
                }
                Trace.ignored((Throwable)throwable);
            }
        }
    }

    public void create(Image image, File file) {
        InformationDesc informationDesc = this._ld.getInformation();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = image.getHeight(this._owner);
        int n2 = image.getWidth(this._owner);
        if (file != null) {
            try {
                String string = file.getCanonicalPath();
                this.addSplashToCacheIndex(this._key, string);
            }
            catch (Throwable throwable) {
                Trace.ignored((Throwable)throwable);
            }
        }
    }

    private void addSplashToCacheIndex(String string, String string2) {
        if (string2 != null) {
            this._props.setProperty(string, string2);
        } else if (this._props.containsKey(string)) {
            this._props.remove(string);
        }
        File[] fileArray = this._dir.listFiles();
        if (fileArray == null) {
            return;
        }
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i].equals(this._index)) continue;
            try {
                String string3 = fileArray[i].getCanonicalPath();
                if (this._props.containsValue(string3)) continue;
                fileArray[i].delete();
                continue;
            }
            catch (IOException iOException) {
                this.splashError(iOException);
            }
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this._index);
            this._props.store(fileOutputStream, "");
            fileOutputStream.flush();
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            this.splashError(iOException);
        }
    }

    private void splashError(Throwable throwable) {
        LaunchErrorDialog.show(this._owner, throwable, false);
        throw new Error(throwable.toString());
    }
}

